/*
 * Decompiled with CFR 0.152.
 */
package js7.controller.command;

import cats.Applicative;
import cats.UnorderedFoldable$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Outcome;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import js7.base.log.CanBindCorrelId$;
import js7.base.log.CorrelId;
import js7.base.log.CorrelId$;
import js7.base.log.CorrelIdWrapped;
import js7.base.log.CorrelIdWrapped$;
import js7.base.problem.Problem;
import js7.base.system.startup.Halt$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.controller.command.ControllerCommandExecutor$;
import js7.core.command.CommandExecutor;
import js7.core.command.CommandMeta;
import js7.core.command.CommandRegister;
import js7.core.command.CommandRun;
import js7.data.controller.ControllerCommand;
import js7.data.controller.ControllerCommand$;
import js7.data.controller.ControllerCommand$Batch$;
import js7.data.controller.ControllerCommand$Batch$Response$;
import js7.data.controller.ControllerCommand$EmergencyStop$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class ControllerCommandExecutor
implements CommandExecutor<ControllerCommand> {
    private final CommandExecutor<ControllerCommand> otherCommandExecutor;
    private final CommandRegister<ControllerCommand> register;

    public ControllerCommandExecutor(CommandExecutor<ControllerCommand> otherCommandExecutor) {
        this.otherCommandExecutor = otherCommandExecutor;
        this.register = new CommandRegister();
    }

    @Override
    public IO<Either<Problem, ControllerCommand.Response>> executeCommand(ControllerCommand command, CommandMeta meta) {
        return this.executeCommand(command, meta, (Option<CorrelId>)None$.MODULE$);
    }

    private IO<Either<Problem, ControllerCommand.Response>> executeCommand(ControllerCommand command, CommandMeta meta, Option<CorrelId> batchId) {
        return IO$.MODULE$.defer(() -> this.executeCommand$$anonfun$1(command, meta, batchId));
    }

    private IO<Either<Problem, ControllerCommand.Response>> executeCommand2(ControllerCommand command, CommandMeta meta, CorrelId id, Option<CorrelId> batchId) {
        return IO$.MODULE$.defer(() -> this.executeCommand2$$anonfun$1(command, meta, batchId, id));
    }

    private void logCommand(CommandRun<ControllerCommand> run) {
        ControllerCommand controllerCommand = run.command();
        if (controllerCommand instanceof ControllerCommand.Batch) {
            ControllerCommand.Batch batch = ControllerCommand$Batch$.MODULE$.unapply((ControllerCommand.Batch)controllerCommand);
            Seq<CorrelIdWrapped<ControllerCommand>> seq = batch._1();
            return;
        }
        Logger LoggerImpl_this = ControllerCommandExecutor$.js7$controller$command$ControllerCommandExecutor$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("\u2198 {}", run);
            return;
        }
    }

    private static final void executeCommand$$anonfun$1$$anonfun$2$$anonfun$1(CommandRun run$4, Throwable t$1) {
        Logger LoggerImpl_this = ControllerCommandExecutor$.js7$controller$command$ControllerCommandExecutor$$$logger;
        if (LoggerImpl_this.underlying().isWarnEnabled()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = run$4;
            Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t$1);
            objectArray[1] = ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable);
            LoggerImpl_this.underlying().warn("{} failed: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
            return;
        }
    }

    private final void executeCommand$$anonfun$1$$anonfun$3(CommandRun run$5) {
        this.register.remove(run$5.correlId());
    }

    private final IO executeCommand$$anonfun$1(ControllerCommand command$1, CommandMeta meta$1, Option batchId$1) {
        CorrelId correlId = CorrelId$.MODULE$.current();
        CommandRun<ControllerCommand> run = this.register.add(command$1, meta$1, correlId, (Option<CorrelId>)batchId$1);
        this.logCommand(run);
        return this.executeCommand2(command$1, meta$1, correlId, (Option<CorrelId>)batchId$1).map((Function1 & Serializable)checkedResponse -> {
            if (run.batchInternalId().isEmpty()) {
                Either either = checkedResponse;
                if (either instanceof Right) {
                    Logger LoggerImpl_this = ControllerCommandExecutor$.js7$controller$command$ControllerCommandExecutor$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug("\u2199 " + run.idString() + " " + ControllerCommand$.MODULE$.jsonCodec().classToName(run.command().getClass()) + (" (" + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(run.runningSince())))) + "): " + checkedResponse));
                    }
                } else if (either instanceof Left) {
                    Problem problem2 = (Problem)((Left)either).value();
                } else {
                    throw new MatchError((Object)either);
                }
            }
            checkedResponse.left().foreach((Function1)(JProcedure1 & Serializable)problem -> {
                Logger LoggerImpl_this = ControllerCommandExecutor$.js7$controller$command$ControllerCommandExecutor$$$logger;
                if (LoggerImpl_this.underlying().isWarnEnabled()) {
                    LoggerImpl_this.underlying().warn("{} rejected: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{run, problem}), Object.class));
                    return;
                }
            });
            return checkedResponse.map((Function1 & Serializable)_$1 -> _$1);
        }).guaranteeCase((Function1 & Serializable)x$1 -> {
            Outcome outcome = x$1;
            if (outcome instanceof Outcome.Errored) {
                Throwable throwable;
                cats.effect.package$.MODULE$.Outcome();
                Outcome.Errored errored = Outcome.Errored$.MODULE$.unapply((Outcome.Errored)outcome);
                Throwable t = throwable = (Throwable)errored._1();
                if (run.batchInternalId().isEmpty()) {
                    return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        ControllerCommandExecutor.executeCommand$$anonfun$1$$anonfun$2$$anonfun$1(run, t);
                        return BoxedUnit.UNIT;
                    });
                }
            }
            return IO$.MODULE$.unit();
        }).guarantee(IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.executeCommand$$anonfun$1$$anonfun$3(run);
            return BoxedUnit.UNIT;
        }));
    }

    private static final Option $anonfun$2$$anonfun$1$$anonfun$1(CorrelId id$4) {
        return Some$.MODULE$.apply((Object)id$4);
    }

    private final IO $anonfun$2$$anonfun$1(ControllerCommand command$3, CommandMeta meta$3, Option batchId$3, CorrelId id$2) {
        return this.executeCommand(command$3, meta$3, (Option<CorrelId>)batchId$3.orElse(() -> ControllerCommandExecutor.$anonfun$2$$anonfun$1$$anonfun$1(id$2)));
    }

    private final IO executeCommand2$$anonfun$1(ControllerCommand command$2, CommandMeta meta$2, Option batchId$2, CorrelId id$1) {
        ControllerCommand controllerCommand = command$2;
        if (controllerCommand instanceof ControllerCommand.Batch) {
            Seq<CorrelIdWrapped<ControllerCommand>> seq;
            ControllerCommand.Batch batch = ControllerCommand$Batch$.MODULE$.unapply((ControllerCommand.Batch)controllerCommand);
            Seq<CorrelIdWrapped<ControllerCommand>> correlIdWrappedCommands = seq = batch._1();
            Seq ios = (Seq)correlIdWrappedCommands.withFilter((Function1 & Serializable)x$1 -> {
                CorrelIdWrapped correlIdWrapped = x$1;
                if (correlIdWrapped != null) {
                    CorrelIdWrapped correlIdWrapped2 = CorrelIdWrapped$.MODULE$.unapply(correlIdWrapped);
                    CorrelId correlId = correlIdWrapped2._1();
                    ControllerCommand controllerCommand = (ControllerCommand)correlIdWrapped2._2();
                    CorrelId correlId2 = correlId;
                    ControllerCommand command = controllerCommand;
                    return true;
                }
                return false;
            }).map((Function1 & Serializable)x$1 -> {
                CorrelIdWrapped correlIdWrapped = x$1;
                if (correlIdWrapped != null) {
                    CorrelIdWrapped correlIdWrapped2 = CorrelIdWrapped$.MODULE$.unapply(correlIdWrapped);
                    CorrelId correlId = correlIdWrapped2._1();
                    ControllerCommand controllerCommand = (ControllerCommand)correlIdWrapped2._2();
                    CorrelId correlId2 = correlId;
                    ControllerCommand command = controllerCommand;
                    return correlId2.bind(() -> this.$anonfun$2$$anonfun$1(command, meta$2, batchId$2, id$1), CanBindCorrelId$.MODULE$.io());
                }
                throw new MatchError((Object)correlIdWrapped);
            });
            return ((IO)package.traverse$.MODULE$.toTraverseOps((Object)ios, UnorderedFoldable$.MODULE$.catsTraverseForSeq()).sequence((.less.colon.less)$less$colon$less$.MODULE$.refl(), (Applicative)IO$.MODULE$.asyncForIO())).map((Function1 & Serializable)checkedResponses -> package$.MODULE$.Right().apply((Object)ControllerCommand$Batch$Response$.MODULE$.apply((Seq<Either<Problem, ControllerCommand.Response>>)checkedResponses)));
        }
        if (controllerCommand instanceof ControllerCommand.EmergencyStop) {
            boolean bl;
            ControllerCommand.EmergencyStop emergencyStop = ControllerCommand$EmergencyStop$.MODULE$.unapply((ControllerCommand.EmergencyStop)controllerCommand);
            boolean restart = bl = emergencyStop._1();
            throw Halt$.MODULE$.haltJava("\ud83d\udfe5 EmergencyStop command received: JS7 CONTROLLER STOPS NOW", restart, Halt$.MODULE$.haltJava$default$3());
        }
        return this.otherCommandExecutor.executeCommand(command$2, meta$2);
    }
}

