/*
 * Decompiled with CFR 0.152.
 */
package js7.data.execution.workflow.instructions;

import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.time.ZoneId;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$CheckedOption$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.JavaTime$;
import js7.base.time.JavaTime$JavaTimeZone$;
import js7.base.time.Timestamp;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.base.utils.ScalaUtils$syntax$RichPartialFunction$;
import js7.data.calendar.Calendar;
import js7.data.calendar.Calendar$;
import js7.data.calendar.CalendarExecutor$;
import js7.data.calendar.CalendarPath;
import js7.data.event.Event;
import js7.data.event.KeyedEvent;
import js7.data.execution.workflow.instructions.EventInstructionExecutor;
import js7.data.execution.workflow.instructions.InstructionExecutor;
import js7.data.execution.workflow.instructions.InstructionExecutorService;
import js7.data.execution.workflow.instructions.ScheduleCalculator;
import js7.data.execution.workflow.instructions.ScheduleCalculator$;
import js7.data.item.VersionedItemId;
import js7.data.order.CycleState;
import js7.data.order.CycleState$;
import js7.data.order.Order;
import js7.data.order.Order$BetweenCycles$;
import js7.data.order.Order$Ready$;
import js7.data.order.OrderEvent;
import js7.data.order.OrderEvent$OrderCycleFinished$;
import js7.data.order.OrderEvent$OrderCycleStarted$;
import js7.data.order.OrderEvent$OrderCyclingPrepared$;
import js7.data.order.OrderEvent$OrderMoved$;
import js7.data.order.OrderObstacle;
import js7.data.order.OrderObstacle$WaitingForOtherTime$;
import js7.data.order.OrderObstacleCalculator;
import js7.data.state.StateView;
import js7.data.workflow.Workflow;
import js7.data.workflow.Workflow$;
import js7.data.workflow.instructions.Cycle;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class CycleExecutor
implements InstructionExecutor,
EventInstructionExecutor {
    private final InstructionExecutorService service;
    private final Class instructionClass;

    public CycleExecutor(InstructionExecutorService service) {
        this.service = service;
        this.instructionClass = Cycle.class;
    }

    @Override
    public InstructionExecutorService service() {
        return this.service;
    }

    public Class<? extends Cycle> instructionClass() {
        return this.instructionClass;
    }

    public Either<Problem, List<KeyedEvent<OrderEvent.OrderActorEvent>>> toEvents(Cycle cycle, Order<Order.State> order, StateView state) {
        Timestamp now = this.clock().now();
        return (Either)this.start((Order)order).orElse(() -> this.toEvents$$anonfun$1(order, state, cycle, now)).orElse(() -> this.toEvents$$anonfun$2(order, cycle, state, now)).getOrElse(CycleExecutor::toEvents$$anonfun$3);
    }

    private List<KeyedEvent<OrderEvent.OrderActorEvent>> nextCycleStateToEvent(Option<CycleState> cycleState, Order<Order.State> order) {
        OrderEvent.OrderActorEvent orderActorEvent;
        Option<CycleState> option = cycleState;
        if (option instanceof Some) {
            CycleState cycleState2 = (CycleState)((Some)option).value();
            orderActorEvent = OrderEvent$OrderCyclingPrepared$.MODULE$.apply(cycleState2);
        } else if (None$.MODULE$.equals(option)) {
            orderActorEvent = OrderEvent$OrderMoved$.MODULE$.apply(order.position().increment(), OrderEvent$OrderMoved$.MODULE$.$lessinit$greater$default$2());
        } else {
            throw new MatchError(option);
        }
        OrderEvent.OrderActorEvent event = orderActorEvent;
        KeyedEvent<Event> keyedEvent = event.toKeyedEvent(order.id());
        return package$.MODULE$.Nil().$colon$colon(keyedEvent);
    }

    public Either<Problem, List<KeyedEvent<OrderEvent.OrderActorEvent>>> onReturnFromSubworkflow(Cycle instr, Order<Order.State> order, StateView state) {
        Either checkedKeyedEvent = this.toScheduleCalculator(order, instr, state).flatMap((Function1 & Serializable)calculator -> {
            Option option = Checked$.MODULE$.CheckedOption(order.position().branchPath().lastOption().map((Function1 & Serializable)_$2 -> _$2.branchId()));
            return Checked$CheckedOption$.MODULE$.toChecked$extension(option, (Function0<Problem>)((Function0 & Serializable)() -> CycleExecutor.$anonfun$1$$anonfun$2(order))).flatMap((Function1 & Serializable)branchId -> branchId.toCycleState().map((Function1 & Serializable)cycleState -> OrderEvent$OrderCycleFinished$.MODULE$.apply(calculator.nextCycleState(this.clock().now(), (CycleState)cycleState)).toKeyedEvent(order.id())));
        });
        return checkedKeyedEvent.map((Function1 & Serializable)_$3 -> package$.MODULE$.Nil().$colon$colon(_$3));
    }

    private Either<Problem, ScheduleCalculator> toScheduleCalculator(Order<Order.State> order, Cycle cycle, StateView state) {
        PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(state.keyToItem(Workflow$.MODULE$));
        return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, order.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))).flatMap((Function1 & Serializable)workflow -> this.toCalendarAndScheduleCalculator((Workflow)workflow, cycle, state).map((Function1 & Serializable)pair -> (ScheduleCalculator)pair._2()));
    }

    private Either<Problem, Tuple2<Calendar, ScheduleCalculator>> toCalendarAndScheduleCalculator(Workflow workflow, Cycle cycle, StateView state) {
        Option option = Checked$.MODULE$.CheckedOption(workflow.calendarPath());
        return Checked$CheckedOption$.MODULE$.toChecked$extension(option, (Function0<Problem>)((Function0 & Serializable)CycleExecutor::toCalendarAndScheduleCalculator$$anonfun$1)).flatMap((Function1 & Serializable)calendarPath -> {
            PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(state.keyToItem(Calendar$.MODULE$));
            return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, calendarPath, Tag$.MODULE$.apply(CalendarPath.class, LightTypeTag$.MODULE$.parse(759943196, "\u0004\u0000\u0001\u001ejs7.data.calendar.CalendarPath\u0001\u0001", "\u0000\u0007\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.UnsignedItemKey\u0001\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.calendar.CalendarPath\u0001\u0001\u000b\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001cjs7.data.item.SimpleItemPath\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.UnsignedItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001$js7.data.item.UnsignedSimpleItemPath\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0002\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\f\u0001\u0001\u0006\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u000b\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\f\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\r\u0001\u0002\u0003\u0000\u0000\u0090\t\u0001\u0001", 30))).flatMap((Function1 & Serializable)calendar -> JavaTime$JavaTimeZone$.MODULE$.toZoneId$extension(JavaTime$.MODULE$.JavaTimeZone(workflow.timeZone())).flatMap((Function1 & Serializable)zone -> ScheduleCalculator$.MODULE$.checked(cycle.schedule(), (ZoneId)zone, calendar.dateOffset(), cycle.onlyOnePeriod()).map((Function1 & Serializable)calculator -> {
                Calendar calendar = (Calendar)Predef$.MODULE$.ArrowAssoc(calendar);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)calendar, calculator);
            })));
        });
    }

    @Override
    public Either<Problem, Set<OrderObstacle>> toObstacles(Order<Order.State> order, OrderObstacleCalculator calculator) {
        CycleState cycleState;
        Order.BetweenCycles betweenCycles;
        Option<CycleState> option;
        Order.State state = order.state();
        if (state instanceof Order.BetweenCycles && (option = (betweenCycles = Order$BetweenCycles$.MODULE$.unapply((Order.BetweenCycles)state))._1()) instanceof Some && (cycleState = (CycleState)((Some)option).value()) != null) {
            CycleState cycleState2 = cycleState;
            if (this.clock().now().$less(cycleState2.next())) {
                return package$.MODULE$.Right().apply(Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OrderObstacle[]{OrderObstacle$WaitingForOtherTime$.MODULE$.apply(cycleState2.next())})));
            }
        }
        return InstructionExecutor.toObstacles$(this, order, calculator);
    }

    private final Option toEvents$$anonfun$1(Order order$1, StateView state$1, Cycle cycle$1, Timestamp now$1) {
        return order$1.ifState(ClassTag$.MODULE$.apply(Order$Ready$.class)).map((Function1 & Serializable)order -> {
            PartialFunction partialFunction = ScalaUtils$syntax$.MODULE$.RichPartialFunction(state$1.keyToItem(Workflow$.MODULE$));
            return ScalaUtils$syntax$RichPartialFunction$.MODULE$.checked$extension(partialFunction, order.workflowId(), Tag$.MODULE$.apply(VersionedItemId.class, LightTypeTag$.MODULE$.parse(451645742, "\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001", "\u0000\u0005\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.VersionedItemPath\u0001\u0001\u0002\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0001\u0001\u0001\u001djs7.data.item.VersionedItemId\u0001\u0000\u0004\u0000\u0001\u001ejs7.data.workflow.WorkflowPath\u0001\u0001\u0000\u0001\u0005\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.SignableItemKey\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0007\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0006\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u00012js7.data.item.InventoryItemPath$.AttachableToAgent\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001\u0002\u0000\u0001\u0090\u0007\u0001\u0001\u0005\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0007\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0002\u0003\u0000\u0000\u0090\u0005\u0001\u0001", 30))).flatMap((Function1 & Serializable)workflow -> this.toCalendarAndScheduleCalculator((Workflow)workflow, cycle$1, state$1).map((Function1 & Serializable)pair -> {
                Tuple2 tuple2 = pair;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Calendar calendar = (Calendar)tuple2._1();
                ScheduleCalculator calculator = (ScheduleCalculator)tuple2._2();
                Tuple2 $1$ = tuple2;
                Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)$1$, (Object)calendar, (Object)calculator);
                Tuple2 $1$2 = (Tuple2)tuple3._1();
                Calendar calendar2 = (Calendar)tuple3._2();
                ScheduleCalculator calculator2 = (ScheduleCalculator)tuple3._3();
                return Tuple2$.MODULE$.apply(pair, (Object)$1$2);
            }).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._2();
                    Tuple2 pair = (Tuple2)tuple2._1();
                    if (tuple22 != null) {
                        Calendar calendar = (Calendar)tuple22._1();
                        ScheduleCalculator calculator = (ScheduleCalculator)tuple22._2();
                        return CalendarExecutor$.MODULE$.checked(calendar, workflow.timeZone()).flatMap((Function1 & Serializable)calendarExecutor -> calendarExecutor.orderIdToTimeInterval(order.id()).map((Function1 & Serializable)timeInterval -> {
                            Timestamp timestamp = timeInterval.start();
                            Timestamp timestamp2 = timeInterval.end();
                            Option<CycleState> cycleState = calculator.nextCycleState(now$1, CycleState$.MODULE$.apply(timestamp2, -1, -1, 0, timestamp));
                            return this.nextCycleStateToEvent(cycleState, (Order<Order.State>)order);
                        }));
                    }
                }
                throw new MatchError((Object)tuple2);
            }));
        });
    }

    private static final KeyedEvent toEvents$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(Order order$8) {
        return OrderEvent$OrderCycleStarted$.MODULE$.toKeyedEvent(order$8.id());
    }

    private final Option toEvents$$anonfun$2(Order order$6, Cycle cycle$4, StateView state$4, Timestamp now$7) {
        return order$6.ifState(ClassTag$.MODULE$.apply(Order.BetweenCycles.class)).map((Function1 & Serializable)order -> {
            Option<CycleState> option = ((Order.BetweenCycles)order.state()).cycleState();
            if (None$.MODULE$.equals(option)) {
                KeyedEvent keyedEvent = OrderEvent$OrderMoved$.MODULE$.apply(order.position().increment(), OrderEvent$OrderMoved$.MODULE$.$lessinit$greater$default$2()).toKeyedEvent(order.id());
                return package$.MODULE$.Right().apply((Object)package$.MODULE$.Nil().$colon$colon((Object)keyedEvent));
            }
            if (option instanceof Some) {
                CycleState cycleState = (CycleState)((Some)option).value();
                return this.toScheduleCalculator((Order<Order.State>)order, cycle$4, state$4).flatMap((Function1 & Serializable)_$1 -> _$1.maybeRecalcCycleState(now$7, cycleState)).map((Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (None$.MODULE$.equals(option)) {
                        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenList$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(cycleState.next().$less$eq(now$7)), () -> CycleExecutor.toEvents$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(order));
                    }
                    if (option instanceof Some) {
                        Option maybeRecalculatedCycleState = (Option)((Some)option).value();
                        return this.nextCycleStateToEvent((Option<CycleState>)maybeRecalculatedCycleState, (Order<Order.State>)order);
                    }
                    throw new MatchError((Object)option);
                });
            }
            throw new MatchError(option);
        });
    }

    private static final Either toEvents$$anonfun$3() {
        return package$.MODULE$.Right().apply((Object)package$.MODULE$.Nil());
    }

    private static final String $anonfun$1$$anonfun$2$$anonfun$1(Order order$11) {
        return order$11.id() + " Cycle Position expected: " + order$11.position();
    }

    private static final Problem $anonfun$1$$anonfun$2(Order order$10) {
        return Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> CycleExecutor.$anonfun$1$$anonfun$2$$anonfun$1(order$10)), Problem$.MODULE$.apply$default$2());
    }

    private static final String toCalendarAndScheduleCalculator$$anonfun$1$$anonfun$1() {
        return "Cycle instruction requires Workflow.calendarPath";
    }

    private static final Problem toCalendarAndScheduleCalculator$$anonfun$1() {
        return Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)CycleExecutor::toCalendarAndScheduleCalculator$$anonfun$1$$anonfun$1), Problem$.MODULE$.apply$default$2());
    }
}

