/*
 * Decompiled with CFR 0.152.
 */
package js7.data.lock;

import java.io.Serializable;
import js7.base.circeutils.typed.TypedJsonCodec;
import js7.base.utils.Assertions$;
import js7.data.lock.Acquired$;
import js7.data.lock.Acquired$Available$;
import js7.data.lock.Acquired$Exclusive$;
import js7.data.lock.Acquired$NonExclusive$;
import js7.data.lock.LockRefusal;
import js7.data.lock.LockRefusal$AlreadyAcquiredByThisOrder$;
import js7.data.lock.LockRefusal$InvalidCount$;
import js7.data.lock.LockRefusal$IsInUse$;
import js7.data.lock.LockRefusal$UnknownReleasingOrderError$;
import js7.data.order.OrderId;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public interface Acquired {
    public static TypedJsonCodec<Acquired> jsonCodec() {
        return Acquired$.MODULE$.jsonCodec();
    }

    public static int ordinal(Acquired acquired) {
        return Acquired$.MODULE$.ordinal(acquired);
    }

    public int lockCount();

    public Iterable<OrderId> orderIds();

    public boolean isAcquiredBy(OrderId var1);

    public Either<LockRefusal, Acquired> acquireFor(OrderId var1, Option<Object> var2);

    public Either<LockRefusal, Acquired> release(OrderId var1);

    public static final class Exclusive
    implements Acquired,
    Product,
    Serializable {
        private final OrderId orderId;

        public static Exclusive apply(OrderId orderId) {
            return Acquired$Exclusive$.MODULE$.apply(orderId);
        }

        public static Exclusive fromProduct(Product product) {
            return Acquired$Exclusive$.MODULE$.fromProduct(product);
        }

        public static Exclusive unapply(Exclusive exclusive) {
            return Acquired$Exclusive$.MODULE$.unapply(exclusive);
        }

        public Exclusive(OrderId orderId) {
            this.orderId = orderId;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Exclusive)) return false;
            Exclusive exclusive = (Exclusive)object;
            OrderId orderId = this.orderId();
            OrderId orderId2 = exclusive.orderId();
            if (orderId != null) {
                if (!((Object)orderId).equals(orderId2)) return false;
                return true;
            }
            if (orderId2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Exclusive;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Exclusive";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "orderId";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public OrderId orderId() {
            return this.orderId;
        }

        @Override
        public int lockCount() {
            return 1;
        }

        public Seq<OrderId> orderIds() {
            return package$.MODULE$.Nil().$colon$colon((Object)this.orderId());
        }

        @Override
        public boolean isAcquiredBy(OrderId orderId) {
            OrderId orderId2 = this.orderId();
            OrderId orderId3 = orderId;
            return !(orderId2 != null ? !((Object)orderId2).equals(orderId3) : orderId3 != null);
        }

        public Left<LockRefusal, Nothing$> acquireFor(OrderId orderId, Option<Object> count) {
            OrderId orderId2 = this.orderId();
            OrderId orderId3 = orderId;
            if (!(orderId2 != null ? !((Object)orderId2).equals(orderId3) : orderId3 != null)) {
                return package$.MODULE$.Left().apply((Object)LockRefusal$AlreadyAcquiredByThisOrder$.MODULE$);
            }
            return package$.MODULE$.Left().apply((Object)LockRefusal$IsInUse$.MODULE$);
        }

        public Either<LockRefusal, Acquired$Available$> release(OrderId orderId) {
            OrderId orderId2 = this.orderId();
            OrderId orderId3 = orderId;
            if (orderId2 == null ? orderId3 != null : !((Object)orderId2).equals(orderId3)) {
                return package$.MODULE$.Left().apply((Object)LockRefusal$UnknownReleasingOrderError$.MODULE$);
            }
            return package$.MODULE$.Right().apply((Object)Acquired$Available$.MODULE$);
        }

        public Exclusive copy(OrderId orderId) {
            return new Exclusive(orderId);
        }

        public OrderId copy$default$1() {
            return this.orderId();
        }

        public OrderId _1() {
            return this.orderId();
        }
    }

    public static final class NonExclusive
    implements Acquired,
    Product,
    Serializable {
        private final Map orderToCount;

        public static NonExclusive apply(Map<OrderId, Object> map) {
            return Acquired$NonExclusive$.MODULE$.apply(map);
        }

        public static NonExclusive fromProduct(Product product) {
            return Acquired$NonExclusive$.MODULE$.fromProduct(product);
        }

        public static NonExclusive unapply(NonExclusive nonExclusive) {
            return Acquired$NonExclusive$.MODULE$.unapply(nonExclusive);
        }

        public NonExclusive(Map<OrderId, Object> orderToCount) {
            this.orderToCount = orderToCount;
            Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1(orderToCount)), "orderToCount.nonEmpty"), FullName$.MODULE$.apply("js7.data.lock.Acquired.NonExclusive"), FileName$.MODULE$.apply("Acquired.scala"), Line$.MODULE$.apply(59));
            Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy2$1(orderToCount)), "orderToCount.values.forall(_ >= 1)"), FullName$.MODULE$.apply("js7.data.lock.Acquired.NonExclusive"), FileName$.MODULE$.apply("Acquired.scala"), Line$.MODULE$.apply(60));
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof NonExclusive)) return false;
            NonExclusive nonExclusive = (NonExclusive)object;
            Map<OrderId, Object> map = this.orderToCount();
            Map<OrderId, Object> map2 = nonExclusive.orderToCount();
            if (map != null) {
                if (!map.equals(map2)) return false;
                return true;
            }
            if (map2 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof NonExclusive;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "NonExclusive";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "orderToCount";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Map<OrderId, Object> orderToCount() {
            return this.orderToCount;
        }

        @Override
        public int lockCount() {
            return BoxesRunTime.unboxToInt((Object)this.orderToCount().values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }

        @Override
        public Iterable<OrderId> orderIds() {
            return this.orderToCount().keys();
        }

        @Override
        public boolean isAcquiredBy(OrderId orderId) {
            return this.orderToCount().contains((Object)orderId);
        }

        public Either<LockRefusal, NonExclusive> acquireFor(OrderId orderId, Option<Object> count) {
            if (this.orderToCount().contains((Object)orderId)) {
                return package$.MODULE$.Left().apply((Object)LockRefusal$AlreadyAcquiredByThisOrder$.MODULE$);
            }
            Option<Object> option = count;
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)LockRefusal$IsInUse$.MODULE$);
            }
            if (option instanceof Some) {
                int n = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                if (n >= 1) {
                    OrderId orderId2 = (OrderId)Predef$.MODULE$.ArrowAssoc((Object)orderId);
                    return package$.MODULE$.Right().apply((Object)Acquired$NonExclusive$.MODULE$.apply((Map<OrderId, Object>)((Map)this.orderToCount().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)orderId2, (Object)BoxesRunTime.boxToInteger((int)n))))));
                }
                return package$.MODULE$.Left().apply((Object)LockRefusal$InvalidCount$.MODULE$.apply(n));
            }
            throw new MatchError(option);
        }

        @Override
        public Either<LockRefusal, Acquired> release(OrderId orderId) {
            if (!this.orderToCount().contains((Object)orderId)) {
                return package$.MODULE$.Left().apply((Object)LockRefusal$UnknownReleasingOrderError$.MODULE$);
            }
            return package$.MODULE$.Right().apply((Object)(this.orderToCount().size() == 1 ? Acquired$Available$.MODULE$ : this.copy((Map<OrderId, Object>)((Map)this.orderToCount().$minus((Object)orderId)))));
        }

        public NonExclusive copy(Map<OrderId, Object> orderToCount) {
            return new NonExclusive(orderToCount);
        }

        public Map<OrderId, Object> copy$default$1() {
            return this.orderToCount();
        }

        public Map<OrderId, Object> _1() {
            return this.orderToCount();
        }

        private final boolean v$proxy1$1(Map orderToCount$1) {
            return orderToCount$1.nonEmpty();
        }

        private final boolean v$proxy2$1(Map orderToCount$2) {
            return orderToCount$2.values().forall((Function1)(JFunction1.mcZI.sp & Serializable)_$1 -> _$1 >= 1);
        }
    }
}

