/*
 * Decompiled with CFR 0.152.
 */
package js7.data.value.expression.scopes;

import com.typesafe.scalalogging.Logger;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.utils.Atomic$package$Atomic$extensions$;
import js7.base.utils.AtomicUpdater;
import js7.base.utils.AutoClosing$;
import js7.base.utils.ByteUnits$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.data.value.expression.scopes.FileValueScope;
import js7.data.value.expression.scopes.FileValueScope$;
import js7.data.value.expression.scopes.FileValueState$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SetOps;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Right$;

public final class FileValueState
implements AutoCloseable {
    private final Path directory;
    private final ScopeRegister scopeRegister;
    private final Path commonDirectory;
    private final AtomicBoolean commonDirectoryCreated;
    private final AtomicLong directoryNumber;
    private final AtomicReference<Set<Path>> usedFilenames;
    private final AtomicLong uniqueNumber;
    private final Statistics statistics;

    public FileValueState(Path directory) {
        this.directory = directory;
        this.scopeRegister = new ScopeRegister();
        this.commonDirectory = Paths.get("0", new String[0]);
        this.commonDirectoryCreated = new AtomicBoolean(false);
        this.directoryNumber = new AtomicLong(0L);
        Set initial$proxy1 = Predef$.MODULE$.Set().empty();
        this.usedFilenames = new AtomicReference<Set>(initial$proxy1);
        this.uniqueNumber = new AtomicLong(0L);
        this.statistics = new Statistics();
    }

    public Path directory() {
        return this.directory;
    }

    @Override
    public void close() {
        if (this.commonDirectoryCreated.get()) {
            FileValueState$.MODULE$.js7$data$value$expression$scopes$FileValueState$$$tryDelete(this.directory().resolve(this.commonDirectory));
        }
        if (this.statistics.fileCount().get() > 0L) {
            Logger LoggerImpl_this = FileValueState$.js7$data$value$expression$scopes$FileValueState$$$logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info("toFile function statistics: {}", (Object)this.statistics);
                return;
            }
            return;
        }
    }

    public boolean isEmpty() {
        return ((IterableOnceOps)this.usedFilenames.get()).isEmpty() && this.scopeRegister.isEmpty();
    }

    public void startScope(FileValueScope scope) {
        this.scopeRegister.add(scope);
    }

    public void releaseScope(FileValueScope scope) {
        this.scopeRegister.get(scope).foreach((Function1)(JProcedure1 & Serializable)scopeFiles -> {
            scopeFiles.release().foreach((Function1)(JProcedure1 & Serializable)file -> {
                FileValueState$.MODULE$.js7$data$value$expression$scopes$FileValueState$$$tryDelete((Path)file);
                AtomicReference<Set<Path>> atomicReference = this.usedFilenames;
                synchronized (atomicReference) {
                    Atomic$package$Atomic$extensions$.MODULE$.$colon$eq(this.usedFilenames, ((SetOps)this.usedFilenames.get()).$minus((Object)this.directory().relativize((Path)file)));
                }
            });
            this.scopeRegister.remove(scope);
        });
    }

    public Either<Problem, Path> toFile(FileValueScope fileValueScope, String filenamePattern, String content) {
        return Checked$.MODULE$.catchNonFatal(() -> this.toFile$$anonfun$1(filenamePattern, fileValueScope, content)).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Either<Problem, Path> toRelativePath(String filenamePattern) {
        Path path;
        String filename = this.resolveStar(filenamePattern);
        Path f = this.commonDirectory.resolve(filename);
        if (f.getNameCount() != 2) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("No directory is allowed in toFile function filenamePattern argument"));
        }
        Right$ right$ = package$.MODULE$.Right();
        AtomicReference<Set<Path>> atomicReference = this.usedFilenames;
        synchronized (atomicReference) {
            if (((scala.collection.SetOps)this.usedFilenames.get()).contains((Object)f)) {
                Path dedicatedDirectory = Paths.get(BoxesRunTime.boxToLong((long)this.directoryNumber.incrementAndGet()).toString(), new String[0]);
                Atomic$package$Atomic$extensions$.MODULE$.$colon$eq(this.usedFilenames, ((SetOps)this.usedFilenames.get()).$plus((Object)dedicatedDirectory));
                f = dedicatedDirectory.resolve(filename);
            }
            Atomic$package$Atomic$extensions$.MODULE$.$colon$eq(this.usedFilenames, ((SetOps)this.usedFilenames.get()).$plus((Object)f));
            path = f;
        }
        return right$.apply((Object)path);
    }

    private String resolveStar(String filenamePattern) {
        if (StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(filenamePattern), '*')) {
            String unique = BoxesRunTime.boxToLong((long)this.uniqueNumber.incrementAndGet()).toString();
            return filenamePattern.replace("*", unique);
        }
        return filenamePattern;
    }

    public String toString() {
        return "FileValueState(" + this.statistics + ")";
    }

    private final Either toFile$$anonfun$1(String filenamePattern$1, FileValueScope fileValueScope$1, String content$1) {
        return this.toRelativePath(filenamePattern$1).map((Function1 & Serializable)relativePath -> {
            Path file;
            block7: {
                Path relativeDir;
                ScopeFiles scopeFiles = this.scopeRegister.apply(fileValueScope$1);
                Path path = relativeDir = relativePath.getParent();
                Path path2 = this.commonDirectory;
                if (!(path != null ? !((Object)path).equals(path2) : path2 != null)) {
                    AtomicBoolean atomicBoolean = this.commonDirectoryCreated;
                    synchronized (atomicBoolean) {
                        BoxedUnit boxedUnit;
                        if (!this.commonDirectoryCreated.get()) {
                            Files.createDirectory(this.directory().resolve(this.commonDirectory), new FileAttribute[0]);
                            Atomic$package$Atomic$extensions$.MODULE$.$colon$eq(this.commonDirectoryCreated, true);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 6] lbl16 : MonitorExitStatement: MONITOREXIT : var7_7
                        v2 = boxedUnit2;
                    }
                } else {
                    Path dir = this.directory().resolve(relativeDir);
                    scopeFiles.registerFile(dir);
                    Files.createDirectory(dir, new FileAttribute[0]);
                    v2 = BoxesRunTime.boxToLong((long)Atomic$package$Atomic$extensions$.MODULE$.$plus$eq(this.statistics.directoryCount(), 1L));
                }
                file = this.directory().resolve((Path)relativePath);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(Files.newOutputStream(file, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE), StandardCharsets.UTF_8);
                scopeFiles.registerFile(file);
                Atomic$package$Atomic$extensions$.MODULE$.$plus$eq(this.statistics.fileCount(), 1L);
                AutoClosing$.MODULE$.autoClosing(outputStreamWriter, (Function1 & Serializable)_$1 -> _$1.append(content$1));
                long size = Files.size(file);
                Atomic$package$Atomic$extensions$.MODULE$.$plus$eq(this.statistics.totalFileSize(), size);
                file.toFile().setWritable(false);
                Logger LoggerImpl_this = FileValueState$.js7$data$value$expression$scopes$FileValueState$$$logger;
                if (!LoggerImpl_this.underlying().isDebugEnabled()) break block7;
                LoggerImpl_this.underlying().debug("{} => {} {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{FileValueScope$.MODULE$.functionName(), file, ByteUnits$.MODULE$.toKBGB(size)}), Object.class));
            }
            return file;
        });
    }

    public static final class ScopeFiles {
        private final AtomicUpdater files = new AtomicUpdater<List>(package$.MODULE$.List().empty());

        public AtomicUpdater<List<Path>> files() {
            return this.files;
        }

        public void registerFile(Path file) {
            this.files().update((Function1<List<Path>, List<Path>>)((Function1 & Serializable)arg_0 -> FileValueState$.js7$data$value$expression$scopes$FileValueState$ScopeFiles$$_$registerFile$$anonfun$1(file, arg_0)));
        }

        public Seq<Path> release() {
            return (Seq)this.files().getAndSet((List<Path>)package$.MODULE$.Nil());
        }
    }

    public static final class ScopeRegister {
        private final AtomicUpdater<Map<FileValueScope, ScopeFiles>> scopeToFiles = new AtomicUpdater<Map>(Predef$.MODULE$.Map().empty());

        public ScopeFiles apply(FileValueScope scope) {
            return (ScopeFiles)((MapOps)this.scopeToFiles.get()).apply((Object)scope);
        }

        public Option<ScopeFiles> get(FileValueScope scope) {
            return ((MapOps)this.scopeToFiles.get()).get((Object)scope);
        }

        public void add(FileValueScope scope) {
            this.scopeToFiles.update((Function1<Map<FileValueScope, ScopeFiles>, Map<FileValueScope, ScopeFiles>>)((Function1 & Serializable)arg_0 -> FileValueState$.js7$data$value$expression$scopes$FileValueState$ScopeRegister$$_$add$$anonfun$1(scope, arg_0)));
        }

        public void remove(FileValueScope scope) {
            this.scopeToFiles.update((Function1<Map<FileValueScope, ScopeFiles>, Map<FileValueScope, ScopeFiles>>)((Function1 & Serializable)arg_0 -> FileValueState$.js7$data$value$expression$scopes$FileValueState$ScopeRegister$$_$remove$$anonfun$1(scope, arg_0)));
        }

        public boolean isEmpty() {
            return ((IterableOnceOps)this.scopeToFiles.get()).isEmpty();
        }
    }

    public static final class Statistics {
        private final AtomicLong fileCount = new AtomicLong(0L);
        private final AtomicLong directoryCount = new AtomicLong(0L);
        private final AtomicLong totalFileSize = new AtomicLong(0L);

        public AtomicLong fileCount() {
            return this.fileCount;
        }

        public AtomicLong directoryCount() {
            return this.directoryCount;
        }

        public AtomicLong totalFileSize() {
            return this.totalFileSize;
        }

        public String toString() {
            long fileCount = this.fileCount().get();
            return BoxesRunTime.boxToLong((long)fileCount).toString() + " files, " + this.directoryCount().get() + " subdirectories, " + ByteUnits$.MODULE$.toKBGB(this.totalFileSize().get()) + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(fileCount > 0L), (Function0<String>)((Function0 & Serializable)() -> this.toString$$anonfun$1(fileCount)));
        }

        private final String toString$$anonfun$1(long fileCount$1) {
            return ", \u2205 " + ByteUnits$.MODULE$.toKBGB(this.totalFileSize().get() / fileCount$1) + "/file";
        }
    }
}

