/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.watch;

import cats.effect.IO;
import cats.effect.unsafe.IORuntime;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.Path;
import js7.base.catsutils.CatsDeadline;
import js7.base.stream.IncreasingNumberSync;
import js7.base.utils.CloseableIterator;
import js7.base.utils.CloseableIterator$;
import js7.common.jsonseq.PositionAnd;
import js7.common.jsonseq.PositionAnd$;
import js7.data.event.JournalId;
import js7.data.event.JournalPosition;
import js7.data.event.JournalPosition$;
import js7.journal.data.JournalLocation;
import js7.journal.files.JournalFiles$;
import js7.journal.files.JournalFiles$JournalMetaOps$;
import js7.journal.watch.EventReader;
import js7.journal.watch.FileEventIteratorPool;
import js7.journal.watch.JournalIndex;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.Nothing$;

public final class CurrentEventReader
implements EventReader {
    public static final long OFFSET$3 = LazyVals$.MODULE$.getOffsetStatic(CurrentEventReader.class.getDeclaredField("iteratorPool$lzy1"));
    public static final long OFFSET$2 = LazyVals$.MODULE$.getOffsetStatic(CurrentEventReader.class.getDeclaredField("js7$journal$watch$EventReader$$journalIndexFactor$lzy1"));
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(CurrentEventReader.class.getDeclaredField("journalIndex$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CurrentEventReader.class.getDeclaredField("js7$journal$watch$EventReader$$logger$lzy1"));
    private volatile Object js7$journal$watch$EventReader$$logger$lzy1;
    private volatile Object journalIndex$lzy1;
    private volatile Object js7$journal$watch$EventReader$$journalIndexFactor$lzy1;
    private volatile Object iteratorPool$lzy1;
    private volatile boolean js7$journal$watch$EventReader$$_closeAfterUse;
    private volatile long js7$journal$watch$EventReader$$_lastUsed;
    private final JournalLocation journalLocation;
    private final JournalId expectedJournalId;
    private final PositionAnd<Object> firstEventPositionAndFileEventId;
    private final boolean isActiveNode;
    private final Config config;
    private final IORuntime ioRuntime;
    private final Path journalFile;
    private final IncreasingNumberSync flushedLengthSync;
    private volatile boolean journalingEnded;
    private volatile long _committedLength;
    private volatile long _lastEventId;

    public CurrentEventReader(JournalLocation journalLocation, JournalId expectedJournalId, PositionAnd<Object> firstEventPositionAndFileEventId, PositionAnd<Object> flushedLengthAndEventId, boolean isActiveNode, Config config, IORuntime ioRuntime) {
        this.journalLocation = journalLocation;
        this.expectedJournalId = expectedJournalId;
        this.firstEventPositionAndFileEventId = firstEventPositionAndFileEventId;
        this.isActiveNode = isActiveNode;
        this.config = config;
        this.ioRuntime = ioRuntime;
        EventReader.$init$(this);
        this.journalFile = JournalFiles$JournalMetaOps$.MODULE$.file$extension(JournalFiles$.MODULE$.JournalMetaOps(journalLocation), this.fileEventId());
        this.flushedLengthSync = new IncreasingNumberSync(0L, (Function1<Object, String>)(Function1 & Serializable)o -> CurrentEventReader.$init$$$anonfun$1(BoxesRunTime.unboxToLong((Object)o)));
        this.flushedLengthSync.onAdded(flushedLengthAndEventId.position());
        this.journalingEnded = false;
        this._committedLength = flushedLengthAndEventId.position();
        this._lastEventId = BoxesRunTime.unboxToLong((Object)flushedLengthAndEventId.value());
    }

    @Override
    public Logger js7$journal$watch$EventReader$$logger() {
        Object object = this.js7$journal$watch$EventReader$$logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.js7$journal$watch$EventReader$$logger$lzyINIT1();
    }

    private Object js7$journal$watch$EventReader$$logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.js7$journal$watch$EventReader$$logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = EventReader.js7$journal$watch$EventReader$$logger$(this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.js7$journal$watch$EventReader$$logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public JournalIndex journalIndex() {
        Object object = this.journalIndex$lzy1;
        if (object instanceof JournalIndex) {
            return (JournalIndex)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (JournalIndex)this.journalIndex$lzyINIT1();
    }

    private Object journalIndex$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.journalIndex$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    JournalIndex journalIndex = null;
                    try {
                        journalIndex = EventReader.journalIndex$(this);
                        object2 = journalIndex == null ? LazyVals.NullValue$.MODULE$ : journalIndex;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.journalIndex$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return journalIndex;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public int js7$journal$watch$EventReader$$journalIndexFactor() {
        Object object = this.js7$journal$watch$EventReader$$journalIndexFactor$lzy1;
        if (object instanceof Integer) {
            return BoxesRunTime.unboxToInt((Object)object);
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return BoxesRunTime.unboxToInt(null);
        }
        return BoxesRunTime.unboxToInt((Object)this.js7$journal$watch$EventReader$$journalIndexFactor$lzyINIT1());
    }

    private Object js7$journal$watch$EventReader$$journalIndexFactor$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.js7$journal$watch$EventReader$$journalIndexFactor$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Integer n = null;
                    try {
                        n = BoxesRunTime.boxToInteger((int)EventReader.js7$journal$watch$EventReader$$journalIndexFactor$(this));
                        object2 = n == null ? LazyVals.NullValue$.MODULE$ : n;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.js7$journal$watch$EventReader$$journalIndexFactor$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return n;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public final FileEventIteratorPool iteratorPool() {
        Object object = this.iteratorPool$lzy1;
        if (object instanceof FileEventIteratorPool) {
            return (FileEventIteratorPool)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (FileEventIteratorPool)this.iteratorPool$lzyINIT1();
    }

    private Object iteratorPool$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.iteratorPool$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    FileEventIteratorPool fileEventIteratorPool = null;
                    try {
                        fileEventIteratorPool = EventReader.iteratorPool$(this);
                        object2 = fileEventIteratorPool == null ? LazyVals.NullValue$.MODULE$ : fileEventIteratorPool;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.iteratorPool$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return fileEventIteratorPool;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$3, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public boolean js7$journal$watch$EventReader$$_closeAfterUse() {
        return this.js7$journal$watch$EventReader$$_closeAfterUse;
    }

    @Override
    public long js7$journal$watch$EventReader$$_lastUsed() {
        return this.js7$journal$watch$EventReader$$_lastUsed;
    }

    @Override
    public void js7$journal$watch$EventReader$$_closeAfterUse_$eq(boolean x$1) {
        this.js7$journal$watch$EventReader$$_closeAfterUse = x$1;
    }

    @Override
    public void js7$journal$watch$EventReader$$_lastUsed_$eq(long x$1) {
        this.js7$journal$watch$EventReader$$_lastUsed = x$1;
    }

    @Override
    public JournalLocation journalLocation() {
        return this.journalLocation;
    }

    @Override
    public JournalId expectedJournalId() {
        return this.expectedJournalId;
    }

    public boolean isActiveNode() {
        return this.isActiveNode;
    }

    @Override
    public Config config() {
        return this.config;
    }

    @Override
    public IORuntime ioRuntime() {
        return this.ioRuntime;
    }

    @Override
    public boolean isHistoric() {
        return false;
    }

    @Override
    public long firstEventPosition() {
        return this.firstEventPositionAndFileEventId.position();
    }

    @Override
    public long fileEventId() {
        return BoxesRunTime.unboxToLong((Object)this.firstEventPositionAndFileEventId.value());
    }

    @Override
    public Path journalFile() {
        return this.journalFile;
    }

    @Override
    public long committedLength() {
        return this._committedLength;
    }

    public JournalPosition journalPosition() {
        JournalPosition journalPosition;
        CurrentEventReader currentEventReader = this;
        synchronized (currentEventReader) {
            journalPosition = JournalPosition$.MODULE$.apply(this.fileEventId(), this._committedLength);
        }
        return journalPosition;
    }

    @Override
    public boolean isEOF(long position) {
        boolean bl;
        CurrentEventReader currentEventReader = this;
        synchronized (currentEventReader) {
            bl = this.journalingEnded && position >= this._committedLength;
        }
        return bl;
    }

    @Override
    public IO<Object> whenDataAvailableAfterPosition(long position, Option<CatsDeadline> until) {
        return this.flushedLengthSync.whenAvailable(position, until, this.flushedLengthSync.whenAvailable$default$3());
    }

    @Override
    public boolean isFlushedAfterPosition(long position) {
        boolean bl;
        CurrentEventReader currentEventReader = this;
        synchronized (currentEventReader) {
            bl = this.journalingEnded || position < this.flushedLengthSync.last();
        }
        return bl;
    }

    public void onJournalingEnded(long fileLength) {
        CurrentEventReader currentEventReader = this;
        synchronized (currentEventReader) {
            this.flushedLengthSync.onAdded(fileLength + 1L);
            this._committedLength = fileLength;
            this.journalingEnded = true;
        }
    }

    public void onFileWritten(long flushedPosition) {
        if (flushedPosition > this.flushedLengthSync.last()) {
            this.flushedLengthSync.onAdded(flushedPosition);
            return;
        }
    }

    public void onEventsCommitted(PositionAnd<Object> positionAndEventId, int n) {
        CurrentEventReader currentEventReader = this;
        synchronized (currentEventReader) {
            PositionAnd<Object> positionAnd = positionAndEventId;
            if (positionAnd == null) {
                throw new MatchError(positionAnd);
            }
            PositionAnd<Object> positionAnd2 = PositionAnd$.MODULE$.unapply(positionAnd);
            long l = positionAnd2._1();
            long l2 = BoxesRunTime.unboxToLong((Object)positionAnd2._2());
            long pos = l;
            long eventId = l2;
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(pos, eventId);
            long pos2 = sp2._1$mcJ$sp();
            long eventId2 = sp2._2$mcJ$sp();
            this.journalIndex().addAfter(eventId2, pos2, n);
            this._committedLength = pos2;
            this._lastEventId = eventId2;
        }
    }

    public CloseableIterator<Nothing$> reverseEventsAfter(long after) {
        return CloseableIterator$.MODULE$.empty();
    }

    public long lastEventId() {
        return this._lastEventId;
    }

    public boolean isEnded() {
        return this.journalingEnded;
    }

    public String toString() {
        return "CurrentEventReader(" + this.journalFile().getFileName() + ")";
    }

    private static final /* synthetic */ String $init$$$anonfun$1(long o) {
        return "position " + o;
    }
}

