/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.watch;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Sync;
import cats.effect.unsafe.IORuntime;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import fs2.Stream;
import fs2.Stream$;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.ProvisionalAssumptions$streamChunks$;
import js7.base.catsutils.CatsDeadline;
import js7.base.catsutils.SyncDeadline;
import js7.base.catsutils.SyncDeadline$;
import js7.base.data.ByteArray;
import js7.base.log.Logger$;
import js7.base.time.Timestamp$;
import js7.base.utils.Assertions$;
import js7.base.utils.AutoClosing$;
import js7.base.utils.CloseableIterator;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import js7.common.jsonseq.InputStreamJsonSeqReader;
import js7.common.jsonseq.InputStreamJsonSeqReader$;
import js7.common.jsonseq.InputStreamJsonSeqReader$JsonSeqFileClosedProblem$;
import js7.common.jsonseq.PositionAnd;
import js7.common.jsonseq.PositionAnd$;
import js7.common.utils.UntilNoneIterator$;
import js7.data.event.Event;
import js7.data.event.JournalId;
import js7.data.event.KeyedEvent;
import js7.data.event.Stamped;
import js7.journal.data.JournalLocation;
import js7.journal.recover.JournalReader$;
import js7.journal.watch.ClosedException;
import js7.journal.watch.EventReader$;
import js7.journal.watch.FileEventIterator;
import js7.journal.watch.FileEventIteratorPool;
import js7.journal.watch.JournalIndex;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.Vector;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;
import scala.sys.package$;
import scala.util.NotGiven$;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public interface EventReader
extends AutoCloseable {
    public static void $init$(EventReader $this) {
        $this.js7$journal$watch$EventReader$$_closeAfterUse_$eq(false);
        $this.js7$journal$watch$EventReader$$_lastUsed_$eq(0L);
    }

    public JournalLocation journalLocation();

    public JournalId expectedJournalId();

    public boolean isHistoric();

    public Path journalFile();

    public long fileEventId();

    public long firstEventPosition();

    public boolean isFlushedAfterPosition(long var1);

    public long committedLength();

    public boolean isEOF(long var1);

    public IO<Object> whenDataAvailableAfterPosition(long var1, Option<CatsDeadline> var3);

    public Config config();

    public IORuntime ioRuntime();

    public static Logger js7$journal$watch$EventReader$$logger$(EventReader $this) {
        return $this.js7$journal$watch$EventReader$$logger();
    }

    default public Logger js7$journal$watch$EventReader$$logger() {
        return Logger$.MODULE$.withPrefix(this.journalFile().getFileName().toString(), ClassTag$.MODULE$.apply(EventReader.class));
    }

    public static JournalIndex journalIndex$(EventReader $this) {
        return $this.journalIndex();
    }

    default public JournalIndex journalIndex() {
        return new JournalIndex(PositionAnd$.MODULE$.apply(this.firstEventPosition(), BoxesRunTime.boxToLong((long)this.fileEventId())), this.config().getInt("js7.journal.watch.index-size"));
    }

    public static int js7$journal$watch$EventReader$$journalIndexFactor$(EventReader $this) {
        return $this.js7$journal$watch$EventReader$$journalIndexFactor();
    }

    default public int js7$journal$watch$EventReader$$journalIndexFactor() {
        return this.config().getInt("js7.journal.watch.index-factor");
    }

    public static FileEventIteratorPool iteratorPool$(EventReader $this) {
        return $this.iteratorPool();
    }

    default public FileEventIteratorPool iteratorPool() {
        return new FileEventIteratorPool(this.journalLocation(), this.expectedJournalId(), this.journalFile(), this.fileEventId(), (Function0<Object>)(Function0 & Serializable)() -> this.committedLength());
    }

    public boolean js7$journal$watch$EventReader$$_closeAfterUse();

    public void js7$journal$watch$EventReader$$_closeAfterUse_$eq(boolean var1);

    public long js7$journal$watch$EventReader$$_lastUsed();

    public void js7$journal$watch$EventReader$$_lastUsed_$eq(long var1);

    public static void closeAfterUse$(EventReader $this) {
        $this.closeAfterUse();
    }

    default public void closeAfterUse() {
        Logger LoggerImpl_this = this.js7$journal$watch$EventReader$$logger();
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("closeAfterUse");
        }
        this.js7$journal$watch$EventReader$$_closeAfterUse_$eq(true);
        if (!this.isInUse()) {
            this.close();
            return;
        }
    }

    public static void close$(EventReader $this) {
        $this.close();
    }

    @Override
    default public void close() {
        this.iteratorPool().close();
    }

    public static Option eventsAfter$(EventReader $this, long after) {
        return $this.eventsAfter(after);
    }

    default public Option<CloseableIterator<Stamped<KeyedEvent<Event>>>> eventsAfter(long after) {
        PositionAnd<Object> indexPositionAndEventId = this.journalIndex().positionAndEventIdAfter(after);
        FileEventIterator iterator = this.iteratorPool().borrowIterator();
        return (Option)AutoClosing$.MODULE$.closeOnError(iterator, () -> this.eventsAfter$$anonfun$1(iterator, indexPositionAndEventId, after));
    }

    public static Stream snapshot$(EventReader $this) {
        return $this.snapshot();
    }

    default public Stream<IO, Object> snapshot() {
        return JournalReader$.MODULE$.snapshot(this.journalLocation().S(), this.journalFile(), this.expectedJournalId());
    }

    public static Stream rawSnapshot$(EventReader $this) {
        return $this.rawSnapshot();
    }

    default public Stream<IO, ByteArray> rawSnapshot() {
        return JournalReader$.MODULE$.rawSnapshot(this.journalLocation().S(), this.journalFile(), this.expectedJournalId());
    }

    public static Stream streamFile$(EventReader $this, long position, Option timeout, boolean markEOF, boolean onlyAcks) {
        return $this.streamFile(position, (Option<FiniteDuration>)timeout, markEOF, onlyAcks);
    }

    default public Stream<IO, PositionAnd<ByteArray>> streamFile(long position, Option<FiniteDuration> timeout, boolean markEOF, boolean onlyAcks) {
        return Stream$.MODULE$.resource(InputStreamJsonSeqReader$.MODULE$.resource(this.journalFile()), (MonadCancel)IO$.MODULE$.asyncForIO()).flatMap((Function1 & Serializable)jsonSeqReader -> Stream$.MODULE$.eval(timeout.fold(EventReader::streamFile$$anonfun$1$$anonfun$1, (Function1 & Serializable)t -> SyncDeadline$.MODULE$.usingNow((Function1 & Serializable)now -> Some$.MODULE$.apply((Object)now.$plus((FiniteDuration)t))))).flatMap((Function1 & Serializable)until -> this.streamFile2((InputStreamJsonSeqReader)jsonSeqReader, position, (Option<SyncDeadline>)until, markEOF, onlyAcks).map((Function1 & Serializable)o -> o), NotGiven$.MODULE$.value()), NotGiven$.MODULE$.value());
    }

    public static boolean streamFile$default$3$(EventReader $this) {
        return $this.streamFile$default$3();
    }

    default public boolean streamFile$default$3() {
        return false;
    }

    private Stream<IO, PositionAnd<ByteArray>> streamFile2(InputStreamJsonSeqReader jsonSeqReader, long position, Option<SyncDeadline> until, boolean markEOF, boolean onlyAcks) {
        return Stream$.MODULE$.suspend(() -> this.streamFile2$$anonfun$1(until, jsonSeqReader, onlyAcks, markEOF, position));
    }

    private boolean streamFile2$default$4() {
        return false;
    }

    public static long lastUsedAt$(EventReader $this) {
        return $this.lastUsedAt();
    }

    default public long lastUsedAt() {
        return this.js7$journal$watch$EventReader$$_lastUsed();
    }

    public static boolean isInUse$(EventReader $this) {
        return $this.isInUse();
    }

    default public boolean isInUse() {
        return this.iteratorPool().isLent();
    }

    private Option eventsAfter$$anonfun$1(FileEventIterator iterator$1, PositionAnd indexPositionAndEventId$1, long after$1) {
        boolean exists;
        long pos = iterator$1.position();
        if (pos != indexPositionAndEventId$1.position() && (pos < indexPositionAndEventId$1.position() || iterator$1.eventId() > after$1)) {
            iterator$1.seek(indexPositionAndEventId$1);
        }
        if (!(exists = iterator$1.skipToEventAfter(this.journalIndex(), after$1))) {
            this.iteratorPool().returnIterator(iterator$1);
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)new EventIterator(this, iterator$1, after$1));
    }

    private static IO streamFile$$anonfun$1$$anonfun$1() {
        return IO$.MODULE$.none();
    }

    private static Option $anonfun$1(InputStreamJsonSeqReader jsonSeqReader$5, BooleanRef eof$1, LongRef lastPosition$1) {
        Option maybeLine = jsonSeqReader$5.readRaw().map((Function1 & Serializable)_$2 -> (ByteArray)_$2.value());
        eof$1.elem = maybeLine.isEmpty();
        lastPosition$1.elem = jsonSeqReader$5.position();
        return maybeLine.map((Function1 & Serializable)_$3 -> PositionAnd$.MODULE$.apply(lastPosition$2.elem, _$3));
    }

    private static PositionAnd streamNext$1$$anonfun$2$$anonfun$3$$anonfun$1(LongRef lastPosition$5) {
        return PositionAnd$.MODULE$.apply(lastPosition$5.elem, EventReader$.js7$journal$watch$EventReader$$$EndOfJournalFileMarker);
    }

    private static IterableOnce streamNext$1$$anonfun$2$$anonfun$3(BooleanRef eof$2, boolean markEOF$6, LongRef lastPosition$4) {
        return ScalaUtils$syntax$RichBoolean$.MODULE$.thenIterator$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(eof$2.elem && markEOF$6), () -> EventReader.streamNext$1$$anonfun$2$$anonfun$3$$anonfun$1(lastPosition$4));
    }

    private Stream streamNext$1$$anonfun$2$$anonfun$4(BooleanRef eof$3, LongRef lastPosition$6, Option until$4, InputStreamJsonSeqReader jsonSeqReader$6, boolean onlyAcks$6, boolean markEOF$7) {
        if (eof$3.elem) {
            return Stream$.MODULE$.empty();
        }
        return this.streamNext$1(until$4, jsonSeqReader$6, onlyAcks$6, markEOF$7, lastPosition$6.elem);
    }

    private /* synthetic */ Stream streamNext$1$$anonfun$2(long position$4, InputStreamJsonSeqReader jsonSeqReader$4, boolean onlyAcks$5, boolean markEOF$5, Option until$3, boolean x$1) {
        boolean bl = x$1;
        if (!bl) {
            return Stream$.MODULE$.empty();
        }
        if (bl) {
            LongRef lastPosition = LongRef.create((long)position$4);
            BooleanRef eof = BooleanRef.create((boolean)false);
            Iterator iterator = ScalaUtils$syntax$.MODULE$.takeThrough(UntilNoneIterator$.MODULE$.apply(() -> EventReader.$anonfun$1(jsonSeqReader$4, eof, lastPosition)), (Function1 & Serializable)_$4 -> this.isFlushedAfterPosition(lastPosition$3.elem));
            if (onlyAcks$5) {
                ObjectRef last = ObjectRef.create(null);
                iterator.foreach((Function1)(JProcedure1 & Serializable)_$5 -> {
                    last$1.elem = _$5;
                });
                iterator = Option$.MODULE$.apply((Object)((PositionAnd)last.elem)).iterator();
            }
            iterator = iterator.tapEach((Function1)(JProcedure1 & Serializable)o -> {
                Object a = o.value();
                ByteArray byteArray = EventReader$.js7$journal$watch$EventReader$$$EndOfJournalFileMarker;
                if (!(a != null ? !a.equals(byteArray) : byteArray != null)) {
                    throw package$.MODULE$.error("Journal file must not contain a line like " + o);
                }
            }).concat(() -> EventReader.streamNext$1$$anonfun$2$$anonfun$3(eof, markEOF$5, lastPosition));
            boolean bl2 = Stream$.MODULE$.fromIterator();
            return Stream.PartiallyAppliedFromIterator$.MODULE$.apply$extension(bl2, iterator, ProvisionalAssumptions$streamChunks$.MODULE$.elementsPerChunkLimit(), (Sync)IO$.MODULE$.asyncForIO()).append(() -> this.streamNext$1$$anonfun$2$$anonfun$4(eof, lastPosition, until$3, jsonSeqReader$4, onlyAcks$5, markEOF$5));
        }
        throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
    }

    private Stream streamNext$1(Option until$2, InputStreamJsonSeqReader jsonSeqReader$3, boolean onlyAcks$4, boolean markEOF$4, long position) {
        return Stream$.MODULE$.eval(this.whenDataAvailableAfterPosition(position, (Option<CatsDeadline>)until$2.map((Function1 & Serializable)_$1 -> _$1.toCatsDeadline()))).flatMap((Function1 & Serializable)x$1 -> this.streamNext$1$$anonfun$2(position, jsonSeqReader$3, onlyAcks$4, markEOF$4, until$2, BoxesRunTime.unboxToBoolean((Object)x$1)), NotGiven$.MODULE$.value());
    }

    private Stream streamFile2$$anonfun$1(Option until$1, InputStreamJsonSeqReader jsonSeqReader$2, boolean onlyAcks$3, boolean markEOF$3, long position$3) {
        jsonSeqReader$2.seek(position$3);
        return this.streamNext$1(until$1, jsonSeqReader$2, onlyAcks$3, markEOF$3, position$3);
    }

    public final class EventIterator
    implements CloseableIterator<Stamped<KeyedEvent<Event>>> {
        private final FileEventIterator iterator_;
        private final long after;
        private final AtomicReference<FileEventIterator> iteratorAtomic;
        private boolean eof;
        private Stamped<KeyedEvent<Event>> _next;
        private final /* synthetic */ EventReader $outer;

        public EventIterator(EventReader $outer, FileEventIterator iterator_, long after) {
            this.iterator_ = iterator_;
            this.after = after;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            IterableOnce.$init$((IterableOnce)this);
            IterableOnceOps.$init$((IterableOnceOps)this);
            Iterator.$init$((Iterator)this);
            this.iteratorAtomic = new AtomicReference<FileEventIterator>(iterator_);
            this.eof = false;
            this._next = null;
        }

        @Override
        public /* synthetic */ Vector js7$base$utils$CloseableIterator$$super$toVector() {
            return IterableOnceOps.toVector$((IterableOnceOps)this);
        }

        @Override
        public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$take(int n) {
            return Iterator.take$((Iterator)this, (int)n);
        }

        @Override
        public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$takeWhile(Function1 p) {
            return Iterator.takeWhile$((Iterator)this, (Function1)p);
        }

        @Override
        public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$drop(int n) {
            return Iterator.drop$((Iterator)this, (int)n);
        }

        @Override
        public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$dropWhile(Function1 p) {
            return Iterator.dropWhile$((Iterator)this, (Function1)p);
        }

        @Override
        public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$filter(Function1 p) {
            return Iterator.filter$((Iterator)this, (Function1)p);
        }

        @Override
        public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$map(Function1 f) {
            return Iterator.map$((Iterator)this, (Function1)f);
        }

        @Override
        public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$flatMap(Function1 f) {
            return Iterator.flatMap$((Iterator)this, (Function1)f);
        }

        @Override
        public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$tapEach(Function1 f) {
            return Iterator.tapEach$((Iterator)this, (Function1)f);
        }

        @Override
        public /* synthetic */ Iterator js7$base$utils$CloseableIterator$$super$collect(PartialFunction pf) {
            return Iterator.collect$((Iterator)this, (PartialFunction)pf);
        }

        @Override
        public void close() {
            EventIterator eventIterator = this;
            synchronized (eventIterator) {
                Option$.MODULE$.apply(this.iteratorAtomic.getAndSet(null)).foreach((Function1)(JProcedure1 & Serializable)it -> {
                    this.$outer.iteratorPool().returnIterator((FileEventIterator)it);
                    if (this.$outer.js7$journal$watch$EventReader$$_closeAfterUse() && !this.$outer.isInUse() || this.$outer.iteratorPool().isClosed()) {
                        Logger LoggerImpl_this = this.$outer.js7$journal$watch$EventReader$$logger();
                        if (LoggerImpl_this.underlying().isDebugEnabled()) {
                            LoggerImpl_this.underlying().debug("CloseableIterator.close _closeAfterUse: '{}'", (Object)this.$outer);
                        }
                        this.$outer.close();
                        return;
                    }
                });
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean hasNext() {
            EventIterator eventIterator = this;
            synchronized (eventIterator) {
                if (this.eof) return false;
                FileEventIterator fileEventIterator = this.iteratorAtomic.get();
                if (fileEventIterator == null) {
                    Logger LoggerImpl_this = this.$outer.js7$journal$watch$EventReader$$logger();
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug(InputStreamJsonSeqReader$JsonSeqFileClosedProblem$.MODULE$.apply(this.iteratorName()).toString());
                    }
                    this.eof = true;
                    return false;
                }
                FileEventIterator iterator = fileEventIterator;
                if (this._next != null) return true;
                boolean has = iterator.hasNext();
                this.eof |= !has;
                if (has) {
                    this.$outer.js7$journal$watch$EventReader$$_lastUsed_$eq(Timestamp$.MODULE$.currentTimeMillis());
                    Object stamped = iterator.next();
                    Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1((Stamped)stamped)), "stamped.eventId >= after"), (Function0<String>)((Function0 & Serializable)() -> this.hasNext$$anonfun$1((Stamped)stamped)), FullName$.MODULE$.apply("js7.journal.watch.EventReader.EventIterator.hasNext"), FileName$.MODULE$.apply("EventReader.scala"), Line$.MODULE$.apply(122));
                    if (this.$outer.isHistoric()) {
                        this.$outer.journalIndex().tryAddAfter(((Stamped)stamped).eventId(), iterator.position(), this.$outer.journalIndex().tryAddAfter$default$3());
                    }
                    this._next = stamped;
                } else {
                    if (this.$outer.isHistoric()) {
                        this.$outer.journalIndex().freeze(this.$outer.js7$journal$watch$EventReader$$journalIndexFactor());
                    }
                    this.close();
                }
                if (!has) return false;
                return true;
            }
        }

        public Stamped<KeyedEvent<Event>> next() {
            Stamped<KeyedEvent<Event>> stamped;
            EventIterator eventIterator = this;
            synchronized (eventIterator) {
                this.hasNext();
                Stamped<KeyedEvent<Event>> stamped2 = this._next;
                if (stamped2 == null) {
                    if (this.iteratorAtomic.get() == null) {
                        throw new ClosedException(this.iterator_.journalFile());
                    }
                    throw new NoSuchElementException("EventReader read past end of file");
                }
                Stamped<KeyedEvent<Event>> result = stamped2;
                this._next = null;
                stamped = result;
            }
            return stamped;
        }

        private String iteratorName() {
            return this.iterator_.toString();
        }

        public final /* synthetic */ EventReader js7$journal$watch$EventReader$EventIterator$$$outer() {
            return this.$outer;
        }

        private final boolean v$proxy1$1(Stamped stamped$1) {
            return stamped$1.eventId() >= this.after;
        }

        private final String hasNext$$anonfun$1(Stamped stamped$2) {
            return stamped$2.eventId() + " \u2265 " + this.after;
        }
    }

    public static final class TimeoutException
    extends java.util.concurrent.TimeoutException {
    }
}

