/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.write;

import cats.effect.unsafe.IORuntime;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.nio.file.Path;
import js7.base.circeutils.CirceUtils$;
import js7.base.circeutils.CirceUtils$RichJson$;
import js7.base.data.ByteArray;
import js7.base.log.Logger$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.Stopwatch$;
import js7.data.event.JournalSeparators$;
import js7.data.event.SnapshotableState;
import js7.journal.data.JournalLocation;
import js7.journal.write.JournalWriter;
import js7.journal.write.SnapshotJournalWriter$;
import js7.journal.write.SnapshotStatisticsCounter;
import scala.Function1;
import scala.Int$;
import scala.Option;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.function.JProcedure1;

public final class SnapshotJournalWriter
extends JournalWriter {
    private final Path file;
    private final Option simulateSync;
    private final IORuntime ioRuntime;
    private final Logger logger;
    private final SnapshotStatisticsCounter statistics;
    private boolean snapshotStarted;
    private int snapshotCount;
    private final Deadline runningSince;

    public static SnapshotJournalWriter forTest(JournalLocation journalLocation, long l, IORuntime iORuntime) {
        return SnapshotJournalWriter$.MODULE$.forTest(journalLocation, l, iORuntime);
    }

    public SnapshotJournalWriter(SnapshotableState.HasCodec S, Path file, long after, Option<FiniteDuration> simulateSync, IORuntime ioRuntime) {
        this.file = file;
        this.simulateSync = simulateSync;
        this.ioRuntime = ioRuntime;
        super(S, after, false);
        this.logger = Logger$.MODULE$.withPrefix(this.getClass(), file.getFileName().toString());
        this.statistics = new SnapshotStatisticsCounter();
        this.snapshotStarted = false;
        this.snapshotCount = 0;
        this.runningSince = Deadline$.MODULE$.now();
    }

    @Override
    public Path file() {
        return this.file;
    }

    @Override
    public Option<FiniteDuration> simulateSync() {
        return this.simulateSync;
    }

    @Override
    public IORuntime ioRuntime() {
        return this.ioRuntime;
    }

    @Override
    public SnapshotStatisticsCounter statistics() {
        return this.statistics;
    }

    public void closeAndLog() {
        super.close();
        FiniteDuration elapsed = ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(this.runningSince));
        Logger LoggerImpl_this = this.logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("Snapshot finished - " + Stopwatch$.MODULE$.itemsPerSecondString(elapsed, Int$.MODULE$.int2long(this.snapshotCount), "objects") + " \u00b7 " + Stopwatch$.MODULE$.bytesPerSecondString(elapsed, this.fileLength()));
        }
        this.statistics().debugString().foreach((Function1)(JProcedure1 & Serializable)o -> {
            Logger LoggerImpl_this = this.logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                LoggerImpl_this.underlying().info(o);
                return;
            }
        });
    }

    public void beginSnapshotSection() {
        if (this.snapshotStarted) {
            throw new IllegalStateException("SnapshotJournalWriter: duplicate beginSnapshotSection()");
        }
        this.jsonWriter().write(CirceUtils$RichJson$.MODULE$.toByteArray$extension(CirceUtils$.MODULE$.RichJson(JournalSeparators$.MODULE$.SnapshotHeader())));
        this.flush(false);
        this.snapshotStarted = true;
    }

    public void writeSnapshot(ByteArray json) {
        if (!this.snapshotStarted) {
            throw new IllegalStateException("SnapshotJournalWriter: writeSnapshots(), but snapshots have not been started");
        }
        this.statistics().countSnapshot();
        this.jsonWriter().write(json);
        ++this.snapshotCount;
    }

    public void endSnapshotSection() {
        this.jsonWriter().write(CirceUtils$RichJson$.MODULE$.toByteArray$extension(CirceUtils$.MODULE$.RichJson(JournalSeparators$.MODULE$.SnapshotFooter())));
        this.statistics().setFileLength(this.jsonWriter().fileLength());
    }

    public String toString() {
        return "SnapshotJournalWriter(" + this.file().getFileName() + ")";
    }
}

