/*
 * Decompiled with CFR 0.152.
 */
package js7.launcher.forwindows;

import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinNT;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.launcher.forwindows.Redirection$;

public final class Redirection {
    private final WinNT.HANDLE startupInfoHandle;
    private final boolean closeStartupInfoHandle;
    private final WinNT.HANDLE pipeHandle;
    private final AtomicBoolean released;
    private final AtomicBoolean pipeClosed;

    public static Redirection forDirectFile(File file) {
        return Redirection$.MODULE$.forDirectFile(file);
    }

    public static Redirection newStdinPipeRedirection() {
        return Redirection$.MODULE$.newStdinPipeRedirection();
    }

    public static Redirection newStdouterrPipeRedirection() {
        return Redirection$.MODULE$.newStdouterrPipeRedirection();
    }

    public Redirection(WinNT.HANDLE startupInfoHandle, boolean closeStartupInfoHandle, WinNT.HANDLE pipeHandle) {
        this.startupInfoHandle = startupInfoHandle;
        this.closeStartupInfoHandle = closeStartupInfoHandle;
        this.pipeHandle = pipeHandle;
        this.released = new AtomicBoolean(false);
        this.pipeClosed = new AtomicBoolean(false);
    }

    public WinNT.HANDLE startupInfoHandle() {
        return this.startupInfoHandle;
    }

    public WinNT.HANDLE pipeHandle() {
        return this.pipeHandle;
    }

    public void releaseStartupInfoHandle() {
        if (!this.released.getAndSet(true)) {
            if (this.closeStartupInfoHandle) {
                Kernel32Util.closeHandle((WinNT.HANDLE)this.startupInfoHandle());
                return;
            }
            return;
        }
    }

    public void closePipe() {
        if (!this.pipeClosed.getAndSet(true)) {
            WinNT.HANDLE hANDLE = this.pipeHandle();
            WinNT.HANDLE hANDLE2 = WinBase.INVALID_HANDLE_VALUE;
            if (hANDLE == null ? hANDLE2 != null : !hANDLE.equals(hANDLE2)) {
                Kernel32Util.closeHandle((WinNT.HANDLE)this.pipeHandle());
                return;
            }
        }
    }
}

