/*
 * Decompiled with CFR 0.152.
 */
package js7.launcher.process;

import cats.Applicative;
import cats.Invariant$;
import cats.UnorderedFoldable$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.MonadCancel;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.nio.file.Path;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.io.process.KeyLogin;
import js7.base.io.process.ProcessSignal;
import js7.base.io.process.ReturnCode;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.AsyncLock;
import js7.base.utils.AsyncLock$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.SetOnce;
import js7.base.utils.SetOnce$;
import js7.data.job.CommandLine;
import js7.data.job.JobKey;
import js7.data.job.ProcessExecutable$;
import js7.data.order.OrderId;
import js7.data.order.OrderOutcome;
import js7.data.order.OrderOutcome$Failed$;
import js7.data.value.Value;
import js7.data.value.package$NamedValues$;
import js7.launcher.StdObservers;
import js7.launcher.configuration.JobLauncherConf;
import js7.launcher.forwindows.WindowsLogon;
import js7.launcher.forwindows.WindowsLogon$;
import js7.launcher.forwindows.WindowsProcess$;
import js7.launcher.process.PipedProcess;
import js7.launcher.process.PipedProcess$;
import js7.launcher.process.ProcessConfiguration;
import js7.launcher.process.ProcessConfiguration$;
import js7.launcher.process.ProcessDriver$;
import js7.launcher.process.ProcessDriver$Conf$;
import js7.launcher.process.ShellReturnValuesProvider;
import js7.launcher.process.ShellReturnValuesProvider$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Either$;
import scala.util.Left;
import scala.util.Right;

public final class ProcessDriver {
    public final OrderId js7$launcher$process$ProcessDriver$$orderId;
    public final Conf js7$launcher$process$ProcessDriver$$conf;
    public final JobLauncherConf js7$launcher$process$ProcessDriver$$jobLauncherConf;
    public final SetOnce<PipedProcess> js7$launcher$process$ProcessDriver$$pipedProcessOnce;
    public final AsyncLock js7$launcher$process$ProcessDriver$$startProcessLock;
    public volatile boolean js7$launcher$process$ProcessDriver$$killed;
    public volatile Option<ProcessSignal> js7$launcher$process$ProcessDriver$$killedBeforeStart;

    public ProcessDriver(OrderId orderId, Conf conf, JobLauncherConf jobLauncherConf) {
        this.js7$launcher$process$ProcessDriver$$orderId = orderId;
        this.js7$launcher$process$ProcessDriver$$conf = conf;
        this.js7$launcher$process$ProcessDriver$$jobLauncherConf = jobLauncherConf;
        this.js7$launcher$process$ProcessDriver$$pipedProcessOnce = SetOnce$.MODULE$.apply(Tag$.MODULE$.apply(PipedProcess.class, LightTypeTag$.MODULE$.parse(132266827, "\u0004\u0000\u0001!js7.launcher.process.PipedProcess\u0001\u0001", "\u0000\u0000\u0000", 30)));
        this.js7$launcher$process$ProcessDriver$$startProcessLock = AsyncLock$.MODULE$.apply(orderId.toString(), AsyncLock$.MODULE$.apply$default$2(), AsyncLock$.MODULE$.apply$default$3(), AsyncLock$.MODULE$.apply$default$4());
        this.js7$launcher$process$ProcessDriver$$killed = false;
        this.js7$launcher$process$ProcessDriver$$killedBeforeStart = None$.MODULE$;
    }

    public IO<OrderOutcome.Completed> runProcess(Map<String, Option<String>> env, StdObservers stdObservers) {
        return (IO)ShellReturnValuesProvider$.MODULE$.resource(this.js7$launcher$process$ProcessDriver$$jobLauncherConf.tmpDirectory(), this.js7$launcher$process$ProcessDriver$$jobLauncherConf.systemEncoding(), this.js7$launcher$process$ProcessDriver$$conf.v1Compatible()).use((Function1 & Serializable)returnValuesProvider -> new Run(this, env, stdObservers, (ShellReturnValuesProvider)returnValuesProvider).runProcess(), (MonadCancel)IO$.MODULE$.asyncForIO());
    }

    public IO<BoxedUnit> kill(ProcessSignal signal) {
        return this.js7$launcher$process$ProcessDriver$$startProcessLock.lock((Function0<String>)((Function0 & Serializable)ProcessDriver::kill$$anonfun$1), IO$.MODULE$.defer(() -> this.kill$$anonfun$2(signal)));
    }

    public IO<BoxedUnit> js7$launcher$process$ProcessDriver$$sendProcessSignal(PipedProcess pipedProcess, ProcessSignal signal) {
        return IO$.MODULE$.defer(() -> this.sendProcessSignal$$anonfun$1(pipedProcess, signal));
    }

    public String toString() {
        return "ProcessDriver(" + this.js7$launcher$process$ProcessDriver$$conf.jobKey() + ")";
    }

    public static final /* synthetic */ Either js7$launcher$process$ProcessDriver$Run$$_$startProcess$$anonfun$1$$anonfun$1$$anonfun$1(KeyLogin keyLogin) {
        return WindowsLogon$.MODULE$.fromKeyLogin(keyLogin);
    }

    public static final String js7$launcher$process$ProcessDriver$Run$$_$startProcess$$anonfun$1$$anonfun$2$$anonfun$1() {
        return "startProcess";
    }

    private static final String kill$$anonfun$1() {
        return "kill";
    }

    private final void kill$$anonfun$2$$anonfun$1(ProcessSignal signal$2) {
        this.js7$launcher$process$ProcessDriver$$killedBeforeStart = Some$.MODULE$.apply((Object)signal$2);
        Logger LoggerImpl_this = ProcessDriver$.js7$launcher$process$ProcessDriver$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("{} \u25fc\ufe0f Kill before start", (Object)this.js7$launcher$process$ProcessDriver$$orderId);
            return;
        }
    }

    private final IO kill$$anonfun$2(ProcessSignal signal$1) {
        Option<PipedProcess> option = this.js7$launcher$process$ProcessDriver$$pipedProcessOnce.toOption();
        if (None$.MODULE$.equals(option)) {
            return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.kill$$anonfun$2$$anonfun$1(signal$1);
                return BoxedUnit.UNIT;
            });
        }
        if (option instanceof Some) {
            PipedProcess pipedProcess = (PipedProcess)((Some)option).value();
            return this.js7$launcher$process$ProcessDriver$$sendProcessSignal(pipedProcess, signal$1);
        }
        throw new MatchError(option);
    }

    private final IO sendProcessSignal$$anonfun$1(PipedProcess pipedProcess$2, ProcessSignal signal$3) {
        this.js7$launcher$process$ProcessDriver$$killed = true;
        return pipedProcess$2.sendProcessSignal(signal$3);
    }

    public static final class Conf
    implements Product,
    Serializable {
        private final JobKey jobKey;
        private final Function2 toOutcome;
        private final CommandLine commandLine;
        private final Option login;
        private final boolean v1Compatible;

        public static Conf apply(JobKey jobKey, Function2<Map<String, Value>, ReturnCode, OrderOutcome.Completed> function2, CommandLine commandLine, Option<KeyLogin> option, boolean bl) {
            return ProcessDriver$Conf$.MODULE$.apply(jobKey, function2, commandLine, option, bl);
        }

        public static Conf fromProduct(Product product) {
            return ProcessDriver$Conf$.MODULE$.fromProduct(product);
        }

        public static Conf unapply(Conf conf) {
            return ProcessDriver$Conf$.MODULE$.unapply(conf);
        }

        public static Option<KeyLogin> $lessinit$greater$default$4() {
            return ProcessDriver$Conf$.MODULE$.$lessinit$greater$default$4();
        }

        public static boolean $lessinit$greater$default$5() {
            return ProcessDriver$Conf$.MODULE$.$lessinit$greater$default$5();
        }

        public Conf(JobKey jobKey, Function2<Map<String, Value>, ReturnCode, OrderOutcome.Completed> toOutcome, CommandLine commandLine, Option<KeyLogin> login, boolean v1Compatible) {
            this.jobKey = jobKey;
            this.toOutcome = toOutcome;
            this.commandLine = commandLine;
            this.login = login;
            this.v1Compatible = v1Compatible;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.jobKey()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.toOutcome()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.commandLine()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.login()));
            n = Statics.mix((int)n, (int)(this.v1Compatible() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Conf)) return false;
            Conf conf = (Conf)object;
            if (this.v1Compatible() != conf.v1Compatible()) return false;
            JobKey jobKey = this.jobKey();
            JobKey jobKey2 = conf.jobKey();
            if (jobKey == null) {
                if (jobKey2 != null) {
                    return false;
                }
            } else if (!jobKey.equals(jobKey2)) return false;
            Function2<Map<String, Value>, ReturnCode, OrderOutcome.Completed> function2 = this.toOutcome();
            Function2<Map<String, Value>, ReturnCode, OrderOutcome.Completed> function22 = conf.toOutcome();
            if (function2 == null) {
                if (function22 != null) {
                    return false;
                }
            } else if (!function2.equals(function22)) return false;
            CommandLine commandLine = this.commandLine();
            CommandLine commandLine2 = conf.commandLine();
            if (commandLine == null) {
                if (commandLine2 != null) {
                    return false;
                }
            } else if (!((Object)commandLine).equals(commandLine2)) return false;
            Option<KeyLogin> option = this.login();
            Option<KeyLogin> option2 = conf.login();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Conf;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "Conf";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return BoxesRunTime.boxToBoolean((boolean)this._5());
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "jobKey";
                }
                case 1: {
                    return "toOutcome";
                }
                case 2: {
                    return "commandLine";
                }
                case 3: {
                    return "login";
                }
                case 4: {
                    return "v1Compatible";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public JobKey jobKey() {
            return this.jobKey;
        }

        public Function2<Map<String, Value>, ReturnCode, OrderOutcome.Completed> toOutcome() {
            return this.toOutcome;
        }

        public CommandLine commandLine() {
            return this.commandLine;
        }

        public Option<KeyLogin> login() {
            return this.login;
        }

        public boolean v1Compatible() {
            return this.v1Compatible;
        }

        public Conf copy(JobKey jobKey, Function2<Map<String, Value>, ReturnCode, OrderOutcome.Completed> toOutcome, CommandLine commandLine, Option<KeyLogin> login, boolean v1Compatible) {
            return new Conf(jobKey, toOutcome, commandLine, login, v1Compatible);
        }

        public JobKey copy$default$1() {
            return this.jobKey();
        }

        public Function2<Map<String, Value>, ReturnCode, OrderOutcome.Completed> copy$default$2() {
            return this.toOutcome();
        }

        public CommandLine copy$default$3() {
            return this.commandLine();
        }

        public Option<KeyLogin> copy$default$4() {
            return this.login();
        }

        public boolean copy$default$5() {
            return this.v1Compatible();
        }

        public JobKey _1() {
            return this.jobKey();
        }

        public Function2<Map<String, Value>, ReturnCode, OrderOutcome.Completed> _2() {
            return this.toOutcome();
        }

        public CommandLine _3() {
            return this.commandLine();
        }

        public Option<KeyLogin> _4() {
            return this.login();
        }

        public boolean _5() {
            return this.v1Compatible();
        }
    }

    public class Run {
        private final Map<String, Option<String>> env;
        private final StdObservers stdObservers;
        private final ShellReturnValuesProvider returnValuesProvider;
        private final /* synthetic */ ProcessDriver $outer;

        public Run(ProcessDriver $outer, Map<String, Option<String>> env, StdObservers stdObservers, ShellReturnValuesProvider returnValuesProvider) {
            this.env = env;
            this.stdObservers = stdObservers;
            this.returnValuesProvider = returnValuesProvider;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public IO<OrderOutcome.Completed> runProcess() {
            return this.startProcess().flatMap((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Problem problem = (Problem)((Left)either).value();
                    return IO$.MODULE$.pure((Object)OrderOutcome$Failed$.MODULE$.fromProblem(problem, OrderOutcome$Failed$.MODULE$.fromProblem$default$2()));
                }
                if (either instanceof Right) {
                    PipedProcess process = (PipedProcess)((Right)either).value();
                    return ((IO)this.$outer.js7$launcher$process$ProcessDriver$$jobLauncherConf.crashPidFile().register(process.pid()).surround((Object)CatsEffectExtensions$.MODULE$.startAndForget(process.awaitProcessTermination().guarantee(this.$outer.js7$launcher$process$ProcessDriver$$jobLauncherConf.crashPidFile().remove(process.pid()))).flatMap((Function1 & Serializable)_$1 -> IO$.MODULE$.defer(() -> this.runProcess$$anonfun$2$$anonfun$1$$anonfun$1(process))).flatMap((Function1 & Serializable)_$3 -> process.watchProcessAndStdouterr().attempt().flatMap((Function1 & Serializable)either -> IO$.MODULE$.defer(() -> this.runProcess$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(either, process))).flatMap((Function1 & Serializable)returnCode -> this.fetchReturnValues((ReturnCode)returnCode))), (MonadCancel)IO$.MODULE$.asyncForIO())).guarantee(process.release());
                }
                throw new MatchError((Object)either);
            });
        }

        private IO<Either<Problem, PipedProcess>> startProcess() {
            return IO$.MODULE$.defer(this::startProcess$$anonfun$1);
        }

        private IO<OrderOutcome.Completed> fetchReturnValues(ReturnCode returnCode) {
            if (this.$outer.js7$launcher$process$ProcessDriver$$killed) {
                return IO$.MODULE$.pure(this.$outer.js7$launcher$process$ProcessDriver$$conf.toOutcome().apply(package$NamedValues$.MODULE$.empty(), (Object)returnCode));
            }
            IO<Either<Problem, Map<String, Value>>> iO = CatsEffectExtensions$.MODULE$.catchAsChecked(this.returnValuesProvider.read());
            return CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)this::fetchReturnValues$$anonfun$1), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO)).map((Function1 & Serializable)x$1 -> {
                Either either = x$1;
                if (either instanceof Left) {
                    Problem problem = (Problem)((Left)either).value();
                    return OrderOutcome$Failed$.MODULE$.fromProblem(problem.withPrefix("Reading return values file failed:"), (Map<String, Value>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{ProcessExecutable$.MODULE$.toNamedValue(returnCode)}))));
                }
                if (either instanceof Right) {
                    Map namedValues = (Map)((Right)either).value();
                    return (OrderOutcome.Completed)this.$outer.js7$launcher$process$ProcessDriver$$conf.toOutcome().apply((Object)namedValues, (Object)returnCode);
                }
                throw new MatchError((Object)either);
            });
        }

        public final /* synthetic */ ProcessDriver js7$launcher$process$ProcessDriver$Run$$$outer() {
            return this.$outer;
        }

        private final IO runProcess$$anonfun$2$$anonfun$1$$anonfun$1(PipedProcess process$2) {
            block0: {
                Logger LoggerImpl_this = ProcessDriver$.js7$launcher$process$ProcessDriver$$$logger;
                if (!LoggerImpl_this.underlying().isInfoEnabled()) break block0;
                LoggerImpl_this.underlying().info("{} \u2198 Process {} started \u00b7 {} \u00b7 {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.$outer.js7$launcher$process$ProcessDriver$$orderId, process$2.process(), this.$outer.js7$launcher$process$ProcessDriver$$conf.jobKey(), this.$outer.js7$launcher$process$ProcessDriver$$conf.commandLine()}), Object.class));
            }
            return (IO)package.traverse$.MODULE$.toTraverseOps(this.$outer.js7$launcher$process$ProcessDriver$$killedBeforeStart, UnorderedFoldable$.MODULE$.catsTraverseForOption()).traverse((Function1 & Serializable)_$2 -> this.$outer.js7$launcher$process$ProcessDriver$$sendProcessSignal(process$2, (ProcessSignal)_$2), (Applicative)IO$.MODULE$.asyncForIO());
        }

        private final IO runProcess$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(Either either$1, PipedProcess process$5) {
            block0: {
                Logger LoggerImpl_this = ProcessDriver$.js7$launcher$process$ProcessDriver$$$logger;
                if (!LoggerImpl_this.underlying().isInfoEnabled()) break block0;
                Object[] objectArray = new Object[3];
                objectArray[0] = this.$outer.js7$launcher$process$ProcessDriver$$orderId;
                Either either = Either$.MODULE$.MergeableEither(either$1);
                objectArray[1] = (Serializable)Either.MergeableEither$.MODULE$.merge$extension(either);
                objectArray[2] = ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(process$5.duration()));
                LoggerImpl_this.underlying().info("{} \u2199 Process completed with {} after {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray), Object.class));
            }
            return IO$.MODULE$.fromEither(either$1);
        }

        private final void startProcess$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(Option maybeWindowsLogon$1) {
            maybeWindowsLogon$1.foreach((Function1 & Serializable)o -> WindowsProcess$.MODULE$.makeFileAppendableForUser(this.returnValuesProvider.file(), o.userName()));
        }

        private final Either startProcess$$anonfun$1$$anonfun$1() {
            return ((Either)package.traverse$.MODULE$.toTraverseOps(this.$outer.js7$launcher$process$ProcessDriver$$conf.login(), UnorderedFoldable$.MODULE$.catsTraverseForOption()).traverse(ProcessDriver::js7$launcher$process$ProcessDriver$Run$$_$startProcess$$anonfun$1$$anonfun$1$$anonfun$1, (Applicative)Invariant$.MODULE$.catsMonadErrorForEither())).flatMap((Function1 & Serializable)maybeWindowsLogon -> Checked$.MODULE$.catchNonFatal((Function0 & Serializable)() -> {
                this.startProcess$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1((Option)maybeWindowsLogon);
                return BoxedUnit.UNIT;
            }).map((Function1 & Serializable)_$4 -> ProcessConfiguration$.MODULE$.apply((Option<Path>)Some$.MODULE$.apply((Object)this.$outer.js7$launcher$process$ProcessDriver$$jobLauncherConf.workingDirectory()), this.$outer.js7$launcher$process$ProcessDriver$$jobLauncherConf.systemEncoding(), this.$outer.js7$launcher$process$ProcessDriver$$jobLauncherConf.worryAboutStdoutAfterTermination(), (Map<String, Option<String>>)((Map)this.env.updated((Object)this.returnValuesProvider.varName(), (Object)Some$.MODULE$.apply((Object)this.returnValuesProvider.file().toString()))), (Option<WindowsLogon>)maybeWindowsLogon)));
        }

        private final String startProcess$$anonfun$1$$anonfun$2$$anonfun$2() {
            return this.$outer.js7$launcher$process$ProcessDriver$$orderId.toString();
        }

        private final Either startProcess$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$1(PipedProcess pipedProcess$1) {
            this.$outer.js7$launcher$process$ProcessDriver$$pipedProcessOnce.$colon$eq(pipedProcess$1);
            return Checked$.MODULE$.unit();
        }

        private final IO startProcess$$anonfun$1() {
            if (this.$outer.js7$launcher$process$ProcessDriver$$killedBeforeStart.isDefined()) {
                return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.pure("Processing killed before start"));
            }
            IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.apply(this::startProcess$$anonfun$1$$anonfun$1));
            return (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)processConfiguration -> {
                IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(ProcessDriver$.js7$launcher$process$ProcessDriver$$$GlobalStartProcessLock.lock((Function0<String>)((Function0 & Serializable)this::startProcess$$anonfun$1$$anonfun$2$$anonfun$2), PipedProcess$.MODULE$.start(this.$outer.js7$launcher$process$ProcessDriver$$conf.commandLine(), (ProcessConfiguration)processConfiguration, this.stdObservers, this.$outer.js7$launcher$process$ProcessDriver$$orderId, this.$outer.js7$launcher$process$ProcessDriver$$conf.jobKey())));
                return this.$outer.js7$launcher$process$ProcessDriver$$startProcessLock.lock((Function0<String>)((Function0 & Serializable)ProcessDriver::js7$launcher$process$ProcessDriver$Run$$_$startProcess$$anonfun$1$$anonfun$2$$anonfun$1), (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatTapT$extension(iO, (Function1 & Serializable)pipedProcess -> IO$.MODULE$.apply(() -> this.startProcess$$anonfun$1$$anonfun$2$$anonfun$3$$anonfun$1(pipedProcess)), IO$.MODULE$.asyncForIO()));
            }, IO$.MODULE$.asyncForIO());
        }

        private final String fetchReturnValues$$anonfun$1() {
            return "fetchReturnValues " + this.$outer.js7$launcher$process$ProcessDriver$$orderId;
        }
    }
}

