/*
 * Decompiled with CFR 0.152.
 */
package js7.subagent.job;

import cats.Applicative;
import cats.Foldable;
import cats.UnorderedFoldable$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.MonadCancel;
import cats.effect.package$;
import cats.effect.unsafe.IORuntime;
import cats.kernel.Monoid;
import cats.kernel.Semigroup$;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import js7.base.io.process.ProcessSignal;
import js7.base.io.process.ProcessSignal$SIGKILL$;
import js7.base.log.Logger$;
import js7.base.log.Logger$syntax$;
import js7.base.monixutils.AsyncMap;
import js7.base.monixutils.AsyncMap$;
import js7.base.problem.Problem;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.data.job.JobConf;
import js7.data.job.JobResource;
import js7.data.job.JobResourcePath;
import js7.data.order.Order;
import js7.data.order.OrderId;
import js7.data.order.OrderOutcome;
import js7.data.order.OrderOutcome$Disrupted$;
import js7.data.value.expression.Expression;
import js7.data.value.expression.scopes.FileValueState;
import js7.launcher.StdObservers;
import js7.launcher.internal.JobLauncher;
import js7.subagent.job.JobDriver$Params$;
import js7.subagent.job.JobDriverForOrder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Product;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.Enclosing$;

public final class JobDriver {
    private final Params params;
    private final IORuntime ioRuntime;
    private final Logger logger;
    private final AsyncMap<OrderId, JobDriverForOrder> orderToProcess;
    private volatile Deferred lastProcessTerminated;

    public JobDriver(Params params, IORuntime ioRuntime) {
        this.params = params;
        this.ioRuntime = ioRuntime;
        this.logger = Logger$.MODULE$.withPrefix("Job:" + params.jobConf().jobKey().simpleName(), ClassTag$.MODULE$.apply(JobDriver.class));
        this.orderToProcess = AsyncMap$.MODULE$.empty(Tag$.MODULE$.apply(OrderId.class, LightTypeTag$.MODULE$.parse(-414890029, "\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001", "\u0000\u0002\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0016js7.data.order.OrderId\u0001\u0001\u0004\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001", 30)), Tag$.MODULE$.apply(JobDriverForOrder.class, LightTypeTag$.MODULE$.parse(-2022688446, "\u0004\u0000\u0001\"js7.subagent.job.JobDriverForOrder\u0001\u0001", "\u0000\u0000\u0000", 30)));
        this.lastProcessTerminated = null;
        params.checkedJobLauncher().foreach((Function1)(JProcedure1 & Serializable)launcher -> launcher.precheckAndWarn().unsafeRunAndForget(ioRuntime));
        params.checkedJobLauncher().left().foreach((Function1)(JProcedure1 & Serializable)problem -> {
            Logger LoggerImpl_this = this.logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                LoggerImpl_this.underlying().error(problem.toString());
                return;
            }
        });
    }

    public String toString() {
        return "JobDriver(" + this.params.jobConf().jobKey() + " " + this.params.jobConf().workflowJob().executable() + ")";
    }

    public IO<BoxedUnit> stop(ProcessSignal signal) {
        return Logger$syntax$.MODULE$.debugIO(this.logger, "stop", () -> JobDriver.stop$$anonfun$1(signal), IO$.MODULE$.defer(() -> this.stop$$anonfun$2(signal)));
    }

    private IO<BoxedUnit> killAll(ProcessSignal signal) {
        return IO$.MODULE$.defer(() -> this.killAll$$anonfun$1(signal));
    }

    public IO<OrderOutcome> runOrderProcess(Order<Order.Processing> order, Map<String, Expression> executeArguments, StdObservers stdObservers) {
        JobDriverForOrder forOrder = new JobDriverForOrder(order.id(), this.params);
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.apply(this::runOrderProcess$$anonfun$1));
        return ((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatTapT$extension(iO, (Function1 & Serializable)_$3 -> this.orderToProcess.insert(order.id(), forOrder, Enclosing$.MODULE$.apply("js7.subagent.job.JobDriver#runOrderProcess")), IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)x$1 -> {
            JobLauncher jobLauncher;
            Either either = x$1;
            if (either instanceof Left) {
                Problem problem = (Problem)((Left)either).value();
                return IO$.MODULE$.pure((Object)OrderOutcome$Disrupted$.MODULE$.apply(problem));
            }
            if (either instanceof Right && (jobLauncher = (JobLauncher)((Right)either).value()) != null) {
                JobLauncher jobLauncher2 = jobLauncher;
                return forOrder.processOrder(order, executeArguments, stdObservers, jobLauncher2).guarantee(this.removeOrderEntry(forOrder));
            }
            throw new MatchError((Object)either);
        });
    }

    private IO<BoxedUnit> removeOrderEntry(JobDriverForOrder forOrder) {
        return this.orderToProcess.remove(forOrder.orderId(), Enclosing$.MODULE$.apply("js7.subagent.job.JobDriver#removeOrderEntry")).$times$greater(IO$.MODULE$.defer(this::removeOrderEntry$$anonfun$1));
    }

    public IO<BoxedUnit> killProcess(OrderId orderId, ProcessSignal signal) {
        return IO$.MODULE$.defer(() -> this.killProcess$$anonfun$1(orderId, signal));
    }

    private int orderProcessCount() {
        return this.orderToProcess.size();
    }

    private static final Object stop$$anonfun$1(ProcessSignal signal$1) {
        return signal$1;
    }

    private final IO $anonfun$1() {
        return IO$.MODULE$.sleep(this.params.jobConf().sigkillDelay()).$times$greater(this.killAll(ProcessSignal$SIGKILL$.MODULE$));
    }

    private final String stop$$anonfun$2$$anonfun$1$$anonfun$1() {
        return "'killing all " + this.params.jobConf().jobKey() + " processes'";
    }

    private final IO stop$$anonfun$2$$anonfun$1(ProcessSignal signal$3) {
        ProcessSignal processSignal = signal$3;
        ProcessSignal$SIGKILL$ processSignal$SIGKILL$ = ProcessSignal$SIGKILL$.MODULE$;
        IO iO = (IO)IO$.MODULE$.unlessA(!(processSignal != null ? !processSignal.equals(processSignal$SIGKILL$) : processSignal$SIGKILL$ != null), this::$anonfun$1).background().surround(this.lastProcessTerminated.get(), (MonadCancel)IO$.MODULE$.asyncForIO());
        return this.killAll(signal$3).$times$greater(CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)this::stop$$anonfun$2$$anonfun$1$$anonfun$1), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO)));
    }

    private static final IO stop$$anonfun$2$$anonfun$2$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private final IO stop$$anonfun$2(ProcessSignal signal$2) {
        this.lastProcessTerminated = package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
        return IO$.MODULE$.unlessA(this.orderToProcess.isEmpty(), () -> this.stop$$anonfun$2$$anonfun$1(signal$2)).flatMap((Function1 & Serializable)_$1 -> (IO)this.params.checkedJobLauncher().toOption().fold(JobDriver::stop$$anonfun$2$$anonfun$2$$anonfun$1, (Function1 & Serializable)jobLauncher -> Logger$syntax$.MODULE$.traceIO(this.logger, "Stop '" + jobLauncher + "'", Logger$syntax$.MODULE$.traceIO$default$3(this.logger), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(jobLauncher.stop(), Enclosing$.MODULE$.apply("js7.subagent.job.JobDriver#stop")).handleError((Function1)(JProcedure1 & Serializable)throwable -> {
            Logger LoggerImpl_this = this.logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable);
                Throwable throwable3 = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable);
                LoggerImpl_this.underlying().error("Stop '" + jobLauncher + "' failed: " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable2), ScalaUtils$syntax$RichThrowable$.MODULE$.nullIfNoStackTrace$extension(throwable3));
                return;
            }
        }))));
    }

    private final IO killAll$$anonfun$1(ProcessSignal signal$4) {
        Iterable drivers;
        block0: {
            Logger LoggerImpl_this;
            drivers = this.orderToProcess.toMap().values();
            if (!drivers.nonEmpty() || !(LoggerImpl_this = this.logger).underlying().isWarnEnabled()) break block0;
            LoggerImpl_this.underlying().warn("Terminating, sending {} to {} processes", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{signal$4, BoxesRunTime.boxToInteger((int)this.orderProcessCount())}), Object.class));
        }
        return ((IO)package.traverse$.MODULE$.toTraverseOps((Object)drivers.toVector(), UnorderedFoldable$.MODULE$.catsTraverseForVector()).traverse((Function1 & Serializable)driver -> driver.kill(signal$4), (Applicative)IO$.MODULE$.asyncForIO())).map((Function1)(JProcedure1 & Serializable)_$2 -> package.foldable$.MODULE$.toFoldableOps(_$2, (Foldable)UnorderedFoldable$.MODULE$.catsTraverseForVector()).combineAll((Monoid)Semigroup$.MODULE$.catsKernelInstancesForUnit())).handleError((Function1)(JProcedure1 & Serializable)t -> {
            Logger LoggerImpl_this = this.logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                LoggerImpl_this.underlying().error("killAll: " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable), t);
                return;
            }
        });
    }

    private final Either runOrderProcess$$anonfun$1() {
        return this.params.checkedJobLauncher();
    }

    private final IO removeOrderEntry$$anonfun$1$$anonfun$1() {
        return ((IO)this.lastProcessTerminated.complete((Object)BoxedUnit.UNIT)).void();
    }

    private final IO removeOrderEntry$$anonfun$1() {
        return IO$.MODULE$.whenA(this.orderToProcess.isEmpty() && this.lastProcessTerminated != null, this::removeOrderEntry$$anonfun$1$$anonfun$1);
    }

    private final void killProcess$$anonfun$1$$anonfun$1$$anonfun$1(OrderId orderId$3) {
        Logger LoggerImpl_this = this.logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("\u26a0\ufe0f killProcess {} => no process for Order", (Object)orderId$3);
            return;
        }
    }

    private final IO killProcess$$anonfun$1$$anonfun$1(OrderId orderId$2) {
        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.killProcess$$anonfun$1$$anonfun$1$$anonfun$1(orderId$2);
            return BoxedUnit.UNIT;
        });
    }

    private final IO killProcess$$anonfun$1(OrderId orderId$1, ProcessSignal signal$6) {
        return (IO)this.orderToProcess.get(orderId$1).fold(() -> this.killProcess$$anonfun$1$$anonfun$1(orderId$1), (Function1 & Serializable)_$4 -> _$4.killWithSigkillDelay(signal$6));
    }

    public static final class Params
    implements Product,
    Serializable {
        private final JobConf jobConf;
        private final Function1 pathToJobResource;
        private final Either checkedJobLauncher;
        private final FileValueState fileValueState;

        public static Params apply(JobConf jobConf, Function1<JobResourcePath, Either<Problem, JobResource>> function1, Either<Problem, JobLauncher> either, FileValueState fileValueState) {
            return JobDriver$Params$.MODULE$.apply(jobConf, function1, either, fileValueState);
        }

        public static Params fromProduct(Product product) {
            return JobDriver$Params$.MODULE$.fromProduct(product);
        }

        public static Params unapply(Params params) {
            return JobDriver$Params$.MODULE$.unapply(params);
        }

        public Params(JobConf jobConf, Function1<JobResourcePath, Either<Problem, JobResource>> pathToJobResource, Either<Problem, JobLauncher> checkedJobLauncher, FileValueState fileValueState) {
            this.jobConf = jobConf;
            this.pathToJobResource = pathToJobResource;
            this.checkedJobLauncher = checkedJobLauncher;
            this.fileValueState = fileValueState;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Params)) return false;
            Params params = (Params)object;
            JobConf jobConf = this.jobConf();
            JobConf jobConf2 = params.jobConf();
            if (jobConf == null) {
                if (jobConf2 != null) {
                    return false;
                }
            } else if (!((Object)jobConf).equals(jobConf2)) return false;
            Function1<JobResourcePath, Either<Problem, JobResource>> function1 = this.pathToJobResource();
            Function1<JobResourcePath, Either<Problem, JobResource>> function12 = params.pathToJobResource();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            Either<Problem, JobLauncher> either = this.checkedJobLauncher();
            Either<Problem, JobLauncher> either2 = params.checkedJobLauncher();
            if (either == null) {
                if (either2 != null) {
                    return false;
                }
            } else if (!either.equals(either2)) return false;
            FileValueState fileValueState = this.fileValueState();
            FileValueState fileValueState2 = params.fileValueState();
            if (fileValueState == null) {
                if (fileValueState2 == null) return true;
                return false;
            } else {
                if (!fileValueState.equals(fileValueState2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Params;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "Params";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "jobConf";
                }
                case 1: {
                    return "pathToJobResource";
                }
                case 2: {
                    return "checkedJobLauncher";
                }
                case 3: {
                    return "fileValueState";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public JobConf jobConf() {
            return this.jobConf;
        }

        public Function1<JobResourcePath, Either<Problem, JobResource>> pathToJobResource() {
            return this.pathToJobResource;
        }

        public Either<Problem, JobLauncher> checkedJobLauncher() {
            return this.checkedJobLauncher;
        }

        public FileValueState fileValueState() {
            return this.fileValueState;
        }

        public Params copy(JobConf jobConf, Function1<JobResourcePath, Either<Problem, JobResource>> pathToJobResource, Either<Problem, JobLauncher> checkedJobLauncher, FileValueState fileValueState) {
            return new Params(jobConf, pathToJobResource, checkedJobLauncher, fileValueState);
        }

        public JobConf copy$default$1() {
            return this.jobConf();
        }

        public Function1<JobResourcePath, Either<Problem, JobResource>> copy$default$2() {
            return this.pathToJobResource();
        }

        public Either<Problem, JobLauncher> copy$default$3() {
            return this.checkedJobLauncher();
        }

        public FileValueState copy$default$4() {
            return this.fileValueState();
        }

        public JobConf _1() {
            return this.jobConf();
        }

        public Function1<JobResourcePath, Either<Problem, JobResource>> _2() {
            return this.pathToJobResource();
        }

        public Either<Problem, JobLauncher> _3() {
            return this.checkedJobLauncher();
        }

        public FileValueState _4() {
            return this.fileValueState();
        }
    }
}

