/*
 * Decompiled with CFR 0.152.
 */
package com.sos.cli;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.sos.commons.exception.SOSException;
import com.sos.commons.httpclient.SOSRestApiClient;
import com.sos.commons.httpclient.exception.SOSConnectionRefusedException;
import com.sos.commons.sign.keys.certificate.CertificateUtils;
import com.sos.commons.sign.keys.key.KeyUtil;
import com.sos.commons.sign.keys.keyStore.KeyStoreCredentials;
import com.sos.commons.sign.keys.keyStore.KeyStoreUtil;
import com.sos.commons.sign.keys.keyStore.KeystoreType;
import com.sos.commons.util.SOSString;
import com.sos.joc.model.publish.CreateCSRFilter;
import com.sos.joc.model.publish.RolloutResponse;
import com.sos.joc.model.publish.rollout.items.JocConf;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.naming.InvalidNameException;

public class ExecuteRollOut {
    public static final String PRIVATE_CONF_JS7_PARAM_CONFDIR = "js7.config-directory";
    private static final String DEFAULT_DN_WITHOUT_CN = ", OU=default, O=default, C=DE, L=Berlin, ST=Berlin";
    private static final String WS_API = "/joc/api/authentication/certificate/create";
    private static final String HELP = "--help";
    private static final String DN_ONLY = "--dn-only";
    private static final String TOKEN = "--token";
    private static final String JOC_URI = "--joc-uri";
    private static final String SAN = "--san";
    private static final String SRC_KEYSTORE = "--source-keystore";
    private static final String SRC_KEYSTORE_TYPE = "--source-keystore-type";
    private static final String SRC_KEYSTORE_PASS = "--source-keystore-pass";
    private static final String SRC_KEYSTORE_ENTRY_PASS = "--source-keystore-entry-pass";
    private static final String SRC_KEYSTORE_ENTRY_ALIAS = "--source-keystore-entry-alias";
    private static final String SRC_TRUSTSTORE = "--source-truststore";
    private static final String SRC_TRUSTSTORE_TYPE = "--source-truststore-type";
    private static final String SRC_TRUSTSTORE_PASS = "--source-truststore-pass";
    private static final String TRG_KEYSTORE = "--target-keystore";
    private static final String TRG_KEYSTORE_TYPE = "--target-keystore-type";
    private static final String TRG_KEYSTORE_PASS = "--target-keystore-pass";
    private static final String TRG_KEYSTORE_ENTRY_PASS = "--target-keystore-entry-pass";
    private static final String TRG_TRUSTSTORE = "--target-truststore";
    private static final String TRG_TRUSTSTORE_TYPE = "--target-truststore-type";
    private static final String TRG_TRUSTSTORE_PASS = "--target-truststore-pass";
    private static final String SUBJECT_DN = "--subject-dn";
    private static final String KS_ALIAS = "--key-alias";
    private static final String TS_ALIAS = "--ca-alias";
    private static final String SRC_PRIVATE_KEY = "--source-private-key";
    private static final String SRC_CERT = "--source-certificate";
    private static final String SRC_CA_CERT = "--source-ca-cert";
    private static final String PRIVATE_FOLDER_NAME = "private";
    private static final String PRIVATE_CONF_FILENAME = "private.conf";
    private static final String PRIVATE_CONF_JS7_PARAM_WEB = "js7.web";
    private static final String PRIVATE_CONF_JS7_PARAM_JOCURL = "js7.web.joc.url";
    private static final String PRIVATE_CONF_JS7_PARAM_API_SERVER = "js7.api-server";
    private static final String PRIVATE_CONF_JS7_PARAM_KEYSTORE_FILEPATH = "js7.web.https.keystore.file";
    private static final String PRIVATE_CONF_JS7_PARAM_KEYSTORE_KEYPWD = "js7.web.https.keystore.key-password";
    private static final String PRIVATE_CONF_JS7_PARAM_KEYSTORE_STOREPWD = "js7.web.https.keystore.store-password";
    private static final String PRIVATE_CONF_JS7_PARAM_KEYSTORE_ALIAS = "js7.web.https.keystore.alias";
    private static final String PRIVATE_CONF_JS7_PARAM_TRUSTORES_ARRAY = "js7.web.https.truststores";
    private static final String PRIVATE_CONF_JS7_PARAM_TRUSTSTORES_SUB_FILEPATH = "file";
    private static final String PRIVATE_CONF_JS7_PARAM_TRUSTORES_SUB_STOREPWD = "store-password";
    private static final String PRIVATE_CONF_JS7_PARAM_DN = "js7.auth.users.controller.distinguished-names";
    private static final String PRIVATE_CONF_JS7_PARAM_USERS = "js7.auth.users";
    private static final String PRIVATE_CONF_JS7_PARAM_DISTINGUISHED_NAMES = "distinguished-names";
    private static final String DEFAULT_KEYSTORE_FILENAME = "https-keystore.p12";
    private static final String DEFAULT_TRUSTSTORE_FILENAME = "https-truststore.p12";
    private static final String DEFAULT_KEYSTORE_PATH = "${js7.config-directory}\"/private/https-keystore.p12\"";
    private static final String DEFAULT_KEYSTORE_PATH_UNQUOTED = "${js7.config-directory}/private/https-keystore.p12";
    private static final String DEFAULT_TRUSTSTORE_PATH = "${js7.config-directory}\"/private/https-truststore.p12\"";
    private static final String DEFAULT_TRUSTSTORE_PATH_UNQUOTED = "${js7.config-directory}/private/https-truststore.p12";
    private static final String DEFAULT_STORE_PWD = "jobscheduler";
    private static final ConfigParseOptions PARSE_OPTIONS = ConfigParseOptions.defaults().setSyntax(ConfigSyntax.CONF);
    private static final ConfigRenderOptions RENDER_OPTIONS = ConfigRenderOptions.concise().setComments(true).setOriginComments(false).setFormatted(true).setJson(false);
    private static final ConfigResolveOptions RESOLVE_OPTIONS = ConfigResolveOptions.noSystem().setUseSystemEnvironment(false).setAllowUnresolved(true);
    private static SOSRestApiClient client;
    private static String token;
    private static String subjectDN;
    private static String san;
    private static URI jocUri;
    private static List<URI> jocUris;
    private static String srcKeystore;
    private static String srcKeystoreType;
    private static String srcKeystorePasswd;
    private static String srcKeystoreEntryPasswd;
    private static String srcKeystoreEntryAlias;
    private static String srcTruststore;
    private static String srcTruststoreType;
    private static String srcTruststorePasswd;
    private static String targetKeystore;
    private static String targetKeystoreType;
    private static String targetKeystorePasswd;
    private static String targetKeystoreEntryPasswd;
    private static String targetTruststore;
    private static String targetTruststoreType;
    private static String targetTruststorePasswd;
    private static String keyAlias;
    private static String caAlias;
    private static String srcPrivateKeyPath;
    private static String srcCertPath;
    private static String srcCaCertPath;
    private static String confDir;
    private static Config resolved;
    private static Config toUpdate;
    private static boolean dnOnly;
    private static ObjectMapper mapper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args != null && args.length > 0 && args[0].equalsIgnoreCase("cert")) {
            args = (String[])Arrays.stream(args).skip(1L).toArray(String[]::new);
        }
        if (args == null || args.length == 0 || args.length == 1 && args[0].equalsIgnoreCase(HELP)) {
            ExecuteRollOut.printUsage();
        } else {
            for (int i = 0; i < args.length; ++i) {
                String[] split = args[i].split("=", 2);
                if (args[i].startsWith("--token=")) {
                    token = split[1];
                    continue;
                }
                if (args[i].startsWith("--joc-uri=")) {
                    jocUri = URI.create(split[1]);
                    continue;
                }
                if (args[i].startsWith("--source-keystore=")) {
                    srcKeystore = split[1];
                    continue;
                }
                if (args[i].startsWith("--source-keystore-type=")) {
                    srcKeystoreType = split[1];
                    continue;
                }
                if (args[i].startsWith("--source-keystore-pass=")) {
                    srcKeystorePasswd = split[1];
                    continue;
                }
                if (args[i].startsWith("--source-keystore-entry-pass=")) {
                    srcKeystoreEntryPasswd = split[1];
                    continue;
                }
                if (args[i].startsWith("--source-keystore-entry-alias=")) {
                    srcKeystoreEntryAlias = split[1];
                    continue;
                }
                if (args[i].startsWith("--source-truststore=")) {
                    srcTruststore = split[1];
                    continue;
                }
                if (args[i].startsWith("--source-truststore-type=")) {
                    srcTruststoreType = split[1];
                    continue;
                }
                if (args[i].startsWith("--source-truststore-pass=")) {
                    srcTruststorePasswd = split[1];
                    continue;
                }
                if (args[i].startsWith("--target-keystore=")) {
                    targetKeystore = split[1];
                    continue;
                }
                if (args[i].startsWith("--target-keystore-type=")) {
                    targetKeystoreType = split[1];
                    continue;
                }
                if (args[i].startsWith("--target-keystore-pass=")) {
                    targetKeystorePasswd = split[1];
                    continue;
                }
                if (args[i].startsWith("--target-keystore-entry-pass=")) {
                    targetKeystoreEntryPasswd = split[1];
                    continue;
                }
                if (args[i].startsWith("--target-truststore=")) {
                    targetTruststore = split[1];
                    continue;
                }
                if (args[i].startsWith("--target-truststore-type=")) {
                    targetTruststoreType = split[1];
                    continue;
                }
                if (args[i].startsWith("--target-truststore-pass=")) {
                    targetTruststorePasswd = split[1];
                    continue;
                }
                if (args[i].startsWith("--subject-dn=")) {
                    subjectDN = split[1];
                    continue;
                }
                if (args[i].startsWith("--san=")) {
                    san = split[1];
                    continue;
                }
                if (args[i].startsWith("--key-alias=")) {
                    keyAlias = split[1];
                    continue;
                }
                if (args[i].startsWith("--ca-alias=")) {
                    caAlias = split[1];
                    continue;
                }
                if (args[i].startsWith("--source-private-key=")) {
                    srcPrivateKeyPath = split[1];
                    continue;
                }
                if (args[i].startsWith("--source-certificate=")) {
                    srcCertPath = split[1];
                    continue;
                }
                if (args[i].startsWith("--source-ca-cert=")) {
                    srcCaCertPath = split[1];
                    continue;
                }
                if (!args[i].startsWith(DN_ONLY)) continue;
                dnOnly = true;
            }
            String hostname = InetAddress.getLocalHost().getCanonicalHostName();
            if (subjectDN == null || subjectDN.isEmpty()) {
                Object container = "";
                container = hostname.contains(".") ? "CN=" + hostname.substring(0, hostname.indexOf(".")) : "CN=" + hostname;
                String organizationUnit = "OU=Default";
                String organization = "O=Default";
                String location = "L=Default";
                String state = "ST=Default";
                String country = "C=" + System.getProperty("user.country");
                subjectDN = Arrays.asList(hostname, organizationUnit, organization, location, state, country).stream().collect(Collectors.joining(", "));
            }
            if (san == null || san.isEmpty()) {
                san = hostname.contains(".") ? hostname + ", " + hostname.substring(0, hostname.indexOf(".")) : hostname;
            }
            ExecuteRollOut.readConfig();
            try {
                ExecuteRollOut.createClient();
                String response = ExecuteRollOut.callWebService();
                if (client.getHttpResponse() == null) {
                    throw new Exception("no connection to any api-server url could be established, latest error: " + response);
                }
                if (client.statusCode() != 200) {
                    String message = "";
                    try {
                        message = ExecuteRollOut.parseErrorResponse(response);
                    }
                    catch (Exception e) {
                        throw new Exception("API return code was " + client.statusCode());
                    }
                    throw new Exception(message);
                }
                RolloutResponse rollout = (RolloutResponse)mapper.readValue(response, RolloutResponse.class);
                if (!dnOnly) {
                    ExecuteRollOut.addKeyAndCertToStore(rollout);
                }
                if (confDir != null) {
                    ExecuteRollOut.updatePrivateConf(toUpdate, rollout);
                } else {
                    System.out.println("no entries stored to private.conf file. Environment variable <js7.config-directory> not properly set!");
                }
            }
            catch (Throwable e) {
                System.out.println(e.toString());
            }
            finally {
                ExecuteRollOut.closeClient();
            }
        }
    }

    private static KeyStore createKeyStore(boolean isKeystore) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keystore = null;
        Path path = null;
        String passwd = null;
        if (isKeystore) {
            path = targetKeystore != null && !targetKeystore.isEmpty() ? Paths.get(targetKeystore, new String[0]) : Paths.get(confDir, new String[0]).resolve(PRIVATE_FOLDER_NAME).resolve(DEFAULT_KEYSTORE_FILENAME);
            passwd = targetKeystorePasswd != null ? targetKeystorePasswd : DEFAULT_STORE_PWD;
        } else {
            path = targetTruststore != null && !targetTruststore.isEmpty() ? Paths.get(targetTruststore, new String[0]) : Paths.get(confDir, new String[0]).resolve(PRIVATE_FOLDER_NAME).resolve(DEFAULT_TRUSTSTORE_FILENAME);
            passwd = targetTruststorePasswd != null ? targetTruststorePasswd : DEFAULT_STORE_PWD;
        }
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        keystore = KeyStore.getInstance(KeystoreType.PKCS12.value().toLowerCase());
        if (!Files.exists(path, new LinkOption[0])) {
            try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                keystore.load(null, passwd.toCharArray());
                keystore.store(os, passwd.toCharArray());
            }
        }
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            keystore.load(Files.newInputStream(path, new OpenOption[0]), passwd.toCharArray());
        }
        return keystore;
    }

    private static String parseErrorResponse(String response) throws IOException {
        try {
            Pattern pattern = Pattern.compile("^.*code\\\":\\\"(.*)\\\",\\\"message\\\":\\\"([.[^\\\"]]*).*$");
            String code = "";
            String message = "";
            StringReader reader = new StringReader(response);
            BufferedReader buff = new BufferedReader(reader);
            String line = null;
            while ((line = buff.readLine()) != null) {
                Matcher matcher;
                if (line.trim().length() == 0 || !(matcher = pattern.matcher(line)).matches()) continue;
                code = matcher.group(1);
                message = matcher.group(2);
            }
            return code + " : " + message;
        }
        catch (Exception e) {
            return response;
        }
    }

    private static void updatePrivateConf(Config config, RolloutResponse response) throws Exception {
        Object dnPath = PRIVATE_CONF_JS7_PARAM_DN;
        if (response.getControllerId() != null) {
            dnPath = "js7.auth.users." + response.getControllerId() + ".distinguished-names";
        }
        config = config.hasPath((String)dnPath) ? ExecuteRollOut.addToExistingList(config, (String)dnPath, response.getDNs()) : ExecuteRollOut.addToNewList(config, (String)dnPath, response.getDNs());
        if (response.getJocConfs() != null) {
            for (JocConf joc : response.getJocConfs()) {
                if (response.getAgentId() == null) {
                    dnPath = "js7.auth.users." + joc.getJocId().toUpperCase() + ".distinguished-names";
                    if (config.hasPath((String)dnPath)) {
                        config = ExecuteRollOut.addToExistingList(config, (String)dnPath, joc.getDN());
                        continue;
                    }
                    config = ExecuteRollOut.addToNewList(config, (String)dnPath, joc.getDN());
                    continue;
                }
                String webPath = "js7.web." + joc.getJocId() + ".url";
                if (config.hasPath(webPath)) {
                    try {
                        config = ExecuteRollOut.addToExistingList(config, webPath, joc.getUrl());
                    }
                    catch (Exception e) {
                        if (config.getString(webPath).equals(joc.getUrl())) continue;
                        ArrayList<String> newValues = new ArrayList<String>();
                        newValues.add(config.getString(webPath));
                        newValues.add(joc.getUrl());
                        config = ExecuteRollOut.addToNewList(config, webPath, newValues);
                    }
                    continue;
                }
                config = ExecuteRollOut.addToNewList(config, webPath, joc.getUrl());
            }
        }
        ExecuteRollOut.saveConfigToFile(config);
    }

    private static Config addToExistingList(Config config, String configPath, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        return ExecuteRollOut.addToExistingList(config, configPath, values);
    }

    private static Config addToExistingList(Config config, String configPath, List<String> newValues) {
        List values = config.getStringList(configPath);
        for (String value : newValues) {
            if (values.contains(value)) continue;
            values.add(value);
        }
        ConfigValue configValue = ConfigValueFactory.fromAnyRef((Object)values);
        return config.withValue(configPath, configValue);
    }

    private static Config addToNewList(Config config, String configPath, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        return ExecuteRollOut.addToNewList(config, configPath, values);
    }

    private static Config addToNewList(Config config, String configPath, List<String> values) {
        ArrayList<String> newValues = new ArrayList<String>();
        newValues.addAll(values);
        ConfigList configValue = ConfigValueFactory.fromIterable(newValues);
        return config.withValue(configPath, (ConfigValue)configValue);
    }

    private static void saveConfigToFile(Config config) throws IOException {
        String configAsHoconString = config.root().render(RENDER_OPTIONS);
        configAsHoconString = configAsHoconString.replaceAll("\"(" + Pattern.quote(confDir) + "|" + Pattern.quote("${js7.config-directory}") + ")", "\\${js7.config-directory}\"");
        Files.write(Paths.get(confDir, new String[0]).resolve(PRIVATE_FOLDER_NAME).resolve(PRIVATE_CONF_FILENAME), configAsHoconString.getBytes(), new OpenOption[0]);
    }

    private static void readConfig() {
        confDir = System.getProperty(PRIVATE_CONF_JS7_PARAM_CONFDIR);
        Properties props = new Properties();
        if (confDir != null && !confDir.isEmpty()) {
            props.put(PRIVATE_CONF_JS7_PARAM_CONFDIR, confDir);
            toUpdate = ConfigFactory.parseFile((File)Paths.get(confDir, new String[0]).resolve(PRIVATE_FOLDER_NAME).resolve(PRIVATE_CONF_FILENAME).toFile(), (ConfigParseOptions)PARSE_OPTIONS).resolve(RESOLVE_OPTIONS);
            Config defaultConfigWithConfDir = ConfigFactory.parseProperties((Properties)props, (ConfigParseOptions)PARSE_OPTIONS).resolve();
            resolved = ConfigFactory.parseFile((File)Paths.get(confDir, new String[0]).resolve(PRIVATE_FOLDER_NAME).resolve(PRIVATE_CONF_FILENAME).toFile(), (ConfigParseOptions)PARSE_OPTIONS).withFallback((ConfigMergeable)defaultConfigWithConfDir).resolve();
        }
    }

    private static void setKeystoreCredentials() throws Exception {
        KeyStore keyStore = null;
        Object trustStore = null;
        String alias = "";
        if (targetKeystore != null && !targetKeystore.isEmpty()) {
            keyStore = KeyStoreUtil.readKeyStore((String)targetKeystore, (KeystoreType)KeystoreType.fromValue((String)targetKeystoreType), (String)targetKeystorePasswd);
            alias = keyAlias;
        } else if (resolved != null) {
            KeyStoreCredentials credentials = ExecuteRollOut.readKeystoreCredentials(resolved);
            keyStore = KeyStoreUtil.readKeyStore((String)credentials.getPath(), (KeystoreType)KeystoreType.PKCS12, (String)credentials.getStorePwd());
        } else {
            keyStore = KeyStoreUtil.readKeyStore((String)"", (KeystoreType)KeystoreType.PKCS12, null);
        }
    }

    private static void addKeyAndCertToStore(RolloutResponse rolloutResponse) throws Exception {
        KeyStore targetKeyStore = null;
        KeyStore targetTrustStore = null;
        Boolean keyStoreAlreadyExists = false;
        Boolean trustStoreAlreadyExists = false;
        try {
            X509Certificate certificate = KeyUtil.getX509Certificate((String)rolloutResponse.getJocKeyPair().getCertificate());
            PrivateKey privKey = KeyUtil.getPrivateECDSAKeyFromString((String)rolloutResponse.getJocKeyPair().getPrivateKey());
            X509Certificate rootCaCertificate = KeyUtil.getX509Certificate((String)rolloutResponse.getCaCert());
            Certificate[] chain = new Certificate[]{certificate, rootCaCertificate};
            if (targetKeystore != null && !targetKeystore.isEmpty()) {
                Path targetKeystorePath = Paths.get(targetKeystore, new String[0]);
                keyStoreAlreadyExists = Files.exists(targetKeystorePath, new LinkOption[0]);
                if (!keyStoreAlreadyExists.booleanValue()) {
                    targetKeyStore = ExecuteRollOut.createKeyStore(true);
                }
                if ((targetKeyStore = KeyStoreUtil.readKeyStore((String)targetKeystore, (KeystoreType)KeystoreType.fromValue((String)targetKeystoreType), (String)targetKeystorePasswd)) != null) {
                    if (keyAlias != null && !keyAlias.isEmpty()) {
                        targetKeyStore.setKeyEntry(keyAlias, privKey, targetKeystoreEntryPasswd.toCharArray(), chain);
                        targetKeyStore.store(new FileOutputStream(new File(targetKeystore)), targetKeystorePasswd.toCharArray());
                    } else {
                        System.err.println(String.format("no alias provided for the certificate and its private key. Parameter <%1$s> is required.", KS_ALIAS));
                    }
                }
            } else if (resolved != null) {
                KeyStoreCredentials credentials = ExecuteRollOut.readKeystoreCredentials(resolved);
                targetKeyStore = KeyStoreUtil.readKeyStore((String)credentials.getPath(), (KeystoreType)KeystoreType.PKCS12, (String)credentials.getStorePwd());
                if (targetKeyStore != null) {
                    String defaultAlias = CertificateUtils.extractDistinguishedNameQualifier((X509Certificate)certificate);
                    if (defaultAlias != null) {
                        targetKeyStore.setKeyEntry(defaultAlias, privKey, resolved.getString(PRIVATE_CONF_JS7_PARAM_KEYSTORE_KEYPWD).toCharArray(), chain);
                        targetKeyStore.store(new FileOutputStream(new File(credentials.getPath())), credentials.getStorePwd().toCharArray());
                    } else {
                        System.err.println(String.format("no alias provided for the certificate and its private key. Parameter <%1$s> is required.", KS_ALIAS));
                    }
                }
            } else {
                System.err.println(String.format("no keystore found. Parameter <%1$s> is required.", TRG_KEYSTORE));
            }
            if (targetTruststore != null && !targetTruststore.isEmpty()) {
                trustStoreAlreadyExists = Files.exists(Paths.get(targetTruststore, new String[0]), new LinkOption[0]);
                if (!trustStoreAlreadyExists.booleanValue()) {
                    targetTrustStore = ExecuteRollOut.createKeyStore(false);
                }
                if ((targetTrustStore = KeyStoreUtil.readTrustStore((String)targetTruststore, (KeystoreType)KeystoreType.fromValue((String)targetTruststoreType), (String)targetTruststorePasswd)) != null) {
                    if (caAlias != null && !caAlias.isEmpty()) {
                        targetTrustStore.setCertificateEntry(caAlias, rootCaCertificate);
                        targetTrustStore.store(new FileOutputStream(new File(targetTruststore)), targetTruststorePasswd.toCharArray());
                    } else {
                        System.err.println(String.format("no alias provided for the CA certificate. Parameter <%1$s> is required.", TS_ALIAS));
                    }
                }
            } else if (resolved != null) {
                KeyStoreCredentials credentials;
                List<KeyStoreCredentials> truststoresCredentials = ExecuteRollOut.readTruststoreCredentials(resolved);
                Optional<KeyStoreCredentials> defaultTruststoreCredentials = truststoresCredentials.stream().filter(item -> item.getPath().endsWith(DEFAULT_TRUSTSTORE_FILENAME)).filter(Objects::nonNull).findFirst();
                if (defaultTruststoreCredentials.isPresent() && (targetTrustStore = KeyStoreUtil.readTrustStore((String)(credentials = defaultTruststoreCredentials.get()).getPath(), (KeystoreType)KeystoreType.PKCS12, (String)credentials.getStorePwd())) != null) {
                    String defaultAlias = CertificateUtils.extractDistinguishedNameQualifier((X509Certificate)rootCaCertificate);
                    if (defaultAlias == null) {
                        defaultAlias = CertificateUtils.extractFirstCommonName((X509Certificate)rootCaCertificate);
                    }
                    if (defaultAlias != null) {
                        targetTrustStore.setCertificateEntry(defaultAlias, rootCaCertificate);
                        targetTrustStore.store(new FileOutputStream(new File(credentials.getPath())), credentials.getStorePwd().toCharArray());
                    } else {
                        System.err.println(String.format("no alias provided for the certificate and its private key. Parameter <%1$s> is required.", KS_ALIAS));
                    }
                }
            } else {
                System.err.println(String.format("no truststore found. Parameter <%1$s> is required.", TRG_TRUSTSTORE));
            }
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException | InvalidKeySpecException e) {
            System.out.println(e.toString());
        }
        if (targetKeyStore != null) {
            ConfigValue keystorePathValue = null;
            keystorePathValue = keyStoreAlreadyExists == false ? ConfigValueFactory.fromAnyRef((Object)DEFAULT_KEYSTORE_PATH_UNQUOTED) : ConfigValueFactory.fromAnyRef((Object)targetKeystore);
            toUpdate = toUpdate.withValue(PRIVATE_CONF_JS7_PARAM_KEYSTORE_FILEPATH, keystorePathValue);
            ConfigValue keystorePasswdValue = ConfigValueFactory.fromAnyRef((Object)targetKeystorePasswd);
            toUpdate = toUpdate.withValue(PRIVATE_CONF_JS7_PARAM_KEYSTORE_STOREPWD, keystorePasswdValue);
            ConfigValue keystoreEntryPasswdValue = ConfigValueFactory.fromAnyRef((Object)targetKeystoreEntryPasswd);
            toUpdate = toUpdate.withValue(PRIVATE_CONF_JS7_PARAM_KEYSTORE_KEYPWD, keystoreEntryPasswdValue);
            ConfigValue keystoreAliasValue = ConfigValueFactory.fromAnyRef((Object)keyAlias);
            toUpdate = toUpdate.withValue(PRIVATE_CONF_JS7_PARAM_KEYSTORE_ALIAS, keystoreAliasValue);
        }
        if (targetTrustStore != null) {
            ArrayList<ConfigObject> truststores = new ArrayList<ConfigObject>();
            HashMap<String, String> values = new HashMap<String, String>();
            if (!trustStoreAlreadyExists.booleanValue()) {
                values.put(PRIVATE_CONF_JS7_PARAM_TRUSTSTORES_SUB_FILEPATH, DEFAULT_TRUSTSTORE_PATH_UNQUOTED);
            } else {
                values.put(PRIVATE_CONF_JS7_PARAM_TRUSTSTORES_SUB_FILEPATH, targetTruststore);
            }
            values.put(PRIVATE_CONF_JS7_PARAM_TRUSTORES_SUB_STOREPWD, targetTruststorePasswd);
            ConfigObject truststoreObject = ConfigValueFactory.fromMap(values);
            truststores.add(truststoreObject);
            ConfigList truststoreList = ConfigValueFactory.fromIterable(truststores);
            ConfigList truststorePathsValue = ConfigValueFactory.fromIterable((Iterable)truststoreList);
            toUpdate = toUpdate.withValue(PRIVATE_CONF_JS7_PARAM_TRUSTORES_ARRAY, (ConfigValue)truststorePathsValue);
        }
    }

    private static KeyStoreCredentials readKeystoreCredentials(Config config) {
        String keystorePath = "";
        String keyPasswd = "";
        String storePasswd = "";
        String alias = "";
        try {
            keystorePath = config.getString(PRIVATE_CONF_JS7_PARAM_KEYSTORE_FILEPATH);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            keyPasswd = config.getString(PRIVATE_CONF_JS7_PARAM_KEYSTORE_KEYPWD);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            storePasswd = config.getString(PRIVATE_CONF_JS7_PARAM_KEYSTORE_STOREPWD);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            alias = config.getString(PRIVATE_CONF_JS7_PARAM_KEYSTORE_ALIAS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new KeyStoreCredentials(keystorePath, storePasswd, keyPasswd, alias);
    }

    private static List<KeyStoreCredentials> readTruststoreCredentials(Config config) {
        List<Object> credentials = Collections.emptyList();
        try {
            credentials = config.getConfigList(PRIVATE_CONF_JS7_PARAM_TRUSTORES_ARRAY).stream().map(item -> new KeyStoreCredentials(item.getString(PRIVATE_CONF_JS7_PARAM_TRUSTSTORES_SUB_FILEPATH), item.getString(PRIVATE_CONF_JS7_PARAM_TRUSTORES_SUB_STOREPWD))).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return credentials;
    }

    private static void createClient() throws Exception {
        if (client != null) {
            return;
        }
        client = new SOSRestApiClient();
        if (resolved != null) {
            for (Map.Entry entry : resolved.entrySet()) {
                if (!((String)entry.getKey()).startsWith("js7")) continue;
                if (((String)entry.getKey()).contains("password")) {
                    System.out.println((String)entry.getKey() + ": ********");
                    continue;
                }
                System.out.println((String)entry.getKey() + ": " + ((ConfigValue)entry.getValue()).toString());
            }
            String jocUriFromConfig = "";
            try {
                jocUriFromConfig = resolved.getString(PRIVATE_CONF_JS7_PARAM_JOCURL);
                System.out.println("JOC Url (private.conf): " + jocUriFromConfig);
            }
            catch (Exception entry) {
                // empty catch block
            }
            if (!SOSString.isEmpty((String)jocUriFromConfig) && jocUri == null) {
                jocUri = URI.create(jocUriFromConfig);
            } else if (resolved.hasPath(PRIVATE_CONF_JS7_PARAM_API_SERVER)) {
                try {
                    String uri = resolved.getString("js7.api-server.url");
                    jocUri = URI.create(uri);
                }
                catch (Exception e) {
                    try {
                        List uris = resolved.getStringList("js7.api-server.url");
                        for (Object uri : uris) {
                            URI url = URI.create((String)uri);
                            jocUris.add(url);
                        }
                    }
                    catch (Exception e1) {
                        List objects = resolved.getConfigList(PRIVATE_CONF_JS7_PARAM_API_SERVER);
                        for (Config cfg : objects) {
                            if (!cfg.hasPath("url")) continue;
                            URI url = URI.create(cfg.getString("url"));
                            jocUris.add(url);
                        }
                    }
                }
            }
            if (jocUri == null && jocUris.isEmpty()) {
                throw new Exception("missing api-server url");
            }
            List<KeyStoreCredentials> truststoresCredentials = ExecuteRollOut.readTruststoreCredentials(resolved);
            Optional<Object> truststoreOptional = null;
            try {
                System.out.println("read Trustore from: " + ((Config)resolved.getConfigList(PRIVATE_CONF_JS7_PARAM_TRUSTORES_ARRAY).get(0)).getString(PRIVATE_CONF_JS7_PARAM_TRUSTSTORES_SUB_FILEPATH));
                truststoreOptional = truststoresCredentials.stream().filter(item -> item.getPath().endsWith(DEFAULT_TRUSTSTORE_FILENAME)).map(item -> {
                    try {
                        return KeyStoreUtil.readTrustStore((String)item.getPath(), (KeystoreType)KeystoreType.PKCS12, (String)item.getStorePwd());
                    }
                    catch (Exception e) {
                        return null;
                    }
                }).filter(Objects::nonNull).findAny();
            }
            catch (Exception e) {
                System.out.println("create new Truststore at default location.");
                truststoreOptional = Optional.empty();
            }
            KeyStore truststore = null;
            truststore = truststoreOptional.isPresent() ? (KeyStore)truststoreOptional.get() : ExecuteRollOut.createKeyStore(false);
            KeyStoreCredentials credentials = ExecuteRollOut.readKeystoreCredentials(resolved);
            KeyStore keystore = null;
            try {
                System.out.println("read Keystore from: " + resolved.getString(PRIVATE_CONF_JS7_PARAM_KEYSTORE_FILEPATH));
                keystore = KeyStoreUtil.readKeyStore((String)credentials.getPath(), (KeystoreType)KeystoreType.PKCS12, (String)credentials.getStorePwd());
            }
            catch (ConfigException | IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                System.out.println("create new Keystore at default location.");
                keystore = null;
            }
            if (keystore == null) {
                keystore = ExecuteRollOut.createKeyStore(true);
            }
            if (keystore != null && truststore != null) {
                client.setSSLContext(keystore, credentials.getKeyPwd().toCharArray(), credentials.getKeyStoreAlias(), truststore);
            }
        } else {
            KeyStore srcKeyStore = null;
            KeyStore srcTrustStore = null;
            if (srcKeystore != null && !srcKeystore.isEmpty() && srcTruststore != null && !srcTruststore.isEmpty()) {
                srcKeyStore = KeyStoreUtil.readKeyStore((String)srcKeystore, (KeystoreType)KeystoreType.fromValue((String)srcKeystoreType), (String)srcKeystorePasswd);
                srcTrustStore = KeyStoreUtil.readTrustStore((String)srcTruststore, (KeystoreType)KeystoreType.fromValue((String)srcTruststoreType), (String)srcTruststorePasswd);
            } else if (!(srcPrivateKeyPath == null || srcPrivateKeyPath.isEmpty() || srcCertPath == null || srcCertPath.isEmpty() || srcCaCertPath == null || srcCaCertPath.isEmpty())) {
                PrivateKey privKey = null;
                X509Certificate cert = null;
                X509Certificate caCert = null;
                String pk = new String(Files.readAllBytes(Paths.get(srcPrivateKeyPath, new String[0])), StandardCharsets.UTF_8);
                if (pk != null && !pk.isEmpty()) {
                    privKey = pk.contains("RSA") ? KeyUtil.getPrivateRSAKeyFromString((String)pk) : KeyUtil.getPrivateECDSAKeyFromString((String)pk);
                }
                cert = (X509Certificate)KeyUtil.getCertificate((Path)Paths.get(srcCertPath, new String[0]));
                Certificate[] chain = null;
                Certificate[] caChain = null;
                if (srcCaCertPath.contains(",")) {
                    String[] caCertPaths = srcCaCertPath.split(",");
                    caChain = new Certificate[caCertPaths.length];
                    chain = new Certificate[caChain.length + 1];
                    chain[0] = cert;
                    for (int i = 0; i < caCertPaths.length; ++i) {
                        X509Certificate caCertficate = (X509Certificate)KeyUtil.getCertificate((Path)Paths.get(caCertPaths[i].trim(), new String[0]));
                        caChain[i] = caCertficate;
                        chain[i + 1] = caCertficate;
                    }
                } else {
                    caCert = (X509Certificate)KeyUtil.getCertificate((String)srcCaCertPath);
                    chain = new Certificate[]{cert, caCert};
                }
                srcKeyStore = KeyStore.getInstance("PKCS12");
                srcKeyStore.load(null, null);
                srcKeyStore.setKeyEntry(keyAlias, privKey, "".toCharArray(), chain);
                srcTrustStore = KeyStore.getInstance("PKCS12");
                srcTrustStore.load(null, null);
                if (caChain.length != 0) {
                    for (int i = 0; i < caChain.length; ++i) {
                        srcTrustStore.setCertificateEntry(caAlias + (i + 1), caChain[i]);
                    }
                } else {
                    srcTrustStore.setCertificateEntry(caAlias, caCert);
                }
            }
            if (srcKeyStore != null && srcTrustStore != null) {
                if (srcKeystoreEntryPasswd != null) {
                    client.setSSLContext(srcKeyStore, srcKeystoreEntryPasswd.toCharArray(), srcKeystoreEntryAlias, srcTrustStore);
                } else {
                    client.setSSLContext(srcKeyStore, "".toCharArray(), srcKeystoreEntryAlias, srcTrustStore);
                }
            }
        }
    }

    private static void closeClient() {
        if (client != null) {
            client.closeHttpClient();
        }
    }

    private static String createRequestBody(String dn, String hostname) throws InvalidNameException, JsonProcessingException {
        CreateCSRFilter filter = new CreateCSRFilter();
        filter.setDn(dn);
        filter.setHostname(hostname);
        filter.setHostname("sp");
        filter.setSan(san);
        filter.setDnOnly(Boolean.valueOf(dnOnly));
        return mapper.writeValueAsString((Object)filter);
    }

    private static String callWebService() throws Exception {
        client.addHeader("X-Onetime-Token", token);
        client.addHeader("Content-Type", "application/json");
        client.addHeader("Accept", "application/json");
        String hostname = InetAddress.getLocalHost().getCanonicalHostName();
        String response = "";
        if (jocUri != null) {
            if (subjectDN != null && !subjectDN.isEmpty()) {
                return client.postRestService(jocUri.resolve(WS_API), (Object)ExecuteRollOut.createRequestBody(subjectDN, hostname));
            }
        } else if (!jocUris.isEmpty()) {
            for (URI uri : jocUris) {
                try {
                    response = client.postRestService(uri.resolve(WS_API), (Object)ExecuteRollOut.createRequestBody(subjectDN, hostname));
                }
                catch (SOSConnectionRefusedException e) {
                    response = e.getMessage();
                    continue;
                }
                catch (JsonProcessingException | SOSException | InvalidNameException e) {
                    response = e.getMessage();
                    continue;
                }
                if (client.statusCode() != 200) continue;
                return response;
            }
        }
        return response;
    }

    private static String getPriorizedKeystoreKey() {
        return null;
    }

    private static String getPriorizedKeystoreEntryKey() {
        return null;
    }

    private static String getPriorizedTruststoreKey() {
        return null;
    }

    private static void printUsage() {
        System.out.println();
        System.out.println("Executes a roll out of ssl certificates on a controller or an agent instance.");
        System.out.println();
        System.out.println(" [ExecuteRollOut] [Options]");
        System.out.println();
        System.out.printf("  %-29s | %s%n", HELP, "Shows this help page, this option is exclusive and has no value");
        System.out.printf("  %-29s | %s%n", DN_ONLY, "Flag to receive relevant DNs to update the private.conf file, without certficate generation.");
        System.out.printf("  %-29s | %s%n", "--token=", "UUID of the token for a onetime authentication to JS7 JOC to receive the generated certificates.");
        System.out.printf("  %-29s | %s%n", "--subject-dn=", "The SubjectDN to be used consisting of [CN, OU, O, C, L, S] where the current hostname has to be set as CN.");
        System.out.printf("  %-29s | %s%n", "--san=", "The subject alternative names(SAN) should be set with variation of the hostname e.g. including the domain part. The alternatives are separated by comma.");
        System.out.printf("  %-29s | %s%n", "--joc-uri=", "URI of the JS7 JOC to receive the generated certificates from.");
        System.out.printf("  %-29s | %s%n", "--source-keystore=", "Path to the Keystore holding the keys to connect to JS7 JOC over https.");
        System.out.printf("  %-29s | %s%n", "--source-keystore-type=", "Type of the keystore to connect to JS7 JOC over https. (PKCS12[default] and JKS are supported only)");
        System.out.printf("  %-29s | %s%n", "--source-keystore-pass=", "Password for the keystore holding the keys to connect to JS7 JOC over https.");
        System.out.printf("  %-29s | %s%n", "--source-keystore-entry-pass=", "Password for the private key entry of the keystore holding the keys to connect to JS7 JOC over https.");
        System.out.printf("  %-29s | %s%n", "--source-keystore-entry-alias=", "Alias of the private key entry of the keystore holding the keys to connect to JS7 JOC over https.");
        System.out.printf("  %-29s | %s%n", "--source-truststore=", "Path to the Truststore holding the trusted certificates to connect to JS7 JOC over https.");
        System.out.printf("  %-29s | %s%n", "--source-truststore-type=", "Type of the truststore to connect to JS7 JOC over https. (PKCS12[default] and JKS are supported only)");
        System.out.printf("  %-29s | %s%n", "--source-truststore-pass=", "Password for the truststore holding the keys to connect to JS7 JOC over https.");
        System.out.printf("  %-29s | %s%n", "--source-private-key=", "Path to the private Key file used to connect to JS7 JOC over https.");
        System.out.printf("  %-29s | %s%n", "--source-certificate=", "Path to the certificate file used to connect to JS7 JOC over https.");
        System.out.printf("  %-29s | %s%n", "--source-ca-cert=", "Path to the CA certificate file(s) used to connect to JS7 JOC over https. (Comma separated)");
        System.out.printf("  %-29s | %s%n", "--target-keystore=", "Path to the Keystore where the generated SSL certificates and keys should be stored.");
        System.out.printf("  %-29s | %s%n", "--target-keystore-type=", "Type of the keystore to store to. (PKCS12[default] and JKS are supported only)");
        System.out.printf("  %-29s | %s%n", "--target-keystore-pass=", "Password for the keystore to store to.");
        System.out.printf("  %-29s | %s%n", "--target-keystore-entry-pass=", "Password for the private key/certificate entry of the keystore holding the keys for mutual https.");
        System.out.printf("  %-29s | %s%n", "--target-truststore=", "Path to the Truststore where the trusted ca certificate should be stored.");
        System.out.printf("  %-29s | %s%n", "--target-truststore-type=", "Type of the truststore to store to. (PKCS12[default] and JKS are supported only)");
        System.out.printf("  %-29s | %s%n", "--target-truststore-pass=", "Password for the truststore to store to.");
        System.out.printf("  %-29s | %s%n", "--key-alias=", "Alias used to store the certificate and its private key in the target keystore.");
        System.out.printf("  %-29s | %s%n", "--ca-alias=", "Alias used to store the ca certificate in both, the target keystore and truststore.");
        System.out.println();
    }

    static {
        jocUris = new ArrayList<URI>();
        srcKeystoreType = "PKCS12";
        srcTruststoreType = "PKCS12";
        targetKeystoreType = "PKCS12";
        targetTruststoreType = "PKCS12";
        dnOnly = false;
        mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, false);
    }

    private class PriorizedKeyStoreCredentials {
        private KeyStore keystore;
        private KeyStore truststore;

        public PriorizedKeyStoreCredentials(KeyStore keystore, KeyStore truststore) {
            this.keystore = keystore;
            this.truststore = truststore;
        }

        public KeyStore getKeystore() {
            return this.keystore;
        }

        public KeyStore getTruststore() {
            return this.truststore;
        }
    }
}

