/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util.common;

import com.sos.commons.util.SOSReflection;
import com.sos.commons.util.common.SOSArgument;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;

public abstract class ASOSArguments {
    private List<Field> argumentFields;

    public List<Field> getArgumentFields() {
        if (this.argumentFields == null) {
            this.argumentFields = SOSReflection.getAllDeclaredFields(this.getClass()).stream().filter(f -> f.getType().equals(SOSArgument.class)).collect(Collectors.toList());
        }
        return this.argumentFields;
    }

    public String getIdentifier() {
        return this.getClass().getName();
    }

    public void setArguments(List<SOSArgument<?>> args) throws IllegalArgumentException, IllegalAccessException {
        this.getArgumentFields();
        for (Field f : this.argumentFields) {
            f.setAccessible(true);
            SOSArgument<?> current = (SOSArgument<?>)f.get(this);
            if (current.getName() == null) continue;
            SOSArgument<?> extern = this.find(args, current.getName());
            if (extern != null) {
                current = extern;
            }
            f.set(this, current);
        }
    }

    private SOSArgument<?> find(List<SOSArgument<?>> args, String name) {
        return args.stream().filter(a -> a.getName() != null && a.getName().equals(name)).findAny().orElse(null);
    }
}

