/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.credentialstore.keepass.db.kdbx.jaxb;

import com.sos.commons.credentialstore.keepass.SOSKeePassDatabase;
import com.sos.commons.credentialstore.keepass.db.kdbx.ASOSKdbxHandler;
import com.sos.commons.credentialstore.keepass.exceptions.SOSKeePassDatabaseException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.Database;
import org.linguafranca.pwdb.Entry;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbDatabase;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbEntry;
import org.linguafranca.pwdb.kdbx.jaxb.JaxbGroup;
import org.linguafranca.pwdb.kdbx.jaxb.binding.JaxbEntryBinding;
import org.linguafranca.pwdb.kdbx.jaxb.binding.JaxbGroupBinding;
import org.linguafranca.pwdb.kdbx.jaxb.binding.Times;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSKdbxJAXBHandler
extends ASOSKdbxHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSKdbxJAXBHandler.class);

    protected JaxbDatabase load() throws SOSKeePassDatabaseException {
        JaxbDatabase jaxbDatabase;
        block8: {
            InputStream is = Files.newInputStream(this.getKeePassFile(), new OpenOption[0]);
            try {
                jaxbDatabase = JaxbDatabase.load((Credentials)this.getCredentials(), (InputStream)is);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable ex) {
                    throw new SOSKeePassDatabaseException(String.format("[%s]%s", SOSKeePassDatabase.getFilePath(this.getKeePassFile()), ex.toString()), ex);
                }
            }
            is.close();
        }
        return jaxbDatabase;
    }

    @Override
    public Entry<?, ?, ?, ?> createEntry(String[] entryPath) throws SOSKeePassDatabaseException {
        String method = "createEntry";
        JaxbDatabase d = (JaxbDatabase)this.getDatabase();
        JaxbGroup lastGroup = d.getRootGroup();
        JaxbEntry entry = null;
        for (int i = 2; i < entryPath.length; ++i) {
            String name = entryPath[i];
            if (i == entryPath.length - 1) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("[%s][addEntry]%s", method, name));
                }
                entry = this.addEntry(d, lastGroup, name);
                continue;
            }
            List result = lastGroup.findGroups(name);
            if (result == null || result.size() == 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("[%s][addGroup]%s", method, name));
                }
                lastGroup = this.addGroup(d, lastGroup, name);
                continue;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("[%s][useExistingGroup]%s", method, name));
            }
            lastGroup = (JaxbGroup)result.get(0);
        }
        this.setDatabase((Database<?, ?, ?, ?>)d);
        return entry;
    }

    private JaxbEntry addEntry(JaxbDatabase d, JaxbGroup parentGroup, String entryName) {
        JaxbEntry e = (JaxbEntry)d.newEntry(entryName);
        e.setIcon(d.newIcon(Integer.valueOf(0)));
        this.setNewEntryTimesAsUTC(e);
        JaxbEntry entry = parentGroup.addEntry(e);
        this.setModifiedGroupTimesAsUTC(parentGroup);
        return entry;
    }

    private JaxbGroup addGroup(JaxbDatabase d, JaxbGroup parentGroup, String groupName) {
        JaxbGroup g = (JaxbGroup)d.newGroup(groupName);
        g.setIcon(d.newIcon(Integer.valueOf(48)));
        this.setNewGroupTimesAsUTC(g);
        JaxbGroup group = parentGroup.addGroup(g);
        this.setModifiedGroupTimesAsUTC(parentGroup);
        return group;
    }

    private void setNewEntryTimesAsUTC(Object obj) {
        try {
            Field f = FieldUtils.getField(obj.getClass(), (String)"delegate", (boolean)true);
            JaxbEntryBinding b = (JaxbEntryBinding)f.get(obj);
            b.setTimes(this.setNewItemTimes(b.getTimes()));
            f.set(obj, b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setNewGroupTimesAsUTC(Object obj) {
        try {
            Field f = FieldUtils.getField(obj.getClass(), (String)"delegate", (boolean)true);
            JaxbGroupBinding b = (JaxbGroupBinding)f.get(obj);
            b.setTimes(this.setNewItemTimes(b.getTimes()));
            f.set(obj, b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setModifiedGroupTimesAsUTC(Object obj) {
        try {
            Field f = FieldUtils.getField(obj.getClass(), (String)"delegate", (boolean)true);
            JaxbGroupBinding b = (JaxbGroupBinding)f.get(obj);
            b.setTimes(this.setModifiedItemTimes(b.getTimes()));
            f.set(obj, b);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private Times setNewItemTimes(Times t) {
        t.setCreationTime(this.getNowAsUTC());
        t.setLastAccessTime(t.getCreationTime());
        t.setLastModificationTime(t.getCreationTime());
        return t;
    }

    private Times setModifiedItemTimes(Times t) {
        t.setLastAccessTime(this.getNowAsUTC());
        t.setLastModificationTime(t.getLastAccessTime());
        return t;
    }
}

