@echo off

rem #  ------------------------------------------------------------
rem #  Company: Software- und Organisations-Service GmbH
rem #  Purpose: Watchdog script for JS7 Controller
rem #  ------------------------------------------------------------

:restart
echo "%JAVABIN%" ^
 -DJS7.Controller=%JS7_CONTROLLER_ID% %JAVA_OPTIONS% ^
 -classpath "%JS7_CONTROLLER_CLASSPATH%" js7.controller.ControllerMain ^
 --id=%JS7_CONTROLLER_ID% ^
 --http-port=%JS7_CONTROLLER_HTTP_PORT% %HTTPS_PORT_OPTION% ^
 --config-directory="%JS7_CONTROLLER_CONFIG_DIR%" ^
 --data-directory="%JS7_CONTROLLER_DATA%" >"%JS7_CONTROLLER_LOGS%\watchdog.log"
 
start "JS7Controller" /D "%JS7_CONTROLLER_DATA%" /B /WAIT "%JAVABIN%" ^
 -DJS7.Controller=%JS7_CONTROLLER_ID% %JAVA_OPTIONS% ^
 -classpath "%JS7_CONTROLLER_CLASSPATH%" js7.controller.ControllerMain ^
 --id=%JS7_CONTROLLER_ID% ^
 --http-port=%JS7_CONTROLLER_HTTP_PORT% %HTTPS_PORT_OPTION% ^
 --config-directory="%JS7_CONTROLLER_CONFIG_DIR%" ^
 --data-directory="%JS7_CONTROLLER_DATA%" >>"%JS7_CONTROLLER_LOGS%\watchdog.log" 2>&1

set /a JS7_CONTROLLER_EXIT=%ERRORLEVEL%
if exist "%JS7_CONTROLLER_PID_FILE%" del "%JS7_CONTROLLER_PID_FILE%"

rem abort and restart
if %JS7_CONTROLLER_EXIT% equ 98 (
  start "JS7ControllerPid" /B "%COMSPEC%" /C "%JS7_CONTROLLER_STARTSCRIPT%" pid-file
  goto restart
)
rem terminate and restart
if %JS7_CONTROLLER_EXIT% equ 97 (
  start "JS7ControllerPid" /B "%COMSPEC%" /C "%JS7_CONTROLLER_STARTSCRIPT%" pid-file
  goto restart
)

exit %JS7_CONTROLLER_EXIT%
