@echo off
rem # ------------------------------------------------------------
rem # Company: Software- und Organisations-Service GmbH
rem # Author : Oliver Haufe <oliver.haufe@sos-berlin.com>
rem # ------------------------------------------------------------

SETLOCAL

set JS7_CONTROLLER_ID=%~1
set JS7_SERVICE_NAME_SUFFIX=%~2
set JS7_CONTROLLER_LOG_DIR=%~3
set SERVICE_USER=%~4
set "SERVICE_PASSWORD=%~5"
set JS7_CONTROLLER_HOME=%~6
set /a RC=0

if not defined JS7_CONTROLLER_ID (
  echo Please enter the JS7 Controller ID
  goto usage
)

if x%SERVICE_USER% == x\ set SERVICE_USER=
if defined SERVICE_PASSWORD set SERVICE_PASSWORD=--ServicePassword="%SERVICE_PASSWORD%"
if not defined SERVICE_USER set SERVICE_PASSWORD=
goto install

:usage
echo Usage: %~nx0 "id" "[log-dir]" "[service-user]" "[service-password]" "[home-dir]"
call :more_info
echo.
pause
exit /b 0

:more_info
rem echo see also https://kb.sos-berlin.com/x/kQiX for more information.
goto final

:normalize_home
set JS7_CONTROLLER_HOME=%~dp1
set JS7_CONTROLLER_HOME=%JS7_CONTROLLER_HOME:~0,-1%
goto final

:install_service
if not defined SERVICE_USER set SERVICE_USER=LocalSystem

"%SERVICE_INSTALL%" //IS/%SERVICE_NAME% ^
  --DisplayName="%SERVICE_DISPLAY_NAME%" ^
  --Description="%SERVICE_DESCRIPTION%" ^
  --Install="%SERVICE_INSTALL%" ^
  --Startup="%SERVICE_STARTUP%" ^
  --LogPath="%SERVICE_LOGPATH%" ^
  --LogPrefix="%SERVICE_LOGPREFIX%" ^
  --LogLevel="%SERVICE_LOGLEVEL%" ^
  --StartImage="%SERVICE_STARTIMAGE%" ^
  --StartPath="%JS7_CONTROLLER_HOME%" ^
  --StartMode="%SERVICE_STARTMODE%" ^
  --StartParams="%SERVICE_STARTPARAMS%" ^
  --StopImage="%SERVICE_STOPIMAGE%" ^
  --StopPath="%JS7_CONTROLLER_HOME%" ^
  --StopMode="%SERVICE_STOPMODE%" ^
  --StopParams="%SERVICE_STOPPARAMS%" ^
  --ServiceUser="%SERVICE_USER%" %SERVICE_PASSWORD%
goto final

:update
if defined SERVICE_USER set SERVICE_USER=--ServiceUser="%SERVICE_USER%"
 
"%SERVICE_INSTALL%" //US/%SERVICE_NAME% ^
  --DisplayName="%SERVICE_DISPLAY_NAME%" ^
  --Description="%SERVICE_DESCRIPTION%" ^
  --Install="%SERVICE_INSTALL%" ^
  --LogPath="%SERVICE_LOGPATH%" ^
  --LogPrefix="%SERVICE_LOGPREFIX%" ^
  --StartImage="%SERVICE_STARTIMAGE%" ^
  --StartPath="%JS7_CONTROLLER_HOME%" ^
  --StartMode="%SERVICE_STARTMODE%" ^
  --StartParams="%SERVICE_STARTPARAMS%" ^
  --StopImage="%SERVICE_STOPIMAGE%" ^
  --StopPath="%JS7_CONTROLLER_HOME%" ^
  --StopMode="%SERVICE_STOPMODE%" ^
  --StopParams="%SERVICE_STOPPARAMS%" %SERVICE_USER% %SERVICE_PASSWORD%
goto final

:install 
set SERVICE_NAME=js7_controller_%JS7_CONTROLLER_ID%
if defined JS7_SERVICE_NAME_SUFFIX set SERVICE_NAME=%SERVICE_NAME%-%JS7_SERVICE_NAME_SUFFIX%
set SERVICE_DESCRIPTION=JS7 Controller
set SERVICE_DISPLAY_NAME=SOS %SERVICE_DESCRIPTION% -id=%JS7_CONTROLLER_ID%
if defined JS7_SERVICE_NAME_SUFFIX set SERVICE_DISPLAY_NAME=%SERVICE_DISPLAY_NAME% -%JS7_SERVICE_NAME_SUFFIX%

if not defined JS7_CONTROLLER_HOME set JS7_CONTROLLER_HOME=%~dp0..
call :normalize_home "%JS7_CONTROLLER_HOME%\dummy"
if not defined JS7_CONTROLLER_LOG_DIR set JS7_CONTROLLER_LOG_DIR=%JS7_CONTROLLER_HOME%\var\logs
if not exist "%JS7_CONTROLLER_LOG_DIR%" set JS7_CONTROLLER_LOG_DIR=%JS7_CONTROLLER_HOME%\logs
if not exist "%JS7_CONTROLLER_LOG_DIR%" set JS7_CONTROLLER_LOG_DIR=%TEMP%
set SERVICE_INSTALL=%JS7_CONTROLLER_HOME%\service\%SERVICE_NAME%.exe
set SERVICE_MANAGER=%JS7_CONTROLLER_HOME%\service\%SERVICE_NAME%w.exe
set PROCESSOR_ARCH=amd64
if x%PROCESSOR_ARCHITECTURE:64=%==x%PROCESSOR_ARCHITECTURE% set PROCESSOR_ARCH=x86
set SERVICE_INSTALL_TEMPLATE=%JS7_CONTROLLER_HOME%\service\%PROCESSOR_ARCH%\prunsrv.exe
set SERVICE_MANAGER_TEMPLATE=%JS7_CONTROLLER_HOME%\service\manager\prunmgr.exe
 
@REM Service Log Configuration
set SERVICE_LOGPREFIX=controller-service
set SERVICE_LOGPATH=%JS7_CONTROLLER_LOG_DIR%
set SERVICE_LOGLEVEL=Info

@REM Startup Configuration
set SERVICE_STARTUP=auto
set SERVICE_STARTMODE=exe
set SERVICE_STARTIMAGE=%ComSpec%
set SERVICE_STARTPARAMS=/C;bin\controller_instance.cmd start
 
@REM Shutdown Configuration
set SERVICE_STOPMODE=exe
set SERVICE_STOPIMAGE=%ComSpec%
set SERVICE_STOPPARAMS=/C;bin\controller_instance.cmd stop

if not exist "%SERVICE_INSTALL%" (
  echo ...try to copy "%SERVICE_INSTALL_TEMPLATE%"
  echo             to "%SERVICE_INSTALL%"
  copy /Y "%SERVICE_INSTALL_TEMPLATE%" "%SERVICE_INSTALL%"
  if ERRORLEVEL 1 exit /B %ERRORLEVEL% 
)
if not exist "%SERVICE_MANAGER%" (
  echo ...try to copy "%SERVICE_MANAGER_TEMPLATE%"
  echo             to "%SERVICE_MANAGER%"
  copy /Y "%SERVICE_MANAGER_TEMPLATE%" "%SERVICE_MANAGER%"
  if ERRORLEVEL 1 exit /B %ERRORLEVEL% 
)

@REM check if Windows Service is already installed
sc.exe query %SERVICE_NAME% >nul
if not %ERRORLEVEL% == 1060 (
  echo "%SERVICE_NAME%" Service already installed.
  goto update_service
)

@REM install or update Service
call :install_service
if ERRORLEVEL 1 (
  set /a RC=%ERRORLEVEL%
  echo Failed to install "%SERVICE_NAME%" Service. Refer to log in "%SERVICE_LOGPATH%"
  goto finally
)
echo "%SERVICE_NAME%" Service has been installed
goto install_update_service_end
:update_service
call :update
if ERRORLEVEL 1 (
  set /a RC=%ERRORLEVEL%
  echo Failed to update "%SERVICE_NAME%" Service. Refer to log in "%SERVICE_LOGPATH%"
  goto finally
)
echo "%SERVICE_NAME%" Service has been updated
:install_update_service_end
 
echo Please use "%SERVICE_MANAGER%" to change Service configurations

@REM start Service
@REM "%SERVICE_INSTALL%" //ES/%SERVICE_NAME%
@REM if ERRORLEVEL 1 (
@REM   set /a RC=%ERRORLEVEL%
@REM   echo Failed to start "%SERVICE_NAME%" Service. Refer to log in "%SERVICE_LOGPATH%"
@REM   goto finally
@REM )
@REM echo "%SERVICE_NAME%" service has been started


:finally
if %RC% neq 0 exit /b %RC%
exit /b %ERRORLEVEL%

ENDLOCAL 
:final