/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.hashedblock;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

public class CollectingInputStream
extends FilterInputStream {
    private ByteArrayOutputStream collectedBytes = new ByteArrayOutputStream();
    private boolean collecting = true;

    public CollectingInputStream(InputStream in) {
        this(in, true);
    }

    public CollectingInputStream(InputStream in, boolean collecting) {
        super(in);
        this.collecting = collecting;
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        if (this.collecting && result != -1) {
            this.collectedBytes.write(result);
        }
        return result;
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        int result = super.read(b, off, len);
        if (this.collecting && result != -1) {
            this.collectedBytes.write(b, off, result);
        }
        return result;
    }

    @Override
    public long skip(long n) throws IOException {
        return super.skip(n);
    }

    public byte[] getCollectedBytes() {
        return this.collectedBytes.toByteArray();
    }

    public boolean isCollecting() {
        return this.collecting;
    }

    public void setCollecting(boolean collecting) {
        this.collecting = collecting;
    }
}

