/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx;

import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.w3c.dom.Document;

public class KdbxKeyFile {
    private static XPath xpath = XPathFactory.newInstance().newXPath();

    public static byte[] load(InputStream inputStream) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = documentBuilder.parse(inputStream);
            String version = (String)xpath.evaluate("//KeyFile/Meta/Version/text()", doc, XPathConstants.STRING);
            String data = (String)xpath.evaluate("//KeyFile/Key/Data/text()", doc, XPathConstants.STRING);
            if (data == null) {
                return null;
            }
            if (version.equals("2.0")) {
                return Hex.decodeHex((String)data.replaceAll("\\s", ""));
            }
            return Base64.decodeBase64((byte[])data.getBytes());
        }
        catch (Exception e) {
            throw new RuntimeException("Key File input stream cannot be null");
        }
    }
}

