/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jaxb;

import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.NotNull;
import org.linguafranca.pwdb.SerializableDatabase;
import org.linguafranca.pwdb.kdbx.Helpers;
import org.linguafranca.pwdb.kdbx.jaxb.base.ValueBinding;
import org.linguafranca.pwdb.kdbx.jaxb.binding.Binaries;
import org.linguafranca.pwdb.kdbx.jaxb.binding.JaxbEntryBinding;
import org.linguafranca.pwdb.kdbx.jaxb.binding.JaxbGroupBinding;
import org.linguafranca.pwdb.kdbx.jaxb.binding.KeePassFile;
import org.linguafranca.pwdb.kdbx.jaxb.binding.ObjectFactory;
import org.linguafranca.pwdb.kdbx.jaxb.binding.StringField;
import org.linguafranca.pwdb.security.StreamEncryptor;

public class JaxbSerializableDatabase
implements SerializableDatabase {
    private final ObjectFactory objectFactory = new ObjectFactory();
    protected KeePassFile keePassFile;
    private StreamEncryptor encryption;

    public JaxbSerializableDatabase() {
    }

    public JaxbSerializableDatabase(KeePassFile keePassFile) {
        this.keePassFile = keePassFile;
    }

    public static void addBinary(KeePassFile keePassFile, ObjectFactory objectFactory, int index, byte[] value) {
        Binaries.Binary newBin = objectFactory.createBinariesBinary();
        newBin.setID(index);
        newBin.setValue(Helpers.zipBinaryContent((byte[])value));
        newBin.setCompressed(true);
        if (keePassFile.getMeta().getBinaries() == null) {
            keePassFile.getMeta().setBinaries(objectFactory.createBinaries());
        }
        keePassFile.getMeta().getBinaries().getBinary().add(newBin);
    }

    public JaxbSerializableDatabase load(InputStream inputStream) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{KeePassFile.class, ValueBinding.class});
            Unmarshaller u = jc.createUnmarshaller();
            u.setListener(new Unmarshaller.Listener(){

                public void afterUnmarshal(Object target, Object parent) {
                    StringField.Value value;
                    if (target instanceof StringField.Value && (value = (StringField.Value)target).getProtected() != null && value.getProtected().booleanValue()) {
                        byte[] encrypted = Base64.decodeBase64((byte[])value.getValue().getBytes());
                        String decrypted = new String(JaxbSerializableDatabase.this.encryption.decrypt(encrypted), StandardCharsets.UTF_8);
                        value.setValue(decrypted);
                        value.setProtected(null);
                        value.protectOnOutput = true;
                    }
                    if (target instanceof JaxbGroupBinding && parent instanceof JaxbGroupBinding) {
                        ((JaxbGroupBinding)target).parent = (JaxbGroupBinding)parent;
                    }
                    if (target instanceof JaxbEntryBinding && parent instanceof JaxbGroupBinding) {
                        ((JaxbEntryBinding)target).parent = (JaxbGroupBinding)parent;
                    }
                }
            });
            this.keePassFile = (KeePassFile)u.unmarshal(inputStream);
            return this;
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public void save(OutputStream outputStream) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{KeePassFile.class});
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setListener(this.createMarshallerListener(this.getToEncrypt()));
            XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
            XMLStreamWriter xmlStreamWriter = xmlOutputFactory.createXMLStreamWriter(outputStream);
            IndentingXMLStreamWriter writer = new IndentingXMLStreamWriter(xmlStreamWriter){

                public void writeStartDocument() throws XMLStreamException {
                    this.setIndentStep("\t");
                    super.writeStartDocument();
                }

                public void writeAttribute(String localName, String value) throws XMLStreamException {
                    if (localName.equals("ProtectInMemory")) {
                        return;
                    }
                    if (localName.equals("Protected") && !value.equalsIgnoreCase("true")) {
                        return;
                    }
                    super.writeAttribute(localName, value);
                }
            };
            marshaller.marshal((Object)this.keePassFile, (XMLStreamWriter)writer);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Marshaller.Listener createMarshallerListener(final List<String> toEncrypt) {
        return new Marshaller.Listener(){
            String savedValue = "";

            public void beforeMarshal(Object source) {
                if (source instanceof StringField) {
                    StringField field = (StringField)source;
                    if (toEncrypt.contains(field.getKey()) || field.getValue().protectOnOutput) {
                        this.savedValue = field.getValue().getValue();
                        byte[] encrypted = JaxbSerializableDatabase.this.encryption.encrypt(field.getValue().getValue().getBytes(StandardCharsets.UTF_8));
                        byte[] base64Encoded = Base64.encodeBase64((byte[])encrypted);
                        field.getValue().setValue(new String(base64Encoded));
                        field.getValue().setProtected(true);
                    } else {
                        field.getValue().setProtected(false);
                    }
                    field.getValue().setProtectInMemory(false);
                }
            }

            public void afterMarshal(Object source) {
                StringField field;
                if (source instanceof StringField && (field = (StringField)source).getValue().getProtected().booleanValue()) {
                    field.getValue().setValue(this.savedValue);
                    field.getValue().setProtected(false);
                }
            }
        };
    }

    @NotNull
    private List<String> getToEncrypt() {
        ArrayList<String> toEncrypt = new ArrayList<String>();
        if (this.keePassFile.getMeta().getMemoryProtection().getProtectTitle().booleanValue()) {
            toEncrypt.add("Title");
        }
        if (this.keePassFile.getMeta().getMemoryProtection().getProtectURL().booleanValue()) {
            toEncrypt.add("URL");
        }
        if (this.keePassFile.getMeta().getMemoryProtection().getProtectUserName().booleanValue()) {
            toEncrypt.add("UserName");
        }
        if (this.keePassFile.getMeta().getMemoryProtection().getProtectPassword().booleanValue()) {
            toEncrypt.add("Password");
        }
        if (this.keePassFile.getMeta().getMemoryProtection().getProtectNotes().booleanValue()) {
            toEncrypt.add("Notes");
        }
        return toEncrypt;
    }

    public StreamEncryptor getEncryption() {
        return this.encryption;
    }

    public void setEncryption(StreamEncryptor encryption) {
        this.encryption = encryption;
    }

    public byte[] getHeaderHash() {
        return this.keePassFile.getMeta().getHeaderHash();
    }

    public void setHeaderHash(byte[] hash) {
        this.keePassFile.getMeta().setHeaderHash(hash);
    }

    public void addBinary(int index, byte[] value) {
        JaxbSerializableDatabase.addBinary(this.keePassFile, this.objectFactory, index, value);
    }

    public byte[] getBinary(int index) {
        return this.keePassFile.getMeta().getBinaries().getBinary().get(index).getValue();
    }

    public int getBinaryCount() {
        if (Objects.isNull(this.keePassFile.getMeta().getBinaries())) {
            return 0;
        }
        return this.keePassFile.getMeta().getBinaries().getBinary().size();
    }

    public KeePassFile getKeePassFile() {
        return this.keePassFile;
    }

    public void setKeePassFile(KeePassFile keypassFile) {
        this.keePassFile = keypassFile;
    }
}

