/*
 * Decompiled with CFR 0.152.
 */
package org.typelevel.jawn;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import org.typelevel.jawn.AsyncParser;
import org.typelevel.jawn.FContext;
import org.typelevel.jawn.Facade;
import org.typelevel.jawn.IncompleteParseException$;
import org.typelevel.jawn.ParseException$;
import org.typelevel.jawn.Parser$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;

public abstract class Parser<J> {
    private final Charset utf8 = Charset.forName("UTF-8");

    public static int ARRBEG() {
        return Parser$.MODULE$.ARRBEG();
    }

    public static int ARREND() {
        return Parser$.MODULE$.ARREND();
    }

    public static int DATA() {
        return Parser$.MODULE$.DATA();
    }

    public static int ErrorContext() {
        return Parser$.MODULE$.ErrorContext();
    }

    public static int[] HexChars() {
        return Parser$.MODULE$.HexChars();
    }

    public static int KEY() {
        return Parser$.MODULE$.KEY();
    }

    public static int OBJBEG() {
        return Parser$.MODULE$.OBJBEG();
    }

    public static int OBJEND() {
        return Parser$.MODULE$.OBJEND();
    }

    public static int SEP() {
        return Parser$.MODULE$.SEP();
    }

    public static <J> AsyncParser<J> async(AsyncParser.Mode mode) {
        return Parser$.MODULE$.async(mode);
    }

    public static <J> Try<J> parseFromByteArray(byte[] byArray, Facade<J> facade) {
        return Parser$.MODULE$.parseFromByteArray(byArray, facade);
    }

    public static <J> Try<J> parseFromByteBuffer(ByteBuffer byteBuffer, Facade<J> facade) {
        return Parser$.MODULE$.parseFromByteBuffer(byteBuffer, facade);
    }

    public static <J> Try<J> parseFromChannel(ReadableByteChannel readableByteChannel, Facade<J> facade) {
        return Parser$.MODULE$.parseFromChannel(readableByteChannel, (Facade)facade);
    }

    public static <J> Try<J> parseFromCharSequence(CharSequence charSequence, Facade<J> facade) {
        return Parser$.MODULE$.parseFromCharSequence(charSequence, facade);
    }

    public static <J> Try<J> parseFromFile(File file, Facade<J> facade) {
        return Parser$.MODULE$.parseFromFile(file, (Facade)facade);
    }

    public static <J> Try<J> parseFromPath(String string, Facade<J> facade) {
        return Parser$.MODULE$.parseFromPath(string, (Facade)facade);
    }

    public static <J> Try<J> parseFromString(String string, Facade<J> facade) {
        return Parser$.MODULE$.parseFromString(string, facade);
    }

    public static <J> J parseUnsafe(String string, Facade<J> facade) {
        return Parser$.MODULE$.parseUnsafe(string, facade);
    }

    public final Charset utf8() {
        return this.utf8;
    }

    public abstract char at(int var1);

    public abstract CharSequence at(int var1, int var2);

    public abstract boolean atEof(int var1);

    public abstract int reset(int var1);

    public abstract void checkpoint(int var1, int var2, FContext<J> var3, List<FContext<J>> var4);

    public abstract void close();

    public abstract void newline(int var1);

    public abstract int line();

    public abstract int column(int var1);

    public Nothing$ die(int i, String msg) {
        return this.die(i, msg, 6);
    }

    private CharSequence safeAt(int i, int j) {
        CharSequence charSequence;
        while (true) {
            if (j <= i) {
                return "";
            }
            try {
                charSequence = this.at(i, j);
            }
            catch (Exception exception) {
                --j;
                continue;
            }
            break;
        }
        return charSequence;
    }

    public Nothing$ die(int i, String msg, int chars) {
        String string;
        int y = this.line() + 1;
        int x = this.column(i) + 1;
        if (this.atEof(i)) {
            string = "eof";
        } else {
            int offset;
            for (offset = 0; offset < chars && !this.atEof(i + offset); ++offset) {
            }
            CharSequence txt = this.safeAt(i, i + offset);
            string = this.atEof(i + offset) ? new StringBuilder(2).append("'").append(txt).append("'").toString() : new StringBuilder(5).append("'").append(txt).append("...'").toString();
        }
        String got = string;
        String s = StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%s got %s (line %d, column %d)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{msg, got, BoxesRunTime.boxToInteger((int)y), BoxesRunTime.boxToInteger((int)x)}));
        throw ParseException$.MODULE$.apply(s, i, y, x);
    }

    public Nothing$ error(String msg) {
        return scala.sys.package$.MODULE$.error(msg);
    }

    public final int parseNum(int i, FContext<J> ctxt, Facade<J> facade) {
        int j = i;
        char c = this.at(j);
        int decIndex = -1;
        int expIndex = -1;
        if (c == '-') {
            c = this.at(++j);
        }
        if (c == '0') {
            c = this.at(++j);
        } else if ('1' <= c && c <= '9') {
            while ('0' <= (c = this.at(++j)) && c <= '9') {
            }
        } else {
            throw this.die(i, "expected digit");
        }
        if (c == '.') {
            decIndex = j - i;
            if ('0' <= (c = this.at(++j)) && c <= '9') {
                while ('0' <= (c = this.at(++j)) && c <= '9') {
                }
            } else {
                throw this.die(i, "expected digit");
            }
        }
        if (c == 'e' || c == 'E') {
            expIndex = j - i;
            if ((c = this.at(++j)) == '+' || c == '-') {
                c = this.at(++j);
            }
            if ('0' <= c && c <= '9') {
                while ('0' <= (c = this.at(++j)) && c <= '9') {
                }
            } else {
                throw this.die(i, "expected digit");
            }
        }
        ctxt.add(facade.jnum(this.at(i, j), decIndex, expIndex, i), i);
        return j;
    }

    public final int parseNumSlow(int i, FContext<J> ctxt, Facade<J> facade) {
        int j = i;
        char c = this.at(j);
        int decIndex = -1;
        int expIndex = -1;
        if (c == '-') {
            c = this.at(++j);
        }
        if (c == '0') {
            if (this.atEof(++j)) {
                ctxt.add(facade.jnum(this.at(i, j), decIndex, expIndex, i), i);
                return j;
            }
            c = this.at(j);
        } else if ('1' <= c && c <= '9') {
            do {
                if (!this.atEof(++j)) continue;
                ctxt.add(facade.jnum(this.at(i, j), decIndex, expIndex, i), i);
                return j;
            } while ('0' <= (c = this.at(j)) && c <= '9');
        } else {
            throw this.die(i, "expected digit");
        }
        if (c == '.') {
            decIndex = j - i;
            if ('0' <= (c = this.at(++j)) && c <= '9') {
                do {
                    if (!this.atEof(++j)) continue;
                    ctxt.add(facade.jnum(this.at(i, j), decIndex, expIndex, i), i);
                    return j;
                } while ('0' <= (c = this.at(j)) && c <= '9');
            } else {
                throw this.die(i, "expected digit");
            }
        }
        if (c == 'e' || c == 'E') {
            expIndex = j - i;
            if ((c = this.at(++j)) == '+' || c == '-') {
                c = this.at(++j);
            }
            if ('0' <= c && c <= '9') {
                do {
                    if (!this.atEof(++j)) continue;
                    ctxt.add(facade.jnum(this.at(i, j), decIndex, expIndex, i), i);
                    return j;
                } while ('0' <= (c = this.at(j)) && c <= '9');
            } else {
                throw this.die(i, "expected digit");
            }
        }
        ctxt.add(facade.jnum(this.at(i, j), decIndex, expIndex, i), i);
        return j;
    }

    public final char descape(int pos, CharSequence s) {
        int[] hc = Parser$.MODULE$.HexChars();
        int x = 0;
        for (int i = 0; i < 4; ++i) {
            int n = hc[s.charAt(i)];
            if (n < 0) {
                throw this.die(pos, "expected valid unicode escape");
            }
            x = x << 4 | n;
        }
        return (char)x;
    }

    public abstract int parseString(int var1, FContext<J> var2);

    public final J parseTrue(int i, Facade<J> facade) {
        if (this.at(i + 1) == 'r' && this.at(i + 2) == 'u' && this.at(i + 3) == 'e') {
            return facade.jtrue(i);
        }
        throw this.die(i, "expected true");
    }

    public final J parseFalse(int i, Facade<J> facade) {
        if (this.at(i + 1) == 'a' && this.at(i + 2) == 'l' && this.at(i + 3) == 's' && this.at(i + 4) == 'e') {
            return facade.jfalse(i);
        }
        throw this.die(i, "expected false");
    }

    public final J parseNull(int i, Facade<J> facade) {
        if (this.at(i + 1) == 'u' && this.at(i + 2) == 'l' && this.at(i + 3) == 'l') {
            return facade.jnull(i);
        }
        throw this.die(i, "expected null");
    }

    public final Tuple2<J, Object> parse(int i, Facade<J> facade) {
        Tuple2<J, Object> tuple2;
        try {
            tuple2 = this.parseTop(i, facade);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw IncompleteParseException$.MODULE$.apply("exhausted input");
        }
        return tuple2;
    }

    public final Tuple2<J, Object> parseTop(int i, Facade<J> facade) {
        block13: while (true) {
            char c = this.at(i);
            switch (c) {
                case ' ': {
                    ++i;
                    continue block13;
                }
                case '\t': {
                    ++i;
                    continue block13;
                }
                case '\r': {
                    ++i;
                    continue block13;
                }
                case '\n': {
                    this.newline(i);
                    ++i;
                    continue block13;
                }
                case '[': {
                    return this.rparse(6, i + 1, facade.arrayContext(i), (List<FContext<J>>)package$.MODULE$.Nil(), facade);
                }
                case '{': {
                    return this.rparse(7, i + 1, facade.objectContext(i), (List<FContext<J>>)package$.MODULE$.Nil(), facade);
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    FContext<J> ctxt = facade.singleContext(i);
                    int j = this.parseNumSlow(i, ctxt, facade);
                    return Tuple2$.MODULE$.apply(ctxt.finish(i), (Object)BoxesRunTime.boxToInteger((int)j));
                }
                case '\"': {
                    FContext<J> ctxt = facade.singleContext(i);
                    int j = this.parseString(i, ctxt);
                    return Tuple2$.MODULE$.apply(ctxt.finish(i), (Object)BoxesRunTime.boxToInteger((int)j));
                }
                case 't': {
                    return Tuple2$.MODULE$.apply(this.parseTrue(i, facade), (Object)BoxesRunTime.boxToInteger((int)(i + 4)));
                }
                case 'f': {
                    return Tuple2$.MODULE$.apply(this.parseFalse(i, facade), (Object)BoxesRunTime.boxToInteger((int)(i + 5)));
                }
                case 'n': {
                    return Tuple2$.MODULE$.apply(this.parseNull(i, facade), (Object)BoxesRunTime.boxToInteger((int)(i + 4)));
                }
            }
            break;
        }
        throw this.die(i, "expected json value");
    }

    public final Tuple2<J, Object> rparse(int state, int j, FContext<J> context, List<FContext<J>> stack, Facade<J> facade) {
        while (true) {
            int i = this.reset(j);
            this.checkpoint(state, i, context, stack);
            char c = this.at(i);
            if (c == '\n') {
                this.newline(i);
                j = i + 1;
                continue;
            }
            if (c == ' ' || c == '\t' || c == '\r') {
                j = i + 1;
                continue;
            }
            if (state == 1) {
                if (c == '[') {
                    int n = 6;
                    int n2 = i + 1;
                    FContext<J> fContext = facade.arrayContext(i);
                    List list = stack.$colon$colon(context);
                    state = n;
                    j = n2;
                    context = fContext;
                    stack = list;
                    continue;
                }
                if (c == '{') {
                    int n = 7;
                    int n3 = i + 1;
                    FContext<J> fContext = facade.objectContext(i);
                    List list = stack.$colon$colon(context);
                    state = n;
                    j = n3;
                    context = fContext;
                    stack = list;
                    continue;
                }
                if (c >= '0' && c <= '9' || c == '-') {
                    int j2 = this.parseNum(i, context, facade);
                    int n = context.isObj() ? 5 : 4;
                    int n4 = j2;
                    state = n;
                    j = n4;
                    continue;
                }
                if (c == '\"') {
                    int j3 = this.parseString(i, context);
                    int n = context.isObj() ? 5 : 4;
                    int n5 = j3;
                    state = n;
                    j = n5;
                    continue;
                }
                if (c == 't') {
                    context.add(this.parseTrue(i, facade), i);
                    int n = context.isObj() ? 5 : 4;
                    int n6 = i + 4;
                    state = n;
                    j = n6;
                    continue;
                }
                if (c == 'f') {
                    context.add(this.parseFalse(i, facade), i);
                    int n = context.isObj() ? 5 : 4;
                    int n7 = i + 5;
                    state = n;
                    j = n7;
                    continue;
                }
                if (c == 'n') {
                    context.add(this.parseNull(i, facade), i);
                    int n = context.isObj() ? 5 : 4;
                    int n8 = i + 4;
                    state = n;
                    j = n8;
                    continue;
                }
                throw this.die(i, "expected json value");
            }
            if (c == ']' && (state == 4 || state == 6) || c == '}' && (state == 5 || state == 7)) {
                if (stack.isEmpty()) {
                    return Tuple2$.MODULE$.apply(context.finish(i), (Object)BoxesRunTime.boxToInteger((int)(i + 1)));
                }
                FContext ctxt2 = (FContext)stack.head();
                ctxt2.add(context.finish(i), i);
                int n = ctxt2.isObj() ? 5 : 4;
                int n9 = i + 1;
                FContext fContext = ctxt2;
                List list = (List)stack.tail();
                state = n;
                j = n9;
                context = fContext;
                stack = list;
                continue;
            }
            if (state == 2) {
                if (c == '\"') {
                    int j4 = this.parseString(i, context);
                    int n = 3;
                    int n10 = j4;
                    state = n;
                    j = n10;
                    continue;
                }
                throw this.die(i, "expected \"");
            }
            if (state == 3) {
                if (c == ':') {
                    int n = 1;
                    int n11 = i + 1;
                    state = n;
                    j = n11;
                    continue;
                }
                throw this.die(i, "expected :");
            }
            if (state == 4) {
                if (c == ',') {
                    int n = 1;
                    int n12 = i + 1;
                    state = n;
                    j = n12;
                    continue;
                }
                throw this.die(i, "expected ] or ,");
            }
            if (state == 5) {
                if (c == ',') {
                    int n = 2;
                    int n13 = i + 1;
                    state = n;
                    j = n13;
                    continue;
                }
                throw this.die(i, "expected } or ,");
            }
            if (state == 6) {
                int n = 1;
                int n14 = i;
                state = n;
                j = n14;
                continue;
            }
            int n = 2;
            int n15 = i;
            state = n;
            j = n15;
        }
    }
}

