/*
 * Decompiled with CFR 0.152.
 */
package io.circe.cursor;

import io.circe.ACursor;
import io.circe.CursorOp;
import io.circe.CursorOp$DeleteGoParent$;
import io.circe.CursorOp$Field$;
import io.circe.CursorOp$MoveLeft$;
import io.circe.CursorOp$MoveRight$;
import io.circe.CursorOp$MoveUp$;
import io.circe.HCursor;
import io.circe.Json;
import io.circe.Json$;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.immutable.Vector;
import scala.runtime.BoxesRunTime;

public final class ArrayCursor
extends HCursor {
    private final Vector<Json> values;
    private final int indexValue;
    private final HCursor parent;
    private final boolean changed;

    public ArrayCursor(Vector<Json> values, int indexValue, HCursor parent, boolean changed, HCursor lastCursor, CursorOp lastOp) {
        this.values = values;
        this.indexValue = indexValue;
        this.parent = parent;
        this.changed = changed;
        super(lastCursor, lastOp);
    }

    public int indexValue() {
        return this.indexValue;
    }

    public HCursor parent() {
        return this.parent;
    }

    @Override
    public Json value() {
        return (Json)this.values.apply(this.indexValue());
    }

    @Override
    public Option<Object> index() {
        return Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.indexValue()));
    }

    @Override
    public Option<String> key() {
        return None$.MODULE$;
    }

    private Vector<Json> valuesExcept() {
        return (Vector)this.values.take(this.indexValue()).$plus$plus((IterableOnce)this.values.drop(this.indexValue() + 1));
    }

    @Override
    public HCursor replace(Json newValue, HCursor cursor, CursorOp op) {
        return new ArrayCursor((Vector<Json>)this.values.updated(this.indexValue(), (Object)newValue), this.indexValue(), this.parent(), true, cursor, op);
    }

    @Override
    public HCursor addOp(HCursor cursor, CursorOp op) {
        return new ArrayCursor(this.values, this.indexValue(), this.parent(), this.changed, cursor, op);
    }

    @Override
    public ACursor up() {
        if (!this.changed) {
            return this.parent().addOp(this, CursorOp$MoveUp$.MODULE$);
        }
        return this.parent().replace(Json$.MODULE$.fromValues((Iterable<Json>)this.values), this, CursorOp$MoveUp$.MODULE$);
    }

    @Override
    public ACursor delete() {
        return this.parent().replace(Json$.MODULE$.fromValues((Iterable<Json>)this.valuesExcept()), this, CursorOp$DeleteGoParent$.MODULE$);
    }

    @Override
    public ACursor left() {
        if (this.indexValue() == 0) {
            return this.fail(CursorOp$MoveLeft$.MODULE$);
        }
        return new ArrayCursor(this.values, this.indexValue() - 1, this.parent(), this.changed, this, CursorOp$MoveLeft$.MODULE$);
    }

    @Override
    public ACursor right() {
        if (this.indexValue() == this.values.size() - 1) {
            return this.fail(CursorOp$MoveRight$.MODULE$);
        }
        return new ArrayCursor(this.values, this.indexValue() + 1, this.parent(), this.changed, this, CursorOp$MoveRight$.MODULE$);
    }

    @Override
    public ACursor field(String k) {
        return this.fail(CursorOp$Field$.MODULE$.apply(k));
    }
}

