/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.credentialstore.keepass.db.kdbx;

import com.sos.commons.credentialstore.keepass.SOSKeePassDatabase;
import com.sos.commons.credentialstore.keepass.SOSKeePassPath;
import com.sos.commons.credentialstore.keepass.db.ASOSKeePassHandler;
import com.sos.commons.credentialstore.keepass.db.kdbx.credentials.SOSKdbxCreds;
import com.sos.commons.credentialstore.keepass.exceptions.SOSKeePassAttachmentException;
import com.sos.commons.credentialstore.keepass.exceptions.SOSKeePassDatabaseException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import org.linguafranca.pwdb.Database;
import org.linguafranca.pwdb.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ASOSKdbxHandler
extends ASOSKeePassHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ASOSKdbxHandler.class);

    protected abstract Database<?, ?, ?, ?> load() throws SOSKeePassDatabaseException;

    protected abstract Entry<?, ?, ?, ?> createEntry(String[] var1) throws SOSKeePassDatabaseException;

    @Override
    public boolean isKdbx() {
        return true;
    }

    @Override
    public void load(String pass, Path keyFile) throws SOSKeePassDatabaseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[load]%s", SOSKeePassDatabase.getFilePath(this.getKeePassFile())));
        }
        this.setCredentials(pass, keyFile);
        this.setDatabase(this.load());
    }

    @Override
    public List<? extends Entry<?, ?, ?, ?>> getEntries() {
        if (this.getDatabase() == null) {
            return null;
        }
        return this.getDatabase().findEntries("");
    }

    @Override
    public Entry<?, ?, ?, ?> getEntryByPath(final String path) {
        if (this.getDatabase() == null || path == null) {
            return null;
        }
        List l = this.getDatabase().findEntries(new Entry.Matcher(){

            public boolean matches(Entry entry) {
                Object p = path.startsWith("/") ? path : "/" + path;
                return entry.getPath().equals(p);
            }
        });
        return l == null || l.size() == 0 ? null : (Entry)l.get(0);
    }

    @Override
    public byte[] getBinaryProperty(Entry<?, ?, ?, ?> entry, String propertyName) throws SOSKeePassAttachmentException {
        block6: {
            try {
                if (propertyName == null) {
                    List l = entry.getBinaryPropertyNames();
                    if (l != null && l.size() > 0) {
                        String fa = (String)l.get(0);
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(String.format("[getBinaryProperty][%s][first BinaryProperty]%s", entry.getPath(), fa));
                        }
                        return entry.getBinaryProperty(fa);
                    }
                    break block6;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug(String.format("[getBinaryProperty][%s][BinaryProperty]%s", entry.getPath(), propertyName));
                }
                return entry.getBinaryProperty(propertyName);
            }
            catch (Throwable e) {
                throw new SOSKeePassAttachmentException(e);
            }
        }
        return null;
    }

    @Override
    public Entry<?, ?, ?, ?> setBinaryProperty(SOSKeePassPath path, Entry<?, ?, ?, ?> entry, Path attachment) throws SOSKeePassAttachmentException {
        String method = "setBinaryProperty";
        if (Files.notExists(attachment, new LinkOption[0])) {
            throw new SOSKeePassAttachmentException(String.format("[%s]attachment file not founded", SOSKeePassDatabase.getFilePath(attachment)));
        }
        String propertyName = SOSKeePassDatabase.getBinaryPropertyName(path, attachment);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s][%s][%s]%s", method, path.getEntry(), propertyName, attachment));
        }
        try {
            entry.setBinaryProperty(propertyName, Files.readAllBytes(attachment));
        }
        catch (Throwable t) {
            throw new SOSKeePassAttachmentException(t);
        }
        return entry;
    }

    @Override
    public Entry<?, ?, ?, ?> setProperty(Entry<?, ?, ?, ?> entry, String name, String value) {
        entry.setProperty(name, value);
        return entry;
    }

    @Override
    public Entry<?, ?, ?, ?> createEntry(String entryPath) throws SOSKeePassDatabaseException {
        String method = "createEntry";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s][entryPath]%s", method, entryPath));
        }
        String[] arr = null;
        if (entryPath.startsWith("/")) {
            arr = entryPath.split("/");
            if (!this.getDatabase().getRootGroup().getName().equals(arr[1])) {
                throw new SOSKeePassDatabaseException(String.format("[%s]could't create entry. Root node not matching: %s != %s", entryPath, arr[1], this.getDatabase().getRootGroup().getName()));
            }
        } else {
            arr = ("/" + this.getDatabase().getRootGroup().getName() + "/" + entryPath).split("/");
        }
        return this.createEntry(arr);
    }

    @Override
    public void saveAs(Path file) throws SOSKeePassDatabaseException {
        if (this.getDatabase() == null) {
            return;
        }
        try (FileOutputStream fos = new FileOutputStream(file.toFile());){
            this.getDatabase().save(this.getCredentials(), (OutputStream)fos);
        }
        catch (Throwable e) {
            throw new SOSKeePassDatabaseException(e);
        }
    }

    protected Date getNowAsUTC() {
        LocalDateTime localDateTime = LocalDateTime.now(ZoneId.of("UTC"));
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    protected void setCredentials(String pass, Path keyFile) throws SOSKeePassDatabaseException {
        SOSKdbxCreds cred = new SOSKdbxCreds();
        cred.load(pass, keyFile);
        this.setCredentials(cred);
    }
}

