/*
 * Decompiled with CFR 0.152.
 */
package com.sos.commons.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class SOSUnicodeInputStream
extends InputStream {
    private static final int BOM_SIZE = 4;
    private PushbackInputStream inStr;
    private boolean initialized = false;
    private String defaultEncoding;
    private String encoding;

    SOSUnicodeInputStream(InputStream in, String defaultEnc) {
        this.inStr = new PushbackInputStream(in, 4);
        this.defaultEncoding = defaultEnc;
    }

    protected void init() throws IOException {
        int unread;
        if (this.initialized) {
            return;
        }
        byte[] bom = new byte[4];
        int n = this.inStr.read(bom, 0, bom.length);
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1) {
            this.encoding = "UTF-32BE";
            unread = n - 4;
        } else if (bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            this.encoding = "UTF-32LE";
            unread = n - 4;
        } else if (bom[0] == -17 && bom[1] == -69 && bom[2] == -65) {
            this.encoding = "UTF-8";
            unread = n - 3;
        } else if (bom[0] == -2 && bom[1] == -1) {
            this.encoding = "UTF-16BE";
            unread = n - 2;
        } else if (bom[0] == -1 && bom[1] == -2) {
            this.encoding = "UTF-16LE";
            unread = n - 2;
        } else {
            this.encoding = this.defaultEncoding;
            unread = n;
        }
        if (unread > 0) {
            this.inStr.unread(bom, n - unread, unread);
        }
        this.initialized = true;
    }

    public String getEncoding() {
        if (!this.initialized) {
            try {
                this.init();
            }
            catch (IOException ex) {
                IllegalStateException ise = new IllegalStateException("Init method failed.");
                ise.initCause(ise);
                throw ise;
            }
        }
        return this.encoding;
    }

    @Override
    public void close() throws IOException {
        this.initialized = true;
        this.inStr.close();
    }

    @Override
    public int read() throws IOException {
        this.initialized = true;
        return this.inStr.read();
    }
}

