/*
 * Decompiled with CFR 0.152.
 */
package js7.base.crypt.x509;

import java.io.Serializable;
import java.util.Base64;
import js7.base.crypt.GenericSignature;
import js7.base.crypt.GenericSignature$;
import js7.base.crypt.Signature;
import js7.base.crypt.SignerId;
import js7.base.crypt.x509.X509Algorithm;
import js7.base.crypt.x509.X509Cert;
import js7.base.crypt.x509.X509Cert$;
import js7.base.crypt.x509.X509Signature$;
import js7.base.data.ByteArray;
import js7.base.data.ByteArray$;
import js7.base.problem.Problem;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class X509Signature
implements Signature,
Product,
Serializable {
    private final ByteArray byteArray;
    private final X509Algorithm algorithm;
    private final Either<SignerId, X509Cert> signerIdOrCertificate;

    public static String TypeName() {
        return X509Signature$.MODULE$.TypeName();
    }

    public static X509Signature apply(ByteArray byteArray, X509Algorithm x509Algorithm, Either<SignerId, X509Cert> either) {
        return X509Signature$.MODULE$.apply(byteArray, x509Algorithm, either);
    }

    public static Either<Problem, X509Signature> fromGenericSignature(GenericSignature genericSignature) {
        return X509Signature$.MODULE$.fromGenericSignature(genericSignature);
    }

    public static X509Signature fromProduct(Product product) {
        return X509Signature$.MODULE$.fromProduct(product);
    }

    public static X509Signature unapply(X509Signature x509Signature) {
        return X509Signature$.MODULE$.unapply(x509Signature);
    }

    public X509Signature(ByteArray byteArray, X509Algorithm algorithm, Either<SignerId, X509Cert> signerIdOrCertificate) {
        this.byteArray = byteArray;
        this.algorithm = algorithm;
        this.signerIdOrCertificate = signerIdOrCertificate;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof X509Signature)) return false;
        X509Signature x509Signature = (X509Signature)object;
        ByteArray byteArray = this.byteArray();
        ByteArray byteArray2 = x509Signature.byteArray();
        if (byteArray == null) {
            if (byteArray2 != null) {
                return false;
            }
        } else if (!((Object)byteArray).equals(byteArray2)) return false;
        X509Algorithm x509Algorithm = this.algorithm();
        X509Algorithm x509Algorithm2 = x509Signature.algorithm();
        if (x509Algorithm == null) {
            if (x509Algorithm2 != null) {
                return false;
            }
        } else if (!((Object)x509Algorithm).equals(x509Algorithm2)) return false;
        Either<SignerId, X509Cert> either = this.signerIdOrCertificate();
        Either<SignerId, X509Cert> either2 = x509Signature.signerIdOrCertificate();
        if (either == null) {
            if (either2 == null) return true;
            return false;
        } else {
            if (!either.equals(either2)) return false;
            return true;
        }
    }

    public boolean canEqual(Object that) {
        return that instanceof X509Signature;
    }

    public int productArity() {
        return 3;
    }

    public String productPrefix() {
        return "X509Signature";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "byteArray";
            }
            case 1: {
                return "algorithm";
            }
            case 2: {
                return "signerIdOrCertificate";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public ByteArray byteArray() {
        return this.byteArray;
    }

    public X509Algorithm algorithm() {
        return this.algorithm;
    }

    public Either<SignerId, X509Cert> signerIdOrCertificate() {
        return this.signerIdOrCertificate;
    }

    @Override
    public GenericSignature toGenericSignature() {
        return GenericSignature$.MODULE$.apply(X509Signature$.MODULE$.TypeName(), Base64.getMimeEncoder().encodeToString(this.byteArray().unsafeArray()), (Option<String>)Some$.MODULE$.apply((Object)this.algorithm().string()), (Option<SignerId>)this.signerIdOrCertificate().left().toOption(), (Option<String>)this.signerIdOrCertificate().toOption().map((Function1 & Serializable)o -> X509Cert$.MODULE$.CertificatePem().toPem((ByteArray)ByteArray$.MODULE$.apply(o.x509Certificate().getEncoded()))));
    }

    public String toString() {
        return "X509Signature( " + this.toGenericSignature().toRawString() + ", " + this.signerIdOrCertificate().fold((Function1 & Serializable)_$1 -> _$1.string(), (Function1 & Serializable)o -> ByteArray$.MODULE$.apply(o.x509Certificate().getEncoded())) + ")";
    }

    public X509Signature copy(ByteArray byteArray, X509Algorithm algorithm, Either<SignerId, X509Cert> signerIdOrCertificate) {
        return new X509Signature(byteArray, algorithm, signerIdOrCertificate);
    }

    public ByteArray copy$default$1() {
        return this.byteArray();
    }

    public X509Algorithm copy$default$2() {
        return this.algorithm();
    }

    public Either<SignerId, X509Cert> copy$default$3() {
        return this.signerIdOrCertificate();
    }

    public ByteArray _1() {
        return this.byteArray();
    }

    public X509Algorithm _2() {
        return this.algorithm();
    }

    public Either<SignerId, X509Cert> _3() {
        return this.signerIdOrCertificate();
    }
}

