/*
 * Decompiled with CFR 0.152.
 */
package js7.base.io.process;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.GenConcurrent;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Resource;
import cats.effect.kernel.Sync;
import com.typesafe.scalalogging.Logger;
import fs2.Compiler;
import fs2.Compiler$;
import fs2.Stream;
import fs2.text$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.data.ByteArray$;
import js7.base.data.ByteSequence$ops$;
import js7.base.fs2utils.Fs2ChunkByteSequence$;
import js7.base.io.ReaderStreams$;
import js7.base.io.process.OperatingSystemSpecific$;
import js7.base.io.process.Pid$;
import js7.base.io.process.Processes;
import js7.base.io.process.ReturnCode;
import js7.base.io.process.ReturnCode$;
import js7.base.io.process.StartRobustly$;
import js7.base.log.Logger$;
import js7.base.log.Logger$syntax$;
import js7.base.thread.IOExecutor$env$;
import scala.Function0;
import scala.Function1;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.sys.process.ProcessLogger;

public final class Processes$
implements Serializable {
    private static final Logger logger;
    private static final String ShellFileExtension;
    private static final scala.collection.immutable.Seq<FileAttribute<Set<?>>> ShellFileAttributes;
    public static final Processes$ MODULE$;

    private Processes$() {
    }

    static {
        MODULE$ = new Processes$();
        logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(Processes$.class));
        ShellFileExtension = OperatingSystemSpecific$.MODULE$.OS().shellFileExtension();
        ShellFileAttributes = OperatingSystemSpecific$.MODULE$.OS().shellFileAttributes();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Processes$.class);
    }

    public scala.collection.immutable.Seq<String> toShellCommandArguments(Path file, scala.collection.immutable.Seq<String> arguments) {
        return (scala.collection.immutable.Seq)((IterableOps)package$.MODULE$.Vector().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{file.toString()}))).$plus$plus(arguments);
    }

    public scala.collection.immutable.Seq<String> toShellCommandArguments$default$2() {
        return package$.MODULE$.Nil();
    }

    public String ShellFileExtension() {
        return ShellFileExtension;
    }

    public scala.collection.immutable.Seq<FileAttribute<Set<?>>> ShellFileAttributes() {
        return ShellFileAttributes;
    }

    public Path newTemporaryShellFile(String name) {
        return OperatingSystemSpecific$.MODULE$.OS().newTemporaryShellFile(name);
    }

    public <F> Resource<F, Path> temporaryShellFileResource(String name, Sync<F> F) {
        return cats.effect.package$.MODULE$.Resource().make(F.interruptible(() -> Processes$.temporaryShellFileResource$$anonfun$1(name)), (Function1 & Serializable)file -> F.interruptible((Function0 & Serializable)() -> {
            Processes$.temporaryShellFileResource$$anonfun$2$$anonfun$1(file);
            return BoxedUnit.UNIT;
        }), F);
    }

    public scala.collection.immutable.Seq<String> directShellCommandArguments(String argument) {
        return OperatingSystemSpecific$.MODULE$.OS().directShellCommandArguments(argument);
    }

    public String runProcess(String commandLine) {
        Logger LoggerImpl_this = logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug(commandLine);
        }
        StringBuilder stdout = new StringBuilder();
        StringBuilder stderr = new StringBuilder();
        int exitCode = scala.sys.process.package$.MODULE$.stringToProcess(commandLine).$bang(new ProcessLogger(stdout){
            private final StringBuilder stdout$1;
            {
                this.stdout$1 = stdout$2;
            }

            public void out(Function0 line) {
                this.stdout$1.$plus$plus$eq((String)line.apply());
                this.stdout$1.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\n'));
            }

            public void err(Function0 line) {
                this.stdout$1.$plus$plus$eq((String)line.apply());
                this.stdout$1.$plus$eq((Object)BoxesRunTime.boxToCharacter((char)'\n'));
            }

            public Object buffer(Function0 f) {
                return f.apply();
            }
        });
        if (exitCode != 0) {
            throw new Processes.ProcessException(commandLine, ReturnCode$.MODULE$.apply(exitCode), ByteArray$.MODULE$.apply(stdout.toString()), ByteArray$.MODULE$.apply(stderr.toString()));
        }
        return stdout.toString();
    }

    public IO<ReturnCode> runAndLogProcess(scala.collection.immutable.Seq<String> args, Function1<String, IO<BoxedUnit>> logLine) {
        return this.startProcess(args).flatMap((Function1 & Serializable)x$12 -> {
            Process process = (Process)x$12._1();
            Stream stream = (Stream)x$12._2();
            Stream stream2 = (Stream)x$12._3();
            return IO$.MODULE$.both(IO$.MODULE$.both(this.logLines$1(logLine, stream), this.logLines$1(logLine, stream2)).guaranteeCase((Function1 & Serializable)x$1 -> {
                Outcome outcome = x$1;
                if (outcome instanceof Outcome.Succeeded) {
                    cats.effect.package$.MODULE$.Outcome();
                    Outcome.Succeeded succeeded = Outcome.Succeeded$.MODULE$.unapply((Outcome.Succeeded)outcome);
                    IO iO = (IO)succeeded._1();
                    return IO$.MODULE$.unit();
                }
                return CatsEffectExtensions$.MODULE$.startAndForget(IO$.MODULE$.blocking((Function0 & Serializable)() -> {
                    Processes$.runAndLogProcess$$anonfun$1$$anonfun$1$$anonfun$1(process);
                    return BoxedUnit.UNIT;
                }).productR(MODULE$.waitForProcessTermination(process)));
            }), this.waitForProcessTermination(process));
        }).map((Function1 & Serializable)_$3 -> (ReturnCode)_$3._2());
    }

    public IO<Tuple3<Process, Stream<IO, Object>, Stream<IO, Object>>> startProcess(Path path, scala.collection.immutable.Seq<String> args) {
        String string = path.toString();
        return this.startProcess((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)args.$plus$colon((Object)string)));
    }

    public IO<Tuple3<Process, Stream<IO, Object>, Stream<IO, Object>>> startProcess(scala.collection.immutable.Seq<String> args) {
        return IO$.MODULE$.defer(() -> Processes$.startProcess$$anonfun$1(args));
    }

    private IO<ReturnCode> waitForProcessTermination(Process process) {
        return IOExecutor$env$.MODULE$.interruptibleVirtualThread(() -> Processes$.waitForProcessTermination$$anonfun$1(process));
    }

    private static final Path temporaryShellFileResource$$anonfun$1(String name$1) {
        return OperatingSystemSpecific$.MODULE$.OS().newTemporaryShellFile(name$1);
    }

    private static final void temporaryShellFileResource$$anonfun$2$$anonfun$1(Path file$1) {
        Files.delete(file$1);
    }

    private final IO logLines$1(Function1 logLine$1, Stream stream) {
        return (IO)stream.chunks().map((Function1 & Serializable)_$2 -> ByteSequence$ops$.MODULE$.toAllByteSequenceOps(_$2, Fs2ChunkByteSequence$.MODULE$.implicitByteSequence()).utf8String()).through(text$.MODULE$.lines()).evalMap(logLine$1).compile(Compiler$.MODULE$.target(Compiler.Target$.MODULE$.forConcurrent((GenConcurrent)IO$.MODULE$.asyncForIO()))).drain();
    }

    private static final void runAndLogProcess$$anonfun$1$$anonfun$1$$anonfun$1(Process process$2) {
        process$2.destroy();
    }

    private static final IO startProcess$$anonfun$1(scala.collection.immutable.Seq args$1) {
        Logger LoggerImpl_this = logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("{}", (Object)args$1.mkString(" "));
        }
        ProcessBuilder processBuilder = new ProcessBuilder(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)args$1).asJava());
        return StartRobustly$.MODULE$.startRobustly(processBuilder, StartRobustly$.MODULE$.startRobustly$default$2(processBuilder)).map((Function1 & Serializable)process -> Tuple3$.MODULE$.apply(process, ReaderStreams$.MODULE$.inputStreamToByteStream(process.getInputStream(), ReaderStreams$.MODULE$.inputStreamToByteStream$default$2()), ReaderStreams$.MODULE$.inputStreamToByteStream(process.getErrorStream(), ReaderStreams$.MODULE$.inputStreamToByteStream$default$2())));
    }

    private static final ReturnCode waitForProcessTermination$$anonfun$1$$anonfun$1(Process process$4) {
        return ReturnCode$.MODULE$.apply(process$4.waitFor());
    }

    private static final ReturnCode waitForProcessTermination$$anonfun$1(Process process$3) {
        return (ReturnCode)Logger$syntax$.MODULE$.traceCallWithResult(logger, "waitFor " + Pid$.MODULE$.apply(process$3.pid()), () -> Processes$.waitForProcessTermination$$anonfun$1$$anonfun$1(process$3));
    }
}

