/*
 * Decompiled with CFR 0.152.
 */
package js7.base.utils;

import io.circe.Codec;
import io.circe.Decoder;
import io.circe.Encoder;
import io.circe.KeyDecoder;
import io.circe.KeyEncoder;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.UUID;
import js7.base.convert.As;
import js7.base.generic.GenericString;
import js7.base.problem.Checked$;
import js7.base.problem.CheckedString;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.utils.Base64UUID;
import scala.Function0;
import scala.Function1;
import scala.NotImplementedError;
import scala.Predef$;
import scala.Product;
import scala.collection.ArrayOps$;
import scala.deriving.Mirror;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.NotGiven$;

public final class Base64UUID$
implements GenericString.Checked_<Base64UUID>,
Mirror.Product {
    private static String name;
    private static Ordering ordering;
    private static CheckedString checkedString;
    private static Encoder jsonEncoder;
    private static Decoder jsonDecoder;
    private static Codec jsonCodec;
    private static KeyEncoder keyEncoder;
    private static KeyDecoder keyDecoder;
    private volatile Object GenericStringAsString$lzy1;
    private static final Base64UUID zero;
    private static final Base64UUID ffff;
    private volatile Object toUrlBase64$lzy1;
    public static final Base64UUID$ MODULE$;

    private Base64UUID$() {
    }

    static {
        MODULE$ = new Base64UUID$();
        GenericString.Companion.$init$(MODULE$);
        GenericString.Checked_.$init$(MODULE$);
        zero = MODULE$.apply(new UUID(0L, 0L));
        ffff = MODULE$.apply(new UUID(-1L, -1L));
        Statics.releaseFence();
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public Ordering ordering() {
        return ordering;
    }

    @Override
    public void js7$base$generic$GenericString$Companion$_setter_$name_$eq(String x$0) {
        name = x$0;
    }

    @Override
    public void js7$base$generic$GenericString$Companion$_setter_$ordering_$eq(Ordering x$0) {
        ordering = x$0;
    }

    @Override
    public final CheckedString checkedString() {
        return checkedString;
    }

    @Override
    public Encoder jsonEncoder() {
        return jsonEncoder;
    }

    @Override
    public Decoder jsonDecoder() {
        return jsonDecoder;
    }

    @Override
    public Codec jsonCodec() {
        return jsonCodec;
    }

    @Override
    public KeyEncoder keyEncoder() {
        return keyEncoder;
    }

    @Override
    public KeyDecoder keyDecoder() {
        return keyDecoder;
    }

    @Override
    public As GenericStringAsString() {
        Object object = this.GenericStringAsString$lzy1;
        if (object instanceof As) {
            return (As)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (As)this.GenericStringAsString$lzyINIT1();
    }

    private Object GenericStringAsString$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.GenericStringAsString$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Base64UUID.OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    As as = null;
                    try {
                        as = GenericString.Checked_.GenericStringAsString$(this);
                        object2 = as == null ? LazyVals.NullValue$.MODULE$ : as;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Base64UUID.OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.GenericStringAsString$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Base64UUID.OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return as;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Base64UUID.OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public void js7$base$generic$GenericString$Checked_$_setter_$checkedString_$eq(CheckedString x$0) {
        checkedString = x$0;
    }

    @Override
    public void js7$base$generic$GenericString$Checked_$_setter_$jsonEncoder_$eq(Encoder x$0) {
        jsonEncoder = x$0;
    }

    @Override
    public void js7$base$generic$GenericString$Checked_$_setter_$jsonDecoder_$eq(Decoder x$0) {
        jsonDecoder = x$0;
    }

    @Override
    public void js7$base$generic$GenericString$Checked_$_setter_$jsonCodec_$eq(Codec x$0) {
        jsonCodec = x$0;
    }

    @Override
    public void js7$base$generic$GenericString$Checked_$_setter_$keyEncoder_$eq(KeyEncoder x$0) {
        keyEncoder = x$0;
    }

    @Override
    public void js7$base$generic$GenericString$Checked_$_setter_$keyDecoder_$eq(KeyDecoder x$0) {
        keyDecoder = x$0;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Base64UUID$.class);
    }

    private Base64UUID apply(UUID uuid, String string) {
        return new Base64UUID(uuid, string);
    }

    public Base64UUID unapply(Base64UUID x$1) {
        return x$1;
    }

    public Base64UUID zero() {
        return zero;
    }

    public Base64UUID ffff() {
        return ffff;
    }

    public Base64UUID apply(UUID uuid) {
        return new Base64UUID(uuid, this.uuidToBase64(uuid));
    }

    public Base64UUID random() {
        return this.apply(UUID.randomUUID());
    }

    public String randomString() {
        return this.uuidToBase64(UUID.randomUUID());
    }

    @Override
    public Base64UUID unchecked(String string) {
        throw new NotImplementedError();
    }

    @Override
    public Either<Problem, Base64UUID> checked(String string) {
        return this.base64ToUUID(string).map((Function1 & Serializable)uuid -> new Base64UUID((UUID)uuid, string));
    }

    private Function1 toUrlBase64() {
        Object object = this.toUrlBase64$lzy1;
        if (object instanceof Function1) {
            return (Function1)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Function1)this.toUrlBase64$lzyINIT1();
    }

    private Object toUrlBase64$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.toUrlBase64$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, Base64UUID.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Function1 & Serializable intersect = null;
                    Function1 & Serializable intersect2 = null;
                    try {
                        Base64.Encoder encoder = Base64.getUrlEncoder().withoutPadding();
                        intersect2 = (Function1 & Serializable)x$0 -> encoder.encodeToString((byte[])x$0);
                        intersect = intersect2 == null ? LazyVals.NullValue$.MODULE$ : intersect2;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, Base64UUID.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, (Object)intersect)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.toUrlBase64$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, Base64UUID.OFFSET$_m_0, (Object)waiting, (Object)intersect);
                            waiting.countDown();
                        }
                    }
                    return intersect2;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, Base64UUID.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String uuidToBase64(UUID uuid) {
        ByteBuffer buffer = ByteBuffer.wrap(new byte[16]);
        buffer.putLong(uuid.getMostSignificantBits());
        buffer.putLong(uuid.getLeastSignificantBits());
        return (String)this.toUrlBase64().apply((Object)buffer.array());
    }

    public Either<Problem, UUID> base64ToUUID(String base64String) {
        return Checked$.MODULE$.catchExpected().apply(() -> Base64UUID$.base64ToUUID$$anonfun$1(base64String), ClassTag$.MODULE$.apply(IllegalArgumentException.class), NotGiven$.MODULE$.value()).flatMap((Function1 & Serializable)bytes -> {
            Left left;
            Object object = Predef$.MODULE$.byteArrayOps(bytes);
            if (ArrayOps$.MODULE$.size$extension(object) != 16) {
                left = package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> Base64UUID$.base64ToUUID$$anonfun$2$$anonfun$1(base64String)), Problem$.MODULE$.apply$default$2()));
            } else {
                ByteBuffer buffer = ByteBuffer.wrap(bytes);
                left = package$.MODULE$.Right().apply((Object)new UUID(buffer.getLong(0), buffer.getLong(8)));
            }
            return left.map((Function1 & Serializable)uuid -> uuid);
        });
    }

    public Base64UUID fromProduct(Product x$0) {
        return new Base64UUID((UUID)x$0.productElement(0), (String)x$0.productElement(1));
    }

    private static final byte[] base64ToUUID$$anonfun$1(String base64String$1) {
        return Base64.getUrlDecoder().decode(base64String$1);
    }

    private static final String base64ToUUID$$anonfun$2$$anonfun$1(String base64String$3) {
        return "Not a Base64-encoded UUID: " + base64String$3;
    }
}

