/*
 * Decompiled with CFR 0.152.
 */
package js7.base.utils;

import java.io.Serializable;
import scala.collection.mutable.StringBuilder;
import scala.runtime.ModuleSerializationProxy;

public final class ByteUnits$
implements Serializable {
    public static final ByteUnits$ MODULE$ = new ByteUnits$();

    private ByteUnits$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ByteUnits$.class);
    }

    public String toKBGB(long size) {
        long l = size;
        if (size < 1000L) {
            return size + "bytes";
        }
        if (size < 1000000L) {
            return this.formatNumber(size, 1000, "kB");
        }
        if (size < 1000000000L) {
            return this.formatNumber(size, 1000000, "MB");
        }
        return this.formatNumber(size, 1000000000, "GB");
    }

    public String toMB(long size) {
        long l = size;
        if (size < 0L) {
            return this.toKBGB(size);
        }
        if (size == 0L) {
            return "0MB";
        }
        if (size < 1000000L) {
            return "<1MB";
        }
        return this.toKBGB(size);
    }

    public String toKiBGiB(long size) {
        long l = size;
        if (size < 1024L) {
            return size + "bytes";
        }
        if (size < 2047L) {
            return this.formatNumber(size, 1024, "KiB");
        }
        if (size < 0x100000L) {
            return this.formatNumber(size, 1024, "KiB");
        }
        if (size < 0x40000000L) {
            return this.formatNumber(size, 0x100000, "MiB");
        }
        return this.formatNumber(size, 0x40000000, "GiB");
    }

    public String formatNumber(long number, int divisor, String suffix) {
        StringBuilder sb = new StringBuilder(16);
        long n = number / (long)divisor;
        if (n >= 10L) {
            v0 = sb.append(n);
        } else {
            long l = 10L * number / (long)divisor % 10L;
            if (0L == l) {
                v0 = sb.append(n);
            } else {
                long m = l;
                sb.append(n);
                sb.append('.');
                v0 = sb.append(m);
            }
        }
        sb.append(suffix);
        return sb.toString();
    }
}

