/*
 * Decompiled with CFR 0.152.
 */
package js7.base.utils;

import cats.Functor;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import js7.base.log.BlockingSymbol;
import js7.base.log.CanBindCorrelId$;
import js7.base.log.CorrelId$;
import js7.base.log.LogLevel;
import js7.base.log.LogLevel$;
import js7.base.log.Slf4jUtils$syntax$;
import js7.base.log.Slf4jUtils$syntax$LevelLogger$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.ScalaTime$RichDuration$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.LockKeeper$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichBoolean$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.Enclosing;

public final class LockKeeper<K> {
    private final Map<Object, Queue<Deferred<IO, Token>>> keyToQueue = (Map)Map$.MODULE$.empty();

    public <A> IO<A> lock(K key, IO<A> body, Enclosing enclosing) {
        return (IO)this.lockResource(key, enclosing).surround(body, (MonadCancel)IO$.MODULE$.asyncForIO());
    }

    public Resource<IO, Token> lockResource(K key, Enclosing enclosing) {
        return package$.MODULE$.Resource().make(this.acquire(key, enclosing), (Function1 & Serializable)token -> this.release((Token)token), (Functor)IO$.MODULE$.asyncForIO());
    }

    private IO<Token> acquire(K key, Enclosing enclosing) {
        return IO$.MODULE$.defer(() -> this.acquire$$anonfun$1(key, enclosing));
    }

    private IO<BoxedUnit> release(Token token) {
        return IO$.MODULE$.defer(() -> this.release$$anonfun$1(token));
    }

    public String toString() {
        String string;
        LockKeeper lockKeeper = this;
        synchronized (lockKeeper) {
            string = ((IterableOnceOps)this.keyToQueue.map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                Object key = tuple2._1();
                Queue queue = (Queue)tuple2._2();
                if (queue.isEmpty()) {
                    return key.toString();
                }
                return key + " (" + queue.length() + " waiting)";
            })).mkString(", ");
        }
        return "LockKeeper(" + string + ")";
    }

    private static final void $anonfun$1$$anonfun$1$$anonfun$1(ObjectRef waitingLogLevel$3, BlockingSymbol sym$3, Object key$4, Enclosing enclosing$4, Deadline since$3) {
        LogLevel logLevel = (LogLevel)package.option$.MODULE$.catsSyntaxOptionId((Object)LogLevel$.Info);
        waitingLogLevel$3.elem = OptionIdOps$.MODULE$.some$extension((Object)logLevel);
        sym$3.onInfo();
        Logger LoggerImpl_this = LockKeeper$.js7$base$utils$LockKeeper$$$logger;
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info("{} Still waiting for {} (in {}) since {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{sym$3, key$4, enclosing$4.value(), ScalaTime$RichDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichDuration((Duration)ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$3))))}), Object.class));
            return;
        }
    }

    private static final IO $anonfun$1(Deferred deferred$1, ObjectRef waitingLogLevel$1, BlockingSymbol sym$1, Object key$2, Enclosing enclosing$2, Deadline since$1) {
        IO iO = (IO)deferred$1.get();
        return CatsUtils$syntax$.MODULE$.whenItTakesLonger(iO, CatsUtils$syntax$.MODULE$.whenItTakesLonger$default$2(iO), (Function1<FiniteDuration, IO<BoxedUnit>>)(Function1 & Serializable)_$1 -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
            LockKeeper.$anonfun$1$$anonfun$1$$anonfun$1(waitingLogLevel$1, sym$1, key$2, enclosing$2, since$1);
            return BoxedUnit.UNIT;
        }));
    }

    private static final String message$proxy3$1(Object key$8, Enclosing enclosing$8, Deadline since$7) {
        return "\ud83d\udfe2 Acquired lock '" + key$8 + "' (" + enclosing$8.value() + ") after " + ScalaTime$RichDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichDuration((Duration)ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$7))));
    }

    private static final String acquire$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(Object key$10, Enclosing enclosing$10, Deadline since$9) {
        return LockKeeper.message$proxy3$1(key$10, enclosing$10, since$9);
    }

    private static final void acquire$$anonfun$1$$anonfun$1$$anonfun$1(ObjectRef waitingLogLevel$5, Object key$6, Enclosing enclosing$6, Deadline since$5) {
        ((Option)waitingLogLevel$5.elem).foreach((Function1)(JProcedure1 & Serializable)logLevel -> Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(LockKeeper$.js7$base$utils$LockKeeper$$$logger.underlying()), (LogLevel)logLevel, (Function0<String>)((Function0 & Serializable)() -> LockKeeper.acquire$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(key$6, enclosing$6, since$5))));
    }

    private final IO acquire$$anonfun$1(Object key$1, Enclosing enclosing$1) {
        IO iO;
        Deadline since = Deadline$.MODULE$.now();
        ObjectRef waitingLogLevel = ObjectRef.create((Object)package.option$.MODULE$.none());
        LockKeeper lockKeeper = this;
        synchronized (lockKeeper) {
            IO iO2;
            Option option = this.keyToQueue.get(key$1);
            if (None$.MODULE$.equals(option)) {
                Object object = Predef$.MODULE$.ArrowAssoc(key$1);
                this.keyToQueue.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)Queue$.MODULE$.empty()));
                iO2 = IO$.MODULE$.pure((Object)new Token(this, key$1));
            } else if (option instanceof Some) {
                Queue queue = (Queue)((Some)option).value();
                LogLevel logLevel = (LogLevel)package.option$.MODULE$.catsSyntaxOptionId((Object)LogLevel$.Debug);
                waitingLogLevel.elem = OptionIdOps$.MODULE$.some$extension((Object)logLevel);
                Logger LoggerImpl_this = LockKeeper$.js7$base$utils$LockKeeper$$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("\ud83d\udfe1 Waiting for {} (in {})", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{key$1, enclosing$1.value()}), Object.class));
                }
                Deferred deferred = package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
                queue.$plus$eq((Object)deferred);
                BlockingSymbol sym = new BlockingSymbol();
                iO2 = CorrelId$.MODULE$.current().bind(() -> LockKeeper.$anonfun$1(deferred, waitingLogLevel, sym, key$1, enclosing$1, since), CanBindCorrelId$.MODULE$.io());
            } else {
                throw new MatchError((Object)option);
            }
            iO = iO2;
        }
        IO result = iO;
        return result.flatTap((Function1 & Serializable)_$2 -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
            LockKeeper.acquire$$anonfun$1$$anonfun$1$$anonfun$1(waitingLogLevel, key$1, enclosing$1, since);
            return BoxedUnit.UNIT;
        }));
    }

    private static final IO release$$anonfun$1$$anonfun$1$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private final IO release$$anonfun$1$$anonfun$1(Token token$2) {
        Option option;
        LockKeeper lockKeeper = this;
        synchronized (lockKeeper) {
            Option maybe = ((Queue)this.keyToQueue.apply(token$2.key())).dequeueFirst((Function1 & Serializable)_$3 -> true);
            if (maybe.isEmpty()) {
                this.keyToQueue.remove(token$2.key());
            }
            option = maybe;
        }
        Option dequeued = option;
        return (IO)dequeued.fold(LockKeeper::release$$anonfun$1$$anonfun$1$$anonfun$1, (Function1 & Serializable)deferred -> ((IO)deferred.complete((Object)new Token(this, token$2.key()))).void());
    }

    private final IO release$$anonfun$1(Token token$1) {
        return IO$.MODULE$.unlessA(token$1.released().getAndSet(true), () -> this.release$$anonfun$1$$anonfun$1(token$1));
    }

    public static final String js7$base$utils$LockKeeper$Token$$_$toString$$anonfun$2() {
        return ", released";
    }

    public final class Token {
        private final K key;
        private final AtomicBoolean released;
        private final /* synthetic */ LockKeeper $outer;

        public Token(LockKeeper $outer, K key) {
            this.key = key;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.released = new AtomicBoolean(false);
        }

        public K key() {
            return this.key;
        }

        public AtomicBoolean released() {
            return this.released;
        }

        public String toString() {
            return "LockKeeper.Token(" + this.key() + ScalaUtils$syntax$RichBoolean$.MODULE$.$qmark$qmark$extension(ScalaUtils$syntax$.MODULE$.RichBoolean(this.released().get()), (Function0<String>)((Function0 & Serializable)LockKeeper::js7$base$utils$LockKeeper$Token$$_$toString$$anonfun$2)) + ")";
        }

        public final /* synthetic */ LockKeeper js7$base$utils$LockKeeper$Token$$$outer() {
            return this.$outer;
        }
    }
}

