/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Resource;
import cats.effect.std.Supervisor;
import com.typesafe.scalalogging.Logger;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import js7.base.auth.Admission;
import js7.base.auth.UserAndPassword;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.log.Logger$syntax$;
import js7.base.monixutils.AsyncVariable;
import js7.base.monixutils.AsyncVariable$;
import js7.base.problem.Problem;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.Assertions$;
import js7.cluster.ActivationInhibitor$;
import js7.cluster.ActivationInhibitor$Active$;
import js7.cluster.ActivationInhibitor$Inhibited$;
import js7.cluster.ActivationInhibitor$Initial$;
import js7.cluster.ActivationInhibitor$Passive$;
import js7.data.cluster.ClusterNodeApi;
import js7.data.cluster.ClusterSetting;
import js7.data.cluster.ClusterState;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.Enclosing$;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Name$;
import sourcecode.Text;
import sourcecode.Text$;

public final class ActivationInhibitor {
    private final Supervisor<IO> supervisor;
    private final AsyncVariable<State> _state;

    public static IO<Option<ClusterState.FailedOver>> inhibitActivationOfPassiveNode(ClusterSetting clusterSetting, Option<UserAndPassword> option, Function2<Admission, String, Resource<IO, ClusterNodeApi>> function2) {
        return ActivationInhibitor$.MODULE$.inhibitActivationOfPassiveNode(clusterSetting, option, function2);
    }

    public static Resource<IO, ActivationInhibitor> resource() {
        return ActivationInhibitor$.MODULE$.resource();
    }

    public ActivationInhibitor(Supervisor<IO> supervisor) {
        this.supervisor = supervisor;
        this._state = AsyncVariable$.MODULE$.apply(ActivationInhibitor$Initial$.MODULE$, AsyncVariable$.MODULE$.apply$default$2(), Enclosing$.MODULE$.apply("js7.cluster.ActivationInhibitor#_state"), Tag$.MODULE$.apply(State.class, LightTypeTag$.MODULE$.parse(1451739854, "\u0004\u0000\u0001&js7.cluster.ActivationInhibitor$.State\u0001\u0002\u0003\u0000\u0000\u001fjs7.cluster.ActivationInhibitor\u0001\u0001", "\u0000\u0000\u0000", 30)));
    }

    public IO<BoxedUnit> startActive() {
        return this.startAs(ActivationInhibitor$Active$.MODULE$);
    }

    public IO<BoxedUnit> startPassive() {
        return this.startAs(ActivationInhibitor$Passive$.MODULE$);
    }

    private IO<BoxedUnit> startAs(State state) {
        return IO$.MODULE$.defer(() -> this.startAs$$anonfun$1(state));
    }

    public IO<Either<Problem, Object>> tryToActivate(IO<Either<Problem, Object>> activate) {
        return Logger$syntax$.MODULE$.debugIOWithResult(ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger, this._state.updateCheckedWithResult((Function1 & Serializable)x$12 -> {
            State state = x$12;
            if (ActivationInhibitor$Initial$.MODULE$.equals(state) || ActivationInhibitor$Passive$.MODULE$.equals(state) || ActivationInhibitor$Active$.MODULE$.equals(state)) {
                return activate.flatMap((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left || either instanceof Right && !BoxesRunTime.unboxToBoolean((Object)((Right)either).value())) {
                        Either o = either;
                        return IO$.MODULE$.apply(() -> ActivationInhibitor.tryToActivate$$anonfun$1$$anonfun$1$$anonfun$1(o));
                    }
                    if (either instanceof Right && BoxesRunTime.unboxToBoolean((Object)((Right)either).value())) {
                        return IO$.MODULE$.apply(ActivationInhibitor::tryToActivate$$anonfun$1$$anonfun$1$$anonfun$2);
                    }
                    throw new MatchError((Object)either);
                });
            }
            if (state instanceof Inhibited) {
                Inhibited inhibited = (Inhibited)state;
                return IO$.MODULE$.apply(() -> ActivationInhibitor.tryToActivate$$anonfun$1$$anonfun$2(inhibited));
            }
            throw new MatchError((Object)state);
        }, Enclosing$.MODULE$.apply("js7.cluster.ActivationInhibitor#tryToActivate")), Name$.MODULE$.apply("tryToActivate"));
    }

    public IO<Either<Problem, Object>> inhibitActivation(FiniteDuration duration) {
        return Logger$syntax$.MODULE$.debugIOWithResult(ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger, this._state.updateCheckedWithResult((Function1 & Serializable)x$1 -> {
            State state = x$1;
            if (ActivationInhibitor$Initial$.MODULE$.equals(state) || ActivationInhibitor$Passive$.MODULE$.equals(state) || state instanceof Inhibited) {
                State state2 = state;
                return this.setInhibitionTimer(duration).$times$greater(IO$.MODULE$.apply(() -> ActivationInhibitor.inhibitActivation$$anonfun$1$$anonfun$1(state2)));
            }
            if (ActivationInhibitor$Active$.MODULE$.equals(state)) {
                ActivationInhibitor$Active$ activationInhibitor$Active$ = (ActivationInhibitor$Active$)Predef$.MODULE$.ArrowAssoc((Object)ActivationInhibitor$Active$.MODULE$);
                return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)activationInhibitor$Active$, (Object)BoxesRunTime.boxToBoolean((boolean)false)));
            }
            throw new MatchError((Object)state);
        }, Enclosing$.MODULE$.apply("js7.cluster.ActivationInhibitor#inhibitActivation")), Name$.MODULE$.apply("inhibitActivation"));
    }

    private IO<BoxedUnit> setInhibitionTimer(FiniteDuration duration) {
        return ((IO)this.supervisor.supervise((Object)this._state.update((Function1<State, IO<State>>)(Function1 & Serializable)x$1 -> {
            State state = x$1;
            if (state instanceof Inhibited) {
                Inhibited inhibited = ActivationInhibitor$Inhibited$.MODULE$.unapply((Inhibited)state);
                int n = inhibited._1();
                if (1 == n) {
                    return IO$.MODULE$.pure((Object)ActivationInhibitor$Passive$.MODULE$);
                }
                int n2 = n;
                return IO$.MODULE$.pure((Object)ActivationInhibitor$Inhibited$.MODULE$.apply(n2 - 1));
            }
            State state2 = state;
            return IO$.MODULE$.apply(() -> ActivationInhibitor.setInhibitionTimer$$anonfun$1$$anonfun$1(duration, state2));
        }, Enclosing$.MODULE$.apply("js7.cluster.ActivationInhibitor#setInhibitionTimer")).delayBy((Duration)duration))).void();
    }

    public IO<Option<State>> state() {
        return this._state.lockedValue().map((Function1 & Serializable)_$2 -> Some$.MODULE$.apply(_$2)).timeoutTo((Duration)ScalaTime$DurationRichInt$.MODULE$.ms$extension(ScalaTime$.MODULE$.DurationRichInt(100)), IO$.MODULE$.none());
    }

    private final IO startAs$$anonfun$1(State state$1) {
        block0: {
            Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            LoggerImpl_this.underlying().debug("startAs {}", (Object)state$1);
        }
        return this._state.update((Function1<State, IO<State>>)(Function1 & Serializable)x$1 -> {
            State state = x$1;
            if (ActivationInhibitor$Initial$.MODULE$.equals(state)) {
                return IO$.MODULE$.pure((Object)state$1);
            }
            State s = state;
            return IO$.MODULE$.raiseError((Throwable)new IllegalStateException("ActivationInhibitor startAs(" + state$1 + "): Already '" + s + "''"));
        }, Enclosing$.MODULE$.apply("js7.cluster.ActivationInhibitor#startAs")).void();
    }

    private static final /* synthetic */ Tuple2 tryToActivate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(boolean _$1) {
        ActivationInhibitor$Passive$ activationInhibitor$Passive$ = (ActivationInhibitor$Passive$)Predef$.MODULE$.ArrowAssoc((Object)ActivationInhibitor$Passive$.MODULE$);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)activationInhibitor$Passive$, (Object)BoxesRunTime.boxToBoolean((boolean)_$1));
    }

    private static final Either tryToActivate$$anonfun$1$$anonfun$1$$anonfun$1(Either o$1) {
        block0: {
            Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            LoggerImpl_this.underlying().debug("tryToActivate: Passive \u2014 due to {}", (Object)o$1);
        }
        return o$1.map((Function1 & Serializable)_$1 -> ActivationInhibitor.tryToActivate$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)_$1)));
    }

    private static final Right tryToActivate$$anonfun$1$$anonfun$1$$anonfun$2() {
        Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("tryToActivate: Active \u2014 due to Right(true)");
        }
        ActivationInhibitor$Active$ activationInhibitor$Active$ = (ActivationInhibitor$Active$)Predef$.MODULE$.ArrowAssoc((Object)ActivationInhibitor$Active$.MODULE$);
        return package$.MODULE$.Right().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)activationInhibitor$Active$, (Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    private static final Right tryToActivate$$anonfun$1$$anonfun$2(Inhibited inhibited$1) {
        Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info("Activation inhibited");
        }
        Inhibited inhibited = (Inhibited)Predef$.MODULE$.ArrowAssoc((Object)inhibited$1);
        return package$.MODULE$.Right().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)inhibited, (Object)BoxesRunTime.boxToBoolean((boolean)false)));
    }

    private static final Right inhibitActivation$$anonfun$1$$anonfun$1(Object state$3) {
        int n;
        Object object = state$3;
        if (object instanceof Inhibited) {
            int n2;
            Inhibited inhibited = ActivationInhibitor$Inhibited$.MODULE$.unapply((Inhibited)object);
            int n3 = n2 = inhibited._1();
            n = n3 + 1;
        } else {
            n = 1;
        }
        int depth = n;
        Inhibited inhibited = (Inhibited)Predef$.MODULE$.ArrowAssoc((Object)ActivationInhibitor$Inhibited$.MODULE$.apply(depth));
        return package$.MODULE$.Right().apply((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)inhibited, (Object)BoxesRunTime.boxToBoolean((boolean)true)));
    }

    private static final State setInhibitionTimer$$anonfun$1$$anonfun$1(FiniteDuration duration$3, State state$4) {
        block0: {
            Logger LoggerImpl_this = ActivationInhibitor$.js7$cluster$ActivationInhibitor$$$logger;
            if (!LoggerImpl_this.underlying().isErrorEnabled()) break block0;
            LoggerImpl_this.underlying().error("inhibitActivation timeout after {}: expected Inhibited but got '{}'", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration$3)), state$4}), Object.class));
        }
        return state$4;
    }

    public static class Inhibited
    implements State,
    Product,
    Serializable {
        private final int depth;

        public static Inhibited apply(int n) {
            return ActivationInhibitor$Inhibited$.MODULE$.apply(n);
        }

        public static Inhibited fromProduct(Product product) {
            return ActivationInhibitor$Inhibited$.MODULE$.fromProduct(product);
        }

        public static Inhibited unapply(Inhibited inhibited) {
            return ActivationInhibitor$Inhibited$.MODULE$.unapply(inhibited);
        }

        public Inhibited(int depth) {
            this.depth = depth;
            Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1(depth)), "depth >= 1"), FullName$.MODULE$.apply("js7.cluster.ActivationInhibitor.Inhibited"), FileName$.MODULE$.apply("ActivationInhibitor.scala"), Line$.MODULE$.apply(135));
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.depth());
            return Statics.finalizeHash((int)n, (int)1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Inhibited)) return false;
            Inhibited inhibited = (Inhibited)object;
            if (this.depth() != inhibited.depth()) return false;
            if (!inhibited.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Inhibited;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Inhibited";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return BoxesRunTime.boxToInteger((int)this._1());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "depth";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public int depth() {
            return this.depth;
        }

        public Inhibited copy(int depth) {
            return new Inhibited(depth);
        }

        public int copy$default$1() {
            return this.depth();
        }

        public int _1() {
            return this.depth();
        }

        private final boolean v$proxy1$1(int depth$1) {
            return depth$1 >= 1;
        }
    }

    public static interface State {
    }
}

