/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import com.typesafe.scalalogging.Logger;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.net.SocketException;
import js7.base.auth.Admission;
import js7.base.auth.UserAndPassword;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.eventbus.EventPublisher;
import js7.base.log.LogLevel;
import js7.base.log.Logger$syntax$;
import js7.base.log.Slf4jUtils$syntax$;
import js7.base.log.Slf4jUtils$syntax$LevelLogger$;
import js7.base.monixlike.MonixLikeExtensions$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.system.startup.Halt$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichDeadline$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.Assertions$;
import js7.base.utils.Delayer;
import js7.base.utils.OneTimeToken;
import js7.base.utils.OneTimeToken$;
import js7.base.utils.OneTimeTokenProvider;
import js7.base.utils.OneTimeTokenProvider$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.base.utils.SetOnce;
import js7.base.utils.SetOnce$;
import js7.cluster.ActivationInhibitor;
import js7.cluster.ActivationInhibitor$;
import js7.cluster.ClusterCommon$;
import js7.cluster.ClusterCommon$ClusterWatchAgreedToActivation$;
import js7.cluster.ClusterCommon$ClusterWatchDisagreedToActivation$;
import js7.cluster.ClusterConf;
import js7.cluster.ClusterConf$;
import js7.cluster.ClusterWatchCounterpart;
import js7.cluster.ClusterWatchSynchronizer;
import js7.cluster.watch.api.ClusterWatchConfirmation;
import js7.core.license.LicenseChecker;
import js7.data.cluster.ClusterCommand;
import js7.data.cluster.ClusterEvent;
import js7.data.cluster.ClusterNodeApi;
import js7.data.cluster.ClusterState;
import js7.data.cluster.ClusterState$Empty$;
import js7.data.cluster.ClusterWatchProblems$ClusterNodeLossNotConfirmedProblem$;
import js7.data.cluster.ClusterWatchProblems$ClusterPassiveLostWhileFailedOverProblem$;
import js7.data.cluster.ClusterWatchProblems$ClusterWatchInactiveNodeProblem$;
import js7.data.command.CommonCommand;
import org.apache.pekko.util.Timeout;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.Enclosing$;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Name$;
import sourcecode.Text;
import sourcecode.Text$;

public final class ClusterCommon {
    private final ClusterWatchCounterpart clusterWatchCounterpart;
    private final Function2<Admission, String, Resource<IO, ClusterNodeApi>> clusterNodeApi;
    private final ClusterConf clusterConf;
    private final LicenseChecker licenseChecker;
    private final EventPublisher<Object> testEventBus;
    private final ActivationInhibitor activationInhibitor;
    private final Timeout journalActorAskTimeout;
    private final SetOnce<ClusterWatchSynchronizer> _clusterWatchSynchronizer;
    private final OneTimeTokenProvider couplingTokenProvider;

    public static String clusterEventAndStateToString(ClusterEvent clusterEvent, ClusterState clusterState) {
        return ClusterCommon$.MODULE$.clusterEventAndStateToString(clusterEvent, clusterState);
    }

    public static Resource<IO, ClusterCommon> resource(ClusterWatchCounterpart clusterWatchCounterpart, Function2<Admission, String, Resource<IO, ClusterNodeApi>> function2, ClusterConf clusterConf, LicenseChecker licenseChecker, EventPublisher<Object> eventPublisher, Timeout timeout) {
        return ClusterCommon$.MODULE$.resource(clusterWatchCounterpart, function2, clusterConf, licenseChecker, eventPublisher, timeout);
    }

    public ClusterCommon(ClusterWatchCounterpart clusterWatchCounterpart, Function2<Admission, String, Resource<IO, ClusterNodeApi>> clusterNodeApi, ClusterConf clusterConf, LicenseChecker licenseChecker, EventPublisher<Object> testEventBus, ActivationInhibitor activationInhibitor, Timeout journalActorAskTimeout) {
        this.clusterWatchCounterpart = clusterWatchCounterpart;
        this.clusterNodeApi = clusterNodeApi;
        this.clusterConf = clusterConf;
        this.licenseChecker = licenseChecker;
        this.testEventBus = testEventBus;
        this.activationInhibitor = activationInhibitor;
        this.journalActorAskTimeout = journalActorAskTimeout;
        this._clusterWatchSynchronizer = SetOnce$.MODULE$.apply(Tag$.MODULE$.apply(ClusterWatchSynchronizer.class, LightTypeTag$.MODULE$.parse(-636438082, "\u0004\u0000\u0001$js7.cluster.ClusterWatchSynchronizer\u0001\u0001", "\u0000\u0000\u0000", 30)));
        this.couplingTokenProvider = OneTimeTokenProvider$.MODULE$.unsafe();
    }

    public ClusterWatchCounterpart clusterWatchCounterpart() {
        return this.clusterWatchCounterpart;
    }

    public Function2<Admission, String, Resource<IO, ClusterNodeApi>> clusterNodeApi() {
        return this.clusterNodeApi;
    }

    public EventPublisher<Object> testEventBus() {
        return this.testEventBus;
    }

    public ActivationInhibitor activationInhibitor() {
        return this.activationInhibitor;
    }

    public Timeout journalActorAskTimeout() {
        return this.journalActorAskTimeout;
    }

    public OneTimeTokenProvider couplingTokenProvider() {
        return this.couplingTokenProvider;
    }

    public IO<BoxedUnit> stop() {
        return IO$.MODULE$.defer(this::stop$$anonfun$1);
    }

    public IO<Either<Problem, BoxedUnit>> requireValidLicense() {
        return IO$.MODULE$.apply(this::requireValidLicense$$anonfun$1);
    }

    public IO<ClusterWatchSynchronizer> clusterWatchSynchronizer(ClusterState.HasNodes clusterState) {
        return IO$.MODULE$.apply(() -> this.clusterWatchSynchronizer$$anonfun$1(clusterState));
    }

    public ClusterWatchSynchronizer initialClusterWatchSynchronizer(ClusterState.HasNodes clusterState) {
        Option<ClusterWatchSynchronizer> option = this._clusterWatchSynchronizer.toOption();
        if (option instanceof Some) {
            ClusterWatchSynchronizer o = (ClusterWatchSynchronizer)((Some)option).value();
            Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)ClusterCommon.v$proxy1$1(clusterState)), "clusterState.isInstanceOf[FailedOver] || clusterState.isInstanceOf[SwitchedOver]"), FullName$.MODULE$.apply("js7.cluster.ClusterCommon.initialClusterWatchSynchronizer"), FileName$.MODULE$.apply("ClusterCommon.scala"), Line$.MODULE$.apply(59));
            return o;
        }
        if (None$.MODULE$.equals(option)) {
            ClusterWatchSynchronizer result = new ClusterWatchSynchronizer(this.clusterConf.ownId(), this.clusterWatchCounterpart(), clusterState.setting().timing());
            this._clusterWatchSynchronizer.$colon$eq(result);
            return result;
        }
        throw new MatchError(option);
    }

    public IO<BoxedUnit> tryEndlesslyToSendCommand(Admission admission, ClusterCommand command) {
        String name = ScalaUtils$syntax$.MODULE$.RichJavaClass(command.getClass()).simpleScalaName();
        return this.tryEndlesslyToSendCommand((Resource<IO, ClusterNodeApi>)((Resource)this.clusterNodeApi().apply((Object)admission, (Object)name)), (Function1 & Serializable)_$2 -> command);
    }

    public <C extends ClusterCommand> IO<BoxedUnit> tryEndlesslyToSendCommand(Resource<IO, ClusterNodeApi> apiResource, Function1<OneTimeToken, C> toCommand) {
        return this.clusterConf.delayConf().runIO((Function1 & Serializable)delayer -> {
            String name = ((CommonCommand)toCommand.apply((Object)OneTimeToken$.MODULE$.apply("TOKEN"))).toShortString();
            Deadline since = Deadline$.MODULE$.now();
            return (IO)apiResource.use((Function1 & Serializable)api -> ((IO)MonixLikeExtensions$.MODULE$.onErrorRestartLoop(api.retryIfSessionLost(api.loginUntilReachable(api.loginUntilReachable$default$1(), api.loginUntilReachable$default$2(), true).$times$greater((IO)this.couplingTokenProvider().resource().use((Function1 & Serializable)token -> api.executeClusterCommand((ClusterCommand)toCommand.apply(token)), (MonadCancel)IO$.MODULE$.asyncForIO()))).map((Function1)(JProcedure1 & Serializable)_$3 -> {}), BoxedUnit.UNIT, (Function3 & Serializable)(throwable, _$4, retry) -> {
                block0: {
                    Logger LoggerImpl_this;
                    Object object;
                    LogLevel level$proxy1 = delayer.logLevel();
                    Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(ClusterCommon$.js7$cluster$ClusterCommon$$$logger.underlying()), level$proxy1, (Function0<String>)((Function0 & Serializable)() -> ClusterCommon.tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$1(delayer, name, throwable)));
                    if (throwable instanceof SocketException || !ArrayOps$.MODULE$.nonEmpty$extension(object = Predef$.MODULE$.refArrayOps((Object[])throwable.getStackTrace())) || !(LoggerImpl_this = ClusterCommon$.js7$cluster$ClusterCommon$$$logger).underlying().isDebugEnabled()) break block0;
                    LoggerImpl_this.underlying().debug(throwable.toString(), throwable);
                }
                return ((IO)delayer.sleep(Enclosing$.MODULE$.apply("js7.cluster.ClusterCommon#tryEndlesslyToSendCommand"))).$times$greater((IO)retry.apply((Object)BoxedUnit.UNIT));
            }, IO$.MODULE$.asyncForIO())).guaranteeCase((Function1 & Serializable)x$1 -> {
                Outcome outcome = x$1;
                if (outcome instanceof Outcome.Succeeded) {
                    package$.MODULE$.Outcome();
                    Outcome.Succeeded succeeded = Outcome.Succeeded$.MODULE$.unapply((Outcome.Succeeded)outcome);
                    IO iO = (IO)succeeded._1();
                    return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                        ClusterCommon.tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$4$$anonfun$1(delayer, name, since);
                        return BoxedUnit.UNIT;
                    });
                }
                if (outcome instanceof Outcome.Canceled) {
                    package$.MODULE$.Outcome();
                    if (Outcome.Canceled$.MODULE$.unapply((Outcome.Canceled)outcome)) {
                        return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                            ClusterCommon.tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$4$$anonfun$2(delayer, name, since);
                            return BoxedUnit.UNIT;
                        });
                    }
                }
                return IO$.MODULE$.unit();
            }), (MonadCancel)IO$.MODULE$.asyncForIO());
        });
    }

    public IO<Option<ClusterState.FailedOver>> inhibitActivationOfPeer(ClusterState.HasNodes clusterState, Option<UserAndPassword> peersUserAndPassword) {
        return ActivationInhibitor$.MODULE$.inhibitActivationOfPassiveNode(clusterState.setting(), peersUserAndPassword, this.clusterNodeApi());
    }

    public IO<Either<Problem, Object>> ifClusterWatchAllowsActivation(ClusterState.HasNodes clusterState, ClusterEvent.ClusterNodeLostEvent event, IO<Either<Problem, Object>> body) {
        return Logger$syntax$.MODULE$.traceIOWithResult(ClusterCommon$.js7$cluster$ClusterCommon$$$logger, this.activationInhibitor().tryToActivate(this.activate(clusterState, event, body)), Name$.MODULE$.apply("ifClusterWatchAllowsActivation"));
    }

    private IO<Either<Problem, Object>> activate(ClusterState.HasNodes clusterState, ClusterEvent.ClusterNodeLostEvent event, IO<Either<Problem, Object>> body) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.pure(clusterState.applyEvent(event)));
        return Logger$syntax$.MODULE$.traceIOWithResult(ClusterCommon$.js7$cluster$ClusterCommon$$$logger, (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)x$12 -> {
            ClusterState clusterState = x$12;
            if (clusterState instanceof ClusterState.HasNodes) {
                ClusterState.HasNodes updatedClusterState = (ClusterState.HasNodes)clusterState;
                return this.clusterWatchSynchronizer(clusterState).flatMap((Function1 & Serializable)_$5 -> _$5.applyEvent(event, updatedClusterState, event instanceof ClusterEvent.ClusterFailedOver, _$5.applyEvent$default$4())).flatMap((Function1 & Serializable)x$1 -> {
                    Either either = x$1;
                    if (either instanceof Left) {
                        Problem problem = (Problem)((Left)either).value();
                        if (problem.is(ClusterWatchProblems$ClusterNodeLossNotConfirmedProblem$.MODULE$) || problem.is(ClusterWatchProblems$ClusterWatchInactiveNodeProblem$.MODULE$)) {
                            Logger LoggerImpl_this = ClusterCommon$.js7$cluster$ClusterCommon$$$logger;
                            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                                LoggerImpl_this.underlying().warn("\u26d4 ClusterWatch did not agree to '{}' event: {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{ScalaUtils$syntax$.MODULE$.RichJavaClass(event.getClass()).simpleScalaName(), problem}), Object.class));
                            }
                            this.testEventBus().publish(ClusterCommon$ClusterWatchDisagreedToActivation$.MODULE$);
                            if (event instanceof ClusterEvent.ClusterPassiveLost) {
                                String msg = "\ud83d\udfe5 While this node has lost the passive node and is waiting for ClusterWatch's agreement, the passive node failed over";
                                if (this.clusterConf.testDontHaltWhenPassiveLostRejected()) {
                                    return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, ClusterWatchProblems$ClusterPassiveLostWhileFailedOverProblem$.MODULE$);
                                }
                                throw Halt$.MODULE$.haltJava(msg, true, true);
                            }
                            return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, BoxesRunTime.boxToBoolean((boolean)false));
                        }
                        return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, problem);
                    }
                    if (either instanceof Right) {
                        Option option = (Option)((Right)either).value();
                        if (None$.MODULE$.equals(option)) {
                            Logger LoggerImpl_this = ClusterCommon$.js7$cluster$ClusterCommon$$$logger;
                            if (LoggerImpl_this.underlying().isDebugEnabled()) {
                                LoggerImpl_this.underlying().debug("No ClusterWatch confirmation required for '{}' event", (Object)ScalaUtils$syntax$.MODULE$.RichJavaClass(event.getClass()).simpleScalaName());
                            }
                            return body;
                        }
                        Option maybeConfirm = option;
                        Option option2 = maybeConfirm;
                        if (None$.MODULE$.equals(option2)) {
                            Logger LoggerImpl_this = ClusterCommon$.js7$cluster$ClusterCommon$$$logger;
                            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                                LoggerImpl_this.underlying().info("ClusterWatch agreed to '{}' event", (Object)ScalaUtils$syntax$.MODULE$.RichJavaClass(event.getClass()).simpleScalaName());
                            }
                        } else if (option2 instanceof Some) {
                            ClusterWatchConfirmation confirm = (ClusterWatchConfirmation)((Some)option2).value();
                            Logger LoggerImpl_this = ClusterCommon$.js7$cluster$ClusterCommon$$$logger;
                            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                                LoggerImpl_this.underlying().info("{} agreed to '{}' event", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{confirm.confirmer(), ScalaUtils$syntax$.MODULE$.RichJavaClass(event.getClass()).simpleScalaName()}), Object.class));
                            }
                        } else {
                            throw new MatchError((Object)option2);
                        }
                        this.testEventBus().publish(ClusterCommon$ClusterWatchAgreedToActivation$.MODULE$);
                        return body;
                    }
                    throw new MatchError((Object)either);
                });
            }
            if (ClusterState$Empty$.MODULE$.equals(clusterState)) {
                return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.pure("ClusterState:Empty in ifClusterWatchAllowsActivation ??"));
            }
            throw new MatchError((Object)clusterState);
        }, IO$.MODULE$.asyncForIO()), Name$.MODULE$.apply("activate"));
    }

    private static final IO stop$$anonfun$1$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private final IO stop$$anonfun$1() {
        return (IO)this._clusterWatchSynchronizer.toOption().fold(ClusterCommon::stop$$anonfun$1$$anonfun$1, (Function1 & Serializable)_$1 -> _$1.stop());
    }

    private final Either requireValidLicense$$anonfun$1() {
        return this.licenseChecker.checkLicense(ClusterConf$.MODULE$.ClusterProductName());
    }

    private final ClusterWatchSynchronizer clusterWatchSynchronizer$$anonfun$1$$anonfun$1(ClusterState.HasNodes clusterState$2) {
        return this.initialClusterWatchSynchronizer(clusterState$2);
    }

    private final ClusterWatchSynchronizer clusterWatchSynchronizer$$anonfun$1(ClusterState.HasNodes clusterState$1) {
        return (ClusterWatchSynchronizer)this._clusterWatchSynchronizer.toOption().getOrElse(() -> this.clusterWatchSynchronizer$$anonfun$1$$anonfun$1(clusterState$1));
    }

    private static final boolean v$proxy1$1(ClusterState.HasNodes clusterState$3) {
        return clusterState$3 instanceof ClusterState.FailedOver || clusterState$3 instanceof ClusterState.SwitchedOver;
    }

    private static final String message$proxy1$1(Delayer delayer$3, String name$3, Throwable throwable$1) {
        Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(throwable$1);
        return delayer$3.symbol() + " " + name$3 + " command failed with " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable);
    }

    private static final String tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$3$$anonfun$1(Delayer delayer$7, String name$9, Throwable throwable$2) {
        return ClusterCommon.message$proxy1$1(delayer$7, name$9, throwable$2);
    }

    private static final String message$proxy3$1(String name$6, Deadline since$4) {
        return "\ud83d\udfe2 " + name$6 + " command succeeded after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$4))));
    }

    private static final String tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$4$$anonfun$1$$anonfun$1(String name$10, Deadline since$7) {
        return ClusterCommon.message$proxy3$1(name$10, since$7);
    }

    private static final void tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$4$$anonfun$1(Delayer delayer$5, String name$5, Deadline since$3) {
        LogLevel level$proxy2 = delayer$5.relievedLogLevel();
        Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(ClusterCommon$.js7$cluster$ClusterCommon$$$logger.underlying()), level$proxy2, (Function0<String>)((Function0 & Serializable)() -> ClusterCommon.tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$4$$anonfun$1$$anonfun$1(name$5, since$3)));
    }

    private static final String message$proxy4$1(String name$8, Deadline since$6) {
        return "\u25fc\ufe0f  " + name$8 + " command canceled after " + ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(ScalaTime$RichDeadline$.MODULE$.elapsed$extension(ScalaTime$.MODULE$.RichDeadline(since$6))));
    }

    private static final String tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$4$$anonfun$2$$anonfun$1(String name$12, Deadline since$9) {
        return ClusterCommon.message$proxy4$1(name$12, since$9);
    }

    private static final void tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$4$$anonfun$2(Delayer delayer$6, String name$7, Deadline since$5) {
        LogLevel level$proxy3 = delayer$6.relievedLogLevel();
        Slf4jUtils$syntax$LevelLogger$.MODULE$.log$extension(Slf4jUtils$syntax$.MODULE$.LevelLogger(ClusterCommon$.js7$cluster$ClusterCommon$$$logger.underlying()), level$proxy3, (Function0<String>)((Function0 & Serializable)() -> ClusterCommon.tryEndlesslyToSendCommand$$anonfun$2$$anonfun$1$$anonfun$4$$anonfun$2$$anonfun$1(name$7, since$5)));
    }
}

