/*
 * Decompiled with CFR 0.152.
 */
package js7.cluster;

import cats.Applicative;
import cats.UnorderedFoldable$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Deferred;
import cats.effect.kernel.Outcome;
import cats.effect.kernel.Ref;
import cats.effect.kernel.Resource;
import cats.effect.package$;
import cats.effect.unsafe.IORuntime;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import fs2.Stream;
import izumi.reflect.Tag;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.auth.Admission;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.UnsafeMemoizable$;
import js7.base.eventbus.EventPublisher;
import js7.base.log.Logger$syntax$;
import js7.base.monixlike.MonixLikeExtensions$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.problem.ProblemException$;
import js7.base.service.MainServiceTerminationException;
import js7.base.service.Service;
import js7.base.service.StoppableByRequest;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$DurationRichInt$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.Allocated;
import js7.base.utils.Atomic$package$Atomic$extensions$;
import js7.base.utils.CatsUtils$syntax$;
import js7.base.utils.CatsUtils$syntax$RichResource$;
import js7.base.utils.OneTimeToken;
import js7.base.utils.ProgramTermination;
import js7.base.utils.ProgramTermination$;
import js7.base.utils.ProgramTermination$Restart$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEither$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.cluster.ClusterCommon;
import js7.cluster.ClusterConf;
import js7.cluster.ClusterNode$;
import js7.cluster.ClusterNode$ClusterWatchConfirmed$;
import js7.cluster.ClusterNode$Prepared$;
import js7.cluster.PassiveClusterNode;
import js7.cluster.WorkingClusterNode;
import js7.cluster.WorkingClusterNode$;
import js7.core.license.LicenseChecker;
import js7.data.Problems$ClusterNodeIsNotActiveProblem$;
import js7.data.Problems$ClusterNodeIsNotBackupProblem$;
import js7.data.Problems$PassiveClusterNodeResetProblem$;
import js7.data.cluster.ClusterCommand;
import js7.data.cluster.ClusterCommand$ClusterConfirmCoupling$;
import js7.data.cluster.ClusterCommand$ClusterInhibitActivation$;
import js7.data.cluster.ClusterCommand$ClusterInhibitActivation$Response$;
import js7.data.cluster.ClusterCommand$Response$Accepted$;
import js7.data.cluster.ClusterNodeApi;
import js7.data.cluster.ClusterState;
import js7.data.cluster.ClusterWatchRequest;
import js7.data.cluster.ClusterWatchingCommand;
import js7.data.event.ClusterableState;
import js7.data.event.Event;
import js7.data.event.KeyedEvent;
import js7.data.event.Stamped;
import js7.data.node.NodeId;
import js7.data.node.NodeNameToPassword;
import js7.journal.EventIdGenerator;
import js7.journal.data.JournalLocation;
import js7.journal.recover.Recovered;
import org.apache.pekko.actor.ActorRefFactory;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.util.Timeout;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.Seq;
import scala.concurrent.Promise;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NoStackTrace;
import sourcecode.Name$;

public final class ClusterNode<S extends ClusterableState<S>>
implements Service.StoppableByRequest {
    private AtomicBoolean js7$base$service$Service$$started;
    private Deferred js7$base$service$Service$$stopped;
    private boolean stoppableByCancel;
    private Deferred js7$base$service$StoppableByRequest$$fiber;
    private Deferred js7$base$service$StoppableByRequest$$stopRequested;
    private volatile boolean js7$base$service$StoppableByRequest$$_isStopping;
    private IO js7$base$service$StoppableByRequest$$memoizedStop;
    private final Prepared<S> prepared;
    private final AtomicReference<Option<Either<PassiveClusterNode<S>, Allocated<IO, WorkingClusterNode<S>>>>> passiveOrWorkingNode;
    private final Ref<IO, IO<Either<Problem, S>>> currentStateRef;
    private final ClusterConf clusterConf;
    private final EventIdGenerator eventIdGenerator;
    private final EventPublisher<Stamped<KeyedEvent<Event>>> eventBus;
    private final ClusterCommon common;
    private final Deferred<IO, BoxedUnit> shuttingDown;
    private final Recovered.Extract recoveredExtract;
    private final ActorSystem actorSystem;
    private final Tag<S> evidence$1;
    private final ClusterableState.Companion<S> S;
    private final NodeNameToPassword<S> nodeNameToPassword;
    private final IORuntime ioRuntime;
    private final Timeout timeout;
    private final Deferred<IO, Try<Either<ProgramTermination, WorkingClusterNode<S>>>> workingNodeStarted;
    private boolean _dontNotifyActiveNodeAboutShutdown;
    private final IO<Either<Problem, S>> currentState;

    public static <S extends ClusterableState<S>> Resource<IO, ClusterNode<S>> recoveringResource(Resource<IO, ActorSystem> resource, Function3<Admission, String, ActorSystem, Resource<IO, ClusterNodeApi>> function3, LicenseChecker licenseChecker, JournalLocation journalLocation, ClusterConf clusterConf, EventIdGenerator eventIdGenerator, EventPublisher<Object> eventPublisher, Tag<S> tag, ClusterableState.Companion<S> companion, NodeNameToPassword<S> nodeNameToPassword, IORuntime iORuntime, Timeout timeout) {
        return ClusterNode$.MODULE$.recoveringResource(resource, function3, licenseChecker, journalLocation, clusterConf, eventIdGenerator, eventPublisher, tag, companion, nodeNameToPassword, iORuntime, timeout);
    }

    public ClusterNode(Prepared<S> prepared, AtomicReference<Option<Either<PassiveClusterNode<S>, Allocated<IO, WorkingClusterNode<S>>>>> passiveOrWorkingNode, Ref<IO, IO<Either<Problem, S>>> currentStateRef, ClusterConf clusterConf, EventIdGenerator eventIdGenerator, EventPublisher<Stamped<KeyedEvent<Event>>> eventBus, ClusterCommon common, Deferred<IO, BoxedUnit> shuttingDown, Recovered.Extract recoveredExtract, ActorSystem actorSystem, Tag<S> evidence$1, ClusterableState.Companion<S> S, NodeNameToPassword<S> nodeNameToPassword, IORuntime ioRuntime, Timeout timeout) {
        this.prepared = prepared;
        this.passiveOrWorkingNode = passiveOrWorkingNode;
        this.currentStateRef = currentStateRef;
        this.clusterConf = clusterConf;
        this.eventIdGenerator = eventIdGenerator;
        this.eventBus = eventBus;
        this.common = common;
        this.shuttingDown = shuttingDown;
        this.recoveredExtract = recoveredExtract;
        this.actorSystem = actorSystem;
        this.evidence$1 = evidence$1;
        this.S = S;
        this.nodeNameToPassword = nodeNameToPassword;
        this.ioRuntime = ioRuntime;
        this.timeout = timeout;
        Service.$init$(this);
        StoppableByRequest.$init$(this);
        this.workingNodeStarted = package$.MODULE$.Deferred().unsafe(IO$.MODULE$.asyncForIO());
        this._dontNotifyActiveNodeAboutShutdown = false;
        this.currentState = ((IO)currentStateRef.get()).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
        Statics.releaseFence();
    }

    @Override
    public AtomicBoolean js7$base$service$Service$$started() {
        return this.js7$base$service$Service$$started;
    }

    public Deferred js7$base$service$Service$$stopped() {
        return this.js7$base$service$Service$$stopped;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$started_$eq(AtomicBoolean x$0) {
        this.js7$base$service$Service$$started = x$0;
    }

    @Override
    public void js7$base$service$Service$_setter_$js7$base$service$Service$$stopped_$eq(Deferred x$0) {
        this.js7$base$service$Service$$stopped = x$0;
    }

    @Override
    public boolean stoppableByCancel() {
        return this.stoppableByCancel;
    }

    public final Deferred js7$base$service$StoppableByRequest$$fiber() {
        return this.js7$base$service$StoppableByRequest$$fiber;
    }

    public Deferred js7$base$service$StoppableByRequest$$stopRequested() {
        return this.js7$base$service$StoppableByRequest$$stopRequested;
    }

    @Override
    public boolean js7$base$service$StoppableByRequest$$_isStopping() {
        return this.js7$base$service$StoppableByRequest$$_isStopping;
    }

    public IO js7$base$service$StoppableByRequest$$memoizedStop() {
        return this.js7$base$service$StoppableByRequest$$memoizedStop;
    }

    @Override
    public void js7$base$service$StoppableByRequest$$_isStopping_$eq(boolean x$1) {
        this.js7$base$service$StoppableByRequest$$_isStopping = x$1;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$stoppableByCancel_$eq(boolean x$0) {
        this.stoppableByCancel = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$fiber_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$fiber = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$stopRequested_$eq(Deferred x$0) {
        this.js7$base$service$StoppableByRequest$$stopRequested = x$0;
    }

    @Override
    public void js7$base$service$StoppableByRequest$_setter_$js7$base$service$StoppableByRequest$$memoizedStop_$eq(IO x$0) {
        this.js7$base$service$StoppableByRequest$$memoizedStop = x$0;
    }

    public ClusterConf clusterConf() {
        return this.clusterConf;
    }

    public Recovered.Extract recoveredExtract() {
        return this.recoveredExtract;
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public IO<Either<Problem, S>> currentState() {
        return this.currentState;
    }

    public IO<Either<ProgramTermination, WorkingClusterNode<S>>> untilActivated() {
        return Logger$syntax$.MODULE$.traceIOWithResult(ClusterNode$.js7$cluster$ClusterNode$$$logger, "untilActivated", ((IO)MonixLikeExtensions$.MODULE$.dematerialize(this.workingNodeStarted.get(), IO$.MODULE$.asyncForIO(), $less$colon$less$.MODULE$.refl())).recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x2) {
                Throwable throwable = x2;
                if (throwable instanceof RestartAfterJournalTruncationException) {
                    RestartAfterJournalTruncationException t = (RestartAfterJournalTruncationException)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x2, Function1 function1) {
                Throwable throwable = x2;
                if (throwable instanceof RestartAfterJournalTruncationException) {
                    RestartAfterJournalTruncationException t = (RestartAfterJournalTruncationException)throwable;
                    Logger LoggerImpl_this = ClusterNode$.js7$cluster$ClusterNode$$$logger;
                    if (LoggerImpl_this.underlying().isInfoEnabled()) {
                        LoggerImpl_this.underlying().info(t.getMessage());
                    }
                    return scala.package$.MODULE$.Left().apply((Object)ProgramTermination$Restart$.MODULE$);
                }
                return function1.apply((Object)x2);
            }
        }));
    }

    @Override
    public IO<Service.Started> start() {
        return this.startService((IO)this.run());
    }

    private IO<BoxedUnit> run() {
        return CatsEffectExtensions$.MODULE$.guaranteeCaseLazy(this.untilWorkingNodeStarted().recover((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Throwable x2) {
                Problem problem;
                Problem problem2;
                Throwable throwable = x2;
                Option<Problem> option = ProblemException$.MODULE$.unapply(throwable);
                if (!option.isEmpty() && ((Object)Problems$PassiveClusterNodeResetProblem$.MODULE$).equals(problem2 = (problem = (Problem)option.get()))) {
                    Problem prblm = problem2;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x2, Function1 function1) {
                Problem problem;
                Problem problem2;
                Option<Problem> option;
                Throwable throwable = x2;
                if (throwable != null && !(option = ProblemException$.MODULE$.unapply(throwable)).isEmpty() && ((Object)Problems$PassiveClusterNodeResetProblem$.MODULE$).equals(problem2 = (problem = (Problem)option.get()))) {
                    Problem prblm = problem2;
                    Logger LoggerImpl_this = ClusterNode$.js7$cluster$ClusterNode$$$logger;
                    if (LoggerImpl_this.underlying().isDebugEnabled()) {
                        LoggerImpl_this.underlying().debug(prblm.toString());
                    }
                    return BoxedUnit.UNIT;
                }
                return function1.apply((Object)x2);
            }
        }).start().flatMap((Function1 & Serializable)fiber -> IO$.MODULE$.race((IO)this.shuttingDown.get(), (IO)CatsEffectExtensions$.MODULE$.joinStd(fiber, IO$.MODULE$.asyncForIO()))).$times$greater(this.untilStopRequested()), (Function1 & Serializable)outcome -> Logger$syntax$.MODULE$.debugIO(ClusterNode$.js7$cluster$ClusterNode$$$logger, "run guarantee", (Function0<Object>)((Function0 & Serializable)() -> ClusterNode.run$$anonfun$2$$anonfun$1(outcome)), this.onShutdown(ProgramTermination$.MODULE$.apply(ProgramTermination$.MODULE$.apply$default$1()), this.onShutdown$default$2()).$times$greater(IO$.MODULE$.defer(() -> this.run$$anonfun$2$$anonfun$2(outcome)))));
    }

    private IO<BoxedUnit> stopWorkingClusterNode() {
        return Logger$syntax$.MODULE$.traceIO(ClusterNode$.js7$cluster$ClusterNode$$$logger, ((IO)this.workingNodeStarted.get()).timeoutTo((Duration)ScalaTime$DurationRichInt$.MODULE$.ms$extension(ScalaTime$.MODULE$.DurationRichInt(10)), IO$.MODULE$.none()).flatMap((Function1 & Serializable)x$1 -> {
            Either either;
            Serializable serializable = x$1;
            if (serializable instanceof Success && (either = (Either)((Success)serializable).value()) instanceof Right) {
                WorkingClusterNode workingClusterNode = (WorkingClusterNode)((Right)either).value();
                IO<BoxedUnit> iO = workingClusterNode.stop();
                return CatsUtils$syntax$.MODULE$.logWhenItTakesLonger(iO, (Function0<String>)((Function0 & Serializable)ClusterNode::stopWorkingClusterNode$$anonfun$1$$anonfun$1), CatsUtils$syntax$.MODULE$.logWhenItTakesLonger$default$3(iO));
            }
            return IO$.MODULE$.unit();
        }), Name$.MODULE$.apply("stopWorkingClusterNode"));
    }

    private IO<BoxedUnit> untilWorkingNodeStarted() {
        return Logger$syntax$.MODULE$.debugIO(ClusterNode$.js7$cluster$ClusterNode$$$logger, ((IO)MonixLikeExtensions$.MODULE$.dematerialize(((IO)MonixLikeExtensions$.MODULE$.materialize(this.untilRecovered().flatMap((Function1 & Serializable)recovered -> this.startWorkingNode((Recovered<S>)recovered)), IO$.MODULE$.asyncForIO())).flatTap((Function1 & Serializable)triedWorkingNode -> {
            Success success;
            Try try_ = triedWorkingNode;
            if (try_ instanceof Failure) {
                Problem problem;
                Throwable throwable = ((Failure)try_).exception();
                Option<Problem> option = ProblemException$.MODULE$.unapply(throwable);
                if (!option.isEmpty() && ((Object)Problems$PassiveClusterNodeResetProblem$.MODULE$).equals(problem = (Problem)option.get())) {
                    Throwable prblm = throwable;
                    Logger LoggerImpl_this = ClusterNode$.js7$cluster$ClusterNode$$$logger;
                    if (LoggerImpl_this.underlying().isWarnEnabled()) {
                        LoggerImpl_this.underlying().warn("Should restart after {}", (Object)prblm);
                    }
                    success = Success$.MODULE$.apply((Object)scala.package$.MODULE$.Left().apply((Object)ProgramTermination$.MODULE$.apply(true)));
                } else {
                    Throwable t = throwable;
                    success = Failure$.MODULE$.apply(t);
                }
            } else if (try_ instanceof Success) {
                WorkingClusterNode o = (WorkingClusterNode)((Success)try_).value();
                success = Success$.MODULE$.apply((Object)scala.package$.MODULE$.Right().apply((Object)o));
            } else {
                throw new MatchError((Object)try_);
            }
            return ((IO)this.workingNodeStarted.complete((Object)success)).attempt();
        }), IO$.MODULE$.asyncForIO(), $less$colon$less$.MODULE$.refl())).flatMap((Function1 & Serializable)workingNode -> (IO)this.currentStateRef.set((Object)workingNode.journal().state().map((Function1 & Serializable)_$1 -> scala.package$.MODULE$.Right().apply(_$1)))), Name$.MODULE$.apply("untilWorkingNodeStarted"));
    }

    private IO<Recovered<S>> untilRecovered() {
        return Logger$syntax$.MODULE$.debugIO(ClusterNode$.js7$cluster$ClusterNode$$$logger, this.prepared.untilRecovered().map((Function1 & Serializable)_$2 -> {
            Either either = ScalaUtils$syntax$.MODULE$.RichEither(_$2);
            return (Recovered)ScalaUtils$syntax$RichEither$.MODULE$.orThrowWithoutOurStackTrace$extension(either);
        }).flatTap((Function1 & Serializable)recovered -> IO$.MODULE$.raiseUnless(recovered.clusterState().isEmptyOrActive(this.clusterConf().ownId()), () -> this.untilRecovered$$anonfun$2$$anonfun$1(recovered))), Name$.MODULE$.apply("untilRecovered"));
    }

    public IO<BoxedUnit> onShutdown(ProgramTermination termination, boolean dontNotifyActiveNode) {
        return IO$.MODULE$.defer(() -> this.onShutdown$$anonfun$1(dontNotifyActiveNode, termination));
    }

    public boolean onShutdown$default$2() {
        return false;
    }

    private IO<WorkingClusterNode<S>> startWorkingNode(Recovered<S> recovered) {
        Resource resource = CatsUtils$syntax$.MODULE$.RichResource(WorkingClusterNode$.MODULE$.resource(recovered, this.common, this.clusterConf(), this.eventIdGenerator, this.eventBus, this.S, this.evidence$1, this.nodeNameToPassword, this.ioRuntime, (ActorRefFactory)this.actorSystem(), this.timeout));
        return Logger$syntax$.MODULE$.traceIO(ClusterNode$.js7$cluster$ClusterNode$$$logger, ((IO)CatsUtils$syntax$RichResource$.MODULE$.toLabeledAllocated$extension(resource, "WorkingClusterNode[" + ((Tag)Predef$.MODULE$.implicitly(this.evidence$1)).tag().shortName() + "]", IO$.MODULE$.asyncForIO(), UnsafeMemoizable$.MODULE$.given_UnsafeMemoizable_F(IO$.MODULE$.asyncForIO()))).flatTap((Function1 & Serializable)allocated -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
            this.startWorkingNode$$anonfun$1$$anonfun$1((Allocated)allocated);
            return BoxedUnit.UNIT;
        })).map((Function1 & Serializable)_$3 -> (WorkingClusterNode)_$3.allocatedThing()), Name$.MODULE$.apply("startWorkingNode"));
    }

    public Either<Problem, WorkingClusterNode<S>> workingClusterNode() {
        return this.passiveOrWorkingNode.get().flatMap((Function1 & Serializable)_$4 -> _$4.toOption()).map((Function1 & Serializable)_$5 -> (WorkingClusterNode)_$5.allocatedThing()).toRight(ClusterNode::workingClusterNode$$anonfun$3);
    }

    public IO<Either<Problem, ClusterCommand.Response>> executeCommand(ClusterCommand command) {
        IO iO;
        String string = "executeCommand " + command.toShortString();
        Function0 & Serializable intersect = ClusterNode::executeCommand$$anonfun$1;
        ClusterCommand clusterCommand = command;
        if (clusterCommand instanceof ClusterCommand.ClusterStartBackupNode) {
            ClusterCommand.ClusterStartBackupNode command2 = (ClusterCommand.ClusterStartBackupNode)clusterCommand;
            iO = IO$.MODULE$.apply(() -> this.executeCommand$$anonfun$2(command2));
        } else if (clusterCommand instanceof ClusterCommand.ClusterConfirmCoupling) {
            OneTimeToken oneTimeToken;
            ClusterCommand.ClusterConfirmCoupling clusterConfirmCoupling = ClusterCommand$ClusterConfirmCoupling$.MODULE$.unapply((ClusterCommand.ClusterConfirmCoupling)clusterCommand);
            OneTimeToken token = oneTimeToken = clusterConfirmCoupling._1();
            IO iO2 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.apply(() -> this.executeCommand$$anonfun$3(token)));
            iO = (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.rightAs$extension((Object)iO2, ClusterNode::executeCommand$$anonfun$4, IO$.MODULE$.asyncForIO());
        } else if (clusterCommand instanceof ClusterCommand.ClusterInhibitActivation) {
            FiniteDuration finiteDuration;
            ClusterCommand.ClusterInhibitActivation clusterInhibitActivation = ClusterCommand$ClusterInhibitActivation$.MODULE$.unapply((ClusterCommand.ClusterInhibitActivation)clusterCommand);
            FiniteDuration duration = finiteDuration = clusterInhibitActivation._1();
            IO iO3 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(this.common.activationInhibitor().inhibitActivation(duration));
            iO = (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO3, (Function1 & Serializable)inhibited -> this.executeCommand$$anonfun$5(duration, BoxesRunTime.unboxToBoolean((Object)inhibited)), IO$.MODULE$.asyncForIO());
        } else if (clusterCommand instanceof ClusterCommand.ClusterPrepareCoupling || clusterCommand instanceof ClusterCommand.ClusterCouple || clusterCommand instanceof ClusterCommand.ClusterRecouple || clusterCommand instanceof ClusterCommand.ClusterPassiveDown) {
            if (this._dontNotifyActiveNodeAboutShutdown) {
                iO = CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> ClusterNode.executeCommand$$anonfun$6(command)), Problem$.MODULE$.apply$default$2()));
            } else {
                IO iO4 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.pure(this.workingClusterNode()));
                iO = (IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO4, (Function1 & Serializable)_$9 -> _$9.executeCommand(command), IO$.MODULE$.asyncForIO());
            }
        } else {
            throw new MatchError((Object)clusterCommand);
        }
        return Logger$syntax$.MODULE$.infoIO(ClusterNode$.js7$cluster$ClusterNode$$$logger, string, (Function0<Object>)intersect, iO);
    }

    public IO<Either<Problem, BoxedUnit>> executeClusterWatchingCommand(ClusterWatchingCommand command) {
        ClusterWatchingCommand clusterWatchingCommand = command;
        if (clusterWatchingCommand instanceof ClusterWatchingCommand.ClusterWatchConfirm) {
            ClusterWatchingCommand.ClusterWatchConfirm cmd = (ClusterWatchingCommand.ClusterWatchConfirm)clusterWatchingCommand;
            return IO$.MODULE$.apply(this::executeClusterWatchingCommand$$anonfun$1).flatMap((Function1 & Serializable)x$1 -> {
                Either either;
                Option option = x$1;
                if (option instanceof Some && (either = (Either)((Some)option).value()) instanceof Right) {
                    Allocated workingClusterNodeAllocated = (Allocated)((Right)either).value();
                    return ((WorkingClusterNode)workingClusterNodeAllocated.allocatedThing()).executeClusterWatchConfirm(cmd);
                }
                return this.common.clusterWatchCounterpart().executeClusterWatchConfirm(cmd);
            }).flatTap((Function1 & Serializable)result -> IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.executeClusterWatchingCommand$$anonfun$3$$anonfun$1(cmd, (Either)result);
                return BoxedUnit.UNIT;
            }));
        }
        throw new MatchError((Object)clusterWatchingCommand);
    }

    public Stream<IO, ClusterWatchRequest> clusterWatchRequestStream() {
        return this.common.clusterWatchCounterpart().newStream();
    }

    public boolean isWorkingNode() {
        return this.passiveOrWorkingNode.get().exists((Function1 & Serializable)_$10 -> _$10.isRight());
    }

    public boolean isPassive() {
        return this.passiveOrWorkingNode.get().exists((Function1 & Serializable)_$11 -> _$11.isLeft());
    }

    public String toString() {
        return "ClusterNode(" + this.clusterConf().ownId().string() + ")";
    }

    private static final Object run$$anonfun$2$$anonfun$1(Outcome outcome$1) {
        return outcome$1;
    }

    private final IO run$$anonfun$2$$anonfun$2(Outcome outcome$2) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.passiveOrWorkingNode.get(), (Object)outcome$2);
        Option option = (Option)tuple2._1();
        if (option instanceof Some) {
            Either either = (Either)((Some)option).value();
            if (either instanceof Left) {
                PassiveClusterNode passiveClusterNode = (PassiveClusterNode)((Left)either).value();
                if (tuple2._2() instanceof Outcome.Succeeded) {
                    package$.MODULE$.Outcome();
                    Outcome.Succeeded succeeded = Outcome.Succeeded$.MODULE$.unapply((Outcome.Succeeded)tuple2._2());
                    IO iO = (IO)succeeded._1();
                    return passiveClusterNode.onShutdown(this._dontNotifyActiveNodeAboutShutdown);
                }
            }
            if (either instanceof Right) {
                Allocated workingClusterNodeAllocated = (Allocated)((Right)either).value();
                return (IO)workingClusterNodeAllocated.release();
            }
        }
        return IO$.MODULE$.unit();
    }

    private static final String stopWorkingClusterNode$$anonfun$1$$anonfun$1() {
        return "workingClusterNode.stop";
    }

    private final Throwable untilRecovered$$anonfun$2$$anonfun$1(Recovered recovered$1) {
        return new IllegalStateException("Controller has recovered from Journal but is not the " + ("active node in ClusterState: id=" + this.clusterConf().ownId() + ", failedOver=" + recovered$1.clusterState()));
    }

    private final IO onShutdown$$anonfun$1(boolean dontNotifyActiveNode$1, ProgramTermination termination$1) {
        Logger LoggerImpl_this = ClusterNode$.js7$cluster$ClusterNode$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace("onShutdown");
        }
        if (dontNotifyActiveNode$1) {
            this._dontNotifyActiveNodeAboutShutdown = true;
        }
        return ((IO)this.shuttingDown.complete((Object)BoxedUnit.UNIT)).attempt().$times$greater(((IO)this.workingNodeStarted.complete((Object)Success$.MODULE$.apply((Object)scala.package$.MODULE$.Left().apply((Object)termination$1)))).attempt().void());
    }

    private final void startWorkingNode$$anonfun$1$$anonfun$1(Allocated allocated$1) {
        Atomic$package$Atomic$extensions$.MODULE$.$colon$eq(this.passiveOrWorkingNode, Some$.MODULE$.apply((Object)scala.package$.MODULE$.Right().apply((Object)allocated$1)));
    }

    private static final Problems$ClusterNodeIsNotActiveProblem$ workingClusterNode$$anonfun$3() {
        return Problems$ClusterNodeIsNotActiveProblem$.MODULE$;
    }

    private static final Object executeCommand$$anonfun$1() {
        return Logger$syntax$.MODULE$.infoIO$default$3(ClusterNode$.js7$cluster$ClusterNode$$$logger);
    }

    private final Either executeCommand$$anonfun$2(ClusterCommand.ClusterStartBackupNode command$1) {
        Option<Promise<ClusterCommand.ClusterStartBackupNode>> option = this.prepared.expectingStartBackupCommand();
        if (None$.MODULE$.equals(option)) {
            if (!this.clusterConf().isBackup()) {
                return scala.package$.MODULE$.Left().apply((Object)Problems$ClusterNodeIsNotBackupProblem$.MODULE$);
            }
            return scala.package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure("Cluster node is not ready to accept a backup node configuration"));
        }
        if (option instanceof Some) {
            Promise promise = (Promise)((Some)option).value();
            NodeId nodeId = command$1.setting().passiveId();
            NodeId nodeId2 = this.clusterConf().ownId();
            if (nodeId == null ? nodeId2 != null : !((Object)nodeId).equals(nodeId2)) {
                return scala.package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure(command$1 + " sent to wrong " + this.clusterConf().ownId()));
            }
            NodeId nodeId3 = command$1.setting().activeId();
            NodeId nodeId4 = this.clusterConf().ownId();
            if (!(nodeId3 != null ? !((Object)nodeId3).equals(nodeId4) : nodeId4 != null)) {
                return scala.package$.MODULE$.Left().apply((Object)Problem$.MODULE$.pure(command$1 + " must not be sent to the active node"));
            }
            promise.trySuccess((Object)command$1);
            return scala.package$.MODULE$.Right().apply((Object)ClusterCommand$Response$Accepted$.MODULE$);
        }
        throw new MatchError(option);
    }

    private static final String executeCommand$$anonfun$3$$anonfun$1() {
        return "Not a passive cluster node";
    }

    private final Either executeCommand$$anonfun$3(OneTimeToken token$1) {
        Either either;
        Option<Either<PassiveClusterNode<S>, Allocated<IO, WorkingClusterNode<S>>>> option = this.passiveOrWorkingNode.get();
        if (option instanceof Some && (either = (Either)((Some)option).value()) instanceof Left) {
            PassiveClusterNode passive = (PassiveClusterNode)((Left)either).value();
            return passive.confirmCoupling(token$1);
        }
        return scala.package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)ClusterNode::executeCommand$$anonfun$3$$anonfun$1), Problem$.MODULE$.apply$default$2()));
    }

    private static final ClusterCommand$Response$Accepted$ executeCommand$$anonfun$4() {
        return ClusterCommand$Response$Accepted$.MODULE$;
    }

    private final /* synthetic */ IO executeCommand$$anonfun$5(FiniteDuration duration$1, boolean inhibited) {
        if (inhibited) {
            return IO$.MODULE$.pure((Object)scala.package$.MODULE$.Right().apply((Object)ClusterCommand$ClusterInhibitActivation$Response$.MODULE$.apply((Option<ClusterState.FailedOver>)None$.MODULE$)));
        }
        return ((IO)MonixLikeExtensions$.MODULE$.dematerialize(this.workingNodeStarted.get(), IO$.MODULE$.asyncForIO(), $less$colon$less$.MODULE$.refl())).flatMap((Function1 & Serializable)_$6 -> (IO)package.traverse$.MODULE$.toTraverseOps(_$6, UnorderedFoldable$.MODULE$.catsTraverseForEither()).traverse((Function1 & Serializable)_$7 -> _$7.journal().clusterState(), (Applicative)IO$.MODULE$.asyncForIO())).map((Function1 & Serializable)_$8 -> Some$.MODULE$.apply(_$8)).timeoutTo((Duration)duration$1.$minus(ScalaTime$DurationRichInt$.MODULE$.ms$extension(ScalaTime$.MODULE$.DurationRichInt(500))), IO$.MODULE$.none()).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.pure("ClusterInhibitActivation timed out \u2014 please try again"));
            }
            if (option instanceof Some) {
                Either either = (Either)((Some)option).value();
                if (either instanceof Left && ((Left)either).value() != null) {
                    return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.pure("ClusterInhibitActivation command failed due to cluster is being terminated"));
                }
                if (either instanceof Right) {
                    ClusterState clusterState = (ClusterState)((Right)either).value();
                    if (clusterState instanceof ClusterState.FailedOver) {
                        ClusterState.FailedOver failedOver = (ClusterState.FailedOver)clusterState;
                        Logger LoggerImpl_this = ClusterNode$.js7$cluster$ClusterNode$$$logger;
                        if (LoggerImpl_this.underlying().isDebugEnabled()) {
                            LoggerImpl_this.underlying().debug("inhibitActivation({}) => {}", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(duration$1)), failedOver}), Object.class));
                        }
                        return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, ClusterCommand$ClusterInhibitActivation$Response$.MODULE$.apply((Option<ClusterState.FailedOver>)Some$.MODULE$.apply((Object)failedOver)));
                    }
                    ClusterState clusterState2 = clusterState;
                    return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, Problem$.MODULE$.pure("ClusterInhibitActivation command failed " + ("because node is already active but not failed-over: " + clusterState2)));
                }
            }
            throw new MatchError((Object)option);
        });
    }

    private static final String executeCommand$$anonfun$6(ClusterCommand command$2) {
        return ScalaUtils$syntax$.MODULE$.RichJavaClass(command$2.getClass()).simpleScalaName() + " command rejected due to dontNotifyActiveNode";
    }

    private final Option executeClusterWatchingCommand$$anonfun$1() {
        return this.passiveOrWorkingNode.get();
    }

    private final void executeClusterWatchingCommand$$anonfun$3$$anonfun$1(ClusterWatchingCommand.ClusterWatchConfirm cmd$3, Either result$1) {
        this.common.testEventBus().publish(ClusterNode$ClusterWatchConfirmed$.MODULE$.apply(cmd$3, (Either<Problem, BoxedUnit>)result$1));
    }

    public static final class ClusterWatchConfirmed
    implements Product,
    Serializable {
        private final ClusterWatchingCommand.ClusterWatchConfirm command;
        private final Either<Problem, BoxedUnit> result;

        public static ClusterWatchConfirmed apply(ClusterWatchingCommand.ClusterWatchConfirm clusterWatchConfirm, Either<Problem, BoxedUnit> either) {
            return ClusterNode$ClusterWatchConfirmed$.MODULE$.apply(clusterWatchConfirm, either);
        }

        public static ClusterWatchConfirmed fromProduct(Product product) {
            return ClusterNode$ClusterWatchConfirmed$.MODULE$.fromProduct(product);
        }

        public static ClusterWatchConfirmed unapply(ClusterWatchConfirmed clusterWatchConfirmed) {
            return ClusterNode$ClusterWatchConfirmed$.MODULE$.unapply(clusterWatchConfirmed);
        }

        public ClusterWatchConfirmed(ClusterWatchingCommand.ClusterWatchConfirm command, Either<Problem, BoxedUnit> result) {
            this.command = command;
            this.result = result;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ClusterWatchConfirmed)) return false;
            ClusterWatchConfirmed clusterWatchConfirmed = (ClusterWatchConfirmed)object;
            ClusterWatchingCommand.ClusterWatchConfirm clusterWatchConfirm = this.command();
            ClusterWatchingCommand.ClusterWatchConfirm clusterWatchConfirm2 = clusterWatchConfirmed.command();
            if (clusterWatchConfirm == null) {
                if (clusterWatchConfirm2 != null) {
                    return false;
                }
            } else if (!((Object)clusterWatchConfirm).equals(clusterWatchConfirm2)) return false;
            Either<Problem, BoxedUnit> either = this.result();
            Either<Problem, BoxedUnit> either2 = clusterWatchConfirmed.result();
            if (either == null) {
                if (either2 == null) return true;
                return false;
            } else {
                if (!either.equals(either2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ClusterWatchConfirmed;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ClusterWatchConfirmed";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "command";
            }
            if (1 == n2) {
                return "result";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ClusterWatchingCommand.ClusterWatchConfirm command() {
            return this.command;
        }

        public Either<Problem, BoxedUnit> result() {
            return this.result;
        }

        public ClusterWatchConfirmed copy(ClusterWatchingCommand.ClusterWatchConfirm command, Either<Problem, BoxedUnit> result) {
            return new ClusterWatchConfirmed(command, result);
        }

        public ClusterWatchingCommand.ClusterWatchConfirm copy$default$1() {
            return this.command();
        }

        public Either<Problem, BoxedUnit> copy$default$2() {
            return this.result();
        }

        public ClusterWatchingCommand.ClusterWatchConfirm _1() {
            return this.command();
        }

        public Either<Problem, BoxedUnit> _2() {
            return this.result();
        }
    }

    public static final class Prepared<S extends ClusterableState<S>>
    implements Product,
    Serializable {
        private final IO<Option<Either<Problem, S>>> currentPassiveReplicatedState;
        private final IO<Either<Problem, Recovered<S>>> untilRecovered;
        private final Option<Promise<ClusterCommand.ClusterStartBackupNode>> expectingStartBackupCommand;

        public static <S extends ClusterableState<S>> Prepared<S> apply(IO<Option<Either<Problem, S>>> iO, IO<Either<Problem, Recovered<S>>> iO2, Option<Promise<ClusterCommand.ClusterStartBackupNode>> option) {
            return ClusterNode$Prepared$.MODULE$.apply(iO, iO2, option);
        }

        public static Prepared<?> fromProduct(Product product) {
            return ClusterNode$Prepared$.MODULE$.fromProduct(product);
        }

        public static <S extends ClusterableState<S>> Prepared<S> unapply(Prepared<S> prepared) {
            return ClusterNode$Prepared$.MODULE$.unapply(prepared);
        }

        public static <S extends ClusterableState<S>> Option<Promise<ClusterCommand.ClusterStartBackupNode>> $lessinit$greater$default$3() {
            return ClusterNode$Prepared$.MODULE$.$lessinit$greater$default$3();
        }

        public Prepared(IO<Option<Either<Problem, S>>> currentPassiveReplicatedState, IO<Either<Problem, Recovered<S>>> untilRecovered, Option<Promise<ClusterCommand.ClusterStartBackupNode>> expectingStartBackupCommand) {
            this.currentPassiveReplicatedState = currentPassiveReplicatedState;
            this.untilRecovered = untilRecovered;
            this.expectingStartBackupCommand = expectingStartBackupCommand;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Prepared)) return false;
            Prepared prepared = (Prepared)object;
            IO<Option<Either<Problem, S>>> iO = this.currentPassiveReplicatedState();
            IO<Option<Either<Problem, S>>> iO2 = prepared.currentPassiveReplicatedState();
            if (iO == null) {
                if (iO2 != null) {
                    return false;
                }
            } else if (!iO.equals(iO2)) return false;
            IO<Either<Problem, Recovered<S>>> iO3 = this.untilRecovered();
            IO<Either<Problem, Recovered<S>>> iO4 = prepared.untilRecovered();
            if (iO3 == null) {
                if (iO4 != null) {
                    return false;
                }
            } else if (!iO3.equals(iO4)) return false;
            Option<Promise<ClusterCommand.ClusterStartBackupNode>> option = this.expectingStartBackupCommand();
            Option<Promise<ClusterCommand.ClusterStartBackupNode>> option2 = prepared.expectingStartBackupCommand();
            if (option == null) {
                if (option2 == null) return true;
                return false;
            } else {
                if (!option.equals(option2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Prepared;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Prepared";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "currentPassiveReplicatedState";
                }
                case 1: {
                    return "untilRecovered";
                }
                case 2: {
                    return "expectingStartBackupCommand";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public IO<Option<Either<Problem, S>>> currentPassiveReplicatedState() {
            return this.currentPassiveReplicatedState;
        }

        public IO<Either<Problem, Recovered<S>>> untilRecovered() {
            return this.untilRecovered;
        }

        public Option<Promise<ClusterCommand.ClusterStartBackupNode>> expectingStartBackupCommand() {
            return this.expectingStartBackupCommand;
        }

        public <S extends ClusterableState<S>> Prepared<S> copy(IO<Option<Either<Problem, S>>> currentPassiveReplicatedState, IO<Either<Problem, Recovered<S>>> untilRecovered, Option<Promise<ClusterCommand.ClusterStartBackupNode>> expectingStartBackupCommand) {
            return new Prepared<S>(currentPassiveReplicatedState, untilRecovered, expectingStartBackupCommand);
        }

        public <S extends ClusterableState<S>> IO<Option<Either<Problem, S>>> copy$default$1() {
            return this.currentPassiveReplicatedState();
        }

        public <S extends ClusterableState<S>> IO<Either<Problem, Recovered<S>>> copy$default$2() {
            return this.untilRecovered();
        }

        public <S extends ClusterableState<S>> Option<Promise<ClusterCommand.ClusterStartBackupNode>> copy$default$3() {
            return this.expectingStartBackupCommand();
        }

        public IO<Option<Either<Problem, S>>> _1() {
            return this.currentPassiveReplicatedState();
        }

        public IO<Either<Problem, Recovered<S>>> _2() {
            return this.untilRecovered();
        }

        public Option<Promise<ClusterCommand.ClusterStartBackupNode>> _3() {
            return this.expectingStartBackupCommand();
        }
    }

    public static final class RestartAfterJournalTruncationException
    extends RuntimeException
    implements MainServiceTerminationException,
    NoStackTrace {
        public RestartAfterJournalTruncationException() {
            super("Restart after journal truncation");
            NoStackTrace.$init$((NoStackTrace)this);
        }

        public Throwable scala$util$control$NoStackTrace$$super$fillInStackTrace() {
            return super.fillInStackTrace();
        }

        @Override
        public ProgramTermination termination() {
            return ProgramTermination$Restart$.MODULE$;
        }
    }
}

