/*
 * Decompiled with CFR 0.152.
 */
package js7.core.item;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$CheckedOption$;
import js7.base.problem.Problem;
import js7.base.utils.Assertions$;
import js7.core.item.ItemPaths$AlienFileProblem$;
import js7.data.item.InventoryItemPath;
import js7.data.item.SourceType;
import js7.data.item.VersionedItemPath;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import sourcecode.FileName$;
import sourcecode.FullName$;
import sourcecode.Line$;
import sourcecode.Text;
import sourcecode.Text$;

public final class ItemPaths$
implements Serializable {
    public static final ItemPaths$AlienFileProblem$ AlienFileProblem;
    public static final ItemPaths$ MODULE$;

    private ItemPaths$() {
    }

    static {
        MODULE$ = new ItemPaths$();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ItemPaths$.class);
    }

    public <P extends InventoryItemPath> Either<Problem, P> fileToItemPath(Iterable<InventoryItemPath.Companion<P>> companions, Path directory, Path file) {
        return this.fileToItemPathAndSourceType(companions, directory, file).map((Function1 & Serializable)_$1 -> (InventoryItemPath)_$1._1());
    }

    public Either<Problem, VersionedItemPath> fileToVersionedItemPath(Iterable<VersionedItemPath.Companion<? extends VersionedItemPath>> companions, Path directory, Path file) {
        return this.fileToItemPathAndSourceType(companions, directory, file).map((Function1 & Serializable)_$2 -> (VersionedItemPath)_$2._1());
    }

    public Either<Problem, Tuple2<InventoryItemPath, SourceType>> fileToItemPathAndSourceType(Iterable<InventoryItemPath.Companion<? extends InventoryItemPath>> companions, Path directory, Path file) {
        Assertions$.MODULE$.assertThat((Text<Object>)Text$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)this.v$proxy1$1(file, directory)), "file.startsWith(directory)"), FullName$.MODULE$.apply("js7.core.item.ItemPaths.fileToItemPathAndSourceType"), FileName$.MODULE$.apply("ItemPaths.scala"), Line$.MODULE$.apply(31));
        Path relativePath = file.subpath(directory.getNameCount(), file.getNameCount());
        String string = this.fileToString(relativePath);
        Option option = Checked$.MODULE$.CheckedOption(companions.iterator().map((Function1 & Serializable)_$3 -> _$3.fromFile(string)).collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Option x2) {
                Option option = x2;
                if (option instanceof Some) {
                    Either o = (Either)((Some)option).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Option x2, Function1 function1) {
                Option option = x2;
                if (option instanceof Some) {
                    Either o = (Either)((Some)option).value();
                    return o;
                }
                return function1.apply((Object)x2);
            }
        }));
        return Checked$CheckedOption$.MODULE$.toChecked$extension(option, (Function0<Problem>)((Function0 & Serializable)() -> ItemPaths$.fileToItemPathAndSourceType$$anonfun$2(relativePath, companions))).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private String fileToString(Path file) {
        return file.toString().replace(file.getFileSystem().getSeparator().charAt(0), '/');
    }

    public Function0<String> js7$core$item$ItemPaths$$$AlienFileProblem$superArg$1(Path relativePath, Set<InventoryItemPath.Companion<? extends InventoryItemPath>> companions) {
        return () -> ItemPaths$.AlienFileProblem$superArg$1$$anonfun$1(relativePath, companions);
    }

    private final boolean v$proxy1$1(Path file$1, Path directory$1) {
        return file$1.startsWith(directory$1);
    }

    private static final Problem fileToItemPathAndSourceType$$anonfun$2(Path relativePath$1, Iterable companions$1) {
        return ItemPaths$AlienFileProblem$.MODULE$.apply(relativePath$1, (Set<InventoryItemPath.Companion<? extends InventoryItemPath>>)companions$1.toSet());
    }

    private static final String AlienFileProblem$superArg$1$$anonfun$1(Path relativePath$2, Set companions$2) {
        return "File '..." + File.separator + StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(relativePath$2.toString()), File.separator) + "' is not recognized as a configuration file (like " + ((IterableOnceOps)((IterableOps)companions$2.flatMap((Function1 & Serializable)_$4 -> _$4.sourceTypeToFilenameExtension().values())).map((Function1 & Serializable)_$5 -> "*" + _$5)).mkString(", ") + ")";
    }
}

