/*
 * Decompiled with CFR 0.152.
 */
package js7.data.board;

import cats.Applicative;
import cats.Invariant$;
import cats.UnorderedFoldable$;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import js7.base.problem.Problem;
import js7.base.time.WallClock;
import js7.base.utils.Collections$implicits$;
import js7.base.utils.Collections$implicits$RichIterable$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichScalaUtilsMap$;
import js7.data.board.BoardItem;
import js7.data.board.BoardPath;
import js7.data.board.BoardState$;
import js7.data.board.GlobalBoard;
import js7.data.board.Notice;
import js7.data.board.NoticeEvent;
import js7.data.board.NoticeEvent$NoticeDeleted$;
import js7.data.board.NoticeEvent$NoticePosted$;
import js7.data.board.NoticeEventSource$;
import js7.data.board.PlannableBoard;
import js7.data.controller.ControllerCommand;
import js7.data.controller.ControllerState;
import js7.data.event.Event;
import js7.data.event.KeyedEvent;
import js7.data.item.InventoryItemState;
import js7.data.order.FreshOrder;
import js7.data.order.Order;
import js7.data.order.Order$Ready$;
import js7.data.order.OrderEvent;
import js7.data.plan.PlanId;
import js7.data.plan.PlanSchemaState;
import js7.data.value.expression.Scope;
import js7.data.value.expression.scopes.NowScope$;
import js7.data.workflow.Workflow;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.util.Either;
import scala.util.Right;
import sourcecode.FileName$;
import sourcecode.Line$;

public final class NoticeEventSource {
    private final WallClock clock;

    public static Either<Problem, List<OrderEvent.OrderNoticeAnnounced>> planToNoticeAnnounced(PlanId planId, FreshOrder freshOrder, Workflow workflow, ControllerState controllerState) {
        return NoticeEventSource$.MODULE$.planToNoticeAnnounced(planId, freshOrder, workflow, controllerState);
    }

    public NoticeEventSource(WallClock clock) {
        this.clock = clock;
    }

    public Either<Problem, List<KeyedEvent<OrderEvent.OrderActorEvent>>> postNotices(Vector<BoardPath> boardPaths, Order<Order$Ready$> order, ControllerState controllerState) {
        Vector vector = (Vector)Collections$implicits$.MODULE$.RichIterable(boardPaths);
        return Collections$implicits$RichIterable$.MODULE$.checkUniqueness$extension((Iterable)vector).flatMap((Function1 & Serializable)x$1 -> {
            Vector vector = x$1;
            MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(controllerState.keyTo((InventoryItemState.Companion)BoardState$.MODULE$));
            return ((Either)package.traverse$.MODULE$.toTraverseOps((Object)boardPaths, UnorderedFoldable$.MODULE$.catsTraverseForVector()).traverse((Function1 & Serializable)key -> ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, key, Tag$.MODULE$.apply(BoardPath.class, LightTypeTag$.MODULE$.parse(1326589135, "\u0004\u0000\u0001\u0018js7.data.board.BoardPath\u0001\u0001", "\u0000\u0007\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0018js7.data.board.BoardPath\u0001\u0001\n\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001cjs7.data.item.SimpleItemPath\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.UnsignedItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001$js7.data.item.UnsignedSimpleItemPath\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.UnsignedItemKey\u0001\u0001\u0004\u0000\u0001\u0090\f\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0002\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0006\u0004\u0000\u0001\u0090\f\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\n\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0001", 30)), FileName$.MODULE$.apply("NoticeEventSource.scala"), Line$.MODULE$.apply(29)), (Applicative)Invariant$.MODULE$.catsMonadErrorForEither())).flatMap((Function1 & Serializable)boardStates -> ((Either)package.traverse$.MODULE$.toTraverseOps(boardStates, UnorderedFoldable$.MODULE$.catsTraverseForVector()).traverse((Function1 & Serializable)boardState -> {
                BoardItem boardItem = boardState.board();
                if (boardItem instanceof GlobalBoard) {
                    GlobalBoard board = (GlobalBoard)boardItem;
                    return board.postingOrderToNotice(order, controllerState, this.clock.now());
                }
                if (boardItem instanceof PlannableBoard) {
                    PlannableBoard board = (PlannableBoard)boardItem;
                    return board.postingOrderToNotice(order, controllerState);
                }
                throw new MatchError((Object)boardItem);
            }, (Applicative)Invariant$.MODULE$.catsMonadErrorForEither())).map((Function1 & Serializable)notices -> {
                Vector<KeyedEvent<Serializable>> postingOrderEvents = NoticeEventSource$.MODULE$.js7$data$board$NoticeEventSource$$$toPostingOrderEvents((Vector<Notice>)notices, order);
                return Tuple2$.MODULE$.apply(notices, postingOrderEvents);
            }).flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                Vector notices = (Vector)tuple2._1();
                Vector postingOrderEvents = (Vector)tuple2._2();
                return NoticeEventSource$.MODULE$.js7$data$board$NoticeEventSource$$$toExpectingOrderEvents(order.planId(), (Vector<Notice>)notices, controllerState).map((Function1 & Serializable)expectingOrderEvents -> (List)expectingOrderEvents.toList().$plus$plus$colon((IterableOnce)postingOrderEvents));
            }));
        });
    }

    public Either<Problem, Seq<KeyedEvent<Event.IsKeyBase>>> executePostNoticeCommand(ControllerCommand.PostNotice postNotice, ControllerState controllerState) {
        Scope scope = NowScope$.MODULE$.apply(this.clock.now());
        MapOps mapOps = ScalaUtils$syntax$.MODULE$.RichScalaUtilsMap(controllerState.keyTo((InventoryItemState.Companion)BoardState$.MODULE$));
        return ScalaUtils$syntax$RichScalaUtilsMap$.MODULE$.checked$extension(mapOps, postNotice.noticeId().boardPath(), Tag$.MODULE$.apply(BoardPath.class, LightTypeTag$.MODULE$.parse(1326589135, "\u0004\u0000\u0001\u0018js7.data.board.BoardPath\u0001\u0001", "\u0000\u0007\u0004\u0000\u0001\rscala.Product\u0001\u0001\u0001\u0004\u0000\u0001\fscala.Equals\u0001\u0001\u0004\u0000\u0001\u0018js7.data.board.BoardPath\u0001\u0001\n\u0004\u0000\u0001\u0090\u0002\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.InventoryItemKey\u0001\u0001\u0004\u0000\u0001\u0014java.io.Serializable\u0001\u0001\u0004\u0000\u0001\u001cjs7.data.item.SimpleItemPath\u0001\u0001\u0004\u0000\u0001\u001fjs7.data.item.InventoryItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.data.item.UnsignedItemPath\u0001\u0001\u0004\u0000\u0001\u001ejs7.base.generic.GenericString\u0001\u0001\u0004\u0000\u0001$js7.data.item.UnsignedSimpleItemPath\u0001\u0001\u0004\u0000\u0001\u0090\u0003\u0001\u0001\u0004\u0000\u0001\u001djs7.data.item.UnsignedItemKey\u0001\u0001\u0004\u0000\u0001\u0090\f\u0001\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0003\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0002\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0004\u0000\u0001\u0090\u000b\u0001\u0001\u0006\u0004\u0000\u0001\u0090\f\u0001\u0001\u0004\u0000\u0001\u0090\u0005\u0001\u0001\u0004\u0000\u0001\u0090\u0007\u0001\u0001\u0004\u0000\u0001\u0090\b\u0001\u0001\u0004\u0000\u0001\u0090\t\u0001\u0001\u0004\u0000\u0001\u0090\n\u0001\u0001\u0001\u0000\u0001\u0090\u0004\u0001\u0001\n\u0000\u0001\u0090\u0002\u0001\u0001\u0000\u0001\u0090\u0005\u0001\u0001\u0000\u0001\u0090\u0006\u0001\u0001\u0000\u0001\u0090\u0007\u0001\u0001\u0000\u0001\u0090\b\u0001\u0001\u0000\u0001\u0090\t\u0001\u0001\u0000\u0001\u0090\n\u0001\u0001\u0000\u0001\u0090\u000b\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001\u0000\u0001\u0090\f\u0001\u0001", 30)), FileName$.MODULE$.apply("NoticeEventSource.scala"), Line$.MODULE$.apply(50)).flatMap((Function1 & Serializable)boardState -> boardState.board().toNotice(postNotice.noticeId().plannedNoticeKey(), postNotice.endOfLife(), scope).flatMap((Function1 & Serializable)notice -> controllerState.updatePlannedBoard(postNotice.noticeId().plannedBoardId(), (Function1 & Serializable)_$1 -> _$1.addNotice((Notice)notice)).flatMap((Function1 & Serializable)x$1 -> {
            Right right;
            PlanSchemaState planSchemaState = x$1;
            if (postNotice.endOfLife().exists((Function1 & Serializable)_$2 -> _$2.$less$eq(this.clock.now()))) {
                Logger LoggerImpl_this = NoticeEventSource$.js7$data$board$NoticeEventSource$$$logger;
                if (LoggerImpl_this.underlying().isDebugEnabled()) {
                    LoggerImpl_this.underlying().debug("Delete {} immediately because endOfLife has been reached", notice);
                }
                KeyedEvent keyedEvent = NoticeEvent$NoticeDeleted$.MODULE$.apply(postNotice.noticeId().plannedNoticeKey()).toKeyedEvent(postNotice.noticeId().boardPath());
                right = package$.MODULE$.Right().apply((Object)package$.MODULE$.Nil().$colon$colon((Object)keyedEvent));
            } else {
                right = NoticeEventSource$.MODULE$.js7$data$board$NoticeEventSource$$$postedNoticeToExpectingOrderEvents((Notice)notice, controllerState);
            }
            return right.map((Function1 & Serializable)expectingOrderEvents -> {
                KeyedEvent<NoticeEvent.NoticePosted> keyedEvent = NoticeEvent$NoticePosted$.MODULE$.toKeyedEvent((Notice)notice);
                return (Seq)expectingOrderEvents.$plus$colon(keyedEvent);
            });
        })));
    }
}

