/*
 * Decompiled with CFR 0.152.
 */
package js7.data.orderwatch;

import cats.syntax.package;
import io.circe.Codec;
import io.circe.Decoder;
import io.circe.Encoder;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import js7.base.circeutils.typed.Subtype;
import js7.base.problem.Checked$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.problem.ProblemCode;
import js7.base.time.Timestamp;
import js7.base.utils.SimplePattern;
import js7.data.agent.AgentPath;
import js7.data.item.InventoryItem;
import js7.data.item.InventoryItemPath;
import js7.data.item.ItemRevision;
import js7.data.item.SimpleItem;
import js7.data.item.UnsignedSimpleItemPath;
import js7.data.order.OrderId;
import js7.data.order.OrderId$;
import js7.data.orderwatch.ExternalOrderKey;
import js7.data.orderwatch.ExternalOrderKey$;
import js7.data.orderwatch.ExternalOrderName;
import js7.data.orderwatch.FileWatch$;
import js7.data.orderwatch.FileWatch$FileWatchPatternDoesntMatchProblem$;
import js7.data.orderwatch.FileWatchScope$;
import js7.data.orderwatch.OrderWatch;
import js7.data.orderwatch.OrderWatchPath;
import js7.data.orderwatch.OrderWatchPath$;
import js7.data.plan.PlanId;
import js7.data.plan.PlanKey;
import js7.data.plan.PlanKey$;
import js7.data.plan.PlanSchemaId$;
import js7.data.value.ObjectValue$;
import js7.data.value.StringValue;
import js7.data.value.StringValue$;
import js7.data.value.Value;
import js7.data.value.expression.Expression;
import js7.data.value.expression.Scope;
import js7.data.value.expression.Scope$;
import js7.data.value.expression.scopes.EnvScope$;
import js7.data.value.expression.scopes.NowScope$;
import js7.data.workflow.WorkflowPath;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.View;
import scala.collection.View$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

public final class FileWatch
implements InventoryItem,
SimpleItem,
OrderWatch,
Product,
Serializable {
    private final OrderWatchPath path;
    private final WorkflowPath workflowPath;
    private final AgentPath agentPath;
    private final Expression directoryExpr;
    private final Option<SimplePattern> pattern;
    private final Option<Expression> orderExpr;
    private final Option<Expression> orderIdExpression;
    private final FiniteDuration delay;
    private final Option<ItemRevision> itemRevision;
    private final FileWatch$ companion;
    private final View<InventoryItemPath> referencedItemPaths;
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(FileWatch$.class.getDeclaredField("typeNameAliases$lzy1"));

    public static String FileArgumentName() {
        return FileWatch$.MODULE$.FileArgumentName();
    }

    public static UnsignedSimpleItemPath.Companion<OrderWatchPath> Key() {
        return FileWatch$.MODULE$.Key();
    }

    public static OrderWatchPath$ Path() {
        return FileWatch$.MODULE$.Path();
    }

    public static FileWatch apply(OrderWatchPath orderWatchPath, WorkflowPath workflowPath, AgentPath agentPath, Expression expression, Option<SimplePattern> option, Option<Expression> option2, Option<Expression> option3, FiniteDuration finiteDuration, Option<ItemRevision> option4) {
        return FileWatch$.MODULE$.apply(orderWatchPath, workflowPath, agentPath, expression, option, option2, option3, finiteDuration, option4);
    }

    public static Class<FileWatch> cls() {
        return FileWatch$.MODULE$.cls();
    }

    public static FileWatch fromProduct(Product product) {
        return FileWatch$.MODULE$.fromProduct(product);
    }

    public static Codec.AsObject<FileWatch> jsonCodec() {
        return FileWatch$.MODULE$.jsonCodec();
    }

    public static Decoder<FileWatch> jsonDecoder() {
        return FileWatch$.MODULE$.jsonDecoder();
    }

    public static Encoder.AsObject<FileWatch> jsonEncoder() {
        return FileWatch$.MODULE$.jsonEncoder();
    }

    public static Subtype<FileWatch> subtype() {
        return FileWatch$.MODULE$.subtype();
    }

    public static String typeName() {
        return FileWatch$.MODULE$.typeName();
    }

    public static FileWatch unapply(FileWatch fileWatch) {
        return FileWatch$.MODULE$.unapply(fileWatch);
    }

    public static Option<SimplePattern> $lessinit$greater$default$5() {
        return FileWatch$.MODULE$.$lessinit$greater$default$5();
    }

    public static Option<Expression> $lessinit$greater$default$6() {
        return FileWatch$.MODULE$.$lessinit$greater$default$6();
    }

    public static Option<Expression> $lessinit$greater$default$7() {
        return FileWatch$.MODULE$.$lessinit$greater$default$7();
    }

    public static FiniteDuration $lessinit$greater$default$8() {
        return FileWatch$.MODULE$.$lessinit$greater$default$8();
    }

    public static Option<ItemRevision> $lessinit$greater$default$9() {
        return FileWatch$.MODULE$.$lessinit$greater$default$9();
    }

    public static /* synthetic */ void js7$data$item$InventoryItem$Companion$_setter_$typeName_$eq(String string) {
        FileWatch$.MODULE$.js7$data$item$InventoryItem$Companion$_setter_$typeName_$eq(string);
    }

    public FileWatch(OrderWatchPath path, WorkflowPath workflowPath, AgentPath agentPath, Expression directoryExpr, Option<SimplePattern> pattern, Option<Expression> orderExpr, Option<Expression> orderIdExpression, FiniteDuration delay, Option<ItemRevision> itemRevision) {
        this.path = path;
        this.workflowPath = workflowPath;
        this.agentPath = agentPath;
        this.directoryExpr = directoryExpr;
        this.pattern = pattern;
        this.orderExpr = orderExpr;
        this.orderIdExpression = orderIdExpression;
        this.delay = delay;
        this.itemRevision = itemRevision;
        this.companion = FileWatch$.MODULE$;
        this.referencedItemPaths = View$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new InventoryItemPath[]{agentPath, workflowPath}));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof FileWatch)) return false;
        FileWatch fileWatch = (FileWatch)object;
        OrderWatchPath orderWatchPath = this.path();
        OrderWatchPath orderWatchPath2 = fileWatch.path();
        if (orderWatchPath == null) {
            if (orderWatchPath2 != null) {
                return false;
            }
        } else if (!((Object)orderWatchPath).equals(orderWatchPath2)) return false;
        WorkflowPath workflowPath = this.workflowPath();
        WorkflowPath workflowPath2 = fileWatch.workflowPath();
        if (workflowPath == null) {
            if (workflowPath2 != null) {
                return false;
            }
        } else if (!((Object)workflowPath).equals(workflowPath2)) return false;
        AgentPath agentPath = this.agentPath();
        AgentPath agentPath2 = fileWatch.agentPath();
        if (agentPath == null) {
            if (agentPath2 != null) {
                return false;
            }
        } else if (!((Object)agentPath).equals(agentPath2)) return false;
        Expression expression = this.directoryExpr();
        Expression expression2 = fileWatch.directoryExpr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<SimplePattern> option = this.pattern();
        Option<SimplePattern> option2 = fileWatch.pattern();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<Expression> option3 = this.orderExpr();
        Option<Expression> option4 = fileWatch.orderExpr();
        if (option3 == null) {
            if (option4 != null) {
                return false;
            }
        } else if (!option3.equals(option4)) return false;
        Option<Expression> option5 = this.orderIdExpression();
        Option<Expression> option6 = fileWatch.orderIdExpression();
        if (option5 == null) {
            if (option6 != null) {
                return false;
            }
        } else if (!option5.equals(option6)) return false;
        FiniteDuration finiteDuration = this.delay();
        FiniteDuration finiteDuration2 = fileWatch.delay();
        if (finiteDuration == null) {
            if (finiteDuration2 != null) {
                return false;
            }
        } else if (!finiteDuration.equals(finiteDuration2)) return false;
        Option<ItemRevision> option7 = this.itemRevision();
        Option<ItemRevision> option8 = fileWatch.itemRevision();
        if (option7 == null) {
            if (option8 == null) return true;
            return false;
        } else {
            if (!option7.equals(option8)) return false;
            return true;
        }
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public boolean canEqual(Object that) {
        return that instanceof FileWatch;
    }

    public int productArity() {
        return 9;
    }

    public String productPrefix() {
        return "FileWatch";
    }

    public Object productElement(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return this._1();
            }
            case 1: {
                return this._2();
            }
            case 2: {
                return this._3();
            }
            case 3: {
                return this._4();
            }
            case 4: {
                return this._5();
            }
            case 5: {
                return this._6();
            }
            case 6: {
                return this._7();
            }
            case 7: {
                return this._8();
            }
            case 8: {
                return this._9();
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        switch (n2) {
            case 0: {
                return "path";
            }
            case 1: {
                return "workflowPath";
            }
            case 2: {
                return "agentPath";
            }
            case 3: {
                return "directoryExpr";
            }
            case 4: {
                return "pattern";
            }
            case 5: {
                return "orderExpr";
            }
            case 6: {
                return "orderIdExpression";
            }
            case 7: {
                return "delay";
            }
            case 8: {
                return "itemRevision";
            }
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    @Override
    public OrderWatchPath path() {
        return this.path;
    }

    @Override
    public WorkflowPath workflowPath() {
        return this.workflowPath;
    }

    @Override
    public AgentPath agentPath() {
        return this.agentPath;
    }

    public Expression directoryExpr() {
        return this.directoryExpr;
    }

    public Option<SimplePattern> pattern() {
        return this.pattern;
    }

    public Option<Expression> orderExpr() {
        return this.orderExpr;
    }

    public Option<Expression> orderIdExpression() {
        return this.orderIdExpression;
    }

    public FiniteDuration delay() {
        return this.delay;
    }

    @Override
    public Option<ItemRevision> itemRevision() {
        return this.itemRevision;
    }

    @Override
    public FileWatch$ companion() {
        return this.companion;
    }

    public FileWatch rename(OrderWatchPath path) {
        return this.copy(path, this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), this.copy$default$9());
    }

    @Override
    public FileWatch withRevision(Option<ItemRevision> revision) {
        return this.copy(this.copy$default$1(), this.copy$default$2(), this.copy$default$3(), this.copy$default$4(), this.copy$default$5(), this.copy$default$6(), this.copy$default$7(), this.copy$default$8(), revision);
    }

    @Override
    public View<InventoryItemPath> referencedItemPaths() {
        return this.referencedItemPaths;
    }

    @Override
    public Either<Problem, Tuple2<OrderId, PlanId>> externalToOrderAndPlanId(ExternalOrderName externalOrderName, Option<OrderId> legacyOrderId, Timestamp now) {
        String relativePath = externalOrderName.string();
        Matcher matcher = this.matchFilename(relativePath);
        if (!matcher.matches()) {
            OrderWatchPath OrderWatchPath_this = this.path();
            return package$.MODULE$.Left().apply((Object)FileWatch$FileWatchPatternDoesntMatchProblem$.MODULE$.apply(ExternalOrderKey$.MODULE$.apply(OrderWatchPath_this, externalOrderName)));
        }
        Either checkedDefaultOrderId = OrderId$.MODULE$.checked("file:" + this.path().string() + ":" + relativePath);
        Scope scope = (Scope)package.semigroup$.MODULE$.catsSyntaxSemigroup(package.semigroup$.MODULE$.catsSyntaxSemigroup((Object)FileWatchScope$.MODULE$.apply(this.path(), matcher), Scope$.MODULE$.given_Monoid_Scope()).$bar$plus$bar((Object)EnvScope$.MODULE$), Scope$.MODULE$.given_Monoid_Scope()).$bar$plus$bar((Object)NowScope$.MODULE$.apply(now));
        Tuple2 tuple2 = Tuple2$.MODULE$.apply(this.orderExpr(), this.orderIdExpression());
        Option option = (Option)tuple2._1();
        Option option2 = (Option)tuple2._2();
        if (option instanceof Some) {
            Expression orderExpr = (Expression)((Some)option).value();
            if (None$.MODULE$.equals(option2)) {
                return orderExpr.evalAs(ObjectValue$.MODULE$, scope).flatMap((Function1 & Serializable)obj -> ((Either)obj.nameToValue().get((Object)"orderId").fold(() -> FileWatch.externalToOrderAndPlanId$$anonfun$1$$anonfun$1(checkedDefaultOrderId), (Function1 & Serializable)_$1 -> _$1.asString().flatMap((Function1 & Serializable)string -> OrderId$.MODULE$.checked((String)string)))).flatMap((Function1 & Serializable)orderId -> ((Either)obj.nameToValue().get((Object)"planId").fold(FileWatch::externalToOrderAndPlanId$$anonfun$1$$anonfun$3$$anonfun$1, (Function1 & Serializable)_$2 -> _$2.asList().flatMap((Function1 & Serializable)x$1 -> {
                    Seq seq = x$1;
                    SeqOps seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq);
                    if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 0) == 0) {
                        return package$.MODULE$.Right().apply((Object)PlanId.Global);
                    }
                    if (SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(seqOps, 2) == 0) {
                        Value value = (Value)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 0);
                        Value value2 = (Value)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(seqOps, 1);
                        if (value instanceof StringValue) {
                            String string;
                            StringValue stringValue = StringValue$.MODULE$.unapply((StringValue)value);
                            String planSchemaId2 = string = stringValue._1();
                            if (value2 instanceof StringValue) {
                                String string2;
                                StringValue stringValue2 = StringValue$.MODULE$.unapply((StringValue)value2);
                                String planKey = string2 = stringValue2._1();
                                return PlanSchemaId$.MODULE$.checked(planSchemaId2).flatMap((Function1 & Serializable)planSchemaId -> PlanKey$.MODULE$.checked(planKey).map((Function1 & Serializable)planKey -> planSchemaId.$div((PlanKey)planKey)));
                            }
                        }
                    }
                    return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)FileWatch::externalToOrderAndPlanId$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$2), Problem$.MODULE$.apply$default$2()));
                }))).map((Function1 & Serializable)planId -> {
                    OrderId orderId = (OrderId)Predef$.MODULE$.ArrowAssoc(orderId);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)orderId, planId);
                })));
            }
        }
        if (None$.MODULE$.equals(option)) {
            if (option2 instanceof Some) {
                Expression legacyOrderIdExpr = (Expression)((Some)option2).value();
                return (Either)legacyOrderId.map((Function1 & Serializable)orderId -> {
                    OrderId orderId2 = (OrderId)Predef$.MODULE$.ArrowAssoc(orderId);
                    return Checked$.MODULE$.apply(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)orderId2, (Object)PlanId.Global));
                }).getOrElse(() -> FileWatch.externalToOrderAndPlanId$$anonfun$3(legacyOrderIdExpr, scope));
            }
            if (None$.MODULE$.equals(option2)) {
                return checkedDefaultOrderId.map((Function1 & Serializable)_$4 -> {
                    OrderId orderId = (OrderId)Predef$.MODULE$.ArrowAssoc(_$4);
                    return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)orderId, (Object)PlanId.Global);
                });
            }
        }
        return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)FileWatch::externalToOrderAndPlanId$$anonfun$5), Problem$.MODULE$.apply$default$2()));
    }

    public boolean matchesFilename(String filename) {
        return this.matchFilename(filename).matches();
    }

    private Matcher matchFilename(String filename) {
        return ((Pattern)this.pattern().fold(FileWatch::matchFilename$$anonfun$1, (Function1 & Serializable)_$5 -> _$5.pattern())).matcher(filename);
    }

    public FileWatch copy(OrderWatchPath path, WorkflowPath workflowPath, AgentPath agentPath, Expression directoryExpr, Option<SimplePattern> pattern, Option<Expression> orderExpr, Option<Expression> orderIdExpression, FiniteDuration delay, Option<ItemRevision> itemRevision) {
        return new FileWatch(path, workflowPath, agentPath, directoryExpr, pattern, orderExpr, orderIdExpression, delay, itemRevision);
    }

    public OrderWatchPath copy$default$1() {
        return this.path();
    }

    public WorkflowPath copy$default$2() {
        return this.workflowPath();
    }

    public AgentPath copy$default$3() {
        return this.agentPath();
    }

    public Expression copy$default$4() {
        return this.directoryExpr();
    }

    public Option<SimplePattern> copy$default$5() {
        return this.pattern();
    }

    public Option<Expression> copy$default$6() {
        return this.orderExpr();
    }

    public Option<Expression> copy$default$7() {
        return this.orderIdExpression();
    }

    public FiniteDuration copy$default$8() {
        return this.delay();
    }

    public Option<ItemRevision> copy$default$9() {
        return this.itemRevision();
    }

    public OrderWatchPath _1() {
        return this.path();
    }

    public WorkflowPath _2() {
        return this.workflowPath();
    }

    public AgentPath _3() {
        return this.agentPath();
    }

    public Expression _4() {
        return this.directoryExpr();
    }

    public Option<SimplePattern> _5() {
        return this.pattern();
    }

    public Option<Expression> _6() {
        return this.orderExpr();
    }

    public Option<Expression> _7() {
        return this.orderIdExpression();
    }

    public FiniteDuration _8() {
        return this.delay();
    }

    public Option<ItemRevision> _9() {
        return this.itemRevision();
    }

    private static final Either externalToOrderAndPlanId$$anonfun$1$$anonfun$1(Either checkedDefaultOrderId$2) {
        return checkedDefaultOrderId$2;
    }

    private static final Either externalToOrderAndPlanId$$anonfun$1$$anonfun$3$$anonfun$1() {
        return Checked$.MODULE$.apply(PlanId.Global);
    }

    private static final String externalToOrderAndPlanId$$anonfun$1$$anonfun$3$$anonfun$2$$anonfun$1$$anonfun$2() {
        return "planId must be a list of two strings";
    }

    private static final Either externalToOrderAndPlanId$$anonfun$3(Expression legacyOrderIdExpr$1, Scope scope$1) {
        return legacyOrderIdExpr$1.evalAsString(scope$1).flatMap((Function1 & Serializable)string -> OrderId$.MODULE$.checked((String)string)).map((Function1 & Serializable)_$3 -> {
            OrderId orderId = (OrderId)Predef$.MODULE$.ArrowAssoc(_$3);
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)orderId, (Object)PlanId.Global);
        });
    }

    private static final String externalToOrderAndPlanId$$anonfun$5() {
        return "orderExpr cannot be combined with legacy orderIdExpression";
    }

    private static final Pattern matchFilename$$anonfun$1() {
        return FileWatch$.js7$data$orderwatch$FileWatch$$$defaultPattern;
    }

    public static final class FileWatchPatternDoesntMatchProblem
    implements Problem,
    Problem.Simple,
    Problem.HasCode,
    Problem.Coded,
    Product,
    Serializable {
        public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(FileWatchPatternDoesntMatchProblem.class.getDeclaredField("message$lzy1"));
        private volatile Object message$lzy1;
        private ProblemCode code;
        private final ExternalOrderKey externalOrderKey;

        public static FileWatchPatternDoesntMatchProblem apply(ExternalOrderKey externalOrderKey) {
            return FileWatch$FileWatchPatternDoesntMatchProblem$.MODULE$.apply(externalOrderKey);
        }

        public static FileWatchPatternDoesntMatchProblem fromProduct(Product product) {
            return FileWatch$FileWatchPatternDoesntMatchProblem$.MODULE$.fromProduct(product);
        }

        public static FileWatchPatternDoesntMatchProblem unapply(FileWatchPatternDoesntMatchProblem fileWatchPatternDoesntMatchProblem) {
            return FileWatch$FileWatchPatternDoesntMatchProblem$.MODULE$.unapply(fileWatchPatternDoesntMatchProblem);
        }

        public static /* synthetic */ void js7$base$problem$Problem$Coded$Companion$_setter_$code_$eq(ProblemCode problemCode) {
            FileWatch$FileWatchPatternDoesntMatchProblem$.MODULE$.js7$base$problem$Problem$Coded$Companion$_setter_$code_$eq(problemCode);
        }

        public FileWatchPatternDoesntMatchProblem(ExternalOrderKey externalOrderKey) {
            this.externalOrderKey = externalOrderKey;
            Problem.Coded.$init$(this);
            Statics.releaseFence();
        }

        @Override
        public final String message() {
            Object object = this.message$lzy1;
            if (object instanceof String) {
                return (String)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (String)this.message$lzyINIT1();
        }

        private Object message$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.message$lzy1) == null) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        String string = null;
                        try {
                            string = Problem.Simple.message$(this);
                            object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                        }
                        finally {
                            if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.message$lzy1;
                                LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return string;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }

        @Override
        public ProblemCode code() {
            return this.code;
        }

        @Override
        public void js7$base$problem$Problem$Coded$_setter_$code_$eq(ProblemCode x$0) {
            this.code = x$0;
        }

        public boolean canEqual(Object that) {
            return that instanceof FileWatchPatternDoesntMatchProblem;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "FileWatchPatternDoesntMatchProblem";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "externalOrderKey";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ExternalOrderKey externalOrderKey() {
            return this.externalOrderKey;
        }

        @Override
        public Map<String, String> arguments() {
            return new Map.Map2((Object)"orderWatchPath", (Object)this.externalOrderKey().orderWatchPath().string(), (Object)"externalOrderName", (Object)this.externalOrderKey().name().string());
        }

        public FileWatchPatternDoesntMatchProblem copy(ExternalOrderKey externalOrderKey) {
            return new FileWatchPatternDoesntMatchProblem(externalOrderKey);
        }

        public ExternalOrderKey copy$default$1() {
            return this.externalOrderKey();
        }

        public ExternalOrderKey _1() {
            return this.externalOrderKey();
        }
    }
}

