/*
 * Decompiled with CFR 0.152.
 */
package js7.data.state;

import java.io.Serializable;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.data.item.VersionedItemId;
import js7.data.job.JobKey;
import js7.data.order.Order;
import js7.data.order.Order$Ready$;
import js7.data.order.OrderEvent;
import js7.data.order.OrderEvent$OrderCancelled$;
import js7.data.order.OrderEvent$OrderDeleted$;
import js7.data.order.OrderEvent$OrderDetachable$;
import js7.data.state.OrderEventHandler;
import js7.data.state.OrderEventHandler$FollowUp$;
import js7.data.state.OrderEventHandler$FollowUp$AddChild$;
import js7.data.state.OrderEventHandler$FollowUp$Delete$;
import js7.data.state.OrderEventHandler$FollowUp$LeaveJob$;
import js7.data.workflow.Workflow;
import js7.data.workflow.WorkflowPath;
import scala.Function0;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.util.Either;

public final class OrderEventHandler {
    private final Function1<VersionedItemId<WorkflowPath>, Either<Problem, Workflow>> idToWorkflow;

    public OrderEventHandler(Function1<VersionedItemId<WorkflowPath>, Either<Problem, Workflow>> idToWorkflow) {
        this.idToWorkflow = idToWorkflow;
    }

    public Either<Problem, Seq<FollowUp>> handleEvent(Order<Order.State> previousOrder, OrderEvent event) {
        OrderEvent orderEvent = event;
        if (orderEvent instanceof OrderEvent.OrderProcessed) {
            return ((Either)this.idToWorkflow.apply(previousOrder.workflowId())).flatMap((Function1 & Serializable)workflow -> workflow.positionToJobKey(previousOrder.position()).map((Function1 & Serializable)jobKey -> {
                FollowUp.LeaveJob leaveJob = OrderEventHandler$FollowUp$LeaveJob$.MODULE$.apply((JobKey)jobKey);
                return package$.MODULE$.Nil().$colon$colon((Object)leaveJob);
            }));
        }
        if (OrderEvent$OrderCancelled$.MODULE$.equals(orderEvent) || OrderEvent$OrderDetachable$.MODULE$.equals(orderEvent)) {
            return ((Either)this.idToWorkflow.apply(previousOrder.workflowId())).map((Function1 & Serializable)workflow -> workflow.positionToJobKey(previousOrder.position()).toOption().map((Function1 & Serializable)_$1 -> OrderEventHandler$FollowUp$LeaveJob$.MODULE$.apply((JobKey)_$1)).toList());
        }
        if (orderEvent instanceof OrderEvent.OrderForked) {
            OrderEvent.OrderForked event2 = (OrderEvent.OrderForked)orderEvent;
            return package$.MODULE$.Right().apply(previousOrder.newForkedOrders(event2).map((Function1 & Serializable)_$2 -> OrderEventHandler$FollowUp$AddChild$.MODULE$.apply((Order<Order$Ready$>)_$2)));
        }
        if (orderEvent instanceof OrderEvent.OrderJoined) {
            OrderEvent.OrderJoined joined = (OrderEvent.OrderJoined)orderEvent;
            Order.State state = previousOrder.state();
            if (state instanceof Order.Forked) {
                Order.Forked o2 = (Order.Forked)state;
                return package$.MODULE$.Right().apply(o2.children().map((Function1 & Serializable)o -> OrderEventHandler$FollowUp$Delete$.MODULE$.apply(o.orderId())));
            }
            Order.State state2 = state;
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> OrderEventHandler.handleEvent$$anonfun$5(joined, state2)), Problem$.MODULE$.apply$default$2()));
        }
        if (orderEvent == OrderEvent$OrderDeleted$.MODULE$) {
            FollowUp.Delete delete = OrderEventHandler$FollowUp$Delete$.MODULE$.apply(previousOrder.id());
            return package$.MODULE$.Right().apply((Object)package$.MODULE$.Nil().$colon$colon((Object)delete));
        }
        return package$.MODULE$.Right().apply((Object)package$.MODULE$.Nil());
    }

    private static final String handleEvent$$anonfun$5(OrderEvent.OrderJoined joined$1, Order.State state$1) {
        return "Event " + joined$1 + ", but Order is in state " + state$1;
    }

    public static interface FollowUp {
        public static int ordinal(FollowUp followUp) {
            return OrderEventHandler$FollowUp$.MODULE$.ordinal(followUp);
        }
    }
}

