/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.log;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Locale;
import js7.base.log.CorrelId;
import js7.base.log.CorrelId$;
import js7.base.log.LoggingEscapeCodes$;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichDuration$;
import js7.base.utils.Classes$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichString$;
import js7.base.utils.ScalaUtils$syntax$RichStringBuilder$;
import js7.data.event.Event;
import js7.data.event.KeyedEvent;
import js7.data.event.KeyedEvent$NoKey$;
import js7.data.event.Stamped;
import js7.journal.log.JournalLogger$;
import js7.journal.log.JournalLogger$PersistFrame$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Product;
import scala.collection.IndexedSeqView;
import scala.collection.Iterator;
import scala.collection.View;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Deadline;
import scala.concurrent.duration.Deadline$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;

public final class JournalLogger {
    private final String syncOrFlushString;
    private final boolean suppressTiming;
    private final int syncOrFlushWidth;
    private final String ackSyncOrFlushString;
    private final SubclassCache infoLoggableEventClasses;
    private final StringBuilder sb;
    private boolean suppressed;

    public static boolean $lessinit$greater$default$3() {
        return JournalLogger$.MODULE$.$lessinit$greater$default$3();
    }

    public JournalLogger(String syncOrFlushString, Set<String> infoLogEvents, boolean suppressTiming) {
        this.syncOrFlushString = syncOrFlushString;
        this.suppressTiming = suppressTiming;
        this.syncOrFlushWidth = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(6), syncOrFlushString.length());
        this.ackSyncOrFlushString = syncOrFlushString.toUpperCase(Locale.ROOT);
        this.infoLoggableEventClasses = new SubclassCache(infoLogEvents);
        this.sb = new StringBuilder();
        this.suppressed = false;
    }

    public void logCommitted(IndexedSeqView<Loggable> persists, boolean ack) {
        if (!this.suppressed) {
            Logger LoggerImpl_this = JournalLogger$.js7$journal$log$JournalLogger$$$logger;
            if (LoggerImpl_this.underlying().isInfoEnabled()) {
                View loggablePersists;
                Deadline committedAt = Deadline$.MODULE$.now();
                IndexedSeqView<Loggable> myPersists = this.dropEmptyPersists(persists);
                Logger LoggerImpl_this2 = JournalLogger$.js7$journal$log$JournalLogger$$$logger;
                if (LoggerImpl_this2.underlying().isTraceEnabled()) {
                    this.logPersists(myPersists, committedAt, this.logPersists$default$3(), (Function2<PersistFrame, Stamped<KeyedEvent<Event>>, BoxedUnit>)(JProcedure2 & Serializable)(frame, stamped) -> this.traceLogPersist(ack, (PersistFrame)frame, (Stamped<KeyedEvent<Event>>)stamped));
                }
                if ((loggablePersists = (View)myPersists.filter((Function1 & Serializable)_$1 -> _$1.stampedSeq().exists((Function1 & Serializable)stamped -> this.isLoggable$3((Stamped)stamped)))).nonEmpty()) {
                    this.logPersists((IndexedSeqView<Loggable>)loggablePersists.toVector().view(), committedAt, (Function1<Stamped<KeyedEvent<Event>>, Object>)(Function1 & Serializable)stamped -> this.isLoggable$3((Stamped)stamped), (Function2<PersistFrame, Stamped<KeyedEvent<Event>>, BoxedUnit>)(JProcedure2 & Serializable)(frame, stamped) -> this.infoLogPersist((PersistFrame)frame, (Stamped<KeyedEvent<Event>>)stamped));
                    return;
                }
                return;
            }
            return;
        }
    }

    public boolean logCommitted$default$2() {
        return false;
    }

    public void suppress(boolean supressed) {
        this.suppressed = supressed;
    }

    private IndexedSeqView<Loggable> dropEmptyPersists(IndexedSeqView<Loggable> persists) {
        int dropLeft = persists.segmentLength((Function1 & Serializable)_$2 -> _$2.stampedSeq().isEmpty());
        int dropRight = persists.reverse().segmentLength((Function1 & Serializable)_$3 -> _$3.stampedSeq().isEmpty());
        return persists.slice(dropLeft, persists.length() - dropRight);
    }

    private void logPersists(IndexedSeqView<Loggable> persists, Deadline committedAt, Function1<Stamped<KeyedEvent<Event>>, Object> isLoggable, Function2<PersistFrame, Stamped<KeyedEvent<Event>>, BoxedUnit> body) {
        CorrelId$.MODULE$.isolate((JProcedure1 & Serializable)logCorrelId -> {
            IntRef index = IntRef.create((int)0);
            persists.foreach((Function1)(JProcedure1 & Serializable)persist -> {
                logCorrelId.$colon$eq(persist.correlId());
                Seq stampedSeq = (Seq)persist.stampedSeq().filter(isLoggable);
                PersistFrame frame = JournalLogger$PersistFrame$.MODULE$.apply((Loggable)persist, stampedSeq.length(), index$1.elem, persists.length(), committedAt);
                Iterator stampedIterator = stampedSeq.iterator();
                boolean hasNext = stampedIterator.hasNext();
                while (hasNext) {
                    Stamped stamped = (Stamped)stampedIterator.next();
                    hasNext = stampedIterator.hasNext();
                    frame.isLastEvent_$eq(!hasNext);
                    body.apply((Object)frame, (Object)stamped);
                    frame.nr_$eq(frame.nr() + 1L);
                    frame.isFirstEvent_$eq(false);
                }
                ++index$1.elem;
            });
        });
    }

    private Function1<Stamped<KeyedEvent<Event>>, Object> logPersists$default$3() {
        return (Function1 & Serializable)_$4 -> true;
    }

    private void traceLogPersist(boolean ack, PersistFrame frame, Stamped<KeyedEvent<Event>> stamped) {
        StringBuilder stringBuilder;
        this.sb.clear();
        this.sb.append(':');
        this.sb.append(frame.persistMarker());
        ScalaUtils$syntax$RichStringBuilder$.MODULE$.fillRight$extension(ScalaUtils$syntax$.MODULE$.RichStringBuilder(this.sb), this.syncOrFlushWidth, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
            this.traceLogPersist$$anonfun$1(frame, ack);
            return BoxedUnit.UNIT;
        });
        if (frame.isLastEvent()) {
            this.sb.append(' ');
            ScalaUtils$syntax$RichStringBuilder$.MODULE$.fillRight$extension(ScalaUtils$syntax$.MODULE$.RichStringBuilder(this.sb), 6, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.traceLogPersist$$anonfun$2(frame);
                return BoxedUnit.UNIT;
            });
            v0 = BoxedUnit.UNIT;
        } else if (frame.nr() == frame.beforeLastEventNr() && frame.beforeLastEventNr() > frame.persist().eventNumber()) {
            ScalaUtils$syntax$RichStringBuilder$.MODULE$.fillLeft$extension(ScalaUtils$syntax$.MODULE$.RichStringBuilder(this.sb), 7, (Function0<BoxedUnit>)(Function0 & Serializable)() -> {
                this.traceLogPersist$$anonfun$3(frame);
                return BoxedUnit.UNIT;
            });
            v0 = BoxedUnit.UNIT;
        } else {
            v0 = this.sb.append("       ");
        }
        this.sb.append(frame.transactionMarker(true));
        this.sb.append(stamped.eventId());
        Object object = stamped.value().key();
        KeyedEvent$NoKey$ keyedEvent$NoKey$ = KeyedEvent$NoKey$.MODULE$;
        if (object == null ? keyedEvent$NoKey$ != null : !object.equals(keyedEvent$NoKey$)) {
            this.sb.append(' ');
            this.sb.append(stamped.value().key());
            this.sb.append(JournalLogger$.js7$journal$log$JournalLogger$$$spaceArrow);
        }
        Event event = stamped.value().event();
        String string = ScalaUtils$syntax$.MODULE$.RichString(event.toString());
        String eventString = ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$extension(string, 200, ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$2$extension(string), true, ScalaUtils$syntax$RichString$.MODULE$.truncateWithEllipsis$default$4$extension(string));
        if (LoggingEscapeCodes$.MODULE$.isColorAllowed() && !event.isMinor()) {
            this.sb.append(" \u001b[39m\u001b[1m");
            int i = ScalaUtils$syntax$.MODULE$.indexOfOrLength(eventString, '(');
            this.sb.underlying().append(eventString, 0, i);
            this.sb.append("\u001b[0m");
            this.sb.underlying().append(eventString, i, eventString.length());
            stringBuilder = this.sb.append(LoggingEscapeCodes$.MODULE$.resetColor());
        } else {
            this.sb.append(' ');
            stringBuilder = this.sb.append(eventString);
        }
        Predef$.MODULE$.locally((Object)stringBuilder);
        Logger LoggerImpl_this = JournalLogger$.js7$journal$log$JournalLogger$$$logger;
        if (LoggerImpl_this.underlying().isTraceEnabled()) {
            LoggerImpl_this.underlying().trace(this.sb.toString());
            return;
        }
    }

    private void infoLogPersist(PersistFrame frame, Stamped<KeyedEvent<Event>> stamped) {
        this.sb.clear();
        this.sb.append("Event ");
        this.sb.append(frame.transactionMarker(false));
        Object object = stamped.value().key();
        KeyedEvent$NoKey$ keyedEvent$NoKey$ = KeyedEvent$NoKey$.MODULE$;
        if (object == null ? keyedEvent$NoKey$ != null : !object.equals(keyedEvent$NoKey$)) {
            this.sb.append(stamped.value().key());
            this.sb.append(JournalLogger$.js7$journal$log$JournalLogger$$$spaceArrowSpace);
        }
        this.sb.append(stamped.value().event().toShortString());
        Logger LoggerImpl_this = JournalLogger$.js7$journal$log$JournalLogger$$$logger;
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info(this.sb.toString());
            return;
        }
    }

    private final boolean isLoggable$3(Stamped stamped) {
        Object event = ((KeyedEvent)stamped.value()).event();
        return this.infoLoggableEventClasses.contains(event.getClass()) || !event.isSucceeded();
    }

    private final void traceLogPersist$$anonfun$1(PersistFrame frame$1, boolean ack$2) {
        if (frame$1.isLastEvent() && frame$1.persist().isLastOfFlushedOrSynced()) {
            this.sb.append(ack$2 ? this.ackSyncOrFlushString : this.syncOrFlushString);
            return;
        }
        if (frame$1.isFirstEvent() && frame$1.persistIndex() == 0 && frame$1.persistCount() >= 2) {
            this.sb.append(frame$1.persistCount());
            return;
        }
        if (frame$1.nr() == frame$1.beforeLastEventNr() && frame$1.persistEventCount() >= 10000) {
            long micros = frame$1.duration().toMicros();
            if (micros != 0L) {
                int k = (int)(1000.0 * (double)frame$1.persistEventCount() / (double)micros);
                if (k < 1000) {
                    this.sb.append(k);
                    this.sb.append("k/s");
                    return;
                }
                this.sb.append(k / 1000);
                this.sb.append("M/s");
                return;
            }
            return;
        }
    }

    private final void traceLogPersist$$anonfun$2(PersistFrame frame$2) {
        if (!this.suppressTiming && frame$2.duration().$greater$eq((Object)JournalLogger$.js7$journal$log$JournalLogger$$$MinimumDuration)) {
            this.sb.append(ScalaTime$RichDuration$.MODULE$.msPretty$extension(ScalaTime$.MODULE$.RichDuration((Duration)frame$2.duration())));
            return;
        }
    }

    private final void traceLogPersist$$anonfun$3(PersistFrame frame$3) {
        this.sb.append(frame$3.persistEventCount());
    }

    public static interface Loggable {
        public CorrelId correlId();

        public long eventNumber();

        public Seq<Stamped<KeyedEvent<Event>>> stampedSeq();

        public boolean isTransaction();

        public Deadline since();

        public boolean isLastOfFlushedOrSynced();
    }

    public static final class PersistFrame
    implements Product,
    Serializable {
        private final Loggable persist;
        private final int persistEventCount;
        private final int persistIndex;
        private final int persistCount;
        private final Deadline committedAt;
        private final long beforeLastEventNr;
        private final FiniteDuration duration;
        private long nr;
        private boolean isFirstEvent;
        private boolean isLastEvent;

        public static PersistFrame apply(Loggable loggable, int n, int n2, int n3, Deadline deadline) {
            return JournalLogger$PersistFrame$.MODULE$.apply(loggable, n, n2, n3, deadline);
        }

        public static PersistFrame fromProduct(Product product) {
            return JournalLogger$PersistFrame$.MODULE$.fromProduct(product);
        }

        public static PersistFrame unapply(PersistFrame persistFrame) {
            return JournalLogger$PersistFrame$.MODULE$.unapply(persistFrame);
        }

        public PersistFrame(Loggable persist, int persistEventCount, int persistIndex, int persistCount, Deadline committedAt) {
            this.persist = persist;
            this.persistEventCount = persistEventCount;
            this.persistIndex = persistIndex;
            this.persistCount = persistCount;
            this.committedAt = committedAt;
            this.beforeLastEventNr = persist.eventNumber() + (long)persistEventCount - 2L;
            this.duration = committedAt.$minus(persist.since());
            this.nr = persist.eventNumber();
            this.isFirstEvent = true;
            this.isLastEvent = true;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.persist()));
            n = Statics.mix((int)n, (int)this.persistEventCount());
            n = Statics.mix((int)n, (int)this.persistIndex());
            n = Statics.mix((int)n, (int)this.persistCount());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.committedAt()));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof PersistFrame)) return false;
            PersistFrame persistFrame = (PersistFrame)object;
            if (this.persistEventCount() != persistFrame.persistEventCount()) return false;
            if (this.persistIndex() != persistFrame.persistIndex()) return false;
            if (this.persistCount() != persistFrame.persistCount()) return false;
            Loggable loggable = this.persist();
            Loggable loggable2 = persistFrame.persist();
            if (loggable == null) {
                if (loggable2 != null) {
                    return false;
                }
            } else if (!loggable.equals(loggable2)) return false;
            Deadline deadline = this.committedAt();
            Deadline deadline2 = persistFrame.committedAt();
            if (deadline == null) {
                if (deadline2 == null) return true;
                return false;
            } else {
                if (!deadline.equals(deadline2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof PersistFrame;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "PersistFrame";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return BoxesRunTime.boxToInteger((int)this._2());
                }
                case 2: {
                    return BoxesRunTime.boxToInteger((int)this._3());
                }
                case 3: {
                    return BoxesRunTime.boxToInteger((int)this._4());
                }
                case 4: {
                    return this._5();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "persist";
                }
                case 1: {
                    return "persistEventCount";
                }
                case 2: {
                    return "persistIndex";
                }
                case 3: {
                    return "persistCount";
                }
                case 4: {
                    return "committedAt";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Loggable persist() {
            return this.persist;
        }

        public int persistEventCount() {
            return this.persistEventCount;
        }

        public int persistIndex() {
            return this.persistIndex;
        }

        public int persistCount() {
            return this.persistCount;
        }

        public Deadline committedAt() {
            return this.committedAt;
        }

        public long beforeLastEventNr() {
            return this.beforeLastEventNr;
        }

        public FiniteDuration duration() {
            return this.duration;
        }

        public long nr() {
            return this.nr;
        }

        public void nr_$eq(long x$1) {
            this.nr = x$1;
        }

        public boolean isFirstEvent() {
            return this.isFirstEvent;
        }

        public void isFirstEvent_$eq(boolean x$1) {
            this.isFirstEvent = x$1;
        }

        public boolean isLastEvent() {
            return this.isLastEvent;
        }

        public void isLastEvent_$eq(boolean x$1) {
            this.isLastEvent = x$1;
        }

        public char persistMarker() {
            if (this.persistCount() == 1) {
                return ' ';
            }
            if (this.persistIndex() == 0 & this.isFirstEvent()) {
                return '\u250c';
            }
            if (this.persistIndex() == this.persistCount() - 1 & this.isLastEvent()) {
                return '\u2514';
            }
            return '\u2502';
        }

        public char transactionMarker(boolean forTrace) {
            if (this.persistEventCount() == 1) {
                return ' ';
            }
            if (this.persist().isTransaction()) {
                if (this.isFirstEvent()) {
                    return '\u239b';
                }
                if (this.isLastEvent()) {
                    return '\u239d';
                }
                if (forTrace && this.nr() == this.beforeLastEventNr()) {
                    return '\u23a8';
                }
                return '\u23aa';
            }
            if (!forTrace) {
                return ' ';
            }
            if (this.isFirstEvent()) {
                return '\u250c';
            }
            if (this.isLastEvent()) {
                return '\u2514';
            }
            if (this.nr() == this.beforeLastEventNr()) {
                return '\u2524';
            }
            return '\u2575';
        }

        public PersistFrame copy(Loggable persist, int persistEventCount, int persistIndex, int persistCount, Deadline committedAt) {
            return new PersistFrame(persist, persistEventCount, persistIndex, persistCount, committedAt);
        }

        public Loggable copy$default$1() {
            return this.persist();
        }

        public int copy$default$2() {
            return this.persistEventCount();
        }

        public int copy$default$3() {
            return this.persistIndex();
        }

        public int copy$default$4() {
            return this.persistCount();
        }

        public Deadline copy$default$5() {
            return this.committedAt();
        }

        public Loggable _1() {
            return this.persist();
        }

        public int _2() {
            return this.persistEventCount();
        }

        public int _3() {
            return this.persistIndex();
        }

        public int _4() {
            return this.persistCount();
        }

        public Deadline _5() {
            return this.committedAt();
        }
    }

    public static final class SimpleLoggable
    implements Loggable {
        private final CorrelId correlId;
        private final long eventNumber;
        private final Seq<Stamped<KeyedEvent<Event>>> stampedSeq;
        private final boolean isTransaction;
        private final Deadline since;
        private final boolean isLastOfFlushedOrSynced;

        public SimpleLoggable(CorrelId correlId, long eventNumber, Seq<Stamped<KeyedEvent<Event>>> stampedSeq, boolean isTransaction, Deadline since, boolean isLastOfFlushedOrSynced) {
            this.correlId = correlId;
            this.eventNumber = eventNumber;
            this.stampedSeq = stampedSeq;
            this.isTransaction = isTransaction;
            this.since = since;
            this.isLastOfFlushedOrSynced = isLastOfFlushedOrSynced;
        }

        @Override
        public CorrelId correlId() {
            return this.correlId;
        }

        @Override
        public long eventNumber() {
            return this.eventNumber;
        }

        @Override
        public Seq<Stamped<KeyedEvent<Event>>> stampedSeq() {
            return this.stampedSeq;
        }

        @Override
        public boolean isTransaction() {
            return this.isTransaction;
        }

        @Override
        public Deadline since() {
            return this.since;
        }

        @Override
        public boolean isLastOfFlushedOrSynced() {
            return this.isLastOfFlushedOrSynced;
        }
    }

    public static final class SubclassCache {
        private final Set<String> superclassNames;
        private final Map<Class<?>, Object> cache;

        public SubclassCache(Set<String> superclassNames) {
            this.superclassNames = superclassNames;
            this.cache = (Map)Map$.MODULE$.empty();
        }

        public boolean contains(Class<? extends Event> cls) {
            return BoxesRunTime.unboxToBoolean((Object)this.cache.getOrElseUpdate(cls, () -> this.contains$$anonfun$1(cls)));
        }

        public String toString() {
            return "SubclassCache(" + this.superclassNames + ")";
        }

        private final boolean contains$$anonfun$1(Class cls$1) {
            return Classes$.MODULE$.superclassesOf(cls$1).iterator().map(JournalLogger$::js7$journal$log$JournalLogger$SubclassCache$$_$contains$$anonfun$1$$anonfun$1).exists((Function1 & Serializable)elem -> this.superclassNames.contains(elem));
        }
    }
}

