/*
 * Decompiled with CFR 0.152.
 */
package js7.journal.recover;

import cats.effect.IO;
import cats.effect.kernel.Resource;
import cats.effect.unsafe.IORuntime;
import com.typesafe.config.Config;
import com.typesafe.scalalogging.Logger;
import io.circe.Json;
import izumi.reflect.Tag$;
import izumi.reflect.macrortti.LightTypeTag$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$Ops$;
import js7.base.utils.AutoClosing$;
import js7.base.utils.ByteUnits$;
import js7.base.utils.SetOnce;
import js7.base.utils.SetOnce$;
import js7.common.jsonseq.InputStreamJsonSeqReader;
import js7.common.jsonseq.InputStreamJsonSeqReader$;
import js7.common.utils.UntilNoneIterator$;
import js7.data.event.SnapshotableState;
import js7.journal.data.JournalLocation;
import js7.journal.files.JournalFiles$extensions$;
import js7.journal.recover.FileSnapshotableStateRecoverer;
import js7.journal.recover.Recovered;
import js7.journal.recover.StateRecoverer$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Deadline;
import scala.runtime.Arrays$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.sys.package$;
import scala.util.Either;

public final class StateRecoverer<S extends SnapshotableState<S>> {
    private final Path file;
    private final JournalLocation journalLocation;
    private final SnapshotableState.Companion<S> S;
    private final FileSnapshotableStateRecoverer<S> fileRecoverer;
    private long _position;
    private long _lastProperEventPosition;
    private final SetOnce<Object> _firstEventPosition;

    public static <S extends SnapshotableState<S>> Recovered<S> recover(JournalLocation journalLocation, Config config, Deadline deadline, SnapshotableState.Companion<S> companion, IORuntime iORuntime) {
        return StateRecoverer$.MODULE$.recover(journalLocation, config, deadline, companion, iORuntime);
    }

    public static <S extends SnapshotableState<S>> S recoverFile(Path path, SnapshotableState.Companion<S> companion) {
        return StateRecoverer$.MODULE$.recoverFile(path, companion);
    }

    public static <S extends SnapshotableState<S>> Resource<IO, Recovered<S>> resource(JournalLocation journalLocation, Config config, SnapshotableState.Companion<S> companion, IORuntime iORuntime) {
        return StateRecoverer$.MODULE$.resource(journalLocation, config, companion, iORuntime);
    }

    public static <S extends SnapshotableState<S>> Deadline recover$default$3() {
        return StateRecoverer$.MODULE$.recover$default$3();
    }

    public StateRecoverer(Path file, JournalLocation journalLocation, Function0<FileSnapshotableStateRecoverer<S>> newFileJournaledStateRecoverer, SnapshotableState.Companion<S> S) {
        this.file = file;
        this.journalLocation = journalLocation;
        this.S = S;
        this.fileRecoverer = (FileSnapshotableStateRecoverer)newFileJournaledStateRecoverer.apply();
        this._position = 0L;
        this._lastProperEventPosition = 0L;
        this._firstEventPosition = SetOnce$.MODULE$.apply(Tag$.MODULE$.apply(Long.TYPE, LightTypeTag$.MODULE$.parse(1058951704, "\u0004\u0000\u0001\nscala.Long\u0001\u0001", "\u0000\u0001\u0004\u0000\u0001\nscala.Long\u0001\u0001\u0001\u0004\u0000\u0001\fscala.AnyVal\u0001\u0001\u0001\u0000\u0001\u0090\u0002\u0001\u0001\u0001\u0000\u0001\u0090\u0003\u0001\u0001", 30)));
    }

    public Path file() {
        return this.file;
    }

    public void recoverAll() {
        Logger LoggerImpl_this = StateRecoverer$.js7$journal$recover$StateRecoverer$$$logger;
        if (LoggerImpl_this.underlying().isInfoEnabled()) {
            LoggerImpl_this.underlying().info("Recovering from file {} ({})", (Object[])Arrays$.MODULE$.seqToArray((Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.file().getFileName(), ByteUnits$.MODULE$.toKBGB(Files.size(this.file()))}), Object.class));
        }
        AutoClosing$.MODULE$.autoClosing(InputStreamJsonSeqReader$.MODULE$.open(this.file(), InputStreamJsonSeqReader$.MODULE$.open$default$2()), (JProcedure1 & Serializable)jsonReader -> {
            UntilNoneIterator$.MODULE$.apply(() -> StateRecoverer.recoverAll$$anonfun$1$$anonfun$1(jsonReader)).map((Function1 & Serializable)_$1 -> (Json)_$1.value()).foreach((Function1)(JProcedure1 & Serializable)json -> {
                Either either = Checked$.MODULE$.Ops(this.S.decodeJournalJson((Json)json));
                this.fileRecoverer.put(Checked$Ops$.MODULE$.orThrow$extension(either));
                if (this.fileRecoverer.isAfterSnapshotSection()) {
                    this._position = jsonReader.position();
                } else if (this.fileRecoverer.isInCommittedEventsSection()) {
                    this._position = jsonReader.position();
                    this._lastProperEventPosition = jsonReader.position();
                }
                if (this._firstEventPosition.isEmpty() && this.fileRecoverer.isInCommittedEventsSection()) {
                    this._firstEventPosition.$colon$eq(BoxesRunTime.boxToLong((long)jsonReader.position()));
                    return;
                }
            });
            this.fileRecoverer.fileJournalHeader().foreach((Function1)(JProcedure1 & Serializable)h -> {
                Path path = JournalFiles$extensions$.MODULE$.file(this.journalLocation, h.eventId());
                Path path2 = this.file();
                if (path == null ? path2 != null : !((Object)path).equals(path2)) {
                    throw package$.MODULE$.error("JournalHeaders eventId=" + h.eventId() + " does not match the filename '" + this.file().getFileName() + "'");
                }
            });
            this.fileRecoverer.logStatistics();
        });
    }

    public Option<Object> firstEventPosition() {
        return this._firstEventPosition.toOption();
    }

    public long position() {
        return this._position;
    }

    public long lastProperEventPosition() {
        return this._lastProperEventPosition;
    }

    private static final Option recoverAll$$anonfun$1$$anonfun$1(InputStreamJsonSeqReader jsonReader$1) {
        return jsonReader$1.read();
    }
}

