/*
 * Decompiled with CFR 0.152.
 */
package js7.launcher.internal;

import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.unsafe.IORuntime;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import js7.base.catsutils.UnsafeMemoizable$;
import js7.base.log.Logger$syntax$;
import js7.base.problem.Checked$;
import js7.base.problem.Checked$CheckedOption$;
import js7.base.problem.Problem;
import js7.base.problem.Problem$;
import js7.base.thread.IOExecutor;
import js7.base.time.AlarmClock;
import js7.base.utils.Classes$;
import js7.base.utils.Lazy;
import js7.base.utils.Lazy$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.data.job.InternalExecutable;
import js7.data.job.JobConf;
import js7.data.value.Value;
import js7.data.value.expression.Scope;
import js7.data.value.expression.Scope$;
import js7.launcher.OrderProcess;
import js7.launcher.ProcessOrder;
import js7.launcher.internal.InternalJob;
import js7.launcher.internal.InternalJob$JobContext$;
import js7.launcher.internal.InternalJob$Step$;
import js7.launcher.internal.InternalJobAdapter;
import js7.launcher.internal.InternalJobLauncher$;
import js7.launcher.internal.JobLauncher;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.collection.IterableOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class InternalJobLauncher
implements JobLauncher {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(InternalJobLauncher.class.getDeclaredField("startIfNeeded$lzy1"));
    private volatile Object startIfNeeded$lzy1;
    private final InternalExecutable executable;
    private final JobConf jobConf;
    private final Map<String, Value> jobArguments;
    private final ExecutionContext blockingJobEC;
    private final AlarmClock clock;
    private final IORuntime ioRuntime;
    private final IOExecutor iox;
    private final Lazy<Either<Problem, InternalJob>> internalJobLazy;
    private final IO<Either<Problem, BoxedUnit>> start;
    private final IO<BoxedUnit> stop;

    public InternalJobLauncher(InternalExecutable executable, JobConf jobConf, Map<String, Value> jobArguments, ExecutionContext blockingJobEC, AlarmClock clock, IORuntime ioRuntime, IOExecutor iox) {
        this.executable = executable;
        this.jobConf = jobConf;
        this.jobArguments = jobArguments;
        this.blockingJobEC = blockingJobEC;
        this.clock = clock;
        this.ioRuntime = ioRuntime;
        this.iox = iox;
        JobLauncher.$init$(this);
        this.internalJobLazy = Lazy$.MODULE$.apply(() -> this.$init$$$anonfun$1(executable));
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.apply(this::$init$$$anonfun$2));
        this.start = (IO)UnsafeMemoizable$.MODULE$.unsafeMemoize(((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)internalJob -> Logger$syntax$.MODULE$.traceIO(InternalJobLauncher$.js7$launcher$internal$InternalJobLauncher$$$logger, executable.className() + " start", Logger$syntax$.MODULE$.traceIO$default$3(InternalJobLauncher$.js7$launcher$internal$InternalJobLauncher$$$logger), internalJob.start()), IO$.MODULE$.asyncForIO())).flatTap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Problem problem = (Problem)((Left)either).value();
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    InternalJobLauncher.$init$$$anonfun$4$$anonfun$1(executable, problem);
                    return BoxedUnit.UNIT;
                });
            }
            if (either instanceof Right) {
                return IO$.MODULE$.unit();
            }
            throw new MatchError((Object)either);
        }), IO$.MODULE$.asyncForIO());
        this.stop = (IO)UnsafeMemoizable$.MODULE$.unsafeMemoize(IO$.MODULE$.defer(() -> this.$init$$$anonfun$5(executable)), IO$.MODULE$.asyncForIO());
    }

    public final IO startIfNeeded() {
        Object object = this.startIfNeeded$lzy1;
        if (object instanceof IO) {
            return (IO)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (IO)this.startIfNeeded$lzyINIT1();
    }

    private Object startIfNeeded$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.startIfNeeded$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    IO iO = null;
                    try {
                        iO = JobLauncher.startIfNeeded$(this);
                        object2 = iO == null ? LazyVals.NullValue$.MODULE$ : iO;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.startIfNeeded$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return iO;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public JobConf jobConf() {
        return this.jobConf;
    }

    public Map<String, Value> jobArguments() {
        return this.jobArguments;
    }

    @Override
    public IO<Either<Problem, BoxedUnit>> start() {
        return this.start;
    }

    @Override
    public IO<BoxedUnit> stop() {
        return this.stop;
    }

    @Override
    public IO<Either<Problem, OrderProcess>> toOrderProcess(ProcessOrder processOrder) {
        return IO$.MODULE$.apply(() -> this.toOrderProcess$$anonfun$1(processOrder));
    }

    private Either<Problem, InternalJob.Step> toStep(ProcessOrder processOrder) {
        return Scope$.MODULE$.evalExpressionMap(this.executable.arguments(), (Function0<Scope>)((Function0 & Serializable)() -> InternalJobLauncher.toStep$$anonfun$1(processOrder))).map((Function1 & Serializable)args -> InternalJob$Step$.MODULE$.apply(processOrder, (Map<String, Value>)args));
    }

    private Either<Problem, Function0<Either<Problem, InternalJob>>> toInstantiator(String className) {
        return Checked$.MODULE$.catchNonFatalFlatten(() -> this.toInstantiator$$anonfun$1(className));
    }

    private Either<Problem, Function0<Either<Problem, InternalJob>>> tryAdapter(Class<?> cls2) {
        Set internalJobs = (Set)((IterableOps)Classes$.MODULE$.superclassesOf(cls2).flatMap((Function1 & Serializable)cls -> Option$.MODULE$.apply((Object)cls.getAnnotation(InternalJobAdapter.class)))).map((Function1 & Serializable)_$3 -> _$3.value());
        if (IterableOps.SizeCompareOps$.MODULE$.$greater$extension(internalJobs.sizeIs(), 1)) {
            return package$.MODULE$.Left().apply((Object)Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> InternalJobLauncher.tryAdapter$$anonfun$1(cls2)), Problem$.MODULE$.apply$default$2()));
        }
        Option option = Checked$.MODULE$.CheckedOption(internalJobs.headOption());
        return Checked$CheckedOption$.MODULE$.toChecked$extension(option, (Function0<Problem>)((Function0 & Serializable)() -> InternalJobLauncher.tryAdapter$$anonfun$2(cls2))).flatMap((Function1 & Serializable)clas -> InternalJobLauncher$.MODULE$.js7$launcher$internal$InternalJobLauncher$$$getConstructor((Class<? extends InternalJob>)clas)).map((Function1 & Serializable)con -> (Function0 & Serializable)() -> InternalJobLauncher$.MODULE$.js7$launcher$internal$InternalJobLauncher$$$construct((Constructor<InternalJob>)con, this.toJobContext(cls2)));
    }

    private InternalJob.JobContext toJobContext(Class<?> cls) {
        return InternalJob$JobContext$.MODULE$.apply(cls, this.executable, this.jobArguments(), this.jobConf(), this.ioRuntime, this.iox, this.blockingJobEC, this.clock, this.jobConf().systemEncoding());
    }

    @Override
    public String toString() {
        return "InternalJobLauncher(" + this.jobConf().jobKey() + " " + this.executable.className() + ")";
    }

    private final Either $init$$$anonfun$1(InternalExecutable executable$1) {
        return this.toInstantiator(executable$1.className()).flatMap((Function1 & Serializable)_$1 -> (Either)_$1.apply());
    }

    private final Either $init$$$anonfun$2() {
        return this.internalJobLazy.apply();
    }

    private static final void $init$$$anonfun$4$$anonfun$1(InternalExecutable executable$4, Problem problem$1) {
        Logger LoggerImpl_this = InternalJobLauncher$.js7$launcher$internal$InternalJobLauncher$$$logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug(executable$4.className() + " start: " + problem$1, problem$1.throwableOption().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
            return;
        }
    }

    private final IO $init$$$anonfun$5(InternalExecutable executable$5) {
        return (IO)this.internalJobLazy.value().fold((Function1 & Serializable)_$2 -> IO$.MODULE$.unit(), (Function1 & Serializable)internalJob -> Logger$syntax$.MODULE$.traceIO(InternalJobLauncher$.js7$launcher$internal$InternalJobLauncher$$$logger, executable$5.className() + " stop", Logger$syntax$.MODULE$.traceIO$default$3(InternalJobLauncher$.js7$launcher$internal$InternalJobLauncher$$$logger), internalJob.stop()));
    }

    private final Either toOrderProcess$$anonfun$1(ProcessOrder processOrder$1) {
        return this.internalJobLazy.apply().flatMap((Function1 & Serializable)internalJob -> this.toStep(processOrder$1).map((Function1 & Serializable)step -> internalJob.toOrderProcess((InternalJob.Step)step)));
    }

    private static final Scope toStep$$anonfun$1(ProcessOrder processOrder$3) {
        return processOrder$3.scope();
    }

    private final Either toInstantiator$$anonfun$1(String className$1) {
        return InternalJobLauncher$.MODULE$.js7$launcher$internal$InternalJobLauncher$$$loadClass(className$1).flatMap((Function1 & Serializable)cls -> {
            if (InternalJob.class.isAssignableFrom((Class<?>)cls)) {
                return InternalJobLauncher$.MODULE$.js7$launcher$internal$InternalJobLauncher$$$getConstructor((Class<? extends InternalJob>)cls).map((Function1 & Serializable)con -> (Function0 & Serializable)() -> InternalJobLauncher$.MODULE$.js7$launcher$internal$InternalJobLauncher$$$construct((Constructor<InternalJob>)con, this.toJobContext((Class<?>)cls)));
            }
            return this.tryAdapter((Class<?>)cls);
        });
    }

    private static final String tryAdapter$$anonfun$1(Class cls$3) {
        return "Class " + cls$3.getName() + " has multiple @InternalJobAdapter annotations";
    }

    private static final String tryAdapter$$anonfun$2$$anonfun$1(Class cls$5) {
        return "Class '" + cls$5.getName() + "' is not an InternalJob";
    }

    private static final Problem tryAdapter$$anonfun$2(Class cls$4) {
        return Problem$.MODULE$.apply((Function0<String>)((Function0 & Serializable)() -> InternalJobLauncher.tryAdapter$$anonfun$2$$anonfun$1(cls$4)), Problem$.MODULE$.apply$default$2());
    }
}

