/*
 * Decompiled with CFR 0.152.
 */
package js7.service.pgp;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Date;
import js7.base.crypt.SignerId;
import js7.base.generic.SecretString;
import js7.base.log.Logger$;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.crypto.generators.RSAKeyPairGenerator;
import org.bouncycastle.crypto.params.RSAKeyGenerationParameters;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcPBESecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyPair;
import scala.Int$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class PgpKeyGenerator$
implements Serializable {
    private static final Logger logger;
    public static final PgpKeyGenerator$ MODULE$;

    private PgpKeyGenerator$() {
    }

    static {
        MODULE$ = new PgpKeyGenerator$();
        logger = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(PgpKeyGenerator$.class));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PgpKeyGenerator$.class);
    }

    public PGPSecretKey generateSecretKey(SignerId id, SecretString password, int keySize) {
        int publicExponent = 65537;
        int certainty = 80;
        BcPGPKeyPair controllerSigningKeyPair = this.newKeyPair(new RSAKeyGenerationParameters(BigInteger.valueOf(Int$.MODULE$.int2long(publicExponent)), new SecureRandom(), keySize, certainty));
        PGPDigestCalculator shaCalculator = new BcPGPDigestCalculatorProvider().get(2);
        return new PGPKeyRingGenerator(19, (PGPKeyPair)controllerSigningKeyPair, id.string(), shaCalculator, this.signatureSubpackets(), null, (PGPContentSignerBuilder)new BcPGPContentSignerBuilder(controllerSigningKeyPair.getPublicKey().getAlgorithm(), 10), new BcPBESecretKeyEncryptorBuilder(9, shaCalculator).build((char[])StringOps$.MODULE$.toArray$extension(Predef$.MODULE$.augmentString(password.string()), ClassTag$.MODULE$.apply(Character.TYPE)))).generateSecretKeyRing().getSecretKey();
    }

    public int generateSecretKey$default$3() {
        return 4096;
    }

    private BcPGPKeyPair newKeyPair(RSAKeyGenerationParameters parameters) {
        return new BcPGPKeyPair(4, 1, this.newAsymmetricCipherKeyPair(parameters), new Date());
    }

    private AsymmetricCipherKeyPair newAsymmetricCipherKeyPair(RSAKeyGenerationParameters parameters) {
        RSAKeyPairGenerator generator;
        block0: {
            generator = new RSAKeyPairGenerator();
            generator.init((KeyGenerationParameters)parameters);
            Logger LoggerImpl_this = logger;
            if (!LoggerImpl_this.underlying().isDebugEnabled()) break block0;
            LoggerImpl_this.underlying().debug("Generating PGP key, {} bits ...", (Object)BoxesRunTime.boxToInteger((int)parameters.getStrength()));
        }
        return generator.generateKeyPair();
    }

    private PGPSignatureSubpacketVector signatureSubpackets() {
        PGPSignatureSubpacketGenerator generator = new PGPSignatureSubpacketGenerator();
        generator.setKeyFlags(true, 3);
        generator.setPreferredHashAlgorithms(true, new int[]{10});
        generator.setPreferredSymmetricAlgorithms(true, new int[]{9});
        generator.setFeature(true, (byte)1);
        return generator.generate();
    }
}

