/*
 * Decompiled with CFR 0.152.
 */
package js7.subagent.job;

import cats.Applicative;
import cats.Functor;
import cats.Invariant$;
import cats.UnorderedFoldable$;
import cats.effect.IO;
import cats.effect.IO$;
import cats.effect.kernel.Fiber;
import cats.effect.kernel.MonadCancel;
import cats.effect.kernel.Resource;
import cats.syntax.package;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.concurrent.atomic.AtomicReference;
import js7.base.catsutils.CatsEffectExtensions$;
import js7.base.catsutils.FiberVar;
import js7.base.catsutils.SyncDeadline;
import js7.base.catsutils.SyncDeadline$;
import js7.base.io.process.ProcessSignal;
import js7.base.io.process.ProcessSignal$SIGKILL$;
import js7.base.io.process.ProcessSignal$SIGTERM$;
import js7.base.log.Logger$;
import js7.base.problem.Problem;
import js7.base.time.ScalaTime$;
import js7.base.time.ScalaTime$RichFiniteDuration$;
import js7.base.utils.ScalaUtils$syntax$;
import js7.base.utils.ScalaUtils$syntax$RichEitherF$;
import js7.base.utils.ScalaUtils$syntax$RichThrowable$;
import js7.data.job.JobResource;
import js7.data.order.Order;
import js7.data.order.OrderId;
import js7.data.order.OrderOutcome;
import js7.data.order.OrderOutcome$Disrupted$;
import js7.data.order.OrderOutcome$Failed$;
import js7.data.order.OrderOutcome$Killed$;
import js7.data.order.OrderOutcome$TimedOut$;
import js7.data.subagent.Problems$ProcessCancelledBeforeStartProblem$;
import js7.data.value.expression.Expression;
import js7.launcher.OrderProcess;
import js7.launcher.ProcessOrder;
import js7.launcher.ProcessOrder$;
import js7.launcher.StdObservers;
import js7.launcher.internal.JobLauncher;
import js7.subagent.job.JobDriver;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class JobDriverForOrder {
    private final OrderId orderId;
    private final JobDriver.Params jobDriverParams;
    private final Logger logger;
    private final AtomicReference<Option<Either<ProcessSignal, OrderProcess>>> _orderProcess;
    private final FiberVar<BoxedUnit> sigkillFiber;
    private SyncDeadline runningSince;
    private boolean isKilled;
    private boolean sigkilled;
    private boolean timedOut;

    public JobDriverForOrder(OrderId orderId, JobDriver.Params jobDriverParams) {
        this.orderId = orderId;
        this.jobDriverParams = jobDriverParams;
        this.logger = Logger$.MODULE$.withPrefix(orderId + " in Job:" + jobDriverParams.jobConf().jobKey().simpleName(), ClassTag$.MODULE$.apply(JobDriverForOrder.class));
        Option initial$proxy1 = package.option$.MODULE$.none();
        this._orderProcess = new AtomicReference<Option>(initial$proxy1);
        this.sigkillFiber = new FiberVar();
        this.runningSince = null;
        this.isKilled = false;
        this.sigkilled = false;
        this.timedOut = false;
    }

    public OrderId orderId() {
        return this.orderId;
    }

    public IO<OrderOutcome> processOrder(Order<Order.Processing> order, Map<String, Expression> executeArguments, StdObservers stdObservers, JobLauncher jobLauncher) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(IO$.MODULE$.apply(() -> this.processOrder$$anonfun$1(order, executeArguments, stdObservers)));
        return CatsEffectExtensions$.MODULE$.catchIntoChecked((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$1 -> (IO)_$1.use((Function1 & Serializable)processOrder_ -> this.processOrder2(jobLauncher, (ProcessOrder)processOrder_), (MonadCancel)IO$.MODULE$.asyncForIO()), IO$.MODULE$.asyncForIO())).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Problem problem = (Problem)((Left)either).value();
                return OrderOutcome$Disrupted$.MODULE$.apply(problem);
            }
            if (either instanceof Right) {
                OrderOutcome outcome = (OrderOutcome)((Right)either).value();
                return outcome;
            }
            throw new MatchError((Object)either);
        });
    }

    private Either<Problem, Resource<IO, ProcessOrder>> processOrderResource(Order<Order.Processing> order, Map<String, Expression> executeArguments, StdObservers stdObservers) {
        return this.jobDriverParams.checkedJobLauncher().flatMap((Function1 & Serializable)_$2 -> (Either)package.traverse$.MODULE$.toTraverseOps(this.jobDriverParams.jobConf().jobResourcePaths(), UnorderedFoldable$.MODULE$.catsTraverseForSeq()).traverse(this.jobDriverParams.pathToJobResource(), (Applicative)Invariant$.MODULE$.catsMonadErrorForEither())).map((Function1 & Serializable)jobResources -> ProcessOrder$.MODULE$.resource(order, this.jobDriverParams.jobConf().workflow(), this.jobDriverParams.jobConf().jobKey(), this.jobDriverParams.jobConf().workflowJob(), (Seq<JobResource>)jobResources, executeArguments, this.jobDriverParams.jobConf().workflowJob().defaultArguments(), this.jobDriverParams.jobConf().controllerId(), stdObservers, this.jobDriverParams.fileValueState()));
    }

    private IO<Either<Problem, OrderOutcome>> processOrder2(JobLauncher jobLauncher, ProcessOrder processOrder) {
        IO iO = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(jobLauncher.startIfNeeded());
        IO iO2 = (IO)ScalaUtils$syntax$.MODULE$.RichEitherF(ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO, (Function1 & Serializable)_$3 -> jobLauncher.toOrderProcess(processOrder), IO$.MODULE$.asyncForIO()));
        return ((IO)ScalaUtils$syntax$RichEitherF$.MODULE$.flatMapT$extension(iO2, (Function1 & Serializable)orderProcess -> {
            Option<Either<ProcessSignal, OrderProcess>> option = this._orderProcess.getAndSet((Option<Either<ProcessSignal, OrderProcess>>)Some$.MODULE$.apply((Object)package$.MODULE$.Right().apply(orderProcess)));
            if (None$.MODULE$.equals(option)) {
                return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, orderProcess);
            }
            if (option instanceof Some) {
                Either either = (Either)((Some)option).value();
                if (either instanceof Left) {
                    ProcessSignal signal = (ProcessSignal)((Left)either).value();
                    return this.cancelProcess((OrderProcess)orderProcess, signal).as((Object)package$.MODULE$.Left().apply((Object)Problems$ProcessCancelledBeforeStartProblem$.MODULE$));
                }
                if (either instanceof Right) {
                    return IO$.MODULE$.apply(JobDriverForOrder::processOrder2$$anonfun$2$$anonfun$1);
                }
            }
            throw new MatchError(option);
        }, IO$.MODULE$.asyncForIO())).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                Problem problem = (Problem)((Left)either).value();
                if (((Object)Problems$ProcessCancelledBeforeStartProblem$.MODULE$).equals(problem)) {
                    return CatsEffectExtensions$.MODULE$.right(IO$.MODULE$, OrderOutcome$Killed$.MODULE$.apply(OrderOutcome$Failed$.MODULE$.fromProblem(Problems$ProcessCancelledBeforeStartProblem$.MODULE$, OrderOutcome$Failed$.MODULE$.fromProblem$default$2())));
                }
                Problem problem2 = problem;
                return CatsEffectExtensions$.MODULE$.left(IO$.MODULE$, problem2);
            }
            if (either instanceof Right) {
                OrderProcess orderProcess = (OrderProcess)((Right)either).value();
                return IO$.MODULE$.defer(() -> this.processOrder2$$anonfun$3$$anonfun$1(orderProcess, processOrder)).flatMap((Function1 & Serializable)fiber -> SyncDeadline$.MODULE$.usingNow((JProcedure1 & Serializable)now -> {
                    this.runningSince = now;
                }).$times$greater(this.scheduleTimeoutCancellation()).flatMap((Function1 & Serializable)timeoutFiber -> ((IO)package.functor$.MODULE$.toFunctorOps((Object)((IO)CatsEffectExtensions$.MODULE$.joinStd(fiber, IO$.MODULE$.asyncForIO())).map((Function1 & Serializable)outcome -> this.modifyOutcome((OrderOutcome)outcome)), (Functor)IO$.MODULE$.asyncForIO()).mapOrKeep((PartialFunction)new Serializable(processOrder, this){
                    private final ProcessOrder processOrder$6;
                    private final /* synthetic */ JobDriverForOrder $outer;
                    {
                        this.processOrder$6 = processOrder$7;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(OrderOutcome x2) {
                        OrderOutcome orderOutcome = x2;
                        if (orderOutcome instanceof OrderOutcome.IsSucceeded) {
                            OrderOutcome.IsSucceeded outcome = (OrderOutcome.IsSucceeded)orderOutcome;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(OrderOutcome x2, Function1 function1) {
                        OrderOutcome orderOutcome = x2;
                        if (orderOutcome instanceof OrderOutcome.IsSucceeded) {
                            OrderOutcome.IsSucceeded outcome = (OrderOutcome.IsSucceeded)orderOutcome;
                            return this.$outer.js7$subagent$job$JobDriverForOrder$$readErrorLine(this.processOrder$6).getOrElse(() -> JobDriverForOrder.js7$subagent$job$JobDriverForOrder$$anon$1$$_$applyOrElse$$anonfun$1(outcome));
                        }
                        return function1.apply((Object)x2);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{js7$subagent$job$JobDriverForOrder$$anon$1$$_$applyOrElse$$anonfun$1(js7.data.order.OrderOutcome$IsSucceeded )}, serializedLambda);
                    }
                })).guarantee((IO)timeoutFiber.cancel()).guarantee(this.sigkillFiber.cancel()))).handleError((Function1 & Serializable)t -> {
                    block0: {
                        Logger LoggerImpl_this = this.logger;
                        if (!LoggerImpl_this.underlying().isErrorEnabled()) break block0;
                        Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                        Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                        LoggerImpl_this.underlying().error(String.valueOf(ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable)), (Object)ScalaUtils$syntax$RichThrowable$.MODULE$.nullIfNoStackTrace$extension(throwable2));
                    }
                    return OrderOutcome$Failed$.MODULE$.fromThrowable((Throwable)t);
                }).map((Function1 & Serializable)_$4 -> package$.MODULE$.Right().apply(_$4));
            }
            throw new MatchError((Object)either);
        });
    }

    private OrderOutcome modifyOutcome(OrderOutcome outcome) {
        OrderOutcome orderOutcome = outcome;
        if (orderOutcome instanceof OrderOutcome.Completed) {
            OrderOutcome.Completed outcome2 = (OrderOutcome.Completed)orderOutcome;
            if (this.timedOut) {
                return OrderOutcome$TimedOut$.MODULE$.apply(outcome2);
            }
            if (this.isKilled) {
                return OrderOutcome$Killed$.MODULE$.apply(outcome2);
            }
            return outcome2;
        }
        OrderOutcome o = orderOutcome;
        return o;
    }

    public Option<OrderOutcome.Failed> js7$subagent$job$JobDriverForOrder$$readErrorLine(ProcessOrder processOrder) {
        return processOrder.stdObservers().errorLine().map((Function1 & Serializable)errorLine -> {
            if (!this.jobDriverParams.jobConf().workflowJob().failOnErrWritten()) {
                throw Scala3RunTime$.MODULE$.assertFailed();
            }
            return OrderOutcome$Failed$.MODULE$.apply((Option<String>)Some$.MODULE$.apply((Object)("The job's error channel: " + errorLine)), OrderOutcome$Failed$.MODULE$.apply$default$2(), OrderOutcome$Failed$.MODULE$.apply$default$3());
        });
    }

    private IO<Fiber<IO, Throwable, BoxedUnit>> scheduleTimeoutCancellation() {
        return IO$.MODULE$.defer(this::scheduleTimeoutCancellation$$anonfun$1);
    }

    public IO<BoxedUnit> killWithSigkillDelay(ProcessSignal signal_) {
        return IO$.MODULE$.defer(() -> this.killWithSigkillDelay$$anonfun$1(signal_));
    }

    public IO<BoxedUnit> kill(ProcessSignal signal) {
        return IO$.MODULE$.defer(() -> this.kill$$anonfun$1(signal));
    }

    private IO<BoxedUnit> cancelProcess(OrderProcess orderProcess, ProcessSignal signal) {
        ProcessSignal processSignal = signal;
        ProcessSignal$SIGKILL$ processSignal$SIGKILL$ = ProcessSignal$SIGKILL$.MODULE$;
        return orderProcess.cancel(!(processSignal != null ? !processSignal.equals(processSignal$SIGKILL$) : processSignal$SIGKILL$ != null)).handleError((Function1)(JProcedure1 & Serializable)t -> {
            Logger LoggerImpl_this = this.logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                Throwable throwable2 = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                LoggerImpl_this.underlying().error("Kill " + signal + " => " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable), (Object)ScalaUtils$syntax$RichThrowable$.MODULE$.nullIfNoStackTrace$extension(throwable2));
                return;
            }
        });
    }

    private final Either processOrder$$anonfun$1(Order order$1, Map executeArguments$1, StdObservers stdObservers$1) {
        return this.processOrderResource(order$1, (Map<String, Expression>)executeArguments$1, stdObservers$1);
    }

    private static final Nothing$ processOrder2$$anonfun$2$$anonfun$1() {
        return scala.sys.package$.MODULE$.error("Duplicate orderProcess?");
    }

    private final IO processOrder2$$anonfun$3$$anonfun$1(OrderProcess orderProcess$1, ProcessOrder processOrder$2) {
        return orderProcess$1.start(processOrder$2.order().id(), this.jobDriverParams.jobConf().jobKey());
    }

    public static final OrderOutcome.Completed js7$subagent$job$JobDriverForOrder$$anon$1$$_$applyOrElse$$anonfun$1(OrderOutcome.IsSucceeded outcome$1) {
        return outcome$1;
    }

    private static final IO scheduleTimeoutCancellation$$anonfun$1$$anonfun$1() {
        return IO$.MODULE$.unit();
    }

    private final /* synthetic */ IO scheduleTimeoutCancellation$$anonfun$1$$anonfun$2(SyncDeadline since$1, FiniteDuration timeout) {
        return IO$.MODULE$.sleep(timeout).flatMap((Function1 & Serializable)_$5 -> SyncDeadline$.MODULE$.usingNow((JProcedure1 & Serializable)contextual$1 -> {
            this.timedOut = true;
            Logger LoggerImpl_this = this.logger;
            if (LoggerImpl_this.underlying().isWarnEnabled()) {
                LoggerImpl_this.underlying().warn("OrderProcess has timed out after {} and will be killed now", (Object)ScalaTime$RichFiniteDuration$.MODULE$.pretty$extension(ScalaTime$.MODULE$.RichFiniteDuration(since$1.elapsed((SyncDeadline.Now)contextual$1))));
                return;
            }
        })).flatMap((Function1 & Serializable)_$6 -> CatsEffectExtensions$.MODULE$.startAndForget(this.killWithSigkillDelay(ProcessSignal$SIGTERM$.MODULE$).handleError((Function1)(JProcedure1 & Serializable)t -> {
            Logger LoggerImpl_this = this.logger;
            if (LoggerImpl_this.underlying().isErrorEnabled()) {
                Throwable throwable = ScalaUtils$syntax$.MODULE$.RichThrowable(t);
                LoggerImpl_this.underlying().error("killOrderAndForget => " + ScalaUtils$syntax$RichThrowable$.MODULE$.toStringWithCauses$extension(throwable), t);
                return;
            }
        })));
    }

    /*
     * WARNING - void declaration
     */
    private final IO scheduleTimeoutCancellation$$anonfun$1() {
        void var2_1;
        SyncDeadline x$proxy1 = this.runningSince;
        if (x$proxy1 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        void since = var2_1;
        return ((IO)this.jobDriverParams.jobConf().workflowJob().timeout().fold(JobDriverForOrder::scheduleTimeoutCancellation$$anonfun$1$$anonfun$1, arg_0 -> this.scheduleTimeoutCancellation$$anonfun$1$$anonfun$2((SyncDeadline)since, arg_0))).start();
    }

    private final IO killWithSigkillDelay$$anonfun$1$$anonfun$2$$anonfun$1() {
        block0: {
            Logger LoggerImpl_this = this.logger;
            if (!LoggerImpl_this.underlying().isWarnEnabled()) break block0;
            LoggerImpl_this.underlying().warn("SIGKILL now, because sigkillDelay elapsed");
        }
        return this.kill(ProcessSignal$SIGKILL$.MODULE$);
    }

    private final IO killWithSigkillDelay$$anonfun$1$$anonfun$2() {
        return IO$.MODULE$.sleep(this.jobDriverParams.jobConf().sigkillDelay()).productR(IO$.MODULE$.defer(this::killWithSigkillDelay$$anonfun$1$$anonfun$2$$anonfun$1)).start().flatMap((Function1 & Serializable)fiber -> this.sigkillFiber.set((Fiber<IO, Throwable, BoxedUnit>)fiber));
    }

    private final IO killWithSigkillDelay$$anonfun$1(ProcessSignal signal_$1) {
        ProcessSignal signal = ScalaTime$RichFiniteDuration$.MODULE$.isZeroOrBelow$extension(ScalaTime$.MODULE$.RichFiniteDuration(this.jobDriverParams.jobConf().sigkillDelay())) ? ProcessSignal$SIGKILL$.MODULE$ : signal_$1;
        ProcessSignal processSignal = signal;
        ProcessSignal$SIGKILL$ processSignal$SIGKILL$ = ProcessSignal$SIGKILL$.MODULE$;
        return this.kill(signal).$times$greater(IO$.MODULE$.whenA((processSignal == null ? processSignal$SIGKILL$ != null : !processSignal.equals(processSignal$SIGKILL$)) && this._orderProcess.get().exists((Function1 & Serializable)_$7 -> _$7.isRight()), this::killWithSigkillDelay$$anonfun$1$$anonfun$2));
    }

    private final void kill$$anonfun$1$$anonfun$1$$anonfun$1(ProcessSignal signal$3) {
        Logger LoggerImpl_this = this.logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("\u26a0\ufe0f kill({}) BEFORE STARTED", (Object)signal$3);
            return;
        }
    }

    private final void kill$$anonfun$1$$anonfun$1$$anonfun$2(ProcessSignal signal$4) {
        Logger LoggerImpl_this = this.logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("Already killed with {}", (Object)signal$4);
            return;
        }
    }

    private final IO kill$$anonfun$1$$anonfun$1$$anonfun$3(ProcessSignal signal$5, OrderProcess orderProcess$2) {
        Logger LoggerImpl_this = this.logger;
        if (LoggerImpl_this.underlying().isDebugEnabled()) {
            LoggerImpl_this.underlying().debug("Kill {}", (Object)signal$5);
        }
        this.isKilled = true;
        ProcessSignal processSignal = signal$5;
        ProcessSignal$SIGKILL$ processSignal$SIGKILL$ = ProcessSignal$SIGKILL$.MODULE$;
        this.sigkilled |= !(processSignal != null ? !processSignal.equals(processSignal$SIGKILL$) : processSignal$SIGKILL$ != null);
        return this.cancelProcess(orderProcess$2, signal$5);
    }

    private final IO kill$$anonfun$1$$anonfun$1(ProcessSignal signal$2) {
        Option<Either<ProcessSignal, OrderProcess>> option = this._orderProcess.compareAndExchange((Option<Either<ProcessSignal, OrderProcess>>)None$.MODULE$, (Option<Either<ProcessSignal, OrderProcess>>)Some$.MODULE$.apply((Object)package$.MODULE$.Left().apply((Object)signal$2)));
        if (None$.MODULE$.equals(option)) {
            return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                this.kill$$anonfun$1$$anonfun$1$$anonfun$1(signal$2);
                return BoxedUnit.UNIT;
            });
        }
        if (option instanceof Some) {
            Either either = (Either)((Some)option).value();
            if (either instanceof Left) {
                ProcessSignal signal = (ProcessSignal)((Left)either).value();
                return IO$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.kill$$anonfun$1$$anonfun$1$$anonfun$2(signal);
                    return BoxedUnit.UNIT;
                });
            }
            if (either instanceof Right) {
                OrderProcess orderProcess = (OrderProcess)((Right)either).value();
                return IO$.MODULE$.defer(() -> this.kill$$anonfun$1$$anonfun$1$$anonfun$3(signal$2, orderProcess));
            }
        }
        throw new MatchError(option);
    }

    private final IO kill$$anonfun$1(ProcessSignal signal$1) {
        ProcessSignal processSignal = signal$1;
        ProcessSignal$SIGKILL$ processSignal$SIGKILL$ = ProcessSignal$SIGKILL$.MODULE$;
        return IO$.MODULE$.unlessA(!(processSignal != null ? !processSignal.equals(processSignal$SIGKILL$) : processSignal$SIGKILL$ != null) && this.sigkilled, () -> this.kill$$anonfun$1$$anonfun$1(signal$1));
    }
}

