/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.console.password;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.panels.userinput.console.ConsoleField;
import com.izforge.izpack.panels.userinput.field.ValidationStatus;
import com.izforge.izpack.panels.userinput.field.password.PasswordField;
import com.izforge.izpack.panels.userinput.field.password.PasswordGroupField;
import com.izforge.izpack.panels.userinput.gui.password.PasswordGroup;
import com.izforge.izpack.util.Console;
import java.util.List;

public class ConsolePasswordGroupField
extends ConsoleField {
    public ConsolePasswordGroupField(PasswordGroupField field, Console console, Prompt prompt) {
        super(field, console, prompt);
    }

    @Override
    public PasswordGroupField getField() {
        return (PasswordGroupField)super.getField();
    }

    @Override
    public boolean display() {
        if (this.isReadonly()) {
            return true;
        }
        boolean result = false;
        this.printDescription();
        String[] passwords = this.getPasswords();
        if (passwords != null) {
            PasswordGroupField field = this.getField();
            ValidationStatus status = field.validate(new PasswordGroup(passwords));
            if (status.isValid()) {
                try {
                    field.setValue(passwords[0]);
                    result = true;
                }
                catch (Throwable exception) {
                    this.error(exception.getMessage());
                }
            } else {
                this.error(status.getMessage());
            }
        }
        return result;
    }

    private String[] getPasswords() {
        List<PasswordField> fields = this.getField().getPasswordFields();
        Console console = this.getConsole();
        String[] values = new String[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            String value;
            values[i] = value = console.promptPassword(fields.get(i).getLabel(), "");
        }
        return values;
    }
}

