/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userpath;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.resource.Messages;
import com.izforge.izpack.core.substitutor.VariableSubstitutorImpl;
import com.izforge.izpack.installer.console.AbstractConsolePanel;
import com.izforge.izpack.installer.console.ConsolePanel;
import com.izforge.izpack.installer.panel.PanelView;
import com.izforge.izpack.panels.userpath.UserPathPanel;
import com.izforge.izpack.panels.userpath.UserPathPanelAutomationHelper;
import com.izforge.izpack.util.Console;
import java.io.File;
import java.io.PrintWriter;
import java.util.Properties;

public class UserPathConsolePanel
extends AbstractConsolePanel {
    public static final String PATH_VARIABLE = UserPathPanel.pathVariableName;
    public static final String PATH_PACK_DEPENDS = UserPathPanel.pathPackDependsName;
    public static final String PATH_ELEMENT = UserPathPanel.pathElementName;
    public static final String USER_PATH_INFO = "UserPathPanel.info";
    public static final String USER_PATH_NODIR = "UserPathPanel.nodir";
    public static final String USER_PATH_EXISTS = "UserPathPanel.exists_warn";
    private static final String EMPTY = "";
    private Messages messages;
    private final InstallData installData;

    public UserPathConsolePanel(PanelView<ConsolePanel> panel, InstallData installData) {
        super(panel);
        this.installData = installData;
    }

    private void loadLangpack(InstallData installData) {
        this.messages = installData.getMessages();
    }

    private String getTranslation(String id) {
        return this.messages.get(id, new Object[0]);
    }

    public boolean generateOptions(InstallData installData, PrintWriter printWriter) {
        return false;
    }

    @Override
    public boolean run(InstallData installData, Properties p) {
        return false;
    }

    @Override
    public boolean run(InstallData installData, Console console) {
        this.printHeadLine(installData, console);
        this.loadLangpack(installData);
        VariableSubstitutorImpl vs = new VariableSubstitutorImpl(installData.getVariables());
        String pathMessage = this.getTranslation(USER_PATH_INFO);
        String defaultUserPathPanel = installData.getVariable(PATH_VARIABLE);
        defaultUserPathPanel = defaultUserPathPanel == null ? EMPTY : vs.substitute(defaultUserPathPanel, null);
        String userPathPanel = console.promptLocation(pathMessage + " [" + defaultUserPathPanel + "]", defaultUserPathPanel);
        if (userPathPanel == null) {
            return false;
        }
        if (EMPTY.equals(userPathPanel)) {
            if (EMPTY.equals(defaultUserPathPanel)) {
                UserPathConsolePanel.out("Error: Path is empty! Enter a valid path");
                return this.run(installData, console);
            }
            userPathPanel = defaultUserPathPanel;
        } else {
            userPathPanel = vs.substitute(userPathPanel, null);
        }
        if (!UserPathConsolePanel.isPathAFile(userPathPanel)) {
            if (UserPathConsolePanel.doesPathExists(userPathPanel) && !UserPathConsolePanel.isPathEmpty(userPathPanel)) {
                UserPathConsolePanel.out(this.getTranslation(USER_PATH_EXISTS));
                if (!this.promptEndPanel(installData, console)) {
                    return false;
                }
            }
        } else {
            UserPathConsolePanel.out(this.getTranslation(USER_PATH_NODIR));
            return this.run(installData, console);
        }
        if (this.promptEndPanel(installData, console)) {
            installData.setVariable(PATH_VARIABLE, userPathPanel);
            return true;
        }
        return false;
    }

    private static boolean doesPathExists(String path) {
        File file = new File(path);
        return file.exists();
    }

    private static boolean isPathAFile(String path) {
        File file = new File(path);
        return file.isFile();
    }

    private static boolean isPathEmpty(String path) {
        File file = new File(path);
        return file.list().length == 0;
    }

    private static void out(String out) {
        System.out.println(out);
    }

    @Override
    public void createInstallationRecord(IXMLElement panelRoot) {
        new UserPathPanelAutomationHelper().createInstallationRecord(this.installData, panelRoot);
    }
}

