/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class SOSFile {
    public static DirectoryStream<Path> getFileListStream(Path folder, String regexp, int flag) throws IOException {
        if (folder == null) {
            throw new FileNotFoundException("directory not specified!!");
        }
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            throw new FileNotFoundException("directory does not exist: " + folder);
        }
        Pattern pattern = Pattern.compile(regexp, flag);
        return Files.newDirectoryStream(folder, path -> {
            if (Files.isDirectory(path, new LinkOption[0])) {
                return false;
            }
            return pattern.matcher(path.getFileName().toString()).find();
        });
    }

    public static DirectoryStream<Path> getSubDirsStream(Path folder) throws IOException {
        if (folder == null) {
            throw new FileNotFoundException("directory not specified!!");
        }
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            throw new FileNotFoundException("directory does not exist: " + folder);
        }
        return Files.newDirectoryStream(folder, path -> Files.isDirectory(path, new LinkOption[0]));
    }

    public static Stream<Path> getFilesStream(Path folder, String regexp, int flag, boolean withSubFolder) throws IOException {
        if (folder == null) {
            throw new FileNotFoundException("empty directory not allowed!!");
        }
        if (!Files.isDirectory(folder, new LinkOption[0])) {
            throw new FileNotFoundException("directory does not exist: " + folder.toString());
        }
        Predicate<Path> predicate = p -> !Files.isDirectory(p, new LinkOption[0]);
        if (regexp != null) {
            Pattern pattern = Pattern.compile(regexp, flag);
            predicate = p -> !Files.isDirectory(p, new LinkOption[0]) && pattern.matcher(p.getFileName().toString()).find();
        }
        if (withSubFolder) {
            return Files.walk(folder, new FileVisitOption[0]).filter(predicate);
        }
        return Files.list(folder).filter(predicate);
    }

    public static Stream<Path> getFilesStream(Path folder, String regexp, int flag) throws IOException {
        return SOSFile.getFilesStream(folder, regexp, flag, false);
    }

    public static Path copyFile(Path source, Path dest) throws IOException {
        return Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
    }

    public static Path copyFolder(final Path source, final Path target) throws IOException {
        return Files.walkFileTree(source, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                try {
                    Files.copy(dir, target.resolve(source.relativize(dir)), StandardCopyOption.COPY_ATTRIBUTES);
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                }
                catch (IOException e) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                SOSFile.copyFile(file, target.resolve(source.relativize(file)));
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public static void deleteFolder(Path folder, boolean retainRootFolder) throws IOException {
        if (Files.exists(folder, new LinkOption[0])) {
            Files.walk(folder, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(entry -> {
                try {
                    if (!retainRootFolder || !folder.equals(entry)) {
                        Files.delete(entry);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("%1$s could not be removed: %2$s", entry.toString(), e.toString()), e);
                }
            });
        }
    }

    public static void deleteFiles(Path folder) throws IOException {
        SOSFile.deleteFiles(folder, null, 0);
    }

    public static void deleteFiles(Path folder, String regexp, int flag) throws IOException {
        if (Files.exists(folder, new LinkOption[0])) {
            Predicate<Path> predicate = p -> !Files.isDirectory(p, new LinkOption[0]);
            if (regexp != null) {
                Pattern pattern = Pattern.compile(regexp, flag);
                predicate = p -> !Files.isDirectory(p, new LinkOption[0]) && pattern.matcher(p.getFileName().toString()).find();
            }
            Files.list(folder).filter(predicate).forEach(p -> {
                try {
                    Files.deleteIfExists(p);
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("%1$s could not be removed: %2$s", p.toString(), e.toString()), e);
                }
            });
        }
    }

    public static void deleteFilesExcept(Path file) throws IOException {
        Path folder;
        if (file != null && file.getParent() != null && Files.exists(folder = file.getParent(), new LinkOption[0])) {
            String filename = file.getFileName().toString();
            Predicate<Path> predicate = p -> !Files.isDirectory(p, new LinkOption[0]) && !p.getFileName().toString().equals(filename);
            Files.list(folder).filter(predicate).forEach(p -> {
                try {
                    Files.deleteIfExists(p);
                }
                catch (IOException e) {
                    throw new RuntimeException(String.format("%1$s could not be removed: %2$s", p.toString(), e.toString()), e);
                }
            });
        }
    }

    public static void deleteFolder(Path folder) throws Exception {
        SOSFile.deleteFolder(folder, false);
    }

    public static String cutWorkingDir(Path path) {
        if (path == null) {
            return "";
        }
        Path workDir = Paths.get("", new String[0]).toAbsolutePath();
        if (path.startsWith(workDir)) {
            return workDir.relativize(path).toString();
        }
        return path.toString();
    }

    public static Path normalizePath(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        return SOSFile.normalizePath(Paths.get(path, new String[0]));
    }

    public static Path normalizePath(Path path) {
        Path p;
        block7: {
            if (path == null || path.toString().isEmpty()) {
                return null;
            }
            Path p2 = p = path.toAbsolutePath().normalize();
            try {
                int count = p.getNameCount();
                if (count <= 0) break block7;
                for (int i = 0; i < count; ++i) {
                    try {
                        p = p2.getRoot().resolve(p2.subpath(0, count - i)).toRealPath(new LinkOption[0]);
                        if (i > 0) {
                            p = p.resolve(p2.subpath(count - i, count)).toAbsolutePath();
                        }
                        break;
                    }
                    catch (IOException iOException) {
                        continue;
                    }
                }
            }
            catch (Exception e) {
                p = p2;
            }
        }
        return p;
    }

    public static void deleteEmptyTree(Path folder) throws IOException {
        Files.walk(folder, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).forEach(path -> {
            try {
                if (Files.isDirectory(path, new LinkOption[0]) && !Files.newDirectoryStream(path).iterator().hasNext()) {
                    Files.delete(path);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static long countFilesInTree(Path folder) {
        try {
            return Files.walk(folder, new FileVisitOption[0]).filter(p -> !Files.isDirectory(p, new LinkOption[0])).count();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

