/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;

public class UpdateDatabaseDefaultPort
implements PanelAction {
    @Override
    public void executeAction(InstallData idata, AbstractUIHandler ah) {
        String databaseDbmsDefault = idata.getVariable("databaseDbmsDefault");
        String databaseDbms = idata.getVariable("databaseDbms");
        String databasePort = idata.getVariable("databasePort");
        try {
            if (!databaseDbms.equals(databaseDbmsDefault) || databasePort.isEmpty()) {
                idata.setVariable("databasePort", this.setDatabaseDefaultPorts(databaseDbms, databasePort));
                idata.setVariable("databaseDbmsDefault", databaseDbms);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void initialize(PanelActionConfiguration pac) {
    }

    private String setDatabaseDefaultPorts(String dbms, String defaultVal) {
        if (dbms.equals("mysql")) {
            return "3306";
        }
        if (dbms.equals("oracle")) {
            return "1521";
        }
        if (dbms.equals("mssql")) {
            return "1433";
        }
        if (dbms.equals("sybase")) {
            return "5000";
        }
        if (dbms.equals("h2")) {
            return "";
        }
        if (dbms.equals("pgsql")) {
            return "5432";
        }
        return defaultVal;
    }
}

