/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field.search;

import com.izforge.izpack.api.adaptator.IXMLElement;
import com.izforge.izpack.api.data.binding.OsModel;
import com.izforge.izpack.api.exception.IzPackException;
import com.izforge.izpack.panels.userinput.field.Config;
import com.izforge.izpack.panels.userinput.field.FieldReader;
import com.izforge.izpack.panels.userinput.field.search.ResultType;
import com.izforge.izpack.panels.userinput.field.search.SearchFieldConfig;
import com.izforge.izpack.panels.userinput.field.search.SearchType;
import com.izforge.izpack.util.OsConstraintHelper;
import com.izforge.izpack.util.PlatformModelMatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SearchFieldReader
extends FieldReader
implements SearchFieldConfig {
    private int selected = -1;
    private final PlatformModelMatcher matcher;
    private static final Logger logger = Logger.getLogger(SearchFieldReader.class.getName());
    private static final String SEARCH_TYPE = "type";
    private static final String RESULT_TYPE = "result";

    public SearchFieldReader(IXMLElement field, Config config, PlatformModelMatcher matcher) {
        super(field, config);
        this.matcher = matcher;
    }

    @Override
    public String getFilename() {
        return this.getConfig().getString(this.getSpec(), "filename", null);
    }

    @Override
    public String getCheckFilename() {
        return this.getConfig().getString(this.getSpec(), "checkfilename", null);
    }

    @Override
    public SearchType getSearchType() {
        SearchType result = SearchType.FILE;
        Config config = this.getConfig();
        IXMLElement spec = this.getSpec();
        String value = config.getString(spec, SEARCH_TYPE, result.toString());
        try {
            result = SearchType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            logger.log(Level.INFO, "Invalid value for 'type': " + value + " in " + config.getContext(spec));
        }
        return result;
    }

    @Override
    public ResultType getResultType() {
        ResultType result;
        Config config = this.getConfig();
        IXMLElement spec = this.getSpec();
        String value = config.getAttribute(spec, RESULT_TYPE);
        try {
            result = ResultType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            throw new IzPackException("Invalid value for 'result': " + value + " in " + config.getContext(spec));
        }
        return result;
    }

    @Override
    public List<String> getChoices() {
        this.selected = -1;
        ArrayList<String> result = new ArrayList<String>();
        Config config = this.getConfig();
        IXMLElement spec = this.getSpec();
        String set = config.getString(spec, "set", null);
        for (IXMLElement element : spec.getChildrenNamed("choice")) {
            List<OsModel> models = OsConstraintHelper.getOsList(element);
            if (!this.matcher.matchesCurrentPlatform(models)) continue;
            String value = config.getString(element, "value", null);
            if (value.equals(set)) {
                this.selected = result.size();
            }
            result.add(value);
        }
        return result;
    }

    @Override
    public int getSelectedIndex() {
        return this.selected;
    }
}

