/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.izforge.izpack.util.OsVersion;
import com.sos.izpack.process.ProcessHelper;
import com.sos.izpack.process.SOSCommandResult;
import com.sos.izpack.process.SOSFile;
import com.sos.izpack.process.SOSShell;
import com.sos.izpack.util.Install;
import com.sos.izpack.util.XmlInfo;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;

public class InstallDbTables
extends ProcessHelper {
    private final String[] sqlCommand = new String[8];
    private String dbms = null;

    @Override
    public boolean run(String[] args) throws Exception {
        this.ok = true;
        String param = "install";
        String dbError = Install.getDbConnectionError();
        if (args.length > 0) {
            param = args[0];
        }
        if (param != null) {
            if (param.equals("install")) {
                this.writeHeader("Initial database");
            } else {
                this.writeHeader("Update database");
            }
            if (dbError != null && dbError.length() > 0) {
                String installDbScript = OsVersion.IS_WINDOWS ? "\\install\\joc_install_tables.cmd" : "/install/joc_install_tables.sh";
                this.log("... no database transaction proceeds because of the previous database connection error:", new Object[0]);
                this.log(dbError, new Object[0]);
                this.log("... you can call the script %1$s for later database processing.", this.idata.getInstallPath() + installDbScript);
                Install.setInstallError(dbError);
                this.updateInstallResult();
            } else {
                this.execSqls(param);
            }
        }
        return this.ok;
    }

    private void readDbmsSettings(Path settingsFile) throws IOException {
        try {
            XmlInfo hibernateDom = new XmlInfo(settingsFile);
            this.dbms = hibernateDom.getDbmsFromDBDialect();
        }
        catch (Exception e) {
            this.dbms = null;
        }
        if (this.dbms == null || this.dbms.isEmpty()) {
            throw new IOException("... the database management system couldn't be found");
        }
        this.log("... the database management system is %1$s", this.dbms);
        this.dbms = this.dbms.toLowerCase();
    }

    private boolean execSqls(String param) {
        Path configDir = Paths.get(this.idata.getVariable("APPDATA_PATH"), "resources", "joc");
        Path settingsFile = configDir.resolve("hibernate.cfg.xml");
        Path dbDir = Paths.get(this.idata.getInstallPath(), "db");
        try {
            if (!Files.isReadable(settingsFile)) {
                throw new IOException(String.format("... the database connection settings file '%1$s' doesn't exist", settingsFile.toString()));
            }
            this.readDbmsSettings(settingsFile);
            Path dbSubDir = dbDir.resolve(this.dbms);
            if (!Files.isReadable(dbSubDir)) {
                throw new IOException(String.format("... the directory %1$s doesn't exist", dbSubDir.toString()));
            }
            Path javaBin = Paths.get(this.idata.getVariable("JAVA_HOME"), "bin");
            javaBin = OsVersion.IS_WINDOWS ? javaBin.resolve("java.exe") : javaBin.resolve("java");
            this.sqlCommand[0] = javaBin.toString();
            this.sqlCommand[1] = "-classpath";
            this.sqlCommand[2] = this.getClassPath();
            this.sqlCommand[3] = "com.sos.commons.hibernate.SOSHibernateFileProcessor";
            this.sqlCommand[4] = settingsFile.toString();
            this.sqlCommand[5] = dbSubDir.toString();
            this.sqlCommand[6] = "";
            this.sqlCommand[7] = "-execute-from-setup";
            this.execSql(param, dbSubDir);
            this.log("... done", new Object[0]);
        }
        catch (Throwable e) {
            Install.setDbConnectionError(e.toString());
            this.log("... error occurred while executing %1$s:", param);
            this.log(e);
            return false;
        }
        return true;
    }

    private String getClassPath() throws Exception {
        return String.format("%1$s%2$s%4$s%1$s%2$s/patches%3$s%4$s%1$s%2$s/user_lib%3$s%4$s%5$s%2$s/ext/joc%3$s%4$s%5$s/webapps/joc/WEB-INF%2$s%3$s", this.idata.getInstallPath().replace('\\', '/'), "/lib", "/*", File.pathSeparator, this.idata.getVariable("APPDATA_PATH").replace('\\', '/'));
    }

    private void execSql(String param, Path dbDir) throws Throwable {
        this.execSql(param, dbDir, false, this.timeout);
    }

    private void execSql(String param, Path dbDir, boolean suppressError) throws Throwable {
        this.execSql(param, dbDir, suppressError, this.timeout);
    }

    private void execSql(String param, Path dbDir, boolean suppressError, long timeOut) throws Throwable {
        DirectoryStream<Path> sqls = null;
        if (param == null) {
            param = "";
        }
        if (param.equals("install") || param.equals("") || param.equals("update")) {
            if (!param.equals("update")) {
                this.log("... create database tables which not already exist", new Object[0]);
            } else {
                this.log("... update database tables", new Object[0]);
            }
            sqls = SOSFile.getFileListStream(dbDir, "(?<!_insert|_rename|_alter|_procedure|_trigger|_manually|_rescue)\\.sql$", 2);
            for (Path sql : sqls) {
                this.execSql(sql.getFileName().toString(), dbDir);
            }
            sqls = SOSFile.getFileListStream(dbDir, "_alter\\.sql$", 2);
            for (Path sql : sqls) {
                if (sql.getFileName().toString().endsWith("_clob_alter.sql")) {
                    this.log("... processing " + sql.getFileName().toString() + " might take some time", new Object[0]);
                    this.execSql(sql.getFileName().toString(), dbDir, true, 600L);
                    continue;
                }
                this.execSql(sql.getFileName().toString(), dbDir, true, 120L);
            }
            sqls = SOSFile.getFileListStream(dbDir, "_procedure\\.sql$", 2);
            for (Path sql : sqls) {
                this.execSql(sql.getFileName().toString(), dbDir, "pgsql".equals(this.dbms));
            }
            if (!param.equals("update")) {
                this.log("... insert initial rows into database tables", new Object[0]);
            }
            sqls = SOSFile.getFileListStream(dbDir, "_insert\\.sql$", 2);
            for (Path sql : sqls) {
                this.execSql(sql.getFileName().toString(), dbDir);
            }
            sqls = SOSFile.getFileListStream(dbDir, "_trigger\\.sql$", 2);
            for (Path sql : sqls) {
                this.execSql(sql.getFileName().toString(), dbDir);
            }
        } else if (param.toLowerCase().endsWith(".sql")) {
            this.sqlCommand[6] = param;
            SOSCommandResult pr = SOSShell.executeCommand(timeOut, this.sqlCommand);
            if (pr.getExitCode() == 0) {
                this.log("... " + pr.getStdErr().trim(), new Object[0]);
            } else if (!suppressError) {
                throw new SQLException(pr.getStdErr());
            }
        }
    }
}

