/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.util.OsVersion;
import com.sos.izpack.process.ProcessHelper;
import com.sos.izpack.process.SOSCommandResult;
import com.sos.izpack.process.SOSShell;
import com.sos.izpack.util.WindowsRegistry;
import java.io.BufferedReader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JettyJavaOptions
extends ProcessHelper {
    private static final String XMX = "-Xmx";
    private static final String XMS = "-Xms";
    private static final String XSS = "-Xss";
    private Set<String> options = new HashSet<String>();
    private Integer optionXms = null;
    private Integer optionXmx = null;
    private Integer optionXss = null;

    public JettyJavaOptions(InstallData idata) {
        this.idata = idata;
    }

    public String getOptionXms(String _default) {
        if (this.optionXms == null || this.optionXms == 0) {
            if (_default == null) {
                return "";
            }
            return _default.replaceAll("\\D", "");
        }
        return this.optionXms.toString();
    }

    public String getOptionXmx(String _default) {
        if (this.optionXmx == null || this.optionXmx == 0) {
            if (_default == null) {
                return "";
            }
            return _default.replaceAll("\\D", "");
        }
        return this.optionXmx.toString();
    }

    public String getOptionXss(String _default) {
        if (this.optionXss == null || this.optionXss == 0) {
            if (_default == null) {
                return "";
            }
            return _default.replaceAll("\\D", "");
        }
        return this.optionXss.toString();
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public void setOptions(Set<String> options) {
        this.options = options;
    }

    public String getOptionsString() {
        String opt = "";
        for (String o : this.options) {
            opt = opt + " " + o;
        }
        return opt.trim();
    }

    public void read() {
        if (OsVersion.IS_WINDOWS) {
            this.readOptionsOnWindows(this.idata.getVariable("jettyServiceName"));
        } else {
            this.readOptionsOnUnix(this.idata.getInstallPath() + "/jetty/bin/jetty.sh");
        }
    }

    private void readOptionsOnUnix(String startscript) {
        String javaOptions = null;
        if (Files.isExecutable(Paths.get(startscript, new String[0]))) {
            try {
                SOSCommandResult pr = SOSShell.executeCommand(startscript, "status");
                if (pr.getExitCode() == 0 && !pr.getStdErr().trim().isEmpty()) {
                    BufferedReader in = new BufferedReader(new StringReader(pr.getStdOut().trim()));
                    String str = "";
                    Pattern p = Pattern.compile("^\\s*JAVA_OPTIONS\\s*=\\s*(.*)$");
                    Matcher m = null;
                    while ((str = in.readLine()) != null) {
                        m = p.matcher(str = str.trim());
                        if (m.find()) {
                            javaOptions = m.group(1).trim();
                        }
                        if (javaOptions == null) continue;
                    }
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Throwable e) {
                System.out.println(e.toString());
            }
        }
        this.readJavaOptionsString(javaOptions);
    }

    private void readOptionsOnWindows(String jettyServiceName) {
        try {
            if (jettyServiceName == null || jettyServiceName.isEmpty()) {
                jettyServiceName = "joc";
            }
            WindowsRegistry winReg = new WindowsRegistry();
            String key32 = "HKEY_LOCAL_MACHINE\\SOFTWARE\\Apache Software Foundation\\Procrun 2.0\\sos_" + jettyServiceName;
            String key64 = "HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Apache Software Foundation\\Procrun 2.0\\sos_" + jettyServiceName;
            String keyOptions = "\\Parameters\\Java";
            String key = null;
            Long dWord = null;
            if (winReg.keyExist(key32)) {
                key = key32 + keyOptions;
            } else if (winReg.keyExist(key64)) {
                key = key64 + keyOptions;
            }
            if (key != null) {
                String[] opts = winReg.readMultiString(key, "Options");
                if (opts != null) {
                    for (int i = 0; i < opts.length; ++i) {
                        if (opts[i].matches("^-D(jetty\\.home|jetty\\.base|user\\.dir|java\\.io\\.tmpdir|file\\.encoding|user\\.timezone)=.*$")) continue;
                        this.options.add(opts[i]);
                    }
                }
                if ((dWord = winReg.readDWord(key, "JvmMx")) != null) {
                    if (dWord > 0L) {
                        this.optionXmx = dWord.intValue();
                    }
                    dWord = null;
                }
                if ((dWord = winReg.readDWord(key, "JvmMs")) != null) {
                    if (dWord > 0L) {
                        this.optionXms = dWord.intValue();
                    }
                    dWord = null;
                }
                if ((dWord = winReg.readDWord(key, "JvmSs")) != null) {
                    if (dWord > 0L) {
                        this.optionXss = dWord.intValue();
                    }
                    dWord = null;
                }
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
    }

    public void readJavaOptionsString(String javaOptions) {
        if (javaOptions != null) {
            String[] opts = javaOptions.replaceAll(" (-[DX])", "\n$1").split("\n");
            for (int i = 0; i < opts.length; ++i) {
                if (opts[i].matches("^-D(jetty\\.logging\\.dir|jetty\\.home|jetty\\.base|user\\.dir|java\\.io\\.tmpdir|file\\.encoding|user\\.timezone)=.*$")) continue;
                if (opts[i].startsWith(XMX)) {
                    this.optionXmx = this.getXValue(opts[i], "m");
                    continue;
                }
                if (opts[i].startsWith(XMS)) {
                    this.optionXms = this.getXValue(opts[i], "m");
                    continue;
                }
                if (opts[i].startsWith(XSS)) {
                    this.optionXss = this.getXValue(opts[i], "k");
                    continue;
                }
                this.options.add(opts[i]);
            }
        }
    }

    private Integer getXValue(String xOpt, String unit) {
        Integer optVal = null;
        if (xOpt.matches("^-X(mx|ms|ss)\\d+.$")) {
            String xVal = xOpt.replaceAll("\\D", "");
            String xUnit = xOpt.substring(xOpt.length() - 1);
            if (!xVal.isEmpty()) {
                optVal = Integer.valueOf(xVal);
                switch (xUnit.toLowerCase()) {
                    case "b": {
                        if ("m".equals(unit)) {
                            optVal = optVal / 0x100000;
                            break;
                        }
                        if (!"k".equals(unit)) break;
                        optVal = optVal / 1024;
                        break;
                    }
                    case "k": {
                        if (!"m".equals(unit)) break;
                        optVal = optVal / 1024;
                        break;
                    }
                    case "m": {
                        if (!"k".equals(unit)) break;
                        optVal = optVal * 1024;
                        break;
                    }
                    case "g": {
                        if ("m".equals(unit)) {
                            optVal = optVal * 1024;
                            break;
                        }
                        if (!"k".equals(unit)) break;
                        optVal = optVal * 1024 * 1024;
                        break;
                    }
                    default: {
                        if ("m".equals(unit)) {
                            optVal = optVal / 0x100000;
                            break;
                        }
                        if (!"k".equals(unit)) break;
                        optVal = optVal / 1024;
                    }
                }
            }
        }
        return optVal;
    }

    @Override
    public boolean run(String[] args) throws Exception {
        return true;
    }
}

