/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.util;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.PanelActionConfiguration;
import com.izforge.izpack.api.handler.AbstractUIHandler;
import com.izforge.izpack.data.PanelAction;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.OsVersion;
import com.sos.izpack.process.SOSCommandResult;
import com.sos.izpack.process.SOSShell;
import com.sos.izpack.util.Install;
import com.sos.izpack.util.WindowsRegistry;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SetCommonAppData
implements PanelAction {
    @Override
    public void executeAction(InstallData idata, AbstractUIHandler ah) {
        System.setProperty("file.encoding", "UTF-8");
        this.setPrivileged(idata);
        idata.setVariable("shellExt", ".sh");
        idata.setVariable("archiveExt", ".tar.gz");
        Boolean isAutomatedInstallation = (Boolean)idata.getAttribute("automatedInstallation");
        if (isAutomatedInstallation != null) {
            Install.isAutomatedInstallation = isAutomatedInstallation;
        }
        String strCommonAppData = null;
        if (OsVersion.IS_WINDOWS) {
            idata.setVariable("shellExt", ".cmd");
            idata.setVariable("archiveExt", ".zip");
            try {
                WindowsRegistry winReg = new WindowsRegistry();
                try {
                    winReg.deleteOldUninstallKeys();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String commonAppData = null;
                try {
                    commonAppData = winReg.readString("HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Common AppData");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (commonAppData == null) {
                        commonAppData = winReg.readString("HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\User Shell Folders", "Common AppData");
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (commonAppData != null) {
                    strCommonAppData = this.substituteEnvVars(commonAppData);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            if (strCommonAppData == null) {
                String strProgramData = this.substituteEnvVars(IoHelper.getenv("ProgramData"));
                if (strProgramData != null) {
                    strCommonAppData = strProgramData;
                } else {
                    String strAppData = this.substituteEnvVars(IoHelper.getenv("APPDATA"));
                    String strAllUsersProfile = this.substituteEnvVars(IoHelper.getenv("ALLUSERSPROFILE"));
                    if (strAppData != null && strAllUsersProfile != null) {
                        strCommonAppData = strAllUsersProfile + File.separator + Paths.get(strAppData, new String[0]).getFileName().toString();
                    }
                }
            }
        } else {
            String sudoUser = null;
            String sudoHome = idata.getVariable("USER_HOME");
            if ("yes".equals(idata.getVariable("withRootPermissions"))) {
                sudoUser = IoHelper.getenv("SUDO_USER");
                sudoHome = IoHelper.getenv("HOME");
                String suUser = IoHelper.getenv("USER");
                if (sudoUser != null && !sudoUser.isEmpty()) {
                    suUser = sudoUser;
                }
                if (suUser != null && !suUser.isEmpty()) {
                    idata.setVariable("USER_NAME", suUser);
                }
            }
            try {
                String home = SetCommonAppData.getHomeDirFromPasswd(idata.getVariable("USER_NAME"));
                if (home != null) {
                    sudoHome = home;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            idata.setVariable("USER_HOME", sudoHome);
            if ("root".equals(idata.getVariable("USER_NAME"))) {
                strCommonAppData = "/var";
            }
        }
        idata.setVariable("runningUser", idata.getVariable("USER_NAME"));
        idata.setVariable("runningUserHome", idata.getVariable("USER_HOME"));
        if (strCommonAppData == null) {
            strCommonAppData = idata.getVariable("USER_HOME");
        }
        idata.setVariable("CommonAppData", strCommonAppData);
        idata.setVariable("requiredJavaVersion", idata.getInfo().getJavaVersion());
    }

    @Override
    public void initialize(PanelActionConfiguration pac) {
    }

    private String substituteEnvVars(String val) {
        if (val == null) {
            return null;
        }
        String haystack = val;
        Matcher m = Pattern.compile("%([^%]+)%").matcher(haystack);
        String replacement = null;
        while (m.find()) {
            replacement = IoHelper.getenv(m.group(1)).replace('\\', '\u0000');
            if (replacement == null) continue;
            val = val.replaceFirst(Pattern.quote(m.group(0)), replacement).replace('\u0000', '\\');
        }
        return val;
    }

    public static String getHomeDirFromPasswd(String user) throws Throwable {
        String home = null;
        String[] userAttributes = null;
        SOSCommandResult pr = SOSShell.executeCommand("getent", "passwd", "|", "^" + user + ":");
        if (pr.getExitCode() > 0) {
            Optional<String> userLine = Files.lines(Paths.get("/etc/passwd", new String[0])).filter(line -> line.startsWith(user + ":")).findAny();
            if (!userLine.isPresent()) {
                return null;
            }
            userAttributes = userLine.get().split(":");
        } else {
            userAttributes = pr.getStdOut().split(":");
        }
        if (userAttributes != null && userAttributes.length > 5) {
            home = userAttributes[5];
        }
        return home;
    }

    private void setPrivileged(InstallData idata) {
        if ("privileged".equals(System.getProperty("izpack.mode"))) {
            idata.setVariable("withRootPermissions", "no");
        } else {
            idata.setVariable("withRootPermissions", "yes");
        }
        if (OsVersion.IS_UNIX && "root".equals(idata.getVariable("USER_NAME"))) {
            idata.setVariable("withRootPermissions", "yes");
        }
    }
}

