/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.field.search;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.panels.userinput.field.Field;
import com.izforge.izpack.panels.userinput.field.search.ResultType;
import com.izforge.izpack.panels.userinput.field.search.SearchFieldConfig;
import com.izforge.izpack.panels.userinput.field.search.SearchType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class SearchField
extends Field {
    private static final Logger logger = Logger.getLogger(SearchField.class.getName());
    private final InstallData installData;
    private final String filename;
    private final String checkFilename;
    private final SearchType type;
    private final ResultType resultType;
    private final List<String> choices;
    private final int selected;

    public SearchField(SearchFieldConfig config, InstallData installData) {
        super(config, installData);
        this.installData = installData;
        this.filename = config.getFilename();
        this.checkFilename = config.getCheckFilename();
        this.type = config.getSearchType();
        this.resultType = config.getResultType();
        this.choices = config.getChoices();
        this.selected = config.getSelectedIndex();
    }

    public String getFilename() {
        return this.filename;
    }

    public String getCheckFilename() {
        return this.checkFilename;
    }

    public SearchType getType() {
        return this.type;
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public List<String> getChoices() {
        return this.getChoices(this.choices);
    }

    public List<String> getChoices(List<String> choices) {
        ArrayList<String> items = new ArrayList<String>();
        for (String path : choices) {
            path = this.installData.getVariables().replace(path);
            if (path.endsWith("*")) {
                File[] subdirs;
                File dir = new File(path = path.substring(0, path.length() - 1));
                if (!dir.isDirectory() || (subdirs = dir.listFiles()) == null) continue;
                for (File subdir : subdirs) {
                    String search = subdir.getAbsolutePath();
                    if (!this.pathMatches(search)) continue;
                    items.add(search);
                }
                continue;
            }
            if (!this.pathMatches(path)) continue;
            items.add(path);
        }
        return items;
    }

    public int getSelectedIndex() {
        return this.selected;
    }

    public static String resolveEnvValue(String path, Map<String, String> env) {
        int end;
        int envStart;
        StringBuilder str = new StringBuilder();
        int start = 0;
        while ((envStart = path.indexOf(37, start)) >= 0 && (end = path.indexOf(37, envStart + 1)) >= 0) {
            String envKey = path.substring(envStart + 1, end);
            String envValue = env.get(envKey);
            if (envStart > start) {
                str.append(path.substring(start, envStart));
            }
            str.append(envValue);
            start = end + 1;
        }
        if (start > 0) {
            str.append(path.substring(start));
            return str.toString();
        }
        return path;
    }

    public boolean pathMatches(String path) {
        if (path != null) {
            path = SearchField.resolveEnvValue(path, System.getenv());
            File file = this.filename == null || this.type == SearchType.DIRECTORY ? new File(path) : new File(path, this.filename);
            if (file.exists()) {
                if (this.checkFilename == null) {
                    return true;
                }
                if (file.isDirectory()) {
                    if (!(file = new File(file, this.checkFilename)).exists()) {
                        logger.fine(file.getAbsolutePath() + " does not exist");
                        return false;
                    }
                } else if (!file.getAbsolutePath().endsWith(this.checkFilename.replaceAll("\\\\/", File.separator))) {
                    return false;
                }
                return file.isDirectory() == (this.type == SearchType.DIRECTORY);
            }
        }
        return false;
    }

    public String getResult(String item) {
        if (item != null) {
            String path = item = item.trim();
            File file = new File(item);
            if (!file.isDirectory()) {
                path = file.getParent();
            }
            if (this.resultType == ResultType.DIRECTORY) {
                return path;
            }
            if (this.resultType == ResultType.FILE) {
                if (this.filename != null) {
                    return path + File.separatorChar + this.filename;
                }
                return item;
            }
            if (this.resultType == ResultType.PARENTDIR) {
                File dir = new File(path);
                return dir.getParent();
            }
        }
        return null;
    }
}

