/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.panels.userinput.gui.combo;

import com.izforge.izpack.api.handler.Prompt;
import com.izforge.izpack.panels.userinput.field.Choice;
import com.izforge.izpack.panels.userinput.field.combo.ComboField;
import com.izforge.izpack.panels.userinput.gui.GUIField;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;

public class GUIComboField
extends GUIField {
    private final JComboBox combo = new JComboBox();
    private volatile boolean notifyUpdateListener = true;

    public GUIComboField(ComboField field) {
        super(field);
        this.combo.setName(field.getVariable());
        for (Choice choice : field.getChoices()) {
            this.combo.addItem(choice);
        }
        this.combo.setSelectedIndex(field.getSelectedIndex());
        this.combo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (GUIComboField.this.notifyUpdateListener) {
                    GUIComboField.this.notifyUpdateListener();
                }
            }
        });
        this.addField(this.combo);
        this.addTooltip();
    }

    @Override
    public boolean updateField(Prompt prompt, boolean skipValidation) {
        Choice selected = (Choice)this.combo.getSelectedItem();
        String value = selected != null ? selected.getKey() : null;
        this.getField().setValue(value);
        return true;
    }

    @Override
    public boolean updateView() {
        String defaultValue;
        this.notifyUpdateListener = false;
        this.refreshChoices();
        boolean result = super.updateView();
        ComboField field = (ComboField)this.getField();
        String value = field.getInitialValue();
        if (value != null) {
            result = this.splitValue(value);
        }
        if (!result && (defaultValue = field.getDefaultValue()) != null) {
            result = this.splitValue(defaultValue);
        }
        this.notifyUpdateListener = true;
        return result;
    }

    private boolean splitValue(String value) {
        for (int i = 0; i < this.combo.getItemCount(); ++i) {
            Choice item = (Choice)this.combo.getItemAt(i);
            if (!value.equals(item.getTrueValue())) continue;
            this.combo.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    private void refreshChoices() {
        ComboField field = (ComboField)this.getField();
        this.combo.removeAllItems();
        int index = 0;
        for (Choice choice : field.getChoices()) {
            boolean selected;
            String conditionId = choice.getConditionId();
            if (conditionId == null || this.getInstallData().getRules().isConditionTrue(conditionId)) {
                this.combo.addItem(choice);
            }
            boolean bl = selected = field.getSelectedIndex() == index;
            if (selected) {
                this.combo.setSelectedItem(choice);
            }
            ++index;
        }
    }

    @Override
    public JComponent getFirstFocusableComponent() {
        return this.combo;
    }
}

