/*
 * Decompiled with CFR 0.152.
 */
package com.sos.izpack.process;

import com.sos.izpack.process.ProcessHelper;
import com.sos.izpack.process.SOSFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class CopyLicenseFile
extends ProcessHelper {
    public static final String licenseJarName = "js7-license.jar";

    @Override
    public boolean run(String[] args) throws Exception {
        Path targetDir = null;
        Path licenseJar = null;
        if (this.idata.getVariable("installMode") != null) {
            if (this.idata.getVariable("installMode").equals("joc")) {
                targetDir = Paths.get(this.idata.getVariable("APPDATA_PATH"), "resources", "joc", "license");
                licenseJar = Paths.get(this.idata.getVariable("APPDATA_PATH"), "lib", "ext", "joc", licenseJarName);
            } else if (this.idata.getVariable("installMode").equals("controller") || this.idata.getVariable("installMode").equals("agent")) {
                String configPath = this.idata.getVariable("configPath");
                targetDir = configPath != null && !configPath.isEmpty() ? Paths.get(this.idata.getVariable("configPath"), "license") : Paths.get(this.idata.getVariable("APPDATA_PATH"), "config", "license");
                licenseJar = Paths.get(this.idata.getInstallPath(), "lib", "user_lib", licenseJarName);
            }
        }
        String license = this.idata.getVariable("licenseFile");
        if (targetDir != null) {
            try {
                if (Files.exists(licenseJar, new LinkOption[0])) {
                    this.storeLicenseJar(licenseJar);
                }
                if (license != null && !license.isEmpty()) {
                    this.writeHeader("Store license file in " + targetDir.toString());
                    Path licenseFile = Paths.get(license, new String[0]);
                    Path targetFile = targetDir.resolve(licenseFile.getFileName());
                    if (!Files.exists(targetDir, new LinkOption[0])) {
                        Files.createDirectories(targetDir, new FileAttribute[0]);
                    }
                    if (!Files.exists(licenseFile, new LinkOption[0])) {
                        throw new IOException(String.format("%1$s doesn't exist", licenseFile.toString()));
                    }
                    if (Files.isDirectory(licenseFile, new LinkOption[0])) {
                        throw new IOException(String.format("%1$s is not a file", licenseFile.toString()));
                    }
                    if (!Files.isWritable(targetDir)) {
                        throw new IOException(String.format("%1$s isn't writable", targetDir.toString()));
                    }
                    SOSFile.copyFile(licenseFile, targetFile);
                    if (!Files.exists(licenseJar, new LinkOption[0])) {
                        this.storeLicenseJar(licenseJar);
                    }
                    this.log("... done", new Object[0]);
                }
            }
            catch (Exception e) {
                this.log("... error occurred:", new Object[0]);
                this.log(e);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeLicenseJar(Path dest) throws IOException {
        if (dest != null) {
            Path parent = dest.getParent();
            if (!Files.exists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            InputStream inStream = null;
            try {
                inStream = this.getClass().getClassLoader().getResourceAsStream("resources/js7-license.jar");
                if (inStream != null) {
                    Files.copy(inStream, dest, StandardCopyOption.REPLACE_EXISTING);
                }
            }
            finally {
                if (inStream != null) {
                    try {
                        inStream.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

